/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.F3KScore;
import f3kscore.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Competition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static ArrayList<String> groupLetters = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J"));
    private transient F3KScore editor;
    private transient int selectedRoundIndex;
    private transient boolean changesMade;
    private transient int doneRoundCount;
    private String competitionName;
    private ArrayList<Competitor> competitorList;
    private ArrayList<Competitor> resultsList;
    private ArrayList<Task> taskList;
    private ArrayList<Task> taskPool;
    private boolean resultDirty;
    private boolean useLetterGroupNames;

    public Competition(F3KScore editor) {
        this.editor = editor;
        this.competitorList = new ArrayList();
        this.resultsList = new ArrayList();
        this.taskPool = new ArrayList();
        this.taskList = new ArrayList();
        this.resultDirty = true;
        this.useLetterGroupNames = true;
        this.taskPool.add(new Task("Last Flight", "Last flight, 5min max", new int[]{300}));
        this.taskPool.add(new Task("Last Two Flights", "Last two flights, 4min max", new int[]{240, 240}));
        this.taskPool.add(new Task("All Up", "All up, 3x3min max", new int[]{180, 180, 180}));
        this.taskPool.add(new Task("Ladder 15sec", "Increasing times: 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}));
        this.taskPool.add(new Task("Poker", "Poker, 5 self nominated targets", new int[5]));
        this.taskPool.add(new Task("3 of 6", "3 best flights 3min max, 6 launches only", new int[]{180, 180, 180}));
        this.taskPool.add(new Task("5x2min", "5 best flights 2min max", new int[]{120, 120, 120, 120, 120}));
        this.taskPool.add(new Task("1,2,3,4min", "4 best flights 1,2,3,4min max in any order", new int[]{60, 120, 180, 240}));
        this.taskPool.add(new Task("Speed", "F3F/F3B type speed task", new int[1], null, true));
        this.taskPool.add(new Task("Last Two, 3min", "Last two flights, 3min max", new int[]{180, 180}));
        this.taskList.add(this.taskPool.get(0));
        this.taskList.add(this.taskPool.get(1));
        this.taskList.add(this.taskPool.get(2));
        this.taskList.add(this.taskPool.get(3));
        this.taskList.add(this.taskPool.get(4));
        this.taskList.add(this.taskPool.get(5));
        this.taskList.add(this.taskPool.get(6));
    }

    public String getCompetitionName() {
        return this.competitionName;
    }

    public void setCompetitionName(String competitionName) {
        this.competitionName = competitionName;
        this.changesMade = true;
    }

    public boolean addCompetitor(Competitor newCompetitor) {
        if (this.competitorList.contains(newCompetitor)) {
            return false;
        }
        this.competitorList.add(newCompetitor);
        this.setResultDirty();
        this.editor.fireChangeEvent();
        return true;
    }

    public void removeCompetitor(Competitor competitor) {
        this.competitorList.remove(competitor);
        this.setResultDirty();
        this.editor.fireChangeEvent();
    }

    public void setEditor(F3KScore editor) {
        this.editor = editor;
    }

    public void setResultDirty() {
        this.resultDirty = true;
        this.resultsList.clear();
        this.resultsList.addAll(this.competitorList);
    }

    private void calcResultList() {
        this.doneRoundCount = 0;
        boolean done = true;
        while (done && this.doneRoundCount < this.taskList.size()) {
            boolean anyTime = false;
            for (int c = 0; c < this.competitorList.size(); ++c) {
                if (this.getCompetitor(c).getTaskTotalTime(this.doneRoundCount) <= 0) continue;
                anyTime = true;
                break;
            }
            if (anyTime) {
                ++this.doneRoundCount;
                continue;
            }
            done = false;
        }
        int c = 0;
        while (c < this.competitorList.size()) {
            int pos = this.competitorList.get(c).getPosition();
            this.resultsList.set(pos, this.competitorList.get(c));
            ++c;
        }
        this.resultDirty = false;
    }

    public Competitor getCompetitorAtPosition(int pos) {
        if (this.resultDirty) {
            this.calcResultList();
        }
        return this.resultsList.get(pos);
    }

    public void setSelectedRoundIndex(int selectedRoundIndex) {
        this.selectedRoundIndex = selectedRoundIndex;
    }

    public int getSelectedRoundIndex() {
        return this.selectedRoundIndex;
    }

    public Competitor getCompetitor(int index) {
        if (index < this.competitorList.size()) {
            return this.competitorList.get(index);
        }
        return null;
    }

    public Task getPoolTask(int index) {
        return this.taskPool.get(index);
    }

    public Task getRoundTask(int roundIndex) {
        return this.taskList.get(roundIndex);
    }

    public void setRoundTask(int roundIndex, Task task) {
        this.taskList.set(roundIndex, task);
        this.setResultDirty();
        this.editor.fireChangeEvent();
    }

    public Task getSelectedTask() {
        return this.getRoundTask(this.selectedRoundIndex);
    }

    public int getCompetitorCount() {
        return this.competitorList.size();
    }

    public int getNumberOfRounds() {
        return this.taskList.size();
    }

    public int getDoneRoundCount() {
        return this.doneRoundCount;
    }

    public int getDiscardCount() {
        int discardCount = (this.getDoneRoundCount() + 1) / 5;
        if (this.getDoneRoundCount() < 5) {
            discardCount = 0;
        }
        return discardCount;
    }

    public int getGroupCount(int round) {
        int groupCount = 1;
        int c = 0;
        while (c < this.competitorList.size()) {
            if (this.competitorList.get(c).getGroup(round) > groupCount) {
                groupCount = this.competitorList.get(c).getGroup(round);
            }
            ++c;
        }
        return groupCount;
    }

    public int getTaskScore(int round, int group, int totalTime) {
        CompetitorGroup compGroup = new CompetitorGroup(this, group, round);
        boolean isSpeedTask = this.getRoundTask(round).isSpeedTask();
        int LARGE_INT = 99999;
        if (isSpeedTask) {
            totalTime = totalTime > 0 ? LARGE_INT / totalTime : LARGE_INT;
        }
        int maxTime = 0;
        int c = 0;
        while (c < compGroup.GetCompetitorCount()) {
            int time = compGroup.GetCompetitor(c).getTaskTotalTime(round);
            if (isSpeedTask) {
                time = time > 0 ? LARGE_INT / time : LARGE_INT;
            }
            if (time > maxTime) {
                maxTime = time;
            }
            ++c;
        }
        if (maxTime > 0) {
            return totalTime * 1000 / maxTime;
        }
        return 0;
    }

    public int getMaxGroupCount() {
        int max = 0;
        int c = 0;
        while (c < this.getNumberOfRounds()) {
            if (this.getGroupCount(c) > max) {
                max = this.getGroupCount(c);
            }
            ++c;
        }
        return max;
    }

    public Competitor getCompetitorInRoundScoresTable(int round, int row) {
        int group = 1;
        int index = 0;
        while (true) {
            CompetitorGroup compGroup;
            int rowCount;
            if (row < index + (rowCount = (compGroup = new CompetitorGroup(this, group, round)).GetCompetitorCount() + 1)) {
                if (row == index) {
                    return null;
                }
                return compGroup.GetCompetitor(row - index - 1);
            }
            index += rowCount;
            ++group;
        }
    }

    public int getGroupInRound(int round, int row) {
        int group = 1;
        int index = 0;
        CompetitorGroup compGroup;
        int rowCount;
        while (row >= index + (rowCount = (compGroup = new CompetitorGroup(this, group, round)).GetCompetitorCount() + 1)) {
            index += rowCount;
            ++group;
        }
        return group;
    }

    public void setNumberOfRounds(int numRounds) {
        while (this.taskList.size() < numRounds) {
            this.taskList.addAll(this.taskList);
        }
        while (this.taskList.size() > numRounds) {
            this.taskList.remove(numRounds);
        }
        for (Competitor competitor : this.competitorList) {
            competitor.setNumberOfRounds(numRounds);
        }
        this.setResultDirty();
        this.editor.fireChangeEvent();
    }

    public int getTaskPoolSize() {
        return this.taskPool.size();
    }

    public void fireChangeEvent() {
        this.editor.fireChangeEvent();
    }

    public boolean useLetterGroupNames() {
        return this.useLetterGroupNames;
    }

    public void setUseLetterGroupNames(boolean useLetterGroupNames) {
        this.useLetterGroupNames = useLetterGroupNames;
    }

    public void setChangesMade(boolean changesMade) {
        this.changesMade = changesMade;
    }

    public boolean changesMade() {
        return this.changesMade;
    }
}

