/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.GroupsPane;
import f3kscore.RegistrationPane;
import f3kscore.RoundScoresPane;
import f3kscore.StartListPane;
import f3kscore.TasksPane;
import f3kscore.TotalScoresPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class F3KScore
extends JFrame {
    private static Font fontPlain12pt = new Font("Serif", 0, 12);
    private static Font fontBold12pt = new Font("Serif", 1, 12);
    private static Font fontUnBold12pt = new Font("Serif", 1, 12);
    private static Font fontPlain10pt = new Font("Serif", 0, 10);
    private static Font fontBold10pt = new Font("Serif", 1, 10);
    private static Font fontPlain8pt = new Font("Serif", 0, 8);
    private static Font fontBold8pt = new Font("Serif", 1, 8);
    private final JMenuBar mainMenuBar = new JMenuBar();
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu printMenu;
    private JFileChooser fileChooser;
    private Competition competition;
    private ArrayList<AbstractF3KScoreEditorPanel> editorPanels;
    private AbstractF3KScoreEditorPanel registrationPane;
    private AbstractF3KScoreEditorPanel tasksPane;
    private AbstractF3KScoreEditorPanel startListPane;
    private AbstractF3KScoreEditorPanel groupsPane;
    private AbstractF3KScoreEditorPanel timesPane;
    private AbstractF3KScoreEditorPanel totalPane;
    private JTabbedPane tabbedPane;
    private File file;
    private Image f3kIcon;
    private Image f3kLogo;
    private PrinterJob printerJob;
    private JLabel lblCompName;
    private JTextField txtCompName;

    public static void main(String[] args) {
        String fName = null;
        if (args.length > 0) {
            fName = args[0];
        }
        new F3KScore(fName);
    }

    public F3KScore(String fName) {
        Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        fontUnBold12pt = fontUnBold12pt.deriveFont(map);
        this.setTitle("F3KScore");
        URL imgURL = F3KScore.class.getResource("f3k_logo.png");
        this.f3kIcon = new ImageIcon(imgURL).getImage();
        this.setIconImage(this.f3kIcon);
        imgURL = F3KScore.class.getResource("f3kscore.png");
        this.f3kLogo = new ImageIcon(imgURL).getImage();
        this.lblCompName = new JLabel("Competition name:");
        this.txtCompName = new JTextField();
        this.txtCompName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.competition.setCompetitionName(F3KScore.this.txtCompName.getText().trim());
                F3KScore.this.txtCompName.transferFocus();
            }
        });
        this.createMenuBar();
        this.competition = new Competition(this);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new F3kFileFilter());
        this.editorPanels = new ArrayList();
        this.registrationPane = new RegistrationPane(this.competition);
        this.editorPanels.add(this.registrationPane);
        this.tasksPane = new TasksPane(this.competition);
        this.editorPanels.add(this.tasksPane);
        this.startListPane = new StartListPane(this.competition);
        this.editorPanels.add(this.startListPane);
        this.groupsPane = new GroupsPane(this.competition);
        this.editorPanels.add(this.groupsPane);
        this.timesPane = new RoundScoresPane(this.competition);
        this.editorPanels.add(this.timesPane);
        this.totalPane = new TotalScoresPane(this.competition);
        this.editorPanels.add(this.totalPane);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Pilot List", this.registrationPane);
        this.tabbedPane.addTab("Task List", this.tasksPane);
        this.tabbedPane.addTab("Flight Matrix", this.groupsPane);
        this.tabbedPane.addTab("Start List", this.startListPane);
        this.tabbedPane.addTab("Round Scores", this.timesPane);
        this.tabbedPane.addTab("Total Scores", this.totalPane);
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)this.lblCompName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add((Component)this.txtCompName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 10), 0, 0));
        contentPane.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.setOpaque(true);
        super.setContentPane(contentPane);
        super.setSize(900, 460);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                F3KScore.this.exitApplication();
            }
        });
        if (fName != null) {
            final File file = new File(fName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        F3KScore.this.loadFromFile(file);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(F3KScore.this, "Failed when trying to read file \"" + file.getName() + "\"\nError message:\n\n\"" + ex.getLocalizedMessage() + "\"", "Error reading data file", 0);
                    }
                }
            });
        }
    }

    private void exitApplication() {
        if (this.competition.changesMade()) {
            int reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nSave changes before closing?", "Save data?", 1);
            if (reply == 0) {
                this.save(this.file);
            }
            if (reply == 2) {
                return;
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printData(Printable printer) {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition data to print.", "No competition data", 0);
            return;
        }
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        this.printerJob.setPrintable(printer);
        boolean doPrint = this.printerJob.printDialog();
        if (doPrint) {
            try {
                Printable printable = printer;
                synchronized (printable) {
                    this.printerJob.print();
                }
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, "Failed to print data:\n\n" + e.getLocalizedMessage(), "Print error", 0);
            }
        }
    }

    public void printFlightMatrix() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                int height = (int)pf.getImageableHeight();
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                float fontSize = fontPlain10pt.getSize2D();
                float charWidth = fontSize * 0.5f;
                int colCount = F3KScore.this.groupsPane.getTableModel().getColumnCount() - 1;
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float x0 = 50.0f;
                float y = y0;
                int[] columnWidthChars = new int[colCount];
                Arrays.fill(columnWidthChars, 3);
                columnWidthChars[0] = 20;
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.this.competition.getCompetitionName(), (int)x0, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    float y1 = y - (float)rowHeight;
                    g.setFont(fontBold10pt);
                    boolean header = true;
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.groupsPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        if (pageCount == page) {
                            int colIx = 0;
                            while (colIx < colCount) {
                                String s;
                                float colWidth = charWidth * (float)columnWidthChars[colIx];
                                if (header) {
                                    s = F3KScore.this.groupsPane.getTableModel().getColumnName(colIx);
                                    g.drawString(s, (int)x, (int)y);
                                } else {
                                    s = (String)F3KScore.this.groupsPane.getTableModel().getValueAt(rowIx, colIx);
                                    if ((float)s.length() > colWidth / charWidth) {
                                        s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                    }
                                    g.drawString(s, (int)x, (int)y);
                                }
                                x += colWidth;
                                ++colIx;
                            }
                        }
                        if (header) {
                            header = false;
                            g.setFont(fontPlain10pt);
                            if (pageCount == page) {
                                g.setColor(Color.LIGHT_GRAY);
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                                g.setColor(Color.BLACK);
                            }
                            y += 2.0f;
                            --rowIx;
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            if (pageCount == page) {
                                g.setColor(Color.LIGHT_GRAY);
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                                g.setColor(Color.BLACK);
                            }
                            y += 2.0f;
                        }
                        if (pageCount == page) {
                            g.setColor(Color.LIGHT_GRAY);
                            x = x0 - 4.0f;
                            int[] nArray = columnWidthChars;
                            int n = columnWidthChars.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Integer colW = nArray[n2];
                                g.drawLine((int)(x += (float)((int)((float)colW.intValue() * charWidth))), (int)y1, (int)x, (int)y + 2);
                                ++n2;
                            }
                            g.setColor(Color.BLACK);
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.groupsPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public void printResults() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                int height = (int)pf.getImageableWidth();
                g2d.translate(pf.getImageableX() + (double)height, pf.getImageableY());
                g2d.rotate(1.5707963267948966);
                float fontSize = fontPlain10pt.getSize2D();
                float charWidth = fontSize * 0.5f;
                int colCount = F3KScore.this.totalPane.getTableModel().getColumnCount() - 1;
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float x0 = 20.0f;
                float y = y0;
                int[] columnWidth = new int[colCount];
                Arrays.fill(columnWidth, (int)charWidth * 6);
                columnWidth[0] = (int)charWidth * 4;
                columnWidth[1] = (int)charWidth * 20;
                columnWidth[colCount - 6] = (int)charWidth * 7 + 2;
                columnWidth[colCount - 5] = (int)charWidth * 7;
                columnWidth[colCount - 4] = (int)charWidth * 7 + 2;
                columnWidth[colCount - 3] = (int)charWidth * 9;
                columnWidth[colCount - 2] = (int)charWidth * 10;
                columnWidth[colCount - 1] = (int)charWidth * 7;
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.this.competition.getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    float y1 = y - (float)rowHeight;
                    g.setFont(fontBold10pt);
                    boolean header = true;
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.totalPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        if (pageCount == page) {
                            int colIx = 0;
                            while (colIx < colCount) {
                                String s;
                                float colWidth = columnWidth[colIx];
                                if (header) {
                                    s = F3KScore.this.totalPane.getTableModel().getColumnName(colIx);
                                    g.drawString(s, (int)x, (int)y);
                                } else {
                                    s = (String)F3KScore.this.totalPane.getTableModel().getValueAt(rowIx, colIx);
                                    if ((float)s.length() > colWidth / charWidth) {
                                        s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                    }
                                    g.drawString(s, (int)x, (int)y);
                                }
                                x += colWidth;
                                ++colIx;
                            }
                        }
                        if (header) {
                            header = false;
                            g.setFont(fontPlain10pt);
                            if (pageCount == page) {
                                g.setColor(Color.LIGHT_GRAY);
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                                g.setColor(Color.BLACK);
                            }
                            y += 2.0f;
                            --rowIx;
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            if (pageCount == page) {
                                g.setColor(Color.LIGHT_GRAY);
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                                g.setColor(Color.BLACK);
                            }
                            y += 2.0f;
                        }
                        if (pageCount == page) {
                            g.setColor(Color.LIGHT_GRAY);
                            x = x0 - 4.0f;
                            int[] nArray = columnWidth;
                            int n = columnWidth.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Integer colW = nArray[n2];
                                g.drawLine((int)(x += (float)colW.intValue()), (int)y1, (int)x, (int)y + 2);
                                ++n2;
                            }
                            g.setColor(Color.BLACK);
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.totalPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public void printScoreCards() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int roundCount = F3KScore.this.competition.getNumberOfRounds();
                int pagePerComp = 1 + (roundCount - 1) / 8;
                int pageCount = F3KScore.this.competition.getCompetitorCount() * pagePerComp;
                if (page > pageCount) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)g;
                int width = (int)pf.getImageableWidth() + 10;
                int height = (int)pf.getImageableHeight() + 10;
                g2d.translate(pf.getImageableX() - 5.0, pf.getImageableY() - 5.0);
                int compIx = page / pagePerComp;
                int startRound = page % pagePerComp * 8;
                int endRound = startRound + 8 <= roundCount ? startRound + 8 : roundCount;
                Font font = fontPlain12pt;
                int rowHeight = (int)(font.getSize2D() * 1.2f);
                int cardWidth = width / 2;
                int cardHeight = height / 4;
                int roundIx = startRound;
                while (roundIx < endRound) {
                    int xOffset = (roundIx & 1) * cardWidth;
                    int yOffset = (roundIx & 7) / 2 * cardHeight;
                    g.drawRect(xOffset + 0, yOffset + 0, cardWidth, cardHeight);
                    xOffset += 15;
                    String name = F3KScore.this.competition.getCompetitor(compIx).getName();
                    String task = F3KScore.this.competition.getRoundTask(roundIx).getLongName();
                    int group = F3KScore.this.competition.getCompetitor(compIx).getGroup(roundIx);
                    String groupString = "" + group;
                    if (F3KScore.this.competition.useLetterGroupNames()) {
                        groupString = Competition.groupLetters.get(group - 1);
                    }
                    g.setFont(fontUnBold12pt);
                    g.drawString(name, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 0);
                    g.setFont(fontBold12pt);
                    g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 1);
                    g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 25 + rowHeight * 1);
                    g.setFont(fontPlain8pt);
                    g.drawString("Task:  " + task, xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 2);
                    int xr = xOffset + cardWidth / 10;
                    int yr = yOffset + rowHeight * 4 - cardHeight / 6;
                    int c = 0;
                    while (c < 8) {
                        if ((c & 3) == 0) {
                            xr = xOffset + cardWidth / 10;
                            yr += cardHeight / 6;
                        }
                        g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6);
                        xr += cardWidth / 5;
                        ++c;
                    }
                    g.setFont(fontBold12pt);
                    g.drawString("Sign Pilot:", xOffset + cardWidth / 10, yOffset + cardHeight - rowHeight * 2);
                    g.drawString("Sign Timer:", xOffset + cardWidth / 2, yOffset + cardHeight - rowHeight * 2);
                    ++roundIx;
                }
                return 0;
            }
        });
    }

    public void printStartList() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                int width = (int)pf.getImageableWidth();
                int height = (int)pf.getImageableHeight();
                Font font = fontPlain8pt;
                float fontSize = font.getSize2D();
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float x0 = 20.0f;
                float y = y0;
                int colCount = F3KScore.this.startListPane.getTableModel().getColumnCount();
                int colWidth = (int)(((float)width - 2.0f * x0) / (float)colCount);
                int nPilotsInGroup = (int)Math.ceil((double)F3KScore.this.competition.getCompetitorCount() / (double)F3KScore.this.competition.getMaxGroupCount());
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.this.competition.getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.startListPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            int n;
                            String s = (String)F3KScore.this.startListPane.getTableModel().getValueAt(rowIx, colIx);
                            if (s.startsWith("_____")) {
                                s = s.substring(5);
                                font = fontBold8pt;
                                if (colIx == 0) {
                                    y += 5.0f;
                                }
                                if (y + (float)((n = nPilotsInGroup + 1) * rowHeight) >= (float)height - bottomMargin) {
                                    y = height;
                                    --rowIx;
                                    break;
                                }
                            } else if (s.startsWith("Round")) {
                                font = fontBold8pt;
                                n = nPilotsInGroup + 1;
                                if ((y += 5.0f) + (float)(n * rowHeight) + 5.0f >= (float)height - bottomMargin) {
                                    y = height;
                                    --rowIx;
                                    break;
                                }
                            } else {
                                font = fontPlain8pt;
                                if ((double)s.length() > 2.0 * (double)colWidth / (double)fontSize) {
                                    s = String.valueOf(s.substring(0, (int)(2.0 * (double)colWidth / (double)fontSize - 0.5))) + "...";
                                }
                            }
                            if (pageCount == page) {
                                g.setFont(font);
                                g.drawString(s, (int)x, (int)y);
                            }
                            x += (float)colWidth;
                            ++colIx;
                        }
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.startListPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public void createMenuBar() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(new JMenuItem(new AbstractAction("New"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Open"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.chooseFileOpen();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.save(F3KScore.this.file);
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.saveAs();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exitApplication();
            }
        }));
        this.mainMenuBar.add(this.fileMenu);
        this.printMenu = new JMenu("Print");
        this.printMenu.add(new JMenuItem(new AbstractAction("Print Flight Matrix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printFlightMatrix();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Print Score Cards"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printScoreCards();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Print Start List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printStartList();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Print Final Results"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printResults();
            }
        }));
        this.mainMenuBar.add(this.printMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(new JMenuItem(new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showHelpDialog();
            }
        }));
        this.helpMenu.add(new JMenuItem(new AbstractAction("About F3KScore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showAboutDialog();
            }
        }));
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    public void createNewCompetition() {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return;
        }
        this.competition = new Competition(this);
        this.file = null;
        this.setTitle("F3KScore");
        this.fireChangeEvent();
    }

    public void chooseFileOpen() {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return;
        }
        this.fileChooser.setDialogTitle("Select F3KScore file to open");
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                this.loadFromFile(file);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed when trying to read file \"" + file.getName() + "\"\nError message:\n\n\"" + ex.getLocalizedMessage() + "\"", "Error reading data file", 0);
            }
        }
    }

    public void loadFromFile(File file) throws IOException {
        FileInputStream fs = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fs);
        try {
            this.competition = (Competition)ois.readObject();
            this.competition.setEditor(this);
            this.competition.setResultDirty();
            this.fireChangeEvent();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.file = file;
        this.setTitle("F3KScore: " + file.getName());
        this.tabbedPane.setSelectedIndex(0);
    }

    public void saveAs() {
        this.fileChooser.setDialogTitle("Select file name to save F3KScore data");
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 1);
                if (reply == 1) {
                    this.saveAs();
                    return;
                }
                if (reply == 2) {
                    return;
                }
            }
            this.save(file);
            this.file = file;
            this.setTitle("F3KScore: " + file.getName());
        }
    }

    public void save(File file) {
        if (file == null) {
            this.saveAs();
            return;
        }
        try {
            FileOutputStream fs = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fs);
            oos.writeObject(this.competition);
            oos.close();
            this.competition.setChangesMade(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + file.getName() + "\":\n\n" + ex.getLocalizedMessage());
        }
    }

    public void fireChangeEvent() {
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataStructureChanged(this.competition);
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
    }

    public void fireDataChangeEvent() {
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataChanged();
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
    }

    private void showAboutDialog() {
        JDialog aboutDialog = new JDialog(this){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.black);
                g.setFont(new Font("serif", 1, 32));
                int x = 30;
                int y = 60;
                g.drawImage(F3KScore.this.f3kLogo, x, y, null);
                g.drawString("F3KScore", (x += 20) + 120, (y += 0) + 10);
                g.setFont(new Font("serif", 1, 16));
                g.drawString("Version 8.0", x + 120, y + 30);
                g.drawString("FAI F3K Scoring Software", x + 120, y + 50);
                g.drawString("2007-2009,  Peter Jubel", x + 120, y + 70);
                g.drawString("2010,  Oleg Golovidov", x + 120, y + 90);
            }
        };
        aboutDialog.setTitle("About F3KScore");
        aboutDialog.setSize(380, 200);
        aboutDialog.setResizable(false);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setModal(true);
        aboutDialog.setVisible(true);
    }

    private void showHelpDialog() {
        final class HelpDialog
        extends JDialog {
            private static final String newline = "\n";

            public HelpDialog(JFrame parent) {
                super((Frame)parent, "F3KScore Help");
                this.setSize(860, 760);
                this.setLocationRelativeTo(parent);
                JTextArea textArea = new JTextArea(50, 20);
                textArea.setMargin(new Insets(10, 10, 10, 10));
                textArea.setFont(new Font("serif", 0, 14));
                textArea.setLineWrap(true);
                textArea.append("F3KScore is a program for managing F3K contests.\n");
                textArea.append("This program is distributed under the terms of the GNU General Public License.\n");
                textArea.append("See installation directory for GNU General Public License file, version 3.0.\n\n");
                textArea.append("F3KScore is implemented in Java and runs on any Java enabled system.\n");
                textArea.append("Original implementation 2007-2009 by Peter Jubel.\n");
                textArea.append("Re-written in 2010, version 8.0 by Oleg Golovidov.\n");
                textArea.append("Send comments or bug reports to \"oleg.golovidov@gmail.com\"\n");
                textArea.append(newline);
                textArea.append("Functional description:\n");
                textArea.append(" \n");
                textArea.append("Pilot List:\tAdd new competitor by entering a name in the last empty row or paste a new list of pilots copied from Excel.\n");
                textArea.append("\tTo delete a competitor, highlight one or more names, then hit DELETE button.\n");
                textArea.append("\tFirst frequency is used for generating the flight groups.\n");
                textArea.append(newline);
                textArea.append("Task List:\tEnter desired number of rounds in the text box.\n");
                textArea.append("\tClick on the task name to assign a task for each round.\n");
                textArea.append(newline);
                textArea.append("Flight Matrix:\tEnter desired number of flight groups in the text box.\n");
                textArea.append("\tClick the button to generate new random groups.\n");
                textArea.append("\tClick the checkbox to change how group names are displayed (numbers or letters A,B,C,..).\n");
                textArea.append("\tGroups can also be assigned manually by entering a group letter or number directly in the table.\n");
                textArea.append(newline);
                textArea.append("Start List:\tDisplays the names of the pilots for each round/group.\n");
                textArea.append(newline);
                textArea.append("Round Scores:\tFlight times for each round are entered on this page.\n");
                textArea.append("\tFlight time can be entered as seconds, or as minutes and seconds (formats \"1:12\" or \"1.12\" are equivalent).\n");
                textArea.append("\tAll times are automatically truncated to max time according to the definition of the task.\n");
                textArea.append("\tATTENTION: 1,2,3,4 task times must be entered in the proper order to avoid incorrect truncation.\n");
                textArea.append(newline);
                textArea.append("Total Scores:\tPilot names are displayed sorted by their total scores.\n");
                textArea.append("\tDiscarded scores are shown in parantheses.\n");
                textArea.append("\tPenalty values must be entered on this page.\n");
                textArea.append("\tUse Copy/Paste to export results to other applications.\n");
                textArea.append(newline);
                textArea.append(newline);
                textArea.append("Version History:\n");
                textArea.append(" \n");
                textArea.append("version 1:\tOriginal version.\n");
                textArea.append(newline);
                textArea.append("version 2:\tSpeedup in calculating results added more info in Register tab.\n");
                textArea.append(newline);
                textArea.append("version 3:\tMake use of discard rounds if equal score. Removed result Tab, everything is now in Total tab.\n");
                textArea.append(newline);
                textArea.append("version 4:\tAdded about and help window. Added startlist Tab. Added dialog for selecting number of groups in Make Groups command.\n");
                textArea.append(" \n");
                textArea.append("version 5:\tImproved MakeGroups algorithm. Decimal percent on total score.\n");
                textArea.append(" \n");
                textArea.append("version 6:\tAdded F3F/F3B Speed task (fastest time get 1000).\n");
                textArea.append(" \n");
                textArea.append("version 7:\tHandles frequency collisions when making flight groups.\n");
                textArea.append("\tCutting of maxtimes.\n");
                textArea.append("\tPenalty support.\n");
                textArea.append("\tPrinting support (Result, Scorecards, Startlist) .\n");
                textArea.append(" \n");
                textArea.append("version 8:\tMajor re-write of the entire program.\n");
                textArea.append("\tPasting data from Excel.\n");
                textArea.append("\tVarious improvements to the interface.\n");
                textArea.append("\tVarious improvements to the printing functions.\n");
                JScrollPane scrollPane = new JScrollPane(textArea, 22, 30);
                textArea.setCaretPosition(0);
                textArea.setEditable(false);
                this.add(scrollPane);
                this.setVisible(true);
            }
        }
        new HelpDialog(this);
    }

    private class F3kFileFilter
    extends FileFilter {
        private F3kFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (!f.isFile()) {
                return true;
            }
            if (this.getExtension(f) == null) {
                return false;
            }
            return this.getExtension(f).equalsIgnoreCase("f3k");
        }

        @Override
        public String getDescription() {
            return "F3KScore files (.f3k)";
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

