/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class RegistrationPane
extends AbstractF3KScoreEditorPanel {
    private static final int NAME_COLUMN = 1;
    private String[] colNames = new String[]{"", "Name", "Class", "Freq 1", "Freq 2", "Freq 3", "Country", "Club", "Info"};
    private int[] colWidth = new int[]{20, 200, 60, 60, 60, 60, 100, 100, 1500};

    public RegistrationPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new RegistrationTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.table.setColumnSelectionAllowed(true);
        int i = 0;
        while (i < this.colNames.length) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidth[i]);
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidth[i]);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.colNames.length - 1).setMinWidth(50);
        this.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        super.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        ExcelAdapter myAd = new ExcelAdapter(this.table);
        this.table.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "DELETE_ROWS");
        this.table.getActionMap().put("DELETE_ROWS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationPane.this.deleteAction(e);
            }
        });
    }

    private void deleteAction(ActionEvent e) {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int[] cols = this.table.getSelectedColumns();
        if (cols[0] <= 1 && cols[cols.length - 1] >= 1) {
            this.table.setRowSelectionInterval(rows[0], rows[rows.length - 1]);
            this.table.addColumnSelectionInterval(0, this.colNames.length - 1);
            int reply = JOptionPane.showConfirmDialog(this.table.getTopLevelAncestor(), "Delete selected rows?", "Delete rows?", 0);
            if (reply == 0) {
                ArrayList<Competitor> deletedPilots = new ArrayList<Competitor>();
                int row = rows[0];
                while (row <= rows[rows.length - 1]) {
                    deletedPilots.add(this.competition.getCompetitor(row));
                    ++row;
                }
                for (Competitor competitor : deletedPilots) {
                    this.competition.removeCompetitor(competitor);
                }
                this.tableModel.fireTableDataChanged();
            } else {
                this.table.clearSelection();
                this.table.removeEditor();
            }
        } else {
            int row = rows[0];
            while (row <= rows[rows.length - 1]) {
                int col = cols[0];
                while (col <= cols[cols.length - 1]) {
                    this.table.setValueAt("", row, col);
                    ++col;
                }
                ++row;
            }
            this.tableModel.fireTableDataChanged();
        }
        this.competition.setChangesMade(true);
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        int i = 0;
        while (i < this.colNames.length) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidth[i]);
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidth[i]);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.colNames.length - 1).setMinWidth(50);
    }

    private class RegistrationTableModel
    extends AbstractTableModel {
        private RegistrationTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            RegistrationPane.this.configurePanel();
        }

        @Override
        public int getColumnCount() {
            return RegistrationPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return RegistrationPane.this.competition.getCompetitorCount() + 1;
        }

        @Override
        public String getColumnName(int col) {
            return RegistrationPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col >= RegistrationPane.this.colNames.length || row >= RegistrationPane.this.competition.getCompetitorCount()) {
                return null;
            }
            if (col == 0) {
                return row + 1;
            }
            Competitor comp = RegistrationPane.this.competition.getCompetitor(row);
            if (comp != null && col >= 1 && col <= 8) {
                String propName = RegistrationPane.this.colNames[col];
                String val = comp.getProperty(propName);
                return val;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Competitor comp = RegistrationPane.this.competition.getCompetitor(row);
            if (comp == null) {
                if (RegistrationPane.this.colNames[col].equals("Name") && !RegistrationPane.this.competition.addCompetitor(new Competitor(RegistrationPane.this.competition, value.toString()))) {
                    JOptionPane.showMessageDialog(RegistrationPane.this, "Competitor \"" + value + "\" is already included in the list.", "Duplicate Name", 0);
                }
                return;
            }
            comp.setProperty(RegistrationPane.this.colNames[col], value.toString());
            this.fireTableDataChanged();
            RegistrationPane.this.competition.setChangesMade(true);
        }
    }
}

