/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Task;
import java.io.Serializable;
import java.util.Arrays;

public class RoundScore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int groupNumber;
    private Competition competition;
    private Task task;
    private int roundNumber;
    private int[] flightTimes;
    private int totalTime;

    public RoundScore(Competition competition, int roundNumber, Task task) {
        this.competition = competition;
        this.task = task;
        this.roundNumber = roundNumber;
        this.groupNumber = 1;
        this.flightTimes = new int[20];
        Arrays.fill(this.flightTimes, -1);
    }

    private void calcTotalTime() {
        this.totalTime = 0;
        if (this.task != null) {
            int[] nArray = this.flightTimes;
            int n = this.flightTimes.length;
            int n2 = 0;
            while (n2 < n) {
                Integer time = nArray[n2];
                if (time > 0) {
                    this.totalTime += time.intValue();
                }
                ++n2;
            }
        }
    }

    public int getTotalTime() {
        if (this.competition.getRoundTask(this.roundNumber) != this.task) {
            this.task = this.competition.getRoundTask(this.roundNumber);
            this.calcTotalTime();
        }
        return this.totalTime;
    }

    public int getGroup() {
        return this.groupNumber;
    }

    public void setGroup(int inGroup) {
        this.groupNumber = inGroup;
        this.competition.setResultDirty();
    }

    public int getTime(int timeIndex) {
        return this.flightTimes[timeIndex];
    }

    public void setTime(int timeIndex, int time) {
        this.flightTimes[timeIndex] = time;
        this.calcTotalTime();
        this.competition.setResultDirty();
    }
}

