/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;

public class RoundScoresPane
extends AbstractF3KScoreEditorPanel {
    private JSpinner taskSelectSpinner;
    private JLabel taskDescription;
    JScrollPane scrollPane;

    public RoundScoresPane(Competition competition) {
        this.competition = competition;
        Font font = new Font("serif", 1, 18);
        this.taskSelectSpinner = new JSpinner();
        this.taskSelectSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RoundScoresPane.this.roundChanged();
            }
        });
        JLabel taskSelectLabel = new JLabel("Round:");
        taskSelectLabel.setFont(font);
        this.taskDescription = new JLabel();
        this.taskDescription.setFont(font);
        this.tableModel = new RoundScoresTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.scrollPane = new JScrollPane(this.table);
        this.configurePanel();
        ExcelAdapter myAd = new ExcelAdapter(this.table);
        this.setLayout(new GridBagLayout());
        this.add((Component)taskSelectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 0), 0, 0));
        this.add((Component)this.taskSelectSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.add((Component)this.taskDescription, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.taskSelectSpinner.setModel(new SpinnerNumberModel(this.competition.getSelectedRoundIndex() + 1, 1, this.competition.getNumberOfRounds(), 1));
        this.taskDescription.setText(this.competition.getSelectedTask().getLongName());
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        int i = 1;
        while (i <= this.competition.getSelectedTask().getNumFlights() + 2) {
            this.table.getColumnModel().getColumn(i).setMinWidth(80);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(80);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.competition.getSelectedTask().getNumFlights() + 3).setPreferredWidth(2000);
    }

    public void roundChanged() {
        String params = this.taskSelectSpinner.getValue().toString();
        int tcount = Integer.parseInt(params);
        this.competition.setSelectedRoundIndex(tcount - 1);
        this.tableModel.fireTableStructureChanged();
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    private class RoundScoresTableModel
    extends AbstractTableModel {
        private RoundScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            RoundScoresPane.this.configurePanel();
        }

        @Override
        public int getColumnCount() {
            return RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 4;
        }

        @Override
        public int getRowCount() {
            if (RoundScoresPane.this.competition.getCompetitorCount() == 0) {
                return 0;
            }
            return RoundScoresPane.this.competition.getCompetitorCount() + RoundScoresPane.this.competition.getGroupCount(RoundScoresPane.this.competition.getSelectedRoundIndex());
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            if (col > RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 2) {
                return "";
            }
            if (col == RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 1) {
                return "Sum";
            }
            if (col == RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 2) {
                return "Score";
            }
            int timeCut = RoundScoresPane.this.competition.getSelectedTask().getMaxTimeCut(col - 1);
            if (timeCut <= 0) {
                return "T-" + col;
            }
            return "T-" + col + " (max " + timeCut + ")";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col > RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 2) {
                return "";
            }
            int round = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor comp = RoundScoresPane.this.competition.getCompetitorInRoundScoresTable(round, row);
            if (comp != null) {
                if (col == 0) {
                    return comp.getName();
                }
                if (col < RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 1) {
                    int time = comp.getTaskTime(RoundScoresPane.this.competition.getSelectedRoundIndex(), col - 1);
                    if (time >= 0) {
                        return "" + time;
                    }
                    return "";
                }
                if (col == RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 1) {
                    int time = comp.getTaskTotalTime(RoundScoresPane.this.competition.getSelectedRoundIndex());
                    if (time > 0) {
                        return "" + time;
                    }
                    return "";
                }
                if (col == RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 2) {
                    int score = RoundScoresPane.this.competition.getTaskScore(round, comp.getGroup(round), comp.getTaskTotalTime(round));
                    if (score > 0) {
                        return "" + score;
                    }
                    return "";
                }
                return "";
            }
            if (col == 0) {
                int groupNumber = RoundScoresPane.this.competition.getGroupInRound(round, row);
                if (RoundScoresPane.this.competition.useLetterGroupNames()) {
                    String letter = Competition.groupLetters.get(groupNumber - 1);
                    return "#########   Group \"" + letter + "\"  #########";
                }
                return "##########  Group " + groupNumber + "  ##########";
            }
            return "###########";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int round = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor comp = RoundScoresPane.this.competition.getCompetitorInRoundScoresTable(round, row);
            return comp != null && col > 0 && col < RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int round = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor comp = RoundScoresPane.this.competition.getCompetitorInRoundScoresTable(round, row);
            if (comp == null) {
                return;
            }
            int maxTimesCount = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            int timeIndex = col - 1;
            if (timeIndex < 0 || timeIndex >= maxTimesCount) {
                return;
            }
            String valString = value.toString().trim();
            int time = 0;
            if (valString.length() > 0) {
                try {
                    int dotPos = valString.indexOf(46);
                    if (dotPos == -1) {
                        dotPos = valString.indexOf(58);
                    }
                    if (dotPos == -1) {
                        time = Integer.parseInt(valString);
                    } else {
                        String secString = valString.substring(dotPos + 1);
                        String minString = valString.substring(0, dotPos);
                        time = Integer.parseInt(minString) * 60 + Integer.parseInt(secString);
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(RoundScoresPane.this, "Invalid entry: \"" + value + "\"", "Invalid Entry", 0);
                    return;
                }
                int maxTimeCut = RoundScoresPane.this.competition.getSelectedTask().getMaxTimeCut(timeIndex);
                int minTimeCut = RoundScoresPane.this.competition.getSelectedTask().getMinTimeCut(timeIndex);
                if (maxTimeCut > 0 && time > maxTimeCut) {
                    time = maxTimeCut;
                }
                if (time < minTimeCut && time > 0) {
                    time = minTimeCut;
                }
            } else {
                time = -1;
            }
            comp.setTaskTime(RoundScoresPane.this.competition.getSelectedRoundIndex(), timeIndex, time);
            this.fireTableDataChanged();
            RoundScoresPane.this.competition.setChangesMade(true);
        }
    }
}

