/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import java.io.Serializable;

public class Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FLIGHT_TIMES = 20;
    private int fIndex;
    private int numFlights;
    private String name;
    private String longName;
    private int[] maxTimes;
    private int[] minTimes;
    private boolean isSpeedTask;

    public Task(String name, String longName, int[] maxTimes, int[] minTimes, boolean isSpeedTask) {
        this.name = name;
        this.longName = longName;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.isSpeedTask = isSpeedTask;
        this.numFlights = maxTimes.length;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
    }

    public Task(String name, String longName, int[] maxTimes) {
        this(name, longName, maxTimes, null, false);
    }

    public Task(String name, String longName, int[] maxTimes, int[] minTimes) {
        this(name, longName, maxTimes, minTimes, false);
    }

    public boolean isSpeedTask() {
        return this.isSpeedTask;
    }

    public int getPoolIndex() {
        return this.fIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getNumFlights() {
        return this.numFlights;
    }

    public String toString() {
        return this.name;
    }

    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }
}

