/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TotalScoresPane
extends AbstractF3KScoreEditorPanel {
    public TotalScoresPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new TotalScoresTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(3);
        this.configurePanel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.table.getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setMinWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        int col = 2;
        while (col < this.competition.getNumberOfRounds() + 5) {
            this.table.getColumnModel().getColumn(col).setMinWidth(45);
            this.table.getColumnModel().getColumn(col).setPreferredWidth(45);
            ++col;
        }
        this.table.getColumnModel().getColumn(col).setMinWidth(65);
        this.table.getColumnModel().getColumn(col++).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(col).setMinWidth(65);
        this.table.getColumnModel().getColumn(col++).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(col).setMinWidth(65);
        this.table.getColumnModel().getColumn(col++).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(col).setPreferredWidth(2000);
    }

    private class TotalScoresTableModel
    extends AbstractTableModel {
        private TotalScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            TotalScoresPane.this.configurePanel();
        }

        @Override
        public int getColumnCount() {
            return TotalScoresPane.this.competition.getNumberOfRounds() + 9;
        }

        @Override
        public int getRowCount() {
            return TotalScoresPane.this.competition.getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            String[] colNames = new String[]{"", "Name", "Penalty", "Score", "%", "Class", "Country", "Team", ""};
            if (col < 2) {
                return colNames[col];
            }
            if (col < 2 + TotalScoresPane.this.competition.getNumberOfRounds()) {
                return "" + (col - 1);
            }
            return colNames[col - TotalScoresPane.this.competition.getNumberOfRounds()];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor comp = TotalScoresPane.this.competition.getCompetitorAtPosition(row);
            if (comp == null) {
                return "";
            }
            if (col > TotalScoresPane.this.competition.getNumberOfRounds() + 6) {
                return "";
            }
            if (col == 0) {
                return "" + (row + 1);
            }
            if (col == 1) {
                return comp.getName();
            }
            if (col < TotalScoresPane.this.competition.getNumberOfRounds() + 2) {
                int round = col - 2;
                int roundScore = TotalScoresPane.this.competition.getTaskScore(round, comp.getGroup(round), comp.getTaskTotalTime(round));
                if (roundScore == 0) {
                    return "";
                }
                if (comp.isDiscardRound(round)) {
                    return "(" + roundScore + ")";
                }
                return "" + roundScore;
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 2) {
                int penalty = comp.getPenalty();
                if (penalty != 0) {
                    return "" + comp.getPenalty();
                }
                return "";
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 3) {
                int score = comp.getTotalScore();
                if (score != 0) {
                    return "" + comp.getTotalScore();
                }
                return "";
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 4) {
                float val = comp.getPercent();
                if (val != 0.0f) {
                    String perc = String.valueOf(Float.toString(comp.getPercent())) + "00000";
                    return perc.substring(0, 5) + "%";
                }
                return "";
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 5) {
                return comp.getCompetitorClass();
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 6) {
                return comp.getCountry();
            }
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 7) {
                return comp.getClub();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == TotalScoresPane.this.competition.getNumberOfRounds() + 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == TotalScoresPane.this.competition.getNumberOfRounds() + 2) {
                int val = -1;
                try {
                    val = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (val % 100 != 0) {
                    JOptionPane.showMessageDialog(TotalScoresPane.this, "Invalid entry for Penalty. The value must be an integer multiple of 100.", "Invalid Entry", 0);
                    return;
                }
                Competitor comp = TotalScoresPane.this.competition.getCompetitorAtPosition(row);
                int reply = JOptionPane.showConfirmDialog(TotalScoresPane.this, "Change penalty for \"" + comp.getName() + "\" to " + value + "?", "Penalty Changed", 2);
                if (reply != 0) {
                    return;
                }
                comp.setPenalty(Integer.parseInt(value.toString()));
                TotalScoresPane.this.competition.setResultDirty();
                this.fireTableDataChanged();
                TotalScoresPane.this.competition.setChangesMade(true);
            }
        }
    }
}

