/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.F3KScore;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;

public class PrintUtils {
    private static Font fontPlain12pt = new Font("Serif", 0, 12);
    private static Font fontBold12pt = new Font("Serif", 1, 12);
    private static Font fontUnBold12pt = new Font("Serif", 1, 12);
    private static Font fontPlain10pt = new Font("Serif", 0, 10);
    private static Font fontBold10pt = new Font("Serif", 1, 10);
    private static Font fontPlain8pt = new Font("Serif", 0, 8);
    private static Font fontBold8pt = new Font("Serif", 1, 8);
    private static Font fontBold6pt = new Font("Serif", 1, 6);
    private static PrinterJob printerJob;
    private static PageFormat format;

    static {
        Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        fontUnBold12pt = fontUnBold12pt.deriveFont(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printData(final Printable printer) {
        int reply;
        if (F3KScore.editor().getCompetition().getCompetitorCount() == 0 && (reply = JOptionPane.showConfirmDialog(F3KScore.editor(), "You have no pilots in your competition. Do you still want to continue printing?", "No competition pilots", 0)) != 0) {
            return;
        }
        if (printerJob == null) {
            printerJob = PrinterJob.getPrinterJob();
        }
        if (format == null) {
            format = printerJob.defaultPage(new PageFormat());
        }
        try {
            printerJob.getPrintService();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "Unable to get Print Service. Verify that Print Service is running on your computer.", "Printing Error", 0);
            return;
        }
        final PageFormat pf = printerJob.pageDialog(format);
        if (pf == format) {
            return;
        }
        format = pf;
        Pageable myPages = new Pageable(){

            @Override
            public int getNumberOfPages() {
                int nPages = 0;
                while (nPages < 999) {
                    try {
                        if (printer.print(null, pf, nPages) == 1) {
                            break;
                        }
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                    ++nPages;
                }
                return nPages;
            }

            @Override
            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                return pf;
            }

            @Override
            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return printer;
            }
        };
        printerJob.setPageable(myPages);
        boolean doPrint = printerJob.printDialog();
        if (doPrint) {
            try {
                Printable printable = printer;
                synchronized (printable) {
                    printerJob.print();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(F3KScore.editor(), "Failed to print data:\n\n" + e.getLocalizedMessage(), "Print error", 0);
            }
        }
    }

    public static void printPilotList(final ArrayList<Integer> printTotalColumns, final int nRows) {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    int height = (int)pf.getImageableHeight();
                    int width = (int)pf.getImageableWidth();
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    float fontSize = fontPlain10pt.getSize2D();
                    float charWidth = fontSize * 0.5f;
                    int colCount = printTotalColumns.size();
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float leftMargin = 20.0f;
                    float rightMargin = 20.0f;
                    float x0 = leftMargin;
                    float y = y0;
                    int[] columnWidth = new int[colCount];
                    boolean doubleLineHeader = false;
                    int i = 0;
                    while (i < colCount) {
                        int index = (Integer)printTotalColumns.get(i);
                        columnWidth[i] = (int)(1.0 * (double)F3KScore.editor().getRegistrationPane().getTable().getColumnModel().getColumn(index).getPreferredWidth());
                        String s = F3KScore.editor().getRegistrationPane().getTableModel().getColumnName(i);
                        if (s.contains("\n")) {
                            doubleLineHeader = true;
                        } else if ((double)s.length() > (double)columnWidth[i] / (1.2 * (double)charWidth)) {
                            columnWidth[i] = (int)((double)s.length() * 1.2 * (double)charWidth + 3.0);
                        }
                        ++i;
                    }
                    int pageRow = 0;
                    int pageCount = 0;
                    int totalTableWidth = 0;
                    int i2 = 0;
                    while (i2 < colCount) {
                        totalTableWidth += columnWidth[i2];
                        ++i2;
                    }
                    int pagesPerRow = (int)Math.ceil((float)totalTableWidth / ((float)width - leftMargin - rightMargin));
                    if (F3KScore.editor().getCompetition().getCompetitionName() != null && F3KScore.editor().getCompetition().getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.editor().getCompetition().getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    float y1 = y - (float)rowHeight;
                    boolean header = true;
                    int rowIx = 0;
                    int row0 = 0;
                    while (rowIx < nRows) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            y1 = y - (float)rowHeight;
                            ++pageRow;
                            header = true;
                            row0 = rowIx;
                        }
                        int pageCol = 0;
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            float colWidth = columnWidth[colIx];
                            if (x + colWidth > (float)width - rightMargin) {
                                x = x0;
                                ++pageCol;
                            }
                            if ((pageCount = pageRow * pagesPerRow + pageCol) == page && g != null) {
                                int colIndex = (Integer)printTotalColumns.get(colIx);
                                if (header) {
                                    g.setFont(fontBold10pt);
                                    String s = F3KScore.editor().getRegistrationPane().getTableModel().getColumnName(colIndex);
                                    if (doubleLineHeader) {
                                        if (s.contains("\n")) {
                                            doubleLineHeader = true;
                                            String s1 = s.split("\n")[0];
                                            String s2 = s.split("\n")[1];
                                            g.drawString(s1, (int)(x + 0.0f), (int)y);
                                            g.drawString(s2, (int)x, (int)(y + (float)rowHeight));
                                        } else {
                                            g.drawString(s, (int)x, (int)y + rowHeight);
                                        }
                                        g.drawLine((int)x, (int)y + 3 + rowHeight, (int)(x + colWidth), (int)y + 3 + rowHeight);
                                    } else {
                                        g.drawString(s, (int)x, (int)y);
                                        g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                    }
                                } else {
                                    String s;
                                    g.setFont(fontPlain10pt);
                                    Object val = F3KScore.editor().getRegistrationPane().getTableModel().getValueAt(rowIx, colIndex);
                                    String string = s = val != null ? val.toString() : "";
                                    if ((float)s.length() > colWidth / charWidth) {
                                        s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                    }
                                    g.drawString(s, (int)x, (int)y);
                                    g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                }
                                if (x > x0) {
                                    if (header && doubleLineHeader) {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2 + rowHeight);
                                    } else {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2);
                                    }
                                }
                            }
                            x += colWidth;
                            ++colIx;
                        }
                        if (header) {
                            header = false;
                            y += 2.0f;
                            --rowIx;
                            if (doubleLineHeader) {
                                y += (float)rowHeight;
                            }
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            y += 2.0f;
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (page + 1 > (pageRow + 1) * pagesPerRow) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printTaskList() {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    float leftMargin;
                    Graphics2D g2d = (Graphics2D)g;
                    int height = (int)pf.getImageableHeight();
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    float fontSize = fontPlain10pt.getSize2D();
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float x0 = leftMargin = 10.0f;
                    float y = y0;
                    int colCount = 3;
                    int[] columnWidth = new int[]{40, 130, 300};
                    int rowIx = 0;
                    int pageCount = 0;
                    while (true) {
                        if (pageCount == 0 && F3KScore.editor().getCompetition().getCompetitionName() != null && F3KScore.editor().getCompetition().getCompetitionName().length() > 0) {
                            if (page == 0 && g != null) {
                                g.setFont(fontBold10pt);
                                String title = F3KScore.editor().getCompetition().getCompetitionName();
                                g.drawString(title, (int)x0, (int)y);
                            }
                            y += (float)(rowHeight + 5);
                        }
                        float y1 = y - (float)rowHeight;
                        if (g != null) {
                            g.setFont(fontBold10pt);
                        }
                        boolean header = true;
                        int row0 = rowIx;
                        while (rowIx < F3KScore.editor().getTasksPane().getTableModel().getRowCount()) {
                            if (y >= (float)height - bottomMargin) {
                                y = y0;
                                break;
                            }
                            float x = x0;
                            if (pageCount == page) {
                                int colIx = 0;
                                while (colIx < colCount) {
                                    String s;
                                    float colWidth = columnWidth[colIx];
                                    if (header) {
                                        s = F3KScore.editor().getTasksPane().getTableModel().getColumnName(colIx);
                                        if (g != null) {
                                            g.drawString(s, (int)x, (int)y);
                                        }
                                    } else {
                                        s = (String)F3KScore.editor().getTasksPane().getTableModel().getValueAt(rowIx, colIx);
                                        if (g != null) {
                                            g.drawString(s, (int)x, (int)y);
                                        }
                                    }
                                    x += colWidth;
                                    ++colIx;
                                }
                            }
                            if (header) {
                                header = false;
                                if (g != null) {
                                    g.setFont(fontPlain10pt);
                                }
                                --rowIx;
                            }
                            if (pageCount == page && g != null) {
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                            }
                            y += 2.0f;
                            if (pageCount == page && g != null) {
                                x = x0 - 4.0f;
                                int i = 0;
                                while (i < 2) {
                                    int colW = columnWidth[i];
                                    g.drawLine((int)(x += (float)colW), (int)y1, (int)x, (int)y + 2);
                                    ++i;
                                }
                            }
                            y1 = y;
                            y += (float)rowHeight;
                            ++rowIx;
                        }
                        if (pageCount == page) {
                            return 0;
                        }
                        if (rowIx >= F3KScore.editor().getTasksPane().getTableModel().getRowCount()) {
                            return 1;
                        }
                        ++pageCount;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printFlightMatrix() {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    int height = (int)pf.getImageableHeight();
                    int width = (int)pf.getImageableWidth();
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    float fontSize = fontPlain10pt.getSize2D();
                    float charWidth = fontSize * 0.5f;
                    int colCount = F3KScore.editor().getGroupsPane().getTableModel().getColumnCount() - 1;
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float leftMargin = 20.0f;
                    float rightMargin = 20.0f;
                    float x0 = leftMargin;
                    float y = y0;
                    boolean doubleLineHeader = false;
                    int nChars = 3;
                    String shortName = F3KScore.editor().getCompetition().getRoundTask(0).getShortName();
                    if (shortName != null && shortName.length() != 0) {
                        nChars = 4;
                        doubleLineHeader = true;
                    }
                    int[] columnWidth = new int[colCount];
                    Arrays.fill(columnWidth, (int)((float)nChars * charWidth));
                    columnWidth[0] = (int)(3.0f * charWidth) + 2;
                    columnWidth[1] = (int)(20.0f * charWidth);
                    int pageRow = 0;
                    int pageCount = 0;
                    int totalTableWidth = 0;
                    int i = 0;
                    while (i < colCount) {
                        totalTableWidth += columnWidth[i];
                        ++i;
                    }
                    int pagesPerRow = (int)Math.ceil((float)totalTableWidth / ((float)width - leftMargin - rightMargin));
                    if (F3KScore.editor().getCompetition().getCompetitionName() != null && F3KScore.editor().getCompetition().getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.editor().getCompetition().getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 8);
                    }
                    float y1 = y - (float)rowHeight;
                    boolean header = true;
                    int rowIx = 0;
                    int row0 = 0;
                    while (rowIx < F3KScore.editor().getGroupsPane().getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            y1 = y - (float)rowHeight;
                            ++pageRow;
                            header = true;
                            row0 = rowIx;
                        }
                        int pageCol = 0;
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            float colWidth = columnWidth[colIx];
                            if (x + colWidth > (float)width - rightMargin) {
                                x = x0;
                                ++pageCol;
                            }
                            if ((pageCount = pageRow * pagesPerRow + pageCol) == page && g != null) {
                                String s;
                                int colIndex = colIx;
                                if (header) {
                                    g.setFont(fontBold10pt);
                                    s = F3KScore.editor().getTotalPane().getTableModel().getColumnName(colIndex);
                                    if (doubleLineHeader) {
                                        if (s.contains("\n")) {
                                            doubleLineHeader = true;
                                            String s1 = s.split("\n")[0];
                                            String s2 = s.split("\n")[1];
                                            g.drawString(s1, (int)(x + 0.0f), (int)y);
                                            g.setFont(fontBold6pt);
                                            g.drawString(s2, (int)x, (int)(y + (float)rowHeight));
                                        } else {
                                            g.drawString(s, (int)x, (int)y + rowHeight);
                                        }
                                        g.drawLine((int)x, (int)y + 3 + rowHeight, (int)(x + colWidth), (int)y + 3 + rowHeight);
                                    } else {
                                        g.drawString(s, (int)x, (int)y);
                                        g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                    }
                                } else {
                                    g.setFont(fontPlain10pt);
                                    s = (String)F3KScore.editor().getGroupsPane().getTableModel().getValueAt(rowIx, colIndex);
                                    if (s == null) {
                                        s = "";
                                    }
                                    g.drawString(s, (int)x, (int)y);
                                    if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                                        g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                    }
                                }
                                if (x > x0) {
                                    if (header && doubleLineHeader) {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2 + rowHeight);
                                    } else {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2);
                                    }
                                }
                            }
                            x += colWidth;
                            ++colIx;
                        }
                        if (header) {
                            header = false;
                            y += 2.0f;
                            --rowIx;
                            if (doubleLineHeader) {
                                y += (float)rowHeight;
                            }
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            y += 2.0f;
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (page + 1 > (pageRow + 1) * pagesPerRow) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printTotalScores(final ArrayList<Integer> printTotalColumns) {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    int height = (int)pf.getImageableHeight();
                    int width = (int)pf.getImageableWidth();
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    float fontSize = fontPlain10pt.getSize2D();
                    float charWidth = fontSize * 0.5f;
                    int colCount = printTotalColumns.size();
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float leftMargin = 20.0f;
                    float rightMargin = 20.0f;
                    float x0 = leftMargin;
                    float y = y0;
                    int[] columnWidth = new int[colCount];
                    boolean doubleLineHeader = false;
                    int i = 0;
                    while (i < colCount) {
                        int index = (Integer)printTotalColumns.get(i);
                        columnWidth[i] = (int)(0.7 * (double)F3KScore.editor().getTotalPane().getTable().getColumnModel().getColumn(index).getPreferredWidth());
                        String s = F3KScore.editor().getTotalPane().getTableModel().getColumnName(index);
                        if (s.contains("\n")) {
                            doubleLineHeader = true;
                        }
                        ++i;
                    }
                    int pageRow = 0;
                    int pageCount = 0;
                    int totalTableWidth = 0;
                    int i2 = 0;
                    while (i2 < colCount) {
                        totalTableWidth += columnWidth[i2];
                        ++i2;
                    }
                    int pagesPerRow = (int)Math.ceil((float)totalTableWidth / ((float)width - leftMargin - rightMargin));
                    if (F3KScore.editor().getCompetition().getCompetitionName() != null && F3KScore.editor().getCompetition().getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.editor().getCompetition().getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    float y1 = y - (float)rowHeight;
                    boolean header = true;
                    int rowIx = 0;
                    int row0 = 0;
                    while (rowIx < F3KScore.editor().getTotalPane().getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            y1 = y - (float)rowHeight;
                            ++pageRow;
                            header = true;
                            row0 = rowIx;
                        }
                        int pageCol = 0;
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            float colWidth = columnWidth[colIx];
                            if (x + colWidth > (float)width - rightMargin) {
                                x = x0;
                                ++pageCol;
                            }
                            if ((pageCount = pageRow * pagesPerRow + pageCol) == page && g != null) {
                                String s;
                                int colIndex = (Integer)printTotalColumns.get(colIx);
                                if (header) {
                                    g.setFont(fontBold10pt);
                                    s = F3KScore.editor().getTotalPane().getTableModel().getColumnName(colIndex);
                                    if (doubleLineHeader) {
                                        if (s.contains("\n")) {
                                            doubleLineHeader = true;
                                            String s1 = s.split("\n")[0];
                                            String s2 = s.split("\n")[1];
                                            g.drawString(s1, (int)(x + 0.0f), (int)y);
                                            g.drawString(s2, (int)x, (int)(y + (float)rowHeight));
                                        } else {
                                            g.drawString(s, (int)x, (int)y + rowHeight);
                                        }
                                        g.drawLine((int)x, (int)y + 3 + rowHeight, (int)(x + colWidth), (int)y + 3 + rowHeight);
                                    } else {
                                        g.drawString(s, (int)x, (int)y);
                                        g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                    }
                                } else {
                                    g.setFont(fontPlain10pt);
                                    s = (String)F3KScore.editor().getTotalPane().getTableModel().getValueAt(rowIx, colIndex);
                                    if (s == null) {
                                        s = "";
                                    }
                                    if (s.startsWith("(") && s.endsWith(")")) {
                                        s = s.substring(1, s.length() - 1);
                                        g.drawLine((int)x, (int)y - 6, (int)(x + colWidth - 22.0f), (int)y);
                                    }
                                    if ((float)s.length() > colWidth / charWidth) {
                                        s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                    }
                                    g.drawString(s, (int)x, (int)y);
                                    if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                                        g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                    }
                                }
                                if (x > x0) {
                                    if (header && doubleLineHeader) {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2 + rowHeight);
                                    } else {
                                        g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2);
                                    }
                                }
                            }
                            x += colWidth;
                            ++colIx;
                        }
                        if (header) {
                            header = false;
                            y += 2.0f;
                            --rowIx;
                            if (doubleLineHeader) {
                                y += (float)rowHeight;
                            }
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            y += 2.0f;
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (page + 1 > (pageRow + 1) * pagesPerRow) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printTeamScores() {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    float fontSize = fontPlain10pt.getSize2D();
                    float charWidth = fontSize * 0.5f;
                    int colCount = 5;
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float leftMargin = 10.0f;
                    Graphics2D g2d = (Graphics2D)g;
                    int height = (int)pf.getImageableHeight();
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    float x0 = leftMargin;
                    float y = y0;
                    int[] columnWidthChars = new int[]{4, 40, 25, 11, 11};
                    int rowIx = 0;
                    int pageCount = 0;
                    while (true) {
                        if (pageCount == 0 && F3KScore.editor().getCompetition().getCompetitionName() != null && F3KScore.editor().getCompetition().getCompetitionName().length() > 0) {
                            if (page == 0 && g != null) {
                                g.setFont(fontBold10pt);
                                String title = String.format("%s - Team Scores", F3KScore.editor().getCompetition().getCompetitionName());
                                g.drawString(title, (int)x0, (int)y);
                            }
                            y += (float)(rowHeight + 5);
                        }
                        float y1 = y - (float)rowHeight;
                        if (g != null) {
                            g.setFont(fontBold10pt);
                        }
                        boolean header = true;
                        int row0 = rowIx;
                        while (rowIx < F3KScore.editor().getTeamsPane().getTableModel().getRowCount()) {
                            if (y >= (float)height - bottomMargin) {
                                y = y0;
                                break;
                            }
                            float x = x0;
                            boolean newTeamStarted = false;
                            if (pageCount == page) {
                                int colIx = 0;
                                while (colIx < colCount) {
                                    float colWidth = charWidth * (float)columnWidthChars[colIx];
                                    if (header) {
                                        String s = F3KScore.editor().getTeamsPane().getTableModel().getColumnName(colIx);
                                        if (g != null) {
                                            g.drawString(s, (int)x, (int)y);
                                        }
                                    } else {
                                        Object val = F3KScore.editor().getTeamsPane().getTableModel().getValueAt(rowIx, colIx);
                                        if (val != null) {
                                            String s = String.valueOf(val);
                                            if ((float)s.length() > colWidth / charWidth) {
                                                s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                            }
                                            if (g != null) {
                                                g.drawString(s, (int)x, (int)y);
                                            }
                                        }
                                        if (colIx == 0 && val != null) {
                                            newTeamStarted = true;
                                        }
                                    }
                                    x += colWidth;
                                    ++colIx;
                                }
                            }
                            if (header) {
                                header = false;
                                if (g != null) {
                                    g.setFont(fontPlain10pt);
                                }
                                y += 4.0f;
                                --rowIx;
                            } else if (newTeamStarted) {
                                if (pageCount == page && g != null) {
                                    g.drawLine((int)x0 - 2, (int)y - rowHeight, (int)x, (int)y - rowHeight);
                                }
                                y += 2.0f;
                                newTeamStarted = false;
                            }
                            if (pageCount == page && g != null) {
                                x = x0 - 4.0f;
                                int[] nArray = columnWidthChars;
                                int n = columnWidthChars.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Integer colW = nArray[n2];
                                    g.drawLine((int)(x += (float)((int)((float)colW.intValue() * charWidth))), (int)y1, (int)x, (int)y + 2);
                                    ++n2;
                                }
                                g.setColor(Color.BLACK);
                            }
                            y1 = y;
                            y += (float)rowHeight;
                            ++rowIx;
                        }
                        if (pageCount == page) {
                            return 0;
                        }
                        if (rowIx >= F3KScore.editor().getTeamsPane().getTableModel().getRowCount()) {
                            return 1;
                        }
                        ++pageCount;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printScoreCards(final int cardsPerPage) {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int roundCount;
                block25: {
                    roundCount = F3KScore.editor().getCompetition().getNumberOfRounds();
                    int pageCount = (int)Math.ceil((double)F3KScore.editor().getCompetition().getCompetitorCount() / (double)cardsPerPage) * roundCount;
                    if (F3KScore.editor().getCompetition().getCompetitorCount() == 0) {
                        pageCount = roundCount;
                    }
                    if (page < pageCount) break block25;
                    return 1;
                }
                try {
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    Font font = fontPlain12pt;
                    int rowHeight = (int)(font.getSize2D() * 1.2f);
                    int nCols = 2;
                    int nRows = cardsPerPage / 2;
                    if (cardsPerPage == 2) {
                        nCols = 1;
                        nRows = 2;
                    }
                    int cardWidth = width / nCols;
                    int cardHeight = height / nRows;
                    int roundIx = page % roundCount;
                    int card = 0;
                    while (card < cardsPerPage) {
                        int compIx = cardsPerPage * (page / roundCount) + card;
                        if (compIx >= F3KScore.editor().getCompetition().getCompetitorCount()) {
                            compIx = -1;
                        }
                        if (card == cardsPerPage / 2 && cardsPerPage > 2) {
                            if (g != null) {
                                g2d.translate(cardWidth * nCols, cardHeight * nRows);
                            }
                            if (g != null) {
                                g2d.rotate(Math.PI);
                            }
                        }
                        int row = card % nRows;
                        int xOffset = 0;
                        int yOffset = row * cardHeight;
                        if (g != null) {
                            g.drawRect(xOffset + 1, yOffset + 4, cardWidth - 5, cardHeight - 8);
                        }
                        xOffset += 20;
                        int yShift = cardHeight / 5 - 35;
                        yOffset += yShift > 0 ? yShift : 0;
                        String compName = F3KScore.editor().getCompetition().getCompetitionName();
                        float fontSize = fontPlain8pt.getSize2D();
                        if (compName == null) {
                            compName = "";
                        } else if ((double)((float)compName.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                            int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                            compName = String.valueOf(compName.substring(0, nChars)) + "...";
                        }
                        String name = String.format("Pilot:                                                    ", new Object[0]);
                        String groupString = "";
                        if (compIx >= 0) {
                            name = String.format("%d. %s", compIx + 1, F3KScore.editor().getCompetition().getCompetitor(compIx).getFullName());
                            int group = F3KScore.editor().getCompetition().getCompetitor(compIx).getGroupNum(roundIx);
                            groupString = "" + group;
                            if (F3KScore.editor().getCompetition().useLetterGroupNames()) {
                                F3KScore.editor().getCompetition();
                                groupString = Competition.groupLetters.get(group - 1);
                            }
                        }
                        String task = F3KScore.editor().getCompetition().getRoundTask(roundIx).getDescription();
                        String[] textTips = F3KScore.editor().getCompetition().getRoundTask(roundIx).getScoreCardTextTips();
                        if (g != null) {
                            g.setFont(fontBold8pt);
                            g.setColor(Color.GRAY);
                            g.drawString(compName, xOffset + cardWidth / 10, yOffset + 15 - (yShift > 0 ? yShift : 0));
                            g.setColor(Color.BLACK);
                            g.setFont(fontUnBold12pt);
                            g.drawString(name, xOffset + cardWidth / 10, yOffset + 15 + rowHeight * 1);
                            g.setFont(fontBold12pt);
                            g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 2);
                            g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 20 + rowHeight * 2);
                            g.setFont(fontPlain8pt);
                            fontSize = fontPlain8pt.getSize2D();
                            if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                task = String.valueOf(task.substring(0, nChars)) + "...";
                            }
                            g.drawString(task, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 3);
                        }
                        int xr = xOffset + cardWidth / 10;
                        int yr = yOffset + rowHeight * 5 - cardHeight / 6 + 0;
                        int c = 0;
                        while (c < 8) {
                            if (textTips != null && c >= textTips.length) break;
                            if ((c & 3) == 0) {
                                xr = xOffset + cardWidth / 10;
                                yr += cardHeight / 6 - 3;
                            }
                            if (g != null) {
                                g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                                if (textTips != null) {
                                    g.setFont(fontPlain8pt);
                                    g.setColor(Color.GRAY);
                                    g.drawString(textTips[c], xr + 1, yr + 8);
                                    g.setColor(Color.BLACK);
                                }
                            }
                            xr += cardWidth / 5;
                            ++c;
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Penalty:_________", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Sign Pilot:________", xOffset + cardWidth / 10, yOffset + cardHeight - 15 - yShift);
                            g.drawString("Timer:_______", xOffset + cardWidth / 2 + 5, yOffset + cardHeight - 15 - yShift);
                        }
                        ++card;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printScoreCardsSelectedPilot(final List<Competitor> selPilots, final int cardsPerPage) {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    int roundCount = F3KScore.editor().getCompetition().getNumberOfRounds();
                    int pageCountPerPilot = (int)Math.ceil((double)roundCount / (double)cardsPerPage);
                    int pageCount = pageCountPerPilot * selPilots.size();
                    if (page >= pageCount) {
                        return 1;
                    }
                    int pilotIndex = page / pageCountPerPilot;
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    Font font = fontPlain12pt;
                    int rowHeight = (int)(font.getSize2D() * 1.2f);
                    int nCols = 2;
                    int nRows = cardsPerPage / 2;
                    if (cardsPerPage == 2) {
                        nCols = 1;
                        nRows = 2;
                    }
                    int cardWidth = width / nCols;
                    int cardHeight = height / nRows;
                    int card = 0;
                    while (true) {
                        if (card >= cardsPerPage) {
                            return 0;
                        }
                        int roundIx = (page - pilotIndex * pageCountPerPilot) * cardsPerPage + card;
                        if (roundIx >= F3KScore.editor().getCompetition().getNumberOfRounds()) {
                            return 0;
                        }
                        if (card == cardsPerPage / 2 && cardsPerPage > 2) {
                            if (g != null) {
                                g2d.translate(cardWidth * nCols, cardHeight * nRows);
                            }
                            if (g != null) {
                                g2d.rotate(Math.PI);
                            }
                        }
                        int row = card % nRows;
                        int xOffset = 0;
                        int yOffset = row * cardHeight;
                        if (g != null) {
                            g.drawRect(xOffset + 1, yOffset + 4, cardWidth - 5, cardHeight - 8);
                        }
                        xOffset += 20;
                        int yShift = cardHeight / 5 - 35;
                        yOffset += yShift > 0 ? yShift : 0;
                        String compName = F3KScore.editor().getCompetition().getCompetitionName();
                        float fontSize = fontPlain8pt.getSize2D();
                        if (compName == null) {
                            compName = "";
                        } else if ((double)((float)compName.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                            int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                            compName = String.valueOf(compName.substring(0, nChars)) + "...";
                        }
                        String name = ((Competitor)selPilots.get(pilotIndex)).getFullName();
                        name = String.format("%d. %s", pilotIndex + 1, F3KScore.editor().getCompetition().getCompetitor(pilotIndex).getFullName());
                        int group = ((Competitor)selPilots.get(pilotIndex)).getGroupNum(roundIx);
                        String groupString = F3KScore.editor().getCompetition().formatGroupNumberAsString(group);
                        String task = F3KScore.editor().getCompetition().getRoundTask(roundIx).getDescription();
                        String[] textTips = F3KScore.editor().getCompetition().getRoundTask(roundIx).getScoreCardTextTips();
                        if (g != null) {
                            g.setFont(fontBold8pt);
                            g.setColor(Color.GRAY);
                            g.drawString(compName, xOffset + cardWidth / 10, yOffset + 15 - (yShift > 0 ? yShift : 0));
                            g.setColor(Color.BLACK);
                            g.setFont(fontUnBold12pt);
                            g.drawString(name, xOffset + cardWidth / 10, yOffset + 15 + rowHeight * 1);
                            g.setFont(fontBold12pt);
                            g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 2);
                            g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 20 + rowHeight * 2);
                            g.setFont(fontPlain8pt);
                            fontSize = fontPlain8pt.getSize2D();
                            if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                task = String.valueOf(task.substring(0, nChars)) + "...";
                            }
                            g.drawString(task, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 3);
                        }
                        int xr = xOffset + cardWidth / 10;
                        int yr = yOffset + rowHeight * 5 - cardHeight / 6 + 0;
                        int c = 0;
                        while (c < 8 && (textTips == null || c < textTips.length)) {
                            if ((c & 3) == 0) {
                                xr = xOffset + cardWidth / 10;
                                yr += cardHeight / 6 - 3;
                            }
                            if (g != null) {
                                g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                                if (textTips != null) {
                                    g.setFont(fontPlain8pt);
                                    g.setColor(Color.GRAY);
                                    g.drawString(textTips[c], xr + 1, yr + 8);
                                    g.setColor(Color.BLACK);
                                }
                            }
                            xr += cardWidth / 5;
                            ++c;
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Penalty:_________", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Sign Pilot:________", xOffset + cardWidth / 10, yOffset + cardHeight - 15 - yShift);
                            g.drawString("Timer:_______", xOffset + cardWidth / 2 + 5, yOffset + cardHeight - 15 - yShift);
                        }
                        ++card;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printScoreCardsSelectedPilotTaskGroup(final List<Competitor> selPilots, final int roundIndex, final List<Integer> groupList, final int cardsPerPage) {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    int nCards = selPilots.size();
                    int pageCount = (int)Math.ceil((double)nCards / (double)cardsPerPage);
                    if (page >= pageCount) {
                        return 1;
                    }
                    int pilotIndex = page * cardsPerPage;
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    Font font = fontPlain12pt;
                    int rowHeight = (int)(font.getSize2D() * 1.2f);
                    int nCols = 2;
                    int nRows = cardsPerPage / 2;
                    if (cardsPerPage == 2) {
                        nCols = 1;
                        nRows = 2;
                    }
                    int cardWidth = width / nCols;
                    int cardHeight = height / nRows;
                    int card = 0;
                    while (true) {
                        if (card >= cardsPerPage) {
                            return 0;
                        }
                        if (pilotIndex >= selPilots.size()) {
                            return 0;
                        }
                        if (card == cardsPerPage / 2 && cardsPerPage > 2) {
                            if (g != null) {
                                g2d.translate(cardWidth * nCols, cardHeight * nRows);
                            }
                            if (g != null) {
                                g2d.rotate(Math.PI);
                            }
                        }
                        int row = card % nRows;
                        int xOffset = 0;
                        int yOffset = row * cardHeight;
                        if (g != null) {
                            g.drawRect(xOffset + 1, yOffset + 4, cardWidth - 5, cardHeight - 8);
                        }
                        xOffset += 20;
                        int yShift = cardHeight / 5 - 35;
                        yOffset += yShift > 0 ? yShift : 0;
                        String compName = F3KScore.editor().getCompetition().getCompetitionName();
                        float fontSize = fontPlain8pt.getSize2D();
                        if (compName == null) {
                            compName = "";
                        } else if ((double)((float)compName.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                            int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                            compName = String.valueOf(compName.substring(0, nChars)) + "...";
                        }
                        String name = ((Competitor)selPilots.get(pilotIndex)).getFullName();
                        name = String.format("%d. %s", ((Competitor)selPilots.get(pilotIndex)).getStartNumber(), ((Competitor)selPilots.get(pilotIndex)).getFullName());
                        int group = (Integer)groupList.get(pilotIndex);
                        String groupString = F3KScore.editor().getCompetition().formatGroupNumberAsString(group);
                        String task = F3KScore.editor().getCompetition().getRoundTask(roundIndex).getDescription();
                        String[] textTips = F3KScore.editor().getCompetition().getRoundTask(roundIndex).getScoreCardTextTips();
                        if (g != null) {
                            g.setFont(fontBold8pt);
                            g.setColor(Color.GRAY);
                            g.drawString(compName, xOffset + cardWidth / 10, yOffset + 15 - (yShift > 0 ? yShift : 0));
                            g.setColor(Color.BLACK);
                            g.setFont(fontUnBold12pt);
                            g.drawString(name, xOffset + cardWidth / 10, yOffset + 15 + rowHeight * 1);
                            g.setFont(fontBold12pt);
                            g.drawString("Round:  " + (roundIndex + 1), xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 2);
                            g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 20 + rowHeight * 2);
                            g.setFont(fontPlain8pt);
                            fontSize = fontPlain8pt.getSize2D();
                            if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                task = String.valueOf(task.substring(0, nChars)) + "...";
                            }
                            g.drawString(task, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 3);
                        }
                        int xr = xOffset + cardWidth / 10;
                        int yr = yOffset + rowHeight * 5 - cardHeight / 6 + 0;
                        int c = 0;
                        while (c < 8 && (textTips == null || c < textTips.length)) {
                            if ((c & 3) == 0) {
                                xr = xOffset + cardWidth / 10;
                                yr += cardHeight / 6 - 3;
                            }
                            if (g != null) {
                                g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                                if (textTips != null) {
                                    g.setFont(fontPlain8pt);
                                    g.setColor(Color.GRAY);
                                    g.drawString(textTips[c], xr + 1, yr + 8);
                                    g.setColor(Color.BLACK);
                                }
                            }
                            xr += cardWidth / 5;
                            ++c;
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Penalty:_________", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Sign Pilot:________", xOffset + cardWidth / 10, yOffset + cardHeight - 15 - yShift);
                            g.drawString("Timer:_______", xOffset + cardWidth / 2 + 5, yOffset + cardHeight - 15 - yShift);
                        }
                        ++pilotIndex;
                        ++card;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printOfficialScoreCards(final int cardsPerPage) {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                block17: {
                    int roundCount;
                    int pageCount = roundCount = F3KScore.editor().getCompetition().getNumberOfRounds();
                    if (page < pageCount) break block17;
                    return 1;
                }
                try {
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    Font font = fontPlain12pt;
                    int rowHeight = (int)(font.getSize2D() * 1.2f);
                    int nCols = 2;
                    int nRows = cardsPerPage / 2;
                    if (cardsPerPage == 2) {
                        nCols = 1;
                        nRows = 2;
                    }
                    int cardWidth = width / nCols;
                    int cardHeight = height / nRows;
                    int roundIx = page;
                    int card = 0;
                    while (card < cardsPerPage) {
                        if (card == cardsPerPage / 2 && cardsPerPage > 2) {
                            if (g != null) {
                                g2d.translate(cardWidth * nCols, cardHeight * nRows);
                            }
                            if (g != null) {
                                g2d.rotate(Math.PI);
                            }
                        }
                        int row = card % nRows;
                        int xOffset = 0;
                        int yOffset = row * cardHeight;
                        if (g != null) {
                            g.drawRect(xOffset + 1, yOffset + 4, cardWidth - 5, cardHeight - 8);
                        }
                        xOffset += 20;
                        int yShift = cardHeight / 5 - 35;
                        yOffset += yShift > 0 ? yShift : 0;
                        String name = "Pilot:                                                    ";
                        String groupString = "";
                        String task = F3KScore.editor().getCompetition().getRoundTask(roundIx).getDescription();
                        if (g != null) {
                            g.setFont(fontUnBold12pt);
                            g.drawString(name, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 0);
                            g.setFont(fontBold12pt);
                            g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 1);
                            g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 25 + rowHeight * 1);
                            g.setFont(fontPlain8pt);
                            float fontSize = fontPlain8pt.getSize2D();
                            if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                task = String.valueOf(task.substring(0, nChars)) + "...";
                            }
                            g.drawString(task, xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 2);
                        }
                        int xr = xOffset + cardWidth / 10;
                        int yr = yOffset + rowHeight * 4 - cardHeight / 6 + 3;
                        int c = 0;
                        while (c < 8) {
                            if ((c & 3) == 0) {
                                xr = xOffset + cardWidth / 10;
                                yr += cardHeight / 6 - 3;
                            }
                            if (g != null) {
                                g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                                g.setFont(fontPlain8pt);
                                g.setColor(Color.GRAY);
                                g.drawString("" + (c + 1), xr + 1, yr + 8);
                                g.setColor(Color.BLACK);
                            }
                            xr += cardWidth / 5;
                            ++c;
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Penalty:_________", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                        }
                        if (g != null) {
                            g.setFont(fontBold12pt);
                            g.drawString("Official Timechecker:__________", xOffset + cardWidth / 10, yOffset + cardHeight - 15 - yShift);
                        }
                        ++card;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printOfficialScoreCardsAllPilots(int cardsPerPage) {
        class MyPrintable
        implements Printable {
            private ArrayList<CompetitorGroup> groupsList = new ArrayList();
            private ArrayList<Integer> pagesPerBatch = new ArrayList();
            private int totalPageCount = 0;
            private final /* synthetic */ int val$cardsPerPage;

            MyPrintable(int cardsPerPage, int n) {
                this.val$cardsPerPage = n;
                int roundCount = F3KScore.editor().getCompetition().getNumberOfRounds();
                int roundIndex = 0;
                while (roundIndex < roundCount) {
                    int nGroupsInRound = F3KScore.editor().getCompetition().getGroupCount(roundIndex);
                    int groupN = 1;
                    while (groupN <= nGroupsInRound) {
                        this.groupsList.add(new CompetitorGroup(F3KScore.editor().getCompetition(), groupN, roundIndex, true));
                        ++groupN;
                    }
                    ++roundIndex;
                }
                int groupIndex = 0;
                while (groupIndex < this.groupsList.size()) {
                    int maxPilotCount = 0;
                    int cardIndex = 0;
                    while (cardIndex < cardsPerPage && groupIndex < this.groupsList.size()) {
                        int groupSize = this.groupsList.get(groupIndex).getCompetitorCount();
                        if (groupSize > maxPilotCount) {
                            maxPilotCount = groupSize;
                        }
                        ++cardIndex;
                        ++groupIndex;
                    }
                    this.pagesPerBatch.add(maxPilotCount);
                    this.totalPageCount += maxPilotCount;
                }
            }

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                block21: {
                    if (page < this.totalPageCount) break block21;
                    return 1;
                }
                try {
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    Font font = fontPlain12pt;
                    int rowHeight = (int)(font.getSize2D() * 1.2f);
                    int nCols = 2;
                    int nRows = this.val$cardsPerPage / 2;
                    if (this.val$cardsPerPage == 2) {
                        nCols = 1;
                        nRows = 2;
                    }
                    int cardWidth = width / nCols;
                    int cardHeight = height / nRows;
                    int nPages = 0;
                    int batchIndex = 0;
                    while (batchIndex < this.pagesPerBatch.size()) {
                        if ((nPages += this.pagesPerBatch.get(batchIndex).intValue()) > page) {
                            nPages -= this.pagesPerBatch.get(batchIndex).intValue();
                            break;
                        }
                        ++batchIndex;
                    }
                    int pilotIndex = page - nPages;
                    int groupIndex = batchIndex * this.val$cardsPerPage;
                    int card = 0;
                    while (card < this.val$cardsPerPage && groupIndex < this.groupsList.size()) {
                        if (card == this.val$cardsPerPage / 2 && this.val$cardsPerPage > 2 && g != null) {
                            g2d.translate(cardWidth * nCols, cardHeight * nRows);
                            g2d.rotate(Math.PI);
                        }
                        int row = card % nRows;
                        int xOffset = 0;
                        int yOffset = row * cardHeight;
                        if (pilotIndex < this.groupsList.get(groupIndex).getCompetitorCount()) {
                            if (g != null) {
                                g.drawRect(xOffset + 1, yOffset + 4, cardWidth - 5, cardHeight - 8);
                            }
                            xOffset += 20;
                            int yShift = cardHeight / 5 - 35;
                            yOffset += yShift > 0 ? yShift : 0;
                            String compName = F3KScore.editor().getCompetition().getCompetitionName();
                            float fontSize = fontPlain8pt.getSize2D();
                            if (compName == null) {
                                compName = "";
                            } else if ((double)((float)compName.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                compName = String.valueOf(compName.substring(0, nChars)) + "...";
                            }
                            String groupString = this.groupsList.get(groupIndex).getGroupName();
                            Competitor pilot = this.groupsList.get(groupIndex).getCompetitor(pilotIndex);
                            String name = String.format("%d. %s", pilot.getStartNumber(), pilot.getFullName());
                            int roundIx = this.groupsList.get(groupIndex).getRoundIndex();
                            String task = F3KScore.editor().getCompetition().getRoundTask(roundIx).getDescription();
                            String[] textTips = F3KScore.editor().getCompetition().getRoundTask(roundIx).getScoreCardTextTips();
                            if (g != null) {
                                g.setFont(fontBold8pt);
                                g.setColor(Color.GRAY);
                                g.drawString(compName, xOffset + cardWidth / 10, yOffset + 15 - (yShift > 0 ? yShift : 0));
                                g.setColor(Color.BLACK);
                                g.setFont(fontUnBold12pt);
                                g.drawString(name, xOffset + cardWidth / 10, yOffset + 15 + rowHeight * 1);
                                g.setFont(fontBold12pt);
                                g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 2);
                                g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 20 + rowHeight * 2);
                                g.setFont(fontPlain8pt);
                                fontSize = fontPlain8pt.getSize2D();
                                if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                                    int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                                    task = String.valueOf(task.substring(0, nChars)) + "...";
                                }
                                g.drawString(task, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 3);
                            }
                            int xr = xOffset + cardWidth / 10;
                            int yr = yOffset + rowHeight * 5 - cardHeight / 6 + 0;
                            int c = 0;
                            while (c < 8) {
                                if ((c & 3) == 0) {
                                    xr = xOffset + cardWidth / 10;
                                    yr += cardHeight / 6 - 3;
                                }
                                if (g != null) {
                                    g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                                    g.setFont(fontPlain8pt);
                                    g.setColor(Color.GRAY);
                                    g.drawString("" + (c + 1), xr + 1, yr + 8);
                                    g.setColor(Color.BLACK);
                                }
                                xr += cardWidth / 5;
                                ++c;
                            }
                            if (g != null) {
                                g.setFont(fontBold12pt);
                                g.drawString("Penalty:_________", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                            }
                            if (g != null) {
                                g.setFont(fontBold12pt);
                                g.drawString("Official Timechecker:__________", xOffset + cardWidth / 10, yOffset + cardHeight - 15 - yShift);
                            }
                        }
                        ++card;
                        ++groupIndex;
                    }
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        }
        PrintUtils.printData(new MyPrintable(cardsPerPage, cardsPerPage));
    }

    public static void printBibNumbersFullPage() {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                block7: {
                    block6: {
                        try {
                            int pageCount = F3KScore.editor().getCompetition().getCompetitorCount();
                            if (page < pageCount) break block6;
                            return 1;
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                            return 1;
                        }
                    }
                    if (g != null) break block7;
                    return 0;
                }
                Graphics2D g2d = (Graphics2D)g;
                int pageHeight = (int)pf.getImageableHeight();
                int pageWidth = (int)pf.getImageableWidth();
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                Font nameFont = new Font("Arial Black", 1, pageHeight / 10);
                FontRenderContext frc = g2d.getFontRenderContext();
                String nameString = F3KScore.editor().getCompetition().getCompetitor(page).getFullName();
                TextLayout layout = new TextLayout(nameString, nameFont, frc);
                int nameWidth = (int)layout.getBounds().getWidth();
                int nameHeight = (int)layout.getBounds().getHeight();
                int nameX = pageWidth / 2 - nameWidth / 2;
                int nameY = nameHeight + pageHeight / 25;
                g.setFont(nameFont);
                g.drawString(nameString, nameX, nameY);
                int fontSize = 5 * pageHeight / 6;
                Font numberFont = new Font("Arial Black", 1, fontSize);
                String numberString = "" + (page + 1);
                layout = new TextLayout(numberString, numberFont, frc);
                int numberWidth = (int)layout.getBounds().getWidth();
                int numberHeight = (int)layout.getBounds().getHeight();
                int numberX = pageWidth / 2 - numberWidth / 2;
                if (numberString.startsWith("1")) {
                    numberX -= fontSize / 8;
                }
                int numberY = nameY + numberHeight + pageHeight / 25;
                g.setFont(numberFont);
                g.drawString(numberString, numberX, numberY);
                nameFont = new Font("Arial Black", 1, pageHeight / 25);
                nameString = F3KScore.editor().getCompetition().getCompetitionName();
                if (nameString != null) {
                    layout = new TextLayout(nameString, nameFont, frc);
                    nameWidth = (int)layout.getBounds().getWidth();
                    nameHeight = (int)layout.getBounds().getHeight();
                    nameX = pageWidth / 2 - nameWidth / 2;
                    nameY = numberY + nameHeight + pageHeight / 20;
                    g.setFont(nameFont);
                    g.drawString(nameString, nameX, nameY);
                }
                return 0;
            }
        });
    }

    public static void printBibNumbersHalfPage() {
        PrintUtils.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                block8: {
                    block7: {
                        int pageCount = F3KScore.editor().getCompetition().getCompetitorCount();
                        if (page < pageCount) break block7;
                        return 1;
                    }
                    if (g != null) break block8;
                    return 0;
                }
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    int pageHeight = (int)pf.getImageableHeight() / 2;
                    int pageWidth = (int)pf.getImageableWidth();
                    g2d.translate(pf.getImageableX(), pf.getImageableY());
                    int offsetY = -pageHeight / 20;
                    int i = 0;
                    while (i < 2) {
                        Font nameFont = new Font("Arial Black", 1, pageHeight / 10);
                        FontRenderContext frc = g2d.getFontRenderContext();
                        String nameString = F3KScore.editor().getCompetition().getCompetitor(page).getFullName();
                        TextLayout layout = new TextLayout(nameString, nameFont, frc);
                        int nameWidth = (int)layout.getBounds().getWidth();
                        int nameHeight = (int)layout.getBounds().getHeight();
                        int nameX = pageWidth / 2 - nameWidth / 2;
                        int nameY = offsetY + nameHeight + pageHeight / 25;
                        g.setFont(nameFont);
                        g.drawString(nameString, nameX, nameY);
                        int fontSize = 5 * pageHeight / 6;
                        Font numberFont = new Font("Arial Black", 1, fontSize);
                        String numberString = "" + (page + 1);
                        layout = new TextLayout(numberString, numberFont, frc);
                        int numberWidth = (int)layout.getBounds().getWidth();
                        int numberHeight = (int)layout.getBounds().getHeight();
                        int numberX = pageWidth / 2 - numberWidth / 2;
                        if (numberString.startsWith("1")) {
                            numberX -= fontSize / 8;
                        }
                        int numberY = nameY + numberHeight + pageHeight / 25;
                        g.setFont(numberFont);
                        g.drawString(numberString, numberX, numberY);
                        nameFont = new Font("Arial Black", 1, pageHeight / 25);
                        nameString = F3KScore.editor().getCompetition().getCompetitionName();
                        if (nameString != null) {
                            layout = new TextLayout(nameString, nameFont, frc);
                            nameWidth = (int)layout.getBounds().getWidth();
                            nameHeight = (int)layout.getBounds().getHeight();
                            nameX = pageWidth / 2 - nameWidth / 2;
                            nameY = numberY + nameHeight + pageHeight / 25;
                            g.setFont(nameFont);
                            g.drawString(nameString, nameX, nameY);
                        }
                        ++i;
                        offsetY += 12 * pageHeight / 10;
                    }
                    g.drawLine(0, pageHeight, pageWidth, pageHeight);
                    return 0;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printStartList() {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Font font = fontPlain8pt;
                    float fontSize = font.getSize2D();
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float x0 = 20.0f;
                    float y = y0;
                    int colCount = F3KScore.editor().getStartListPane().getTableModel().getColumnCount();
                    int colWidth = (int)(((float)width - 2.0f * x0) / (float)colCount);
                    int roundIndex = -1;
                    int groupNumber = 0;
                    int nGroups = 0;
                    Competition competition = F3KScore.editor().getCompetition();
                    int rowIx = 0;
                    int pageCount = 0;
                    while (true) {
                        if (pageCount == 0 && competition.getCompetitionName() != null && competition.getCompetitionName().length() > 0) {
                            if (page == 0 && g != null) {
                                g.setFont(fontBold10pt);
                                g.drawString(competition.getCompetitionName(), 20, (int)y);
                            }
                            y += (float)(rowHeight + 5);
                        }
                        int row0 = rowIx;
                        while (rowIx < F3KScore.editor().getStartListPane().getTableModel().getRowCount()) {
                            if (y >= (float)height - bottomMargin) {
                                y = y0;
                                break;
                            }
                            float x = x0;
                            int colIx = 0;
                            while (colIx < colCount) {
                                int n;
                                CompetitorGroup aGroup;
                                int groupN;
                                int groupSize;
                                String s = (String)F3KScore.editor().getStartListPane().getTableModel().getValueAt(rowIx, colIx);
                                if (s == null) {
                                    s = "";
                                }
                                if (s.startsWith("_____")) {
                                    s = s.substring(4);
                                    font = fontBold8pt;
                                    ++groupNumber;
                                    if (colIx == 0) {
                                        y += 5.0f;
                                        groupSize = 0;
                                        groupN = groupNumber;
                                        while (groupN <= groupNumber + colCount && groupN <= nGroups) {
                                            aGroup = new CompetitorGroup(competition, groupN, roundIndex, false);
                                            if (aGroup.getCompetitorCount() > groupSize) {
                                                groupSize = aGroup.getCompetitorCount();
                                            }
                                            ++groupN;
                                        }
                                        n = groupSize + 1;
                                        if (y + (float)(n * rowHeight) >= (float)height - bottomMargin) {
                                            y = height;
                                            --rowIx;
                                            --groupNumber;
                                            break;
                                        }
                                    }
                                } else if (s.startsWith("_ ")) {
                                    s = s.substring(2);
                                    font = fontBold8pt;
                                    y += 5.0f;
                                    groupNumber = 1;
                                    groupSize = 0;
                                    nGroups = competition.getGroupCount(++roundIndex);
                                    groupN = groupNumber;
                                    while (groupN <= groupNumber + colCount && groupN <= nGroups) {
                                        aGroup = new CompetitorGroup(competition, groupN, roundIndex, false);
                                        if (aGroup.getCompetitorCount() > groupSize) {
                                            groupSize = aGroup.getCompetitorCount();
                                        }
                                        ++groupN;
                                    }
                                    n = groupSize + 1 + 2;
                                    if (y + (float)(n * rowHeight) + 5.0f >= (float)height - bottomMargin) {
                                        y = height;
                                        --rowIx;
                                        --roundIndex;
                                        break;
                                    }
                                } else {
                                    font = fontPlain8pt;
                                    if ((double)s.length() > 2.0 * (double)colWidth / (double)fontSize) {
                                        s = String.valueOf(s.substring(0, (int)(2.0 * (double)colWidth / (double)fontSize - 0.5))) + "...";
                                    }
                                }
                                if (pageCount == page && g != null) {
                                    g.setFont(font);
                                    g.drawString(s, (int)x, (int)y);
                                }
                                x += (float)colWidth;
                                ++colIx;
                            }
                            y += (float)rowHeight;
                            ++rowIx;
                        }
                        if (pageCount == page) {
                            return 0;
                        }
                        if (rowIx >= F3KScore.editor().getStartListPane().getTableModel().getRowCount()) {
                            return 1;
                        }
                        ++pageCount;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }

    public static void printSelectedRoundScores() {
        PrintUtils.printData(new Printable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                try {
                    Graphics2D g2d = (Graphics2D)g;
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                    int width = (int)pf.getImageableWidth();
                    int height = (int)pf.getImageableHeight();
                    Font font = fontPlain8pt;
                    float fontSize = font.getSize2D();
                    int rowHeight = (int)(fontSize * 1.1f);
                    float topMargin = 10.0f;
                    float bottomMargin = 10.0f;
                    float y0 = topMargin + (float)rowHeight;
                    float x0 = 20.0f;
                    float y = y0;
                    Competition competition = F3KScore.editor().getCompetition();
                    int groupNumber = 0;
                    int colCount = F3KScore.editor().getTimesPane().getTableModel().getColumnCount() - 1;
                    int colWidth = (int)(((float)width - 2.0f * x0 - 100.0f) / (float)colCount);
                    int rowIx = 0;
                    int pageCount = 0;
                    while (true) {
                        if (pageCount == 0 && competition.getCompetitionName() != null && competition.getCompetitionName().length() > 0) {
                            if (page == 0 && g != null) {
                                g.setFont(fontBold10pt);
                                g.drawString(competition.getCompetitionName(), 20, (int)y);
                            }
                            y += (float)(rowHeight + 10);
                        }
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(String.format("Round %s - %s", competition.getSelectedRoundIndex() + 1, competition.getSelectedTask().getDescription()), 20, (int)y);
                        }
                        y += (float)(rowHeight + 10);
                        int row0 = rowIx;
                        int nameRow = 0;
                        while (rowIx < F3KScore.editor().getTimesPane().getTableModel().getRowCount()) {
                            if (y >= (float)height - bottomMargin) {
                                y = y0;
                                break;
                            }
                            float x = x0;
                            int colIx = 0;
                            while (colIx < colCount) {
                                String s = (String)F3KScore.editor().getTimesPane().getTableModel().getValueAt(rowIx, colIx);
                                if (s.startsWith("#####")) {
                                    s = s.substring(3);
                                    s = s.replaceAll("#", " ");
                                    font = fontBold8pt;
                                    if (colIx == 0) {
                                        y += 5.0f;
                                        ++groupNumber;
                                    }
                                    int n = new CompetitorGroup(competition, groupNumber, competition.getSelectedRoundIndex(), false).getCompetitorCount();
                                    if (y + (float)(++n * rowHeight) >= (float)height - bottomMargin) {
                                        y = height;
                                        --rowIx;
                                        break;
                                    }
                                    if (colIx > 0) {
                                        s = F3KScore.editor().getTimesPane().getTableModel().getColumnName(colIx).split("\\s+")[0];
                                    }
                                    nameRow = rowIx;
                                } else {
                                    font = fontPlain8pt;
                                    if (colIx == 0) {
                                        double maxNameLength = 2.0 * (double)(colWidth + 80) / (double)fontSize;
                                        if ((double)s.length() > maxNameLength) {
                                            s = String.valueOf(s.substring(0, (int)(maxNameLength - 0.5))) + "...";
                                        }
                                    }
                                }
                                if (pageCount == page && g != null) {
                                    g.setFont(font);
                                    g.drawString(s, (int)x, (int)y);
                                }
                                x += (float)colWidth;
                                if (colIx == 0) {
                                    x += 80.0f;
                                }
                                ++colIx;
                            }
                            if ((rowIx - nameRow) % 3 == 0) {
                                if (pageCount == page && g != null) {
                                    g.fillRect((int)x0, (int)y + 2, (int)(x - x0), 1);
                                }
                                y += 2.0f;
                            }
                            y += (float)rowHeight;
                            ++rowIx;
                        }
                        if (pageCount == page) {
                            return 0;
                        }
                        if (rowIx >= F3KScore.editor().getTimesPane().getTableModel().getRowCount()) {
                            return 1;
                        }
                        ++pageCount;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Printing error", 0);
                    return 1;
                }
            }
        });
    }
}

