/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import f3kscore.PilotsDatabaseUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class RegistrationPane
extends AbstractF3KScoreEditorPanel {
    private static final int FIRST_NAME_COLUMN = 1;
    private static final int LAST_NAME_COLUMN = 2;
    private String[] colNames = new String[]{"", "First Name", "Last Name", "Class", "Freq 1", "Freq 2", "Team", "FAI/AMA Num", "State", "Club", "E-mail", "Glider Models", "Info", ""};
    private int[] colWidthMin = new int[]{25, 100, 100, 70, 40, 40, 90, 80, 60, 60, 170, 170, 250, 50};
    private int[] colWidth = new int[]{25, 100, 100, 70, 40, 40, 90, 80, 60, 60, 170, 170, 250, 1500};
    private int clickedCol = -1;
    private JPopupMenu popupMenu;
    private JMenu printAllRoundCardsMenu;
    private JMenu sortMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private ExcelAdapter excelAdapter;
    private JMenuItem importPilotsMenuItem;
    private JMenu exportPilotListMenu;

    public RegistrationPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new RegistrationTableModel();
        this.table = new AbstractF3KScoreEditorPanel.F3KScoreTable(this, this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(true);
        this.configurePanel();
        this.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        super.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter = new ExcelAdapter(this.table);
        this.table.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "DELETE_ROWS");
        this.table.getActionMap().put("DELETE_ROWS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationPane.this.deleteAction();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "ENTER_PRESSED");
        this.table.getActionMap().put("ENTER_PRESSED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegistrationPane.this.clickedCol > 0) {
                    int selRow = RegistrationPane.this.table.getSelectedRow();
                    int selCol = RegistrationPane.this.table.getSelectedColumn();
                    if (selRow < 0 || selCol < 0) {
                        return;
                    }
                    if (RegistrationPane.this.clickedCol != -1 && selCol < RegistrationPane.this.clickedCol) {
                        RegistrationPane.this.clickedCol = selCol;
                    }
                    if (RegistrationPane.this.table.isEditing()) {
                        RegistrationPane.this.table.getCellEditor().stopCellEditing();
                        RegistrationPane.this.table.removeEditor();
                    }
                    if (++selRow < RegistrationPane.this.table.getRowCount()) {
                        RegistrationPane.this.table.setRowSelectionInterval(selRow, selRow);
                        RegistrationPane.this.table.setColumnSelectionInterval(RegistrationPane.this.clickedCol, RegistrationPane.this.clickedCol);
                        RegistrationPane.this.table.editCellAt(selRow, RegistrationPane.this.clickedCol);
                    } else {
                        RegistrationPane.this.clickedCol = -1;
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    RegistrationPane.this.clickedCol = RegistrationPane.this.table.columnAtPoint(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = RegistrationPane.this.table.rowAtPoint(p);
                    int[] selRows = RegistrationPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        RegistrationPane.this.table.clearSelection();
                        RegistrationPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = RegistrationPane.this.table.columnAtPoint(p);
                        RegistrationPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    RegistrationPane.this.showPopupMenu(e);
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void deleteAction() {
        rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        cols = this.table.getSelectedColumns();
        if (cols[0] > 2) ** GOTO lbl38
        this.table.addColumnSelectionInterval(0, this.colNames.length - 1);
        msg = new StringBuffer("The following pilots will be removed from the competition:");
        deletedPilots = new ArrayList<Competitor>();
        var8_7 = rows;
        var7_8 = rows.length;
        var6_9 = 0;
        while (var6_9 < var7_8) {
            row = var8_7[var6_9];
            pilot = this.competition.getCompetitor(row);
            if (pilot != null) {
                deletedPilots.add(pilot);
                msg.append("\n     ");
                msg.append(row + 1);
                msg.append(". ");
                msg.append(pilot.getFullName());
            }
            ++var6_9;
        }
        if (deletedPilots.size() == 0) {
            this.table.clearSelection();
            this.table.removeEditor();
            return;
        }
        reply = JOptionPane.showConfirmDialog(this.table.getTopLevelAncestor(), msg.toString(), "Remove pilots from competition data?", 2);
        if (reply == 0) {
            this.competition.removeCompetitors(deletedPilots);
        } else {
            this.table.removeEditor();
            return;
lbl38:
            // 1 sources

            row = rows[0];
            while (row <= rows[rows.length - 1]) {
                col = cols[0];
                while (col <= cols[cols.length - 1]) {
                    this.table.setValueAt("", row, col);
                    ++col;
                }
                ++row;
            }
            this.tableModel.fireTableDataChanged();
        }
        this.competition.setChangesMade(true);
    }

    @Override
    public void dataStructureChanged(Competition competition) {
        int i = 0;
        while (i < this.tableModel.getColumnCount() - 1) {
            this.colWidth[i] = this.table.getColumnModel().getColumn(i).getWidth();
            ++i;
        }
        super.dataStructureChanged(competition);
        this.configurePanel();
    }

    private void configurePanel() {
        int i = 1;
        while (i < this.colNames.length) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidth[i]);
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidthMin[i]);
            ++i;
        }
        this.table.getColumnModel().getColumn(0).setMinWidth(this.colWidthMin[0]);
        this.table.getColumnModel().getColumn(0).setMaxWidth(this.colWidthMin[0]);
        this.setMultilineTableHeaders();
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RegistrationPane.this.deleteAction();
                }
            });
            this.popupMenu.add(this.deleteMenuItem);
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RegistrationPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RegistrationPane.this.excelAdapter.pasteAction();
                }
            });
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.popupMenu.add(this.pasteMenuItem);
            this.sortMenu = new JMenu("Sort pilot list");
            this.popupMenu.add(this.sortMenu);
            JMenu sortIncreasing = new JMenu("increasing order (A...Z, 0...9)");
            this.sortMenu.add(sortIncreasing);
            sortIncreasing.add(new JMenuItem(new AbstractAction("Full Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Name");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("First Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("First Name");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Last Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Last Name");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Class"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Class");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Freq 1"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Freq 1");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Freq 2"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Freq 2");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Team"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Team");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("FAI/AMA Num"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("FAI/AMA Num");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("State"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("State");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Club"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Club");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("E-mail"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("E-mail");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Glider Models"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Glider Models");
                }
            }));
            sortIncreasing.add(new JMenuItem(new AbstractAction("Info"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotList("Info");
                }
            }));
            JMenu sortDecreasing = new JMenu("reverse order (Z...A, 9...0)");
            this.sortMenu.add(sortDecreasing);
            sortDecreasing.add(new JMenuItem(new AbstractAction("Full Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Name");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("First Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("First Name");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Last Name"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Last Name");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Class"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Class");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Freq 1"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Freq 1");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Freq 2"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Freq 2");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Team"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Team");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("FAI/AMA Num"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("FAI/AMA Num");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("State"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("State");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Club"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Club");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("E-mail"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("E-mail");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Glider Models"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Glider Models");
                }
            }));
            sortDecreasing.add(new JMenuItem(new AbstractAction("Info"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().sortPilotListReverse("Info");
                }
            }));
            this.printAllRoundCardsMenu = new JMenu("Print score cards for the selected pilots");
            this.popupMenu.add(this.printAllRoundCardsMenu);
            this.printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().printSelectedPilotsScoreCards(8);
                }
            }));
            this.printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().printSelectedPilotsScoreCards(6);
                }
            }));
            this.printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().printSelectedPilotsScoreCards(4);
                }
            }));
            this.printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    F3KScore.editor().printSelectedPilotsScoreCards(2);
                }
            }));
            this.importPilotsMenuItem = new JMenuItem(new AbstractAction("Import pilot list"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PilotsDatabaseUtils.importPilotList();
                }
            });
            this.importPilotsMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
            this.popupMenu.add(this.importPilotsMenuItem);
            this.exportPilotListMenu = new JMenu("Export pilot list");
            this.popupMenu.add(this.exportPilotListMenu);
            this.exportPilotListMenu.add(new JMenuItem(new AbstractAction("Create new file"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    F3KScore.editor().exportPilotList();
                }
            }));
            this.exportPilotListMenu.add(new JMenuItem(new AbstractAction("Merge into existing database"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PilotsDatabaseUtils.mergePilotListToDatabaseFile();
                }
            }));
        }
        this.sortMenu.setEnabled(this.competition.getCompetitorCount() > 0);
        this.exportPilotListMenu.setEnabled(this.competition.getCompetitorCount() > 0);
        int row = this.table.getSelectedRow();
        this.printAllRoundCardsMenu.setEnabled(this.competition.getCompetitor(row) != null);
        this.deleteMenuItem.setEnabled(this.competition.getCompetitor(row) != null);
        this.copyMenuItem.setEnabled(this.competition.getCompetitor(row) != null);
        this.pasteMenuItem.setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) != null);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class RegistrationTableModel
    extends AbstractTableModel {
        private RegistrationTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return RegistrationPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return RegistrationPane.this.competition.getCompetitorCount() + 50;
        }

        @Override
        public String getColumnName(int col) {
            return RegistrationPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col >= RegistrationPane.this.colNames.length || row >= RegistrationPane.this.competition.getCompetitorCount()) {
                return null;
            }
            if (col == 0) {
                return row + 1;
            }
            Competitor comp = RegistrationPane.this.competition.getCompetitor(row);
            if (comp != null && col >= 1 && col < this.getColumnCount()) {
                String propName = RegistrationPane.this.colNames[col];
                String val = comp.getProperty(propName);
                return val;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (RegistrationPane.this.clickedCol != -1 && col < RegistrationPane.this.clickedCol) {
                RegistrationPane.this.clickedCol = col;
            }
            Competitor comp = RegistrationPane.this.competition.getCompetitor(row);
            if (value.equals("") && comp != null) {
                if (col == 1 && comp.getProperty("Last Name").equals("")) {
                    RegistrationPane.this.deleteAction();
                    return;
                }
                if (col == 2 && comp.getProperty("First Name").equals("")) {
                    RegistrationPane.this.deleteAction();
                    return;
                }
            }
            if (comp == null) {
                if (RegistrationPane.this.colNames[col].equals("First Name") && !value.equals("")) {
                    if (!RegistrationPane.this.competition.addCompetitor(new Competitor(RegistrationPane.this.competition, value.toString(), ""))) {
                        JOptionPane.showMessageDialog(RegistrationPane.this, "Competitor \"" + value + "\" is already included in the list.", "Duplicate Name", 0);
                    } else if (RegistrationPane.this.table.getSelectedRow() == -1 && RegistrationPane.this.table.editCellAt(row + 1, col)) {
                        RegistrationPane.this.table.changeSelection(row, col, false, false);
                    }
                } else if (RegistrationPane.this.colNames[col].equals("Last Name") && !value.equals("")) {
                    if (!RegistrationPane.this.competition.addCompetitor(new Competitor(RegistrationPane.this.competition, "", value.toString()))) {
                        JOptionPane.showMessageDialog(RegistrationPane.this, "Competitor \"" + value + "\" is already included in the list.", "Duplicate Name", 0);
                    } else if (RegistrationPane.this.table.getSelectedRow() == -1 && RegistrationPane.this.table.editCellAt(row + 1, col)) {
                        RegistrationPane.this.table.changeSelection(row, col, false, false);
                    }
                }
                return;
            }
            comp.setProperty(RegistrationPane.this.colNames[col], value.toString());
            this.fireTableDataChanged();
            RegistrationPane.this.competition.setChangesMade(true);
        }
    }
}

