/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AudioConstants;
import java.io.Serializable;
import java.util.ArrayList;

public class Task
implements Serializable,
AudioConstants {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FLIGHT_TIMES = 20;
    public static ArrayList<Task> taskPool = new ArrayList();
    private int fIndex;
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private boolean isSpeedTask;
    private String[] scoreCardTextTips;
    private String[] scoreCardTextTipsAlt;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean hasLandingScore;
    private boolean landingScoredSeparately;

    static {
        taskPool.add(new Task("\"A\" - Last 5:00 in 7:00", "L1x5", "Last flight, 5:00 max, 7:00 window", new int[]{300}, null, 420, false, false, new String[]{"Max=5:00"}, new String[]{"description_task_A_last_flight_7min_window.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"A\" - Last 5:00 in 10:00", "L1x5", "Last flight, 5:00 max, 10:00 window", new int[]{300}, null, 600, false, false, new String[]{"Max=5:00"}, new String[]{"description_task_A_last_flight_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"B\" - Last 2 x 4:00", "L2x4", "Last 2 flights, 4:00 max, 10:00 window", new int[]{240, 240}, null, 600, false, false, new String[]{"Max=4:00", "Max=4:00"}, new String[]{"description_task_B_last_two_4min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"B\" - Last 2 x 3:00", "L2x3", "Last 2 flights, 3:00 max, 7:00 window", new int[]{180, 180}, null, 420, false, false, new String[]{"Max=3:00", "Max=3:00"}, new String[]{"description_task_B_last_two_3min.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"C\" - All up 3 x 3:00", "AUp", "All up, 3 flights, 3:00 max", new int[]{180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"C\" - All up 4 x 3:00", "AUp4", "All up, 4 flights, 3:00 max", new int[]{180, 180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"C\" - All up 5 x 3:00", "AUp5", "All up, 5 flights, 3:00 max", new int[]{180, 180, 180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"D\" - Ladder +15 sec", "Lddr", "Increasing times - 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00, 10:00 window", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}, 600, false, true, new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"}, new String[]{"description_task_D_ladder.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"E\" - Poker", "Pkr", "Poker, 5 self nominated targets, 10:00 window", new int[5], null, 600, false, false, new String[]{"Target #1", "Target #2", "Target #3", "Target #4", "Target #5"}, new String[]{"description_task_E_poker.mp3", "window_3_min_prep_10_min_poker_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"F\" - Best 3 of 6", "3of6", "Best 3 flights, 3:00 max, 6 launches only, 10:00 window", new int[]{180, 180, 180}, null, 600, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"description_task_F_3_of_6.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"G\" - Best 5 x 2:00", "5x2", "Best 5 flights, 2:00 max, 10:00 window", new int[]{120, 120, 120, 120, 120}, null, 600, false, false, new String[]{"Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00"}, new String[]{"description_task_G_5x2.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"H\" - 1:00, 2:00, 3:00, 4:00", "1234", "Best 4 flights, 1:00, 2:00, 3:00, 4:00 max in any order, 10:00 window", new int[]{60, 120, 180, 240}, null, 600, false, false, new String[]{"Max=1:00", "Max=2:00", "Max=3:00", "Max=4:00"}, new String[]{"description_task_H_1_2_3_4.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"I\" - Best 3 x 200s", "3200", "Best 3 flights, 200s (3:20) max, 10:00 window", new int[]{200, 200, 200}, null, 600, false, false, new String[]{"Max=3:20", "Max=3:20", "Max=3:20"}, new String[]{"description_task_I_3x200s.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        taskPool.add(new Task("\"J\" - Last 3 x 3:00", "L3x3", "Last 3 flights, 3:00 max, 10:00 window", new int[]{180, 180, 180}, null, 600, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"description_task_J_last_three_3min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false, false));
        int[] nArray = new int[2];
        nArray[0] = 420;
        taskPool.add(new Task("ALES 7:00 max", "7:00", "Normalized duration with a precision landing, 7:00 maximum", nArray, null, 0, false, false, new String[]{"Max=7:00", "Landing"}, new String[]{"window_3_min_prep_7_min_ALES_30_sec_landing.mp3"}, new String[]{"Max\n7:00", "Landing"}, true, true));
        int[] nArray2 = new int[2];
        nArray2[0] = 600;
        taskPool.add(new Task("ALES 10:00 max", "10:00", "Normalized duration with a precision landing, 10:00 maximum", nArray2, null, 0, false, false, new String[]{"Max=10:00", "Landing"}, new String[]{"window_3_min_prep_10_min_ALES_30_sec_landing.mp3"}, new String[]{"Max\n10:00", "Landing"}, true, true));
        int[] nArray3 = new int[2];
        nArray3[0] = 900;
        taskPool.add(new Task("ALES 15:00 max", "15:00", "Normalized duration with a precision landing, 15:00 maximum", nArray3, null, 0, false, false, new String[]{"Max=15:00", "Landing"}, new String[]{"window_3_min_prep_15_min_ALES_30_sec_landing.mp3"}, new String[]{"Max\n15:00", "Landing"}, true, true));
        taskPool.add(new Task("F3B speed", "F3B", "F3F/F3B type speed task", new int[1], null, 0, true, false, null, null, null, false, false));
    }

    public Task(String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isSpeedTask, boolean isLadderTask, String[] scoreCardTextTips, String[] playList, String[] columnTitles, boolean hasLandingScore, boolean landingScoredSeparately) {
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isSpeedTask = isSpeedTask;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
        this.scoreCardTextTips = scoreCardTextTips;
        this.scoreCardTextTipsAlt = this.scoreCardTextTipsAlt;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.hasLandingScore = hasLandingScore;
        this.landingScoredSeparately = landingScoredSeparately;
    }

    public boolean isSpeedTask() {
        return this.isSpeedTask;
    }

    public boolean isLadderTask() {
        return this.isLadderTask;
    }

    public int getPoolIndex() {
        return this.fIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.longName;
    }

    public int getNumFlights() {
        return this.numFlights;
    }

    public String toString() {
        return this.name;
    }

    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }

    public int getWindowTime() {
        return this.windowTime;
    }

    public String[] getScoreCardTextTips() {
        return this.scoreCardTextTips;
    }

    public String[] getPlaylist() {
        return this.playList;
    }

    public String[] getFlightTimesColumnTitles() {
        return this.flightTimesColumnTitles;
    }

    public boolean hasLandingScore() {
        return this.hasLandingScore;
    }

    public boolean isLandingScoredSeparately() {
        return this.landingScoredSeparately;
    }
}

