/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSpreadsheetReader {
    public static LinkedHashMap<String, List<String[]>> readAll(File file) throws IOException {
        try (InputStream inStream = null;){
            LinkedHashMap<String, List<String[]>> allData = new LinkedHashMap<String, List<String[]>>();
            inStream = new FileInputStream(file);
            XSSFWorkbook wb = new XSSFWorkbook(inStream);
            int i = 0;
            while (i < wb.getNumberOfSheets()) {
                String sName = wb.getSheetName(i);
                allData.put(sName, ExcelSpreadsheetReader.readSheet(wb, i));
                ++i;
            }
            LinkedHashMap<String, List<String[]>> linkedHashMap = allData;
            return linkedHashMap;
        }
    }

    public static List<String[]> readAll(File file, int sheetIndex) throws IOException {
        try (FileInputStream inStream = null;){
            inStream = new FileInputStream(file);
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)inStream);
            List<String[]> list = ExcelSpreadsheetReader.readSheet(wb, sheetIndex);
            return list;
        }
    }

    private static List<String[]> readSheet(XSSFWorkbook wb, int sheetIndex) {
        XSSFFormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        XSSFSheet sheet1 = wb.getSheetAt(sheetIndex);
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Row row : sheet1) {
            ArrayList<String> line = new ArrayList<String>();
            for (Cell cell : row) {
                switch (evaluator.evaluateInCell(cell).getCellType()) {
                    case 1: {
                        line.add(cell.getRichStringCellValue().getString());
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            Date date = cell.getDateCellValue();
                            line.add(new SimpleDateFormat("MM.dd.yyyy").format(date));
                            break;
                        }
                        double val = cell.getNumericCellValue();
                        int intVal = (int)val;
                        if ((double)intVal == val) {
                            line.add(String.valueOf(intVal));
                            break;
                        }
                        line.add(String.valueOf(val));
                        break;
                    }
                    default: {
                        line.add("");
                    }
                }
            }
            String[] lineArray = new String[line.size()];
            line.toArray(lineArray);
            data.add(lineArray);
        }
        return data;
    }
}

