/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.F3KScore;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public abstract class AbstractF3KScoreEditorPanel
extends JPanel {
    protected AbstractTableModel tableModel;
    protected Competition competition;
    protected JTable table;

    protected void setMultilineTableHeaders() {
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> myEnum = this.table.getColumnModel().getColumns();
        while (myEnum.hasMoreElements()) {
            myEnum.nextElement().setHeaderRenderer(renderer);
        }
    }

    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public void dataStructureChanged(Competition competition) {
        this.competition = competition;
        this.tableModel.fireTableStructureChanged();
    }

    public void dataChanged() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
            this.table.removeEditor();
        }
        this.tableModel.fireTableDataChanged();
    }

    public boolean stopEditing() {
        if (this.table.isEditing()) {
            return this.table.getCellEditor().stopCellEditing();
        }
        return true;
    }

    public void updatePanel() {
        this.dataChanged();
    }

    public class F3KScoreTable
    extends JTable {
        public F3KScoreTable(AbstractTableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).selectAll();
                c.setBackground(F3KScore.veryLightBlue);
            }
            return c;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (super.isRowSelected(rowIndex)) {
                if (!super.isColumnSelected(vColIndex)) {
                    c.setBackground(F3KScore.veryLightGrey);
                } else {
                    c.setBackground(this.getSelectionBackground());
                    c.setBackground(F3KScore.veryLightBlue);
                }
            } else {
                c.setBackground(this.getBackground());
            }
            return c;
        }
    }

    public class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        public MultiLineHeaderRenderer() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ListCellRenderer renderer = this.getCellRenderer();
            ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
            this.setCellRenderer(renderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setListData(v);
            return this;
        }
    }
}

