/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CSVParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class CSVWriter
implements Closeable {
    public static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_SEPARATOR = CSVParser.DEFAULT_SEPARATOR;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";

    public CSVWriter(Writer writer) {
        this(writer, DEFAULT_SEPARATOR);
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    public void writeLines(List allLines) {
        for (Object line : allLines) {
            if (line instanceof String[]) {
                this.writeNext((String[])line);
                continue;
            }
            if (line instanceof List) {
                this.writeNext((List)line);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public void writeNext(String[] nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < nextLine.length) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) != null) {
                this.writeElement(sb, nextElement);
            }
            ++i;
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    public void writeNext(List<String> nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < nextLine.size()) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine.get(i)) != null) {
                this.writeElement(sb, nextElement);
            }
            ++i;
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    private void writeElement(StringBuilder sb, String element) {
        if (element.contains(DEFAULT_LINE_END)) {
            element = element.substring(0, element.indexOf(DEFAULT_LINE_END));
        }
        if ((element.indexOf(this.separator) != -1 || this.stringContainsSpecialCharacters(element)) && this.quotechar != '\u0000') {
            sb.append(this.quotechar);
        }
        sb.append(this.stringContainsSpecialCharacters(element) ? this.processLine(element) : element);
        if ((element.indexOf(this.separator) != -1 || this.stringContainsSpecialCharacters(element)) && this.quotechar != '\u0000') {
            sb.append(this.quotechar);
        }
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1;
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        int j = 0;
        while (j < nextElement.length()) {
            char nextChar = nextElement.charAt(j);
            if (this.escapechar != '\u0000' && nextChar == this.quotechar) {
                sb.append(this.escapechar).append(nextChar);
            } else if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                sb.append(this.escapechar).append(nextChar);
            } else {
                sb.append(nextChar);
            }
            ++j;
        }
        return sb;
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }
}

