/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competitor;
import f3kscore.F3KScore;
import f3kscore.Task;
import f3kscore.Team;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class Competition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static ArrayList<String> groupLetters = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T"));
    public static final int MAX_NUM_GROUPS = 20;
    private transient F3KScore editor;
    private transient int selectedRoundIndex;
    private transient boolean changesMade;
    private String competitionName;
    private String date;
    private String endDate;
    private final ArrayList<Competitor> competitorList;
    private final ArrayList<Competitor> resultsList;
    private final ArrayList<Task> taskList;
    private boolean resultDirty;
    private boolean useLetterGroupNames;
    private Integer maxDroppedScores = -1;
    private boolean useSecondsForFlightTimes = false;
    private boolean useLastCommaFirstNameFormat = false;
    private boolean useTeamProtection = true;
    private HashMap<String, Team> teams;
    private List<Team> teamsList;
    private int f3xvaultID;

    public Competition(F3KScore editor, String compType) {
        this.editor = editor;
        this.competitorList = new ArrayList();
        this.resultsList = new ArrayList();
        this.taskList = new ArrayList();
        this.resultDirty = true;
        this.teams = new HashMap();
        this.teamsList = new ArrayList<Team>();
        this.competitionName = "My " + compType + " Competition";
        this.useLetterGroupNames = true;
        switch (compType) {
            case "F3K": {
                this.taskList.add(Task.taskPool.get(0));
                this.taskList.add(Task.taskPool.get(2));
                this.taskList.add(Task.taskPool.get(4));
                this.taskList.add(Task.taskPool.get(7));
                this.taskList.add(Task.taskPool.get(8));
                this.taskList.add(Task.taskPool.get(9));
                this.taskList.add(Task.taskPool.get(10));
                this.taskList.add(Task.taskPool.get(11));
                this.taskList.add(Task.taskPool.get(12));
                this.taskList.add(Task.taskPool.get(13));
                this.maxDroppedScores = -1;
                break;
            }
            case "ALES": {
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.maxDroppedScores = 0;
                break;
            }
            case "TD": {
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.taskList.add(Task.taskPool.get(20));
                this.maxDroppedScores = 0;
                break;
            }
            case "F5J": {
                this.taskList.add(Task.taskPool.get(22));
                this.taskList.add(Task.taskPool.get(22));
                this.taskList.add(Task.taskPool.get(22));
                this.taskList.add(Task.taskPool.get(22));
                this.taskList.add(Task.taskPool.get(22));
                this.maxDroppedScores = -1;
                break;
            }
            default: {
                this.taskList.add(Task.taskPool.get(0));
                this.taskList.add(Task.taskPool.get(2));
                this.taskList.add(Task.taskPool.get(4));
                this.taskList.add(Task.taskPool.get(7));
                this.taskList.add(Task.taskPool.get(8));
                this.taskList.add(Task.taskPool.get(9));
                this.taskList.add(Task.taskPool.get(10));
                this.taskList.add(Task.taskPool.get(11));
                this.taskList.add(Task.taskPool.get(12));
                this.taskList.add(Task.taskPool.get(13));
                this.maxDroppedScores = -1;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.teams == null) {
            this.teams = new HashMap();
        }
        if (this.teamsList == null) {
            this.teamsList = new ArrayList<Team>();
        }
    }

    public static int groupLetterToNumber(String letter) {
        if (groupLetters.contains(letter.toUpperCase())) {
            return groupLetters.indexOf(letter.toUpperCase()) + 1;
        }
        return -1;
    }

    public static String groupNumberToLetter(int groupNum) {
        return groupLetters.get(groupNum - 1);
    }

    public String formatGroupNumberAsString(int groupNumber) {
        if (groupNumber < 0) {
            return "Re-flight";
        }
        if (this.useLetterGroupNames) {
            if (groupNumber > 0 && groupNumber <= groupLetters.size()) {
                return groupLetters.get(groupNumber - 1);
            }
            return "";
        }
        return String.valueOf(groupNumber);
    }

    public String getCompetitionName() {
        return this.competitionName;
    }

    public void setCompetitionName(String competitionName) {
        this.competitionName = competitionName;
        this.changesMade = true;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Team getTeam(String teamName) {
        return this.teams.get(teamName);
    }

    public Team addNewTeam(String teamName) {
        Team newTeam = new Team(teamName, this);
        this.teams.put(teamName, newTeam);
        return newTeam;
    }

    public void removeTeam(String teamName) {
        this.teams.remove(teamName);
        this.sortTeamsList();
    }

    public boolean addCompetitor(Competitor newCompetitor) {
        if (this.competitorList.contains(newCompetitor)) {
            return false;
        }
        this.competitorList.add(newCompetitor);
        newCompetitor.setCompetition(this);
        this.setResultsDirty();
        this.changesMade = true;
        this.editor.fireChangeEvent();
        return true;
    }

    public void removeCompetitor(Competitor competitor) {
        this.competitorList.remove(competitor);
        String teamName = competitor.getTeamName();
        Team team = this.getTeam(teamName);
        if (team != null) {
            team.removePilot(competitor);
        }
        this.setResultsDirty();
        this.editor.fireChangeEvent();
    }

    public void removeCompetitors(List<Competitor> competitors) {
        for (Competitor competitor : competitors) {
            String teamName = competitor.getTeamName();
            Team team = this.getTeam(teamName);
            if (team == null) continue;
            team.removePilot(competitor);
        }
        this.competitorList.removeAll(competitors);
        this.setResultsDirty();
        this.editor.fireChangeEvent();
    }

    public void removeAllCompetitors() {
        this.competitorList.clear();
        this.teamsList.clear();
        this.teams.clear();
        this.setResultsDirty();
        this.editor.fireChangeEvent();
    }

    public List<Competitor> getCompetitorList() {
        return this.competitorList;
    }

    public void setEditor(F3KScore editor) {
        this.editor = editor;
    }

    public void setResultsDirty() {
        this.resultDirty = true;
        this.resultsList.clear();
        this.resultsList.addAll(this.competitorList);
        this.teamsList.clear();
        for (Competitor pilot : this.competitorList) {
            Team team;
            pilot.setResultsDirty();
            String teamName = pilot.getTeamName();
            if (teamName.equals("") || this.teamsList.contains(team = this.getTeam(teamName))) continue;
            this.teamsList.add(team);
        }
    }

    public boolean isResultDirty() {
        return this.resultDirty;
    }

    private void calcResultList() {
        int c = 0;
        while (c < this.competitorList.size()) {
            int pos = this.competitorList.get(c).getPosition();
            this.resultsList.set(pos, this.competitorList.get(c));
            ++c;
        }
        this.resultDirty = false;
    }

    private void sortTeamsList() {
        class TeamScoreComparator
        implements Comparator<Team> {
            TeamScoreComparator() {
            }

            @Override
            public int compare(Team team1, Team team2) {
                if (team1.getTeamScore() > team2.getTeamScore()) {
                    return -1;
                }
                if (team1.getTeamScore() < team2.getTeamScore()) {
                    return 1;
                }
                return team1.getName().compareTo(team2.getName());
            }
        }
        TreeSet<Team> sortedTeamsList = new TreeSet<Team>(new TeamScoreComparator());
        sortedTeamsList.addAll(this.teams.values());
        this.teamsList.clear();
        this.teamsList.addAll(sortedTeamsList);
    }

    public Competitor getCompetitorAtPosition(int pos) {
        if (this.resultDirty) {
            this.calcResultList();
            this.sortTeamsList();
        }
        return this.resultsList.get(pos);
    }

    public void setSelectedRoundIndex(int selectedRoundIndex) {
        this.selectedRoundIndex = selectedRoundIndex;
    }

    public int getSelectedRoundIndex() {
        return this.selectedRoundIndex;
    }

    public Competitor getCompetitor(int index) {
        if (index < this.competitorList.size()) {
            return this.competitorList.get(index);
        }
        return null;
    }

    public Task getRoundTask(int roundIndex) {
        return this.taskList.get(roundIndex);
    }

    public void setRoundTask(int roundIndex, Task task) {
        this.taskList.set(roundIndex, task);
        this.setResultsDirty();
        this.editor.fireChangeEvent();
    }

    public void removeTask(int roundIndex) {
        this.taskList.remove(roundIndex);
        for (Competitor competitor : this.competitorList) {
            competitor.setNumberOfRounds(this.taskList.size());
        }
        this.setResultsDirty();
        this.setChangesMade(true);
        this.editor.fireChangeEvent();
    }

    public List<Task> getTaskList() {
        return (List)this.taskList.clone();
    }

    public void setTaskList(List<Task> newTaskList) {
        this.taskList.clear();
        this.taskList.addAll(newTaskList);
        for (Competitor competitor : this.competitorList) {
            competitor.setNumberOfRounds(this.taskList.size());
        }
        this.setResultsDirty();
        this.setChangesMade(true);
        this.editor.fireChangeEvent();
    }

    public Task getSelectedTask() {
        return this.getRoundTask(this.selectedRoundIndex);
    }

    public int getCompetitorCount() {
        return this.competitorList.size();
    }

    public int getNumberOfRounds() {
        return this.taskList.size();
    }

    public int getDoneRoundCount() {
        int counter = 0;
        int round = 0;
        while (round < this.taskList.size()) {
            if (this.isRoundFlown(round)) {
                ++counter;
            }
            ++round;
        }
        return counter;
    }

    public boolean isRoundFlown(int roundIndex) {
        int pilot = 0;
        while (pilot < this.competitorList.size()) {
            if (this.getCompetitor(pilot).getTaskTotalTime(roundIndex) > 0.0) {
                return true;
            }
            ++pilot;
        }
        return false;
    }

    public int getDiscardCount() {
        int nRounds = this.getDoneRoundCount();
        int nDrops = 0;
        if (this.maxDroppedScores != null && this.maxDroppedScores >= 0) {
            if (this.maxDroppedScores <= nRounds) {
                return this.maxDroppedScores;
            }
            return nRounds;
        }
        if (nRounds >= 5) {
            nDrops = 1;
        }
        return nDrops;
    }

    public int getGroupCount(int roundIndex) {
        return this.getGroupCount(roundIndex, false);
    }

    public int getGroupCount(int roundIndex, boolean countReflight) {
        int groupCount = 1;
        boolean hasReflightGroup = false;
        int c = 0;
        while (c < this.competitorList.size()) {
            int group = this.competitorList.get(c).getGroupNum(roundIndex);
            if (group > groupCount) {
                groupCount = group;
            }
            if (this.competitorList.get(c).isIncludedInReflightGroup(roundIndex)) {
                hasReflightGroup = true;
            }
            ++c;
        }
        if (hasReflightGroup && countReflight) {
            ++groupCount;
        }
        return groupCount;
    }

    public int getMaxGroupCount() {
        return this.getMaxGroupCount(false);
    }

    public int getMaxGroupCount(boolean countReflight) {
        int max = 0;
        int c = 0;
        while (c < this.getNumberOfRounds()) {
            if (this.getGroupCount(c) > max) {
                max = this.getGroupCount(c, countReflight);
            }
            ++c;
        }
        return max;
    }

    public void setNumberOfRounds(int numRounds) {
        while (this.taskList.size() < numRounds) {
            this.taskList.addAll(this.taskList);
        }
        while (this.taskList.size() > numRounds) {
            this.taskList.remove(numRounds);
        }
        for (Competitor competitor : this.competitorList) {
            competitor.setNumberOfRounds(numRounds);
        }
        this.setResultsDirty();
        this.editor.fireChangeEvent();
    }

    public void fireChangeEvent() {
        this.editor.fireChangeEvent();
    }

    public boolean useLetterGroupNames() {
        return this.useLetterGroupNames;
    }

    public void setUseLetterGroupNames(boolean useLetterGroupNames) {
        this.useLetterGroupNames = useLetterGroupNames;
    }

    public void setChangesMade(boolean changesMade) {
        this.changesMade = changesMade;
    }

    public boolean changesMade() {
        return this.changesMade;
    }

    public int getMaxDroppedScores() {
        if (this.maxDroppedScores == null) {
            this.maxDroppedScores = -1;
        }
        return this.maxDroppedScores;
    }

    public void setMaxDroppedScores(int maxDroppedScores) {
        this.maxDroppedScores = maxDroppedScores;
    }

    public boolean isUseSecondsForFlightTimes() {
        return this.useSecondsForFlightTimes;
    }

    public void setUseSecondsForFlightTimes(boolean useSecondsForFlightTimes) {
        this.useSecondsForFlightTimes = useSecondsForFlightTimes;
    }

    public boolean isUseLastCommaFirstNameFormat() {
        return this.useLastCommaFirstNameFormat;
    }

    public void setUseLastCommaFirstNameFormat(boolean useLastCommaFirstNameFormat) {
        this.useLastCommaFirstNameFormat = useLastCommaFirstNameFormat;
    }

    public boolean isUseTeamProtection() {
        return this.useTeamProtection;
    }

    public void setUseTeamProtection(boolean useTeamProtection) {
        this.useTeamProtection = useTeamProtection;
    }

    public boolean haveTeams() {
        int compCount = this.getCompetitorCount();
        int c = 0;
        while (c < compCount - 1) {
            String team = this.getCompetitor(c).getTeamName();
            if (team != null && !team.trim().equals("")) {
                int c2 = c + 1;
                while (c2 < compCount) {
                    if (team.equals(this.getCompetitor(c2).getTeamName())) {
                        return true;
                    }
                    ++c2;
                }
            }
            ++c;
        }
        return false;
    }

    public Collection<Team> getTeams() {
        if (this.resultDirty) {
            this.sortTeamsList();
        }
        return this.teamsList;
    }

    public void clearAllFlightTimes() {
        for (Competitor pilot : this.competitorList) {
            pilot.clearAllFlightTimes();
        }
        this.resultDirty = true;
        this.changesMade = true;
        this.editor.fireDataChangeEvent();
    }

    public int getF3xvaultID() {
        return this.f3xvaultID;
    }

    public void setF3xvaultID(int f3xvaultID) {
        this.f3xvaultID = f3xvaultID;
    }
}

