/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public class RoundScore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int groupNumber;
    private Competition competition;
    private Task lastCalculatedTask;
    private int roundNumber;
    private int[] flightTimes;
    private int totalTime;
    private double totalTaskTime;
    private int penalty;
    private int landingScore;
    private double launchPenalty;

    public RoundScore(Competition competition, int roundIndex) {
        this.competition = competition;
        this.roundNumber = roundIndex;
        this.groupNumber = 1;
        this.flightTimes = new int[20];
        Arrays.fill(this.flightTimes, -1);
    }

    private void calcTotalTime() {
        this.totalTaskTime = -1.0;
        Task task = this.competition.getRoundTask(this.roundNumber);
        boolean isShortestFlightTask = task.isShortestFlightTask();
        boolean isF5Jtask = task.isF5Jtask();
        boolean nonZeroTime = false;
        int nTimes = task.getNumFlights();
        this.landingScore = 0;
        this.launchPenalty = -1.0;
        if (task.hasLandingScore() && task.isLandingScoredSeparately()) {
            this.landingScore = this.flightTimes[--nTimes];
            if (this.landingScore < 0) {
                this.landingScore = 0;
            }
        }
        double shortestFlight = 10000.0;
        int i = 0;
        while (i < nTimes) {
            double time = this.flightTimes[i];
            if (time >= 0.0) {
                if (isF5Jtask && i == 1) {
                    int altitude = (int)time;
                    time = altitude <= 200 ? -1.0 * (double)altitude / 2.0 : -100.0 - (double)(altitude - 200) * 3.0;
                    this.launchPenalty = -1.0 * time;
                }
                this.totalTaskTime += time;
                nonZeroTime = true;
            }
            if (time < shortestFlight) {
                shortestFlight = time;
            }
            ++i;
        }
        if (isF5Jtask && (this.flightTimes[0] <= 0 || this.flightTimes[1] <= 0)) {
            this.totalTaskTime = -1.0;
            nonZeroTime = false;
        }
        if (nonZeroTime) {
            this.totalTaskTime += 1.0;
            if (isShortestFlightTask) {
                this.totalTaskTime = shortestFlight;
                if (this.totalTaskTime < 0.0) {
                    this.totalTaskTime = 0.0;
                }
            }
        }
        this.lastCalculatedTask = task;
    }

    public double getTotalTime() {
        if (this.competition.getRoundTask(this.roundNumber) != this.lastCalculatedTask) {
            this.calcTotalTime();
        }
        return this.totalTaskTime;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public int getGroupNum() {
        return this.groupNumber;
    }

    public void setGroupNum(int groupNum) {
        if (groupNum < 1 || groupNum > 20) {
            throw new IllegalArgumentException("Group assignment is " + groupNum + ", must be between 1 and " + 20);
        }
        this.groupNumber = groupNum;
        this.competition.setResultsDirty();
    }

    public int getTime(int timeIndex) {
        return this.flightTimes[timeIndex];
    }

    public void setTime(int timeIndex, int time) {
        Task task = this.competition.getRoundTask(this.roundNumber);
        int maxTimeCut = task.getMaxTimeCut(timeIndex);
        int minTimeCut = task.getMinTimeCut(timeIndex);
        if (maxTimeCut > 0 && time > maxTimeCut) {
            time = maxTimeCut;
        }
        if (time < minTimeCut && time > 0) {
            time = minTimeCut;
        }
        this.flightTimes[timeIndex] = time;
        if (task.isLadderTask()) {
            int i = 0;
            while (i < timeIndex && time > 0) {
                this.flightTimes[i] = task.getMinTimeCut(i);
                ++i;
            }
            i = timeIndex;
            while (i < this.flightTimes.length && time <= 0) {
                this.flightTimes[i] = -1;
                ++i;
            }
        }
        this.calcTotalTime();
        this.competition.setResultsDirty();
    }

    public void clearAllFlightTimes() {
        this.flightTimes = new int[20];
        Arrays.fill(this.flightTimes, -1);
        this.totalTaskTime = -1.0;
    }

    public int getLandingScore() {
        return this.landingScore;
    }

    public double getAllFlightsTotalTime() {
        Task task = this.competition.getRoundTask(this.roundNumber);
        if (!task.isShortestFlightTask()) {
            return this.getTotalTime();
        }
        int sum = 0;
        int nTimes = task.getNumFlights();
        int i = 0;
        while (i < nTimes) {
            sum += this.flightTimes[i];
            ++i;
        }
        return sum;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.totalTime != 0 && this.totalTaskTime == 0.0) {
            this.totalTaskTime = this.totalTime;
        }
    }

    public double getLaunchPenalty() {
        return this.launchPenalty;
    }
}

