/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import f3kscore.Task;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;

public class TasksPane
extends AbstractF3KScoreEditorPanel {
    private JTextField txtNumRounds;
    private String EMPTY_ITEM = "  ";
    private ExcelAdapter excelAdapter;
    private JPopupMenu popupMenu;
    private JMenuItem copyMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem moveUpMenuItem;
    private JMenuItem moveDownMenuItem;

    public TasksPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new TasksTableModel();
        this.table = new AbstractF3KScoreEditorPanel.F3KScoreTable(this, this.tableModel);
        this.table.setAutoResizeMode(3);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        JLabel lbl = new JLabel("Number of contest rounds:");
        this.txtNumRounds = new JTextField();
        this.txtNumRounds.setMinimumSize(new Dimension(50, 20));
        this.txtNumRounds.setPreferredSize(new Dimension(50, 20));
        this.txtNumRounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.txtNumRounds.transferFocus();
            }
        });
        this.txtNumRounds.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TasksPane.this.numberOfRoundsChanged();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JButton btnUp = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_up.png")));
        JButton btnDown = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_down.png")));
        JButton btnDelete = new JButton(new ImageIcon(F3KScore.class.getResource("delete_icon.png")));
        btnUp.setMargin(new Insets(2, 2, 2, 2));
        btnDown.setMargin(new Insets(2, 2, 2, 2));
        btnDelete.setMargin(new Insets(2, 2, 2, 2));
        btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.moveUp();
            }
        });
        btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.moveDown();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.deleteTask();
            }
        });
        this.configurePanel();
        this.excelAdapter = new ExcelAdapter(this.table){

            @Override
            public void pasteAction() {
            }
        };
        this.setLayout(new GridBagLayout());
        super.add((Component)lbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, 10, 5), 0, 0));
        super.add((Component)this.txtNumRounds, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(1, 1, 2, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        super.add((Component)btnUp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 3, 3, 3), 0, 0));
        super.add((Component)btnDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        super.add((Component)btnDelete, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = TasksPane.this.table.rowAtPoint(p);
                    int[] selRows = TasksPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        TasksPane.this.table.clearSelection();
                        TasksPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = TasksPane.this.table.columnAtPoint(p);
                        TasksPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    TasksPane.this.showPopupMenu(e);
                }
            }
        });
    }

    private void moveUp() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[0] <= 0) {
            this.table.clearSelection();
            return;
        }
        this.table.setRowSelectionInterval(selRows[0], selRows[selRows.length - 1]);
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            Task selectedTask = this.competition.getRoundTask(row);
            Task nextUpTask = this.competition.getRoundTask(row - 1);
            this.competition.setRoundTask(row - 1, selectedTask);
            this.competition.setRoundTask(row, nextUpTask);
            ++i;
        }
        this.competition.setResultsDirty();
        this.competition.setChangesMade(true);
        this.table.setRowSelectionInterval(selRows[0] - 1, selRows[selRows.length - 1] - 1);
    }

    private void moveDown() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[selRows.length - 1] >= this.competition.getNumberOfRounds() - 1) {
            this.table.clearSelection();
            return;
        }
        this.table.setRowSelectionInterval(selRows[0], selRows[selRows.length - 1]);
        int i = selRows.length - 1;
        while (i >= 0) {
            int row = selRows[i];
            Task selectedTask = this.competition.getRoundTask(row);
            Task nextUpTask = this.competition.getRoundTask(row + 1);
            this.competition.setRoundTask(row + 1, selectedTask);
            this.competition.setRoundTask(row, nextUpTask);
            --i;
        }
        this.competition.setResultsDirty();
        this.competition.setChangesMade(true);
        this.table.setRowSelectionInterval(selRows[0] + 1, selRows[selRows.length - 1] + 1);
    }

    private void deleteTask() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[0] < 0) {
            this.table.clearSelection();
            return;
        }
        int i = selRows.length - 1;
        while (i >= 0) {
            int row = selRows[i];
            this.competition.removeTask(row);
            --i;
        }
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public void configurePanel() {
        this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
        int numTasks = Task.taskPool.size();
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.addItem(this.EMPTY_ITEM);
        int i = 0;
        while (i < numTasks) {
            comboBox.addItem(Task.taskPool.get(i));
            ++i;
        }
        comboBox.setMaximumRowCount(18);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screen = toolkit.getScreenSize();
        if (screen.height < 699) {
            comboBox.setMaximumRowCount(10);
        }
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setMinWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(2000);
        PopupMenuListener actionListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                if (TasksPane.this.table.isEditing()) {
                    TasksPane.this.table.getCellEditor().stopCellEditing();
                    TasksPane.this.table.removeEditor();
                    TasksPane.this.table.clearSelection();
                }
            }
        };
        comboBox.addPopupMenuListener(actionListener);
    }

    private void numberOfRoundsChanged() {
        int val = -1;
        try {
            val = Integer.parseInt(this.txtNumRounds.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (val < 1 || val > 50) {
            String badVal = this.txtNumRounds.getText();
            this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
            JOptionPane.showMessageDialog(this, String.format("Invalid value entered for number of rounds: \"%s\"\nMust be an integer between 1 and 50.", badVal), "Invalid entry", 0);
            return;
        }
        if (val == this.competition.getNumberOfRounds()) {
            return;
        }
        this.competition.setSelectedRoundIndex(0);
        this.competition.setNumberOfRounds(val);
        this.competition.setChangesMade(true);
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.deleteTask();
                }
            });
            this.popupMenu.add(this.deleteMenuItem);
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.moveUpMenuItem = new JMenuItem(new AbstractAction("Move Up"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.moveUp();
                }
            });
            this.popupMenu.add(this.moveUpMenuItem);
            this.moveDownMenuItem = new JMenuItem(new AbstractAction("Move Down"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.moveDown();
                }
            });
            this.popupMenu.add(this.moveDownMenuItem);
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class TasksTableModel
    extends AbstractTableModel {
        private TasksTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            TasksPane.this.configurePanel();
        }

        @Override
        public int getRowCount() {
            return TasksPane.this.competition.getNumberOfRounds();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Round";
            }
            if (col == 1) {
                return "Task";
            }
            return "Description";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return String.valueOf(row + 1);
            }
            if (col == 1) {
                return TasksPane.this.competition.getRoundTask(row).getName();
            }
            return TasksPane.this.competition.getRoundTask(row).getDescription();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (TasksPane.this.EMPTY_ITEM.equals(value)) {
                return;
            }
            TasksPane.this.competition.setRoundTask(row, (Task)value);
            TasksPane.this.competition.setResultsDirty();
            TasksPane.this.competition.setChangesMade(true);
        }
    }
}

