/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ProgressMonitorDemo
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private ProgressMonitor progressMonitor;
    private JButton startButton = new JButton("Start");
    private JTextArea taskOutput;
    private Task task;

    public ProgressMonitorDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.add((Component)this.startButton, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.progressMonitor = new ProgressMonitor(this, "Running a Long Task", "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.startButton.setEnabled(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String message = String.format("Completed %d%%.\n", progress);
            this.progressMonitor.setNote(message);
            this.taskOutput.append(message);
            if (this.progressMonitor.isCanceled() || this.task.isDone()) {
                Toolkit.getDefaultToolkit().beep();
                if (this.progressMonitor.isCanceled()) {
                    this.task.cancel(true);
                    this.taskOutput.append("Task canceled.\n");
                } else {
                    this.taskOutput.append("Task completed.\n");
                }
                this.startButton.setEnabled(true);
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("ProgressMonitorDemo");
        frame.setDefaultCloseOperation(3);
        ProgressMonitorDemo newContentPane = new ProgressMonitorDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDemo.createAndShowGUI();
            }
        });
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                while (progress < 100 && !this.isCancelled()) {
                    Thread.sleep(random.nextInt(1000));
                    this.setProgress(Math.min(progress += random.nextInt(10), 100));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ProgressMonitorDemo.this.startButton.setEnabled(true);
            ProgressMonitorDemo.this.progressMonitor.setProgress(0);
        }
    }
}

