/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AudioConstants;
import f3kscore.F3KScore;
import java.io.Serializable;
import java.util.ArrayList;

public class Task
implements Serializable,
AudioConstants {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FLIGHT_TIMES = 20;
    public static final int TASK_TYPE_F3K = 0;
    public static final int TASK_TYPE_F5J = 1;
    public static final int TASK_TYPE_ALES_TD = 2;
    public static final int TASK_TYPE_SPEED = 3;
    public static ArrayList<Task> taskPool = new ArrayList();
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private String codedName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private String[] scoreCardTextTips;
    private String[] scoreCardTextTipsSecondsOnly;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean isShortestFlightTask;
    private int taskType = 0;

    static {
        taskPool.add(new Task(0, "f3k_a", "\"A\" - Last 5:00 in 7:00", "L1x5", "Last flight, 5:00 max, 7:00 window", new int[]{300}, null, 420, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_7min_window.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_a2", "\"A\" - Last 5:00 in 10:00", "L1x5", "Last flight, 5:00 max, 10:00 window", new int[]{300}, null, 600, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_b", "\"B\" - Last 2 x 4:00", "L2x4", "Last 2 flights, 4:00 max, 10:00 window", new int[]{240, 240}, null, 600, false, new String[]{"Max=4:00", "Max=4:00"}, new String[]{"Max=240s", "Max=240s"}, new String[]{"description_task_B_last_two_4min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_b2", "\"B\" - Last 2 x 3:00", "L2x3", "Last 2 flights, 3:00 max, 7:00 window", new int[]{180, 180}, null, 420, false, new String[]{"Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s"}, new String[]{"description_task_B_last_two_3min.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_c", "\"C\" - All up 3 x 3:00", "AUp", "All up, 3 flights, 3:00 max", new int[]{180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_c2", "\"C\" - All up 4 x 3:00", "AUp4", "All up, 4 flights, 3:00 max", new int[]{180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_c3", "\"C\" - All up 5 x 3:00", "AUp5", "All up, 5 flights, 3:00 max", new int[]{180, 180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_d", "\"D\" - Ladder +15 sec", "Laddr", "Increasing times - 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00, in 10:00 window", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}, 600, true, new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"}, new String[]{"30s", "45s", "60s", "75s", "90s", "105s", "120s"}, new String[]{"description_task_D_ladder.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_e", "\"E\" - Poker", "Poker", "Poker, 5 self nominated targets, 10:00 window", new int[5], null, 600, false, new String[]{"Target #1", "Target #2", "Target #3", "Target #4", "Target #5"}, null, new String[]{"description_task_E_poker.mp3", "window_3_min_prep_10_min_poker_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_f", "\"F\" - Best 3 of 6", "3of6", "Best 3 flights, 3:00 max, 6 launches only, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_F_3_of_6.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_g", "\"G\" - Best 5 x 2:00", "5x2.0", "Best 5 flights, 2:00 max, 10:00 window", new int[]{120, 120, 120, 120, 120}, null, 600, false, new String[]{"Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00"}, new String[]{"Max=120s", "Max=120s", "Max=120s", "Max=120s", "Max=120s"}, new String[]{"description_task_G_5x2.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_h", "\"H\" - 1:00, 2:00, 3:00, 4:00", "1234", "Best 4 flights, 1:00, 2:00, 3:00, 4:00 max in any order, 10:00 window", new int[]{60, 120, 180, 240}, null, 600, false, new String[]{"Max=1:00", "Max=2:00", "Max=3:00", "Max=4:00"}, new String[]{"Max=60s", "Max=120s", "Max=180s", "Max=240s"}, new String[]{"description_task_H_1_2_3_4.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_i", "\"I\" - Best 3 x 200s", "3200", "Best 3 flights, 200s (3:20) max, 10:00 window", new int[]{200, 200, 200}, null, 600, false, new String[]{"Max=3:20", "Max=3:20", "Max=3:20"}, new String[]{"Max=200s", "Max=200s", "Max=200s"}, new String[]{"description_task_I_3x200s.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_j", "\"J\" - Last 3 x 3:00", "L3x3", "Last 3 flights, 3:00 max, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_J_last_three_3min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_k", "\"K\" - Big Ladder", "BLddr", "Big Ladder - 5 flights only, 1:00, 1:30, 2:00, 2:30, 3:00 targets, 10:00 window", new int[]{60, 90, 120, 150, 180}, null, 600, false, new String[]{"Max=1:00", "Max=1:30", "Max=2:00", "Max=2:30", "Max=3:00"}, new String[]{"Max=60s", "Max=90s", "Max=120s", "Max=150s", "Max=180s"}, new String[]{"description_task_M_big_ladder.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_l", "\"L\" - Deuce in 7:00", "Deuce", "Deuce - Lowest flight of 2 flights, 7:00 window (non-F3K)", new int[2], null, 420, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_K_lowest_flight_7min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true));
        taskPool.add(new Task(0, "f3k_l2", "\"L\" - Deuce in 10:00", "Deuce", "Deuce - Lowest flight of 2 flights, 10:00 window (non-F3K)", new int[2], null, 600, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_K_lowest_flight_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true));
        taskPool.add(new Task(0, "f3k_m", "\"M\" - Two flights only, 2 x 3:30", "2x3.5", "Two flights only, 3:30 max, 7:00 window (non-F3K)", new int[]{210, 210}, null, 420, false, new String[]{"Max=3:30", "Max=3:30"}, new String[]{"Max=210s", "Max=210s"}, new String[]{"description_task_L_two_flights_only_7min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        taskPool.add(new Task(0, "f3k_m2", "\"M\" - Two flights only, 2 x 5:00", "2x5.0", "Two flights only, 5:00 max, 10:00 window (non-F3K)", new int[]{300, 300}, null, 600, false, new String[]{"Max=5:00", "Max=5:00"}, new String[]{"Max=300s", "Max=300s"}, new String[]{"description_task_L_two_flights_only_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false));
        int[] nArray = new int[2];
        nArray[0] = 420;
        taskPool.add(new Task(2, "ales_7", "ALES/TD - 7:00 max", "7:00", "Normalized duration, landing scored separately, 7:00 maximum", nArray, null, 0, false, new String[]{"Max=7:00", "Landing"}, new String[]{"Max=420s", "Landing"}, new String[]{"window_3_min_prep_7_min_ALES_30_sec_landing.mp3"}, new String[]{"Time", "Landing"}, false));
        int[] nArray2 = new int[2];
        nArray2[0] = 600;
        taskPool.add(new Task(2, "ales_10", "ALES/TD - 10:00 max", "10:00", "Normalized duration, landing scored separately, 10:00 maximum", nArray2, null, 0, false, new String[]{"Max=10:00", "Landing"}, new String[]{"Max=600s", "Landing"}, new String[]{"window_3_min_prep_10_min_ALES_30_sec_landing.mp3"}, new String[]{"Time", "Landing"}, false));
        int[] nArray3 = new int[2];
        nArray3[0] = 900;
        taskPool.add(new Task(2, "ales_15", "ALES/TD - 15:00 max", "15:00", "Normalized duration, landing scored separately, 15:00 maximum", nArray3, null, 0, false, new String[]{"Max=15:00", "Landing"}, new String[]{"Max=900s", "Landing"}, new String[]{"window_3_min_prep_15_min_ALES_30_sec_landing.mp3"}, new String[]{"Time", "Landing"}, false));
        int[] nArray4 = new int[3];
        nArray4[0] = 600;
        taskPool.add(new Task(1, "f5j_10", "F5J - 10:00 window", "10:00", "F5J duration with a measured launch and precision landing, 10:00 window", nArray4, null, 0, false, new String[]{"Time", "Altitude", "Landing"}, null, new String[]{"window_3_min_prep_10_min_ALES_30_sec_landing.mp3"}, new String[]{"Time", "Altitude", "Landing"}, false));
        int[] nArray5 = new int[3];
        nArray5[0] = 900;
        taskPool.add(new Task(1, "f5j_15", "F5J - 15:00 window", "15:00", "F5J duration with a measured launch and precision landing, 15:00 window", nArray5, null, 0, false, new String[]{"Time", "Altitude", "Landing"}, null, new String[]{"window_3_min_prep_15_min_ALES_30_sec_landing.mp3"}, new String[]{"Time", "Altitude", "Landing"}, false));
        taskPool.add(new Task(3, "f3b_speed", "F3B speed", "F3B", "F3F/F3B type speed task", new int[1], null, 0, false, null, null, null, null, false));
    }

    public Task(int taskType, String codedName, String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isLadderTask, String[] scoreCardTextTips, String[] scoreCardTextTipsSecondsOnly, String[] playList, String[] columnTitles, boolean isShortestFlightTask) {
        this.taskType = taskType;
        this.codedName = codedName;
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        this.scoreCardTextTips = scoreCardTextTips;
        this.scoreCardTextTipsSecondsOnly = scoreCardTextTipsSecondsOnly;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.isShortestFlightTask = isShortestFlightTask;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
    }

    public boolean isSpeedTask() {
        return this.taskType == 3;
    }

    public boolean isLadderTask() {
        return this.isLadderTask;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.longName;
    }

    public int getNumFlights() {
        return this.numFlights;
    }

    public String toString() {
        return this.name;
    }

    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }

    public int getWindowTime() {
        return this.windowTime;
    }

    public String[] getScoreCardTextTips() {
        if (F3KScore.editor().getCompetition().isUseSecondsForFlightTimes() && this.scoreCardTextTipsSecondsOnly != null) {
            return this.scoreCardTextTipsSecondsOnly;
        }
        return this.scoreCardTextTips;
    }

    public String[] getPlaylist() {
        return this.playList;
    }

    public String[] getFlightTimesColumnTitles() {
        return this.flightTimesColumnTitles;
    }

    public boolean hasLandingScore() {
        return this.taskType == 2 || this.taskType == 1;
    }

    public boolean isLandingScoredSeparately() {
        return this.taskType == 2;
    }

    public boolean isShortestFlightTask() {
        return this.isShortestFlightTask;
    }

    public boolean isF5Jtask() {
        return this.taskType == 1;
    }

    public boolean isF3Ktask() {
        return this.taskType == 0;
    }

    public boolean isAlesTdTask() {
        return this.taskType == 2;
    }

    public String getCodedName() {
        if (this.codedName == null) {
            for (Task task : taskPool) {
                if (!(this.shortName != null ? task.getShortName().equals(this.shortName) : task.getName().equals(this.name))) continue;
                return task.getCodedName();
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 420) {
                return taskPool.get(0).getCodedName();
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 600) {
                return taskPool.get(1).getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 600) {
                return taskPool.get(2).getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 420) {
                return taskPool.get(3).getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 3) {
                return taskPool.get(4).getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 4) {
                return taskPool.get(5).getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 5) {
                return taskPool.get(6).getCodedName();
            }
            if (this.name.startsWith("\"D\"")) {
                return taskPool.get(7).getCodedName();
            }
            if (this.name.startsWith("\"E\"")) {
                return taskPool.get(8).getCodedName();
            }
            if (this.name.startsWith("\"F\"")) {
                return taskPool.get(9).getCodedName();
            }
            if (this.name.startsWith("\"G\"")) {
                return taskPool.get(10).getCodedName();
            }
            if (this.name.startsWith("\"H\"")) {
                return taskPool.get(11).getCodedName();
            }
            if (this.name.startsWith("\"I\"")) {
                return taskPool.get(12).getCodedName();
            }
            if (this.name.startsWith("\"J\"")) {
                return taskPool.get(13).getCodedName();
            }
        }
        return this.codedName;
    }

    public void setCodedName(String codedName) {
        this.codedName = codedName;
    }
}

