/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class TotalScoresPane
extends AbstractF3KScoreEditorPanel {
    private String[] colNames = new String[20];
    private int[] colWidths = new int[20];
    private boolean useSecondNameColumn;
    private int lastRoundCol;
    private int secondNameCol = -1;
    private int penaltyCol;
    private int scoreCol;
    private int percentCol;
    private int classCol;
    private int faiAmaCol;
    private int clubCol;
    private int stateCol;
    private NumberFormat scoreFormatter = NumberFormat.getNumberInstance();
    private NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private ExcelAdapter excelAdapter;
    private JPopupMenu popupMenu;

    public TotalScoresPane(Competition competition) {
        this.competition = competition;
        this.configurePanel();
        this.tableModel = new TotalScoresTableModel();
        this.table = new AbstractF3KScoreEditorPanel.F3KScoreTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.setMultilineTableHeaders();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter = new ExcelAdapter(this.table){

            @Override
            public void pasteAction() {
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = TotalScoresPane.this.table.rowAtPoint(p);
                    int[] selRows = TotalScoresPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        TotalScoresPane.this.table.clearSelection();
                        TotalScoresPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = TotalScoresPane.this.table.columnAtPoint(p);
                        TotalScoresPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    TotalScoresPane.this.showPopupMenu(e);
                }
            }
        });
        this.scoreFormatter.setMinimumFractionDigits(0);
        this.scoreFormatter.setMaximumFractionDigits(1);
        this.percentFormatter.setMaximumFractionDigits(2);
        this.percentFormatter.setMinimumFractionDigits(2);
    }

    private void configurePanel() {
        int nRounds = this.competition.getNumberOfRounds();
        int nCol = nRounds + 10;
        this.useSecondNameColumn = false;
        if (nRounds > 20) {
            nCol += 2;
            this.useSecondNameColumn = true;
        }
        this.colNames = new String[nCol];
        this.colWidths = new int[nCol];
        this.colNames[0] = "";
        this.colWidths[0] = 25;
        this.colNames[1] = "Name";
        this.colWidths[1] = 140;
        int col = 2;
        while (col < this.competition.getNumberOfRounds() + 2) {
            int roundIndex = col - 2;
            String shortTaskName = this.competition.getRoundTask(roundIndex).getShortName();
            if (shortTaskName == null || shortTaskName.length() == 0) {
                this.colNames[col] = "" + (col - 1);
                this.colWidths[col] = 40;
            } else {
                this.colNames[col] = String.format("%d\n%s", col - 1, shortTaskName);
                this.colWidths[col] = 50;
            }
            ++col;
        }
        this.lastRoundCol = col - 1;
        this.secondNameCol = -1;
        if (this.useSecondNameColumn) {
            this.colNames[col] = "";
            this.colWidths[col] = 25;
            this.secondNameCol = ++col;
            this.colNames[col] = "Name";
            this.colWidths[col] = 150;
            ++col;
        }
        this.penaltyCol = col;
        this.colNames[col] = "Penalty\n& Rnd";
        this.colWidths[col] = 65;
        int i = 0;
        while (i < this.competition.getCompetitorCount()) {
            Competitor comp = this.competition.getCompetitorAtPosition(i);
            if (comp.getPenalty() > 100) {
                this.colWidths[col] = 75;
            }
            if (comp.getPenalty() > 200) {
                this.colWidths[col] = 80;
            }
            ++i;
        }
        this.scoreCol = ++col;
        this.colNames[col] = "Score";
        this.colWidths[col] = 60;
        this.percentCol = ++col;
        this.colNames[col] = "%";
        this.colWidths[col] = 55;
        this.classCol = ++col;
        this.colNames[col] = "Class";
        this.colWidths[col] = 70;
        this.faiAmaCol = ++col;
        this.colNames[col] = "FAI/AMA\nnumber";
        this.colWidths[col] = 85;
        this.clubCol = ++col;
        this.colNames[col] = "Club";
        this.colWidths[col] = 65;
        this.stateCol = ++col;
        this.colNames[col] = "State";
        this.colWidths[col] = 65;
        this.colNames[++col] = "";
        this.colWidths[col] = 2000;
    }

    private void configureColumnWidths() {
        int i = 0;
        while (i < this.colWidths.length) {
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidths[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            ++i;
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TotalScoresPane.this.excelAdapter.copyAction();
                }
            });
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(copyMenuItem);
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class TotalScoresTableModel
    extends AbstractTableModel {
        private TotalScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            TotalScoresPane.this.configurePanel();
            super.fireTableStructureChanged();
            TotalScoresPane.this.configureColumnWidths();
            TotalScoresPane.this.setMultilineTableHeaders();
        }

        @Override
        public int getColumnCount() {
            return TotalScoresPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return TotalScoresPane.this.competition.getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            return TotalScoresPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor pilot = TotalScoresPane.this.competition.getCompetitorAtPosition(row);
            if (pilot == null) {
                return "";
            }
            if (col >= TotalScoresPane.this.colNames.length - 1) {
                return "";
            }
            if (col == 0 || col == TotalScoresPane.this.secondNameCol - 1) {
                return "" + (row + 1);
            }
            if (col == 1 || col == TotalScoresPane.this.secondNameCol) {
                return pilot.getFullName();
            }
            if (col <= TotalScoresPane.this.lastRoundCol) {
                int round = col - 2;
                double roundScore = pilot.getRoundScore(round);
                String displayValue = roundScore == 1000.0 ? "1000" : (roundScore <= 0.0 ? "0" : TotalScoresPane.this.scoreFormatter.format(roundScore));
                if (pilot.isDiscardRound(round) && pilot.calculateTotalScore() >= 0.0) {
                    return "(" + displayValue + ")";
                }
                if (roundScore <= 0.0) {
                    return "";
                }
                return displayValue;
            }
            if (col == TotalScoresPane.this.penaltyCol) {
                int penalty = pilot.getPenalty();
                if (penalty == 0) {
                    return "";
                }
                StringBuffer res = new StringBuffer();
                res.append(pilot.getPenalty());
                if (pilot.getPenaltyRounds().length() > 0) {
                    res.append("/").append(pilot.getPenaltyRounds());
                }
                return res.toString();
            }
            if (col == TotalScoresPane.this.scoreCol) {
                double score = pilot.calculateTotalScore();
                if (score != 0.0) {
                    return TotalScoresPane.this.scoreFormatter.format(pilot.calculateTotalScore());
                }
                return "";
            }
            if (col == TotalScoresPane.this.percentCol) {
                double val = pilot.getPercent();
                if (val == 100.0) {
                    return "100.0%";
                }
                if (val != 0.0) {
                    return TotalScoresPane.this.percentFormatter.format(pilot.getPercent() / 100.0);
                }
                return "";
            }
            if (col == TotalScoresPane.this.classCol) {
                String val = pilot.getProperty("Class");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.faiAmaCol) {
                String val = pilot.getProperty("FAI/AMA Num");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.clubCol) {
                String val = pilot.getProperty("Club");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.stateCol) {
                String val = pilot.getProperty("State");
                return val == null ? "" : val;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

