/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.RoundScore;
import java.io.Serializable;
import java.util.ArrayList;

public class Competitor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Name";
    public static final String CLASS = "Class";
    public static final String COUNTRY = "Country";
    public static final String CLUB = "Club";
    public static final String INFO = "Info";
    public static final String PENALTY = "Penalty";
    public static final String FREQ1 = "Freq 1";
    public static final String FREQ2 = "Freq 2";
    public static final String FREQ3 = "Freq 3";
    public static final String MODELS = "Models";
    public static final String EMAIL = "E-mail";
    public static final String TEAM = "Team";
    private Competition competition;
    private String name;
    private String competitorClass;
    private String country;
    private String club;
    private String info;
    private int penalty;
    private String freq1;
    private String freq2;
    private String freq3;
    private String models;
    private String email;
    private String team;
    private ArrayList<RoundScore> scores;

    public Competitor(Competition competition, String name) {
        this.name = name;
        this.competition = competition;
        this.competitorClass = "";
        this.country = "";
        this.club = "";
        this.info = "";
        this.freq1 = "";
        this.freq2 = "";
        this.freq3 = "";
        this.models = "";
        this.email = "";
        this.team = "";
        this.scores = new ArrayList();
        int numRounds = competition.getNumberOfRounds();
        this.setNumberOfRounds(numRounds);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Competitor) {
            Competitor other = (Competitor)obj;
            return other.getName().equals(this.name);
        }
        return false;
    }

    public void setNumberOfRounds(int numRounds) {
        int i = 0;
        while (i < numRounds) {
            this.scores.add(new RoundScore(this.competition, i, this.competition.getRoundTask(i)));
            ++i;
        }
    }

    public String getProperty(String propName) {
        if (propName.equals(NAME)) {
            return this.name;
        }
        if (propName.equals(CLASS)) {
            return this.competitorClass;
        }
        if (propName.equals(COUNTRY)) {
            return this.country;
        }
        if (propName.equals(CLUB)) {
            return this.club;
        }
        if (propName.equals(INFO)) {
            return this.info;
        }
        if (propName.equals(PENALTY)) {
            return "" + this.penalty;
        }
        if (propName.equals(FREQ1)) {
            return this.freq1;
        }
        if (propName.equals(FREQ2)) {
            return this.freq2;
        }
        if (propName.equals(FREQ3)) {
            return this.freq3;
        }
        if (propName.equals(MODELS)) {
            return this.models;
        }
        if (propName.equals(EMAIL)) {
            return this.email;
        }
        if (propName.equals(TEAM)) {
            return this.team;
        }
        return "";
    }

    public void setProperty(String propName, String propVal) {
        if (propName.equals(NAME)) {
            if (propVal.equals("")) {
                return;
            }
            this.name = propVal;
            this.competition.setResultDirty();
        }
        if (propName.equals(CLASS)) {
            this.competitorClass = propVal;
        }
        if (propName.equals(COUNTRY)) {
            this.country = propVal;
        }
        if (propName.equals(CLUB)) {
            this.club = propVal;
        }
        if (propName.equals(INFO)) {
            this.info = propVal;
        }
        if (propName.equals(PENALTY)) {
            this.penalty = Integer.parseInt(propVal);
        }
        if (propName.equals(FREQ1)) {
            this.freq1 = propVal;
        }
        if (propName.equals(FREQ2)) {
            this.freq2 = propVal;
        }
        if (propName.equals(FREQ3)) {
            this.freq3 = propVal;
        }
        if (propName.equals(MODELS)) {
            this.models = propVal;
        }
        if (propName.equals(EMAIL)) {
            this.email = propVal;
        }
        if (propName.equals(TEAM)) {
            this.team = propVal;
        }
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public String getName() {
        return this.name;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCompetitorClass() {
        return this.competitorClass;
    }

    public String getClub() {
        return this.club;
    }

    public String getInfo() {
        return this.info;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setGroup(int taskIndex, int group) {
        this.scores.get(taskIndex).setGroup(group);
    }

    public int getGroup(int taskIndex) {
        return this.scores.get(taskIndex).getGroup();
    }

    public void setTaskTime(int taskIndex, int flightIndex, int newTime) {
        this.scores.get(taskIndex).setTime(flightIndex, newTime);
    }

    public int getTaskTime(int taskIndex, int flightIndex) {
        return this.scores.get(taskIndex).getTime(flightIndex);
    }

    public int getTaskTotalTime(int taskIndex) {
        return this.scores.get(taskIndex).getTotalTime();
    }

    public int getStartNumber() {
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            if (this.competition.getCompetitor(c) == this) {
                return c;
            }
            ++c;
        }
        return 0;
    }

    public int getPosition() {
        int myScore = this.getTotalScore();
        int pos = 0;
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            Competitor comp = this.competition.getCompetitor(c);
            if (comp != this) {
                int score = comp.getTotalScore();
                if (score > myScore) {
                    ++pos;
                } else if (score == myScore) {
                    int discardCount = this.competition.getDiscardCount();
                    int discardIndex = 0;
                    while (comp.getDiscardScore(discardIndex) == this.getDiscardScore(discardIndex) && discardIndex < discardCount) {
                        ++discardIndex;
                    }
                    if (discardIndex < discardCount) {
                        if (comp.getDiscardScore(discardIndex) > this.getDiscardScore(discardIndex)) {
                            ++pos;
                        }
                    } else if (this.getStartNumber() > comp.getStartNumber()) {
                        ++pos;
                    }
                }
            }
            ++c;
        }
        return pos;
    }

    public float getPercent() {
        int myTotal;
        int maxTotal = myTotal = this.getTotalScore();
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            int tot;
            Competitor comp = this.competition.getCompetitor(c);
            if (comp != this && (tot = comp.getTotalScore()) > maxTotal) {
                maxTotal = tot;
            }
            ++c;
        }
        if (maxTotal > 0) {
            return (float)myTotal * 100.0f / (float)maxTotal;
        }
        return 0.0f;
    }

    public int getDiscardScore(int discardIndex) {
        int nRounds = this.competition.getDoneRoundCount();
        int[] roundScores = new int[nRounds];
        int i = 0;
        while (i < nRounds) {
            roundScores[i] = this.competition.getTaskScore(i, this.getGroup(i), this.getTaskTotalTime(i));
            ++i;
        }
        int discardCount = this.competition.getDiscardCount();
        int[] discardScores = new int[discardCount];
        if (discardIndex < discardCount) {
            int d = 0;
            while (d < discardCount) {
                int lowest = 1000;
                int lowIx = 0;
                int b = 0;
                while (b < nRounds) {
                    if (roundScores[b] >= 0 && roundScores[b] <= lowest) {
                        lowest = roundScores[b];
                        lowIx = b;
                    }
                    ++b;
                }
                discardScores[d] = lowest;
                roundScores[lowIx] = -lowest - 1;
                ++d;
            }
            return discardScores[discardCount - 1 - discardIndex];
        }
        return 0;
    }

    public boolean isDiscardRound(int round) {
        int nRounds = this.competition.getDoneRoundCount();
        if (round >= nRounds) {
            return false;
        }
        int[] roundScores = new int[nRounds];
        int i = 0;
        while (i < nRounds) {
            roundScores[i] = this.competition.getTaskScore(i, this.getGroup(i), this.getTaskTotalTime(i));
            ++i;
        }
        int discardCount = this.competition.getDiscardCount();
        int d = 0;
        while (d < discardCount) {
            int lowest = 1000;
            int lowIx = 0;
            int b = 0;
            while (b < nRounds) {
                if (roundScores[b] >= 0 && roundScores[b] <= lowest) {
                    lowest = roundScores[b];
                    lowIx = b;
                }
                ++b;
            }
            roundScores[lowIx] = -lowest - 1;
            ++d;
        }
        return roundScores[round] < 0;
    }

    public int getTotalScore() {
        int nRounds = this.competition.getDoneRoundCount();
        int[] roundScores = new int[nRounds];
        int i = 0;
        while (i < nRounds) {
            roundScores[i] = this.competition.getTaskScore(i, this.getGroup(i), this.getTaskTotalTime(i));
            ++i;
        }
        int discardCount = this.competition.getDiscardCount();
        int d = 0;
        while (d < discardCount) {
            int lowest = 1000;
            int lowIx = 0;
            int b = 0;
            while (b < nRounds) {
                if (roundScores[b] >= 0 && roundScores[b] <= lowest) {
                    lowest = roundScores[b];
                    lowIx = b;
                }
                ++b;
            }
            roundScores[lowIx] = -lowest - 1;
            ++d;
        }
        int total = 0;
        int c = 0;
        while (c < nRounds) {
            if (roundScores[c] > 0) {
                total += roundScores[c];
            }
            ++c;
        }
        return total - this.penalty;
    }
}

