/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.GroupsPane;
import f3kscore.RegistrationPane;
import f3kscore.RoundScoresPane;
import f3kscore.StartListPane;
import f3kscore.TasksPane;
import f3kscore.TotalScoresPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class F3KScore
extends JFrame {
    private static Font fontPlain12pt = new Font("Serif", 0, 12);
    private static Font fontBold12pt = new Font("Serif", 1, 12);
    private static Font fontUnBold12pt = new Font("Serif", 1, 12);
    private static Font fontPlain10pt = new Font("Serif", 0, 10);
    private static Font fontBold10pt = new Font("Serif", 1, 10);
    private static Font fontPlain8pt = new Font("Serif", 0, 8);
    private static Font fontBold8pt = new Font("Serif", 1, 8);
    private final JMenuBar mainMenuBar = new JMenuBar();
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu printMenu;
    private JMenu exportMenu;
    private Competition competition;
    private ArrayList<AbstractF3KScoreEditorPanel> editorPanels;
    private AbstractF3KScoreEditorPanel registrationPane;
    private AbstractF3KScoreEditorPanel tasksPane;
    private AbstractF3KScoreEditorPanel startListPane;
    private AbstractF3KScoreEditorPanel groupsPane;
    private AbstractF3KScoreEditorPanel timesPane;
    private AbstractF3KScoreEditorPanel totalPane;
    private JTabbedPane tabbedPane;
    private File file;
    private Image f3kIcon;
    private Image f3kLogo;
    private PrinterJob printerJob;
    private JLabel lblCompName;
    private JTextField txtCompName;
    private MyFileFilter f3kFilter;
    private MyFileFilter csvFilter;
    private MyFileFilter txtFilter;
    private File currentDir;

    public static void main(String[] args) {
        String fName = null;
        if (args.length > 0) {
            fName = args[0];
        }
        new F3KScore(fName);
    }

    public F3KScore(String fName) {
        Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        fontUnBold12pt = fontUnBold12pt.deriveFont(map);
        this.setTitle("F3KScore");
        URL imgURL = F3KScore.class.getResource("f3k_logo.png");
        this.f3kIcon = new ImageIcon(imgURL).getImage();
        this.setIconImage(this.f3kIcon);
        imgURL = F3KScore.class.getResource("f3kscore.png");
        this.f3kLogo = new ImageIcon(imgURL).getImage();
        this.lblCompName = new JLabel("Competition name:");
        this.txtCompName = new JTextField();
        this.txtCompName.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                F3KScore.this.competition.setCompetitionName(F3KScore.this.txtCompName.getText().trim());
                F3KScore.this.competition.setChangesMade(true);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.createMenuBar();
        this.competition = new Competition(this);
        this.f3kFilter = new MyFileFilter("f3k", "F3KScore files (.f3k)");
        this.csvFilter = new MyFileFilter("csv", "Comma separated value files (.csv)");
        this.txtFilter = new MyFileFilter("txt", "Text files (.txt)");
        this.editorPanels = new ArrayList();
        this.registrationPane = new RegistrationPane(this.competition);
        this.editorPanels.add(this.registrationPane);
        this.tasksPane = new TasksPane(this.competition);
        this.editorPanels.add(this.tasksPane);
        this.startListPane = new StartListPane(this.competition);
        this.editorPanels.add(this.startListPane);
        this.groupsPane = new GroupsPane(this.competition);
        this.editorPanels.add(this.groupsPane);
        this.timesPane = new RoundScoresPane(this.competition);
        this.editorPanels.add(this.timesPane);
        this.totalPane = new TotalScoresPane(this.competition);
        this.editorPanels.add(this.totalPane);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Pilot List", this.registrationPane);
        this.tabbedPane.addTab("Task List", this.tasksPane);
        this.tabbedPane.addTab("Flight Matrix", this.groupsPane);
        this.tabbedPane.addTab("Start List", this.startListPane);
        this.tabbedPane.addTab("Round Scores", this.timesPane);
        this.tabbedPane.addTab("Total Scores", this.totalPane);
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)this.lblCompName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add((Component)this.txtCompName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 10), 0, 0));
        contentPane.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.setOpaque(true);
        super.setContentPane(contentPane);
        super.setSize(900, 460);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                F3KScore.this.exitApplication();
            }
        });
        if (fName != null) {
            final File file = new File(fName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        F3KScore.this.loadFromFile(file);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(F3KScore.this, "Failed when trying to read file \"" + file.getName() + "\"\nError message:\n\n\"" + ex.getLocalizedMessage() + "\"", "Error reading data file", 0);
                    }
                }
            });
        }
    }

    private void exitApplication() {
        if (this.competition.changesMade()) {
            int reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nSave changes before closing?", "Save data?", 1);
            if (reply == 0) {
                this.save(this.file);
            }
            if (reply == 2) {
                return;
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printData(final Printable printer) {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition data to print.", "No competition data", 0);
            return;
        }
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        Pageable myPages = new Pageable(){

            @Override
            public int getNumberOfPages() {
                int nPages = 0;
                while (nPages < 999) {
                    try {
                        if (printer.print(null, new PageFormat(), nPages) == 1) {
                            break;
                        }
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                    ++nPages;
                }
                return nPages;
            }

            @Override
            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                return new PageFormat();
            }

            @Override
            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return printer;
            }
        };
        this.printerJob.setPageable(myPages);
        boolean doPrint = this.printerJob.printDialog();
        if (doPrint) {
            try {
                Printable printable = printer;
                synchronized (printable) {
                    this.printerJob.print();
                }
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, "Failed to print data:\n\n" + e.getLocalizedMessage(), "Print error", 0);
            }
        }
    }

    public void printFlightMatrix() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                float fontSize = fontPlain10pt.getSize2D();
                float charWidth = fontSize * 0.5f;
                int colCount = F3KScore.this.groupsPane.getTableModel().getColumnCount() - 1;
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float leftMargin = 50.0f;
                Graphics2D g2d = (Graphics2D)g;
                int height = (int)pf.getImageableHeight();
                if (colCount <= 20) {
                    if (g != null) {
                        g2d.translate(pf.getImageableX(), pf.getImageableY());
                    }
                } else {
                    leftMargin = 20.0f;
                    if (colCount > 30) {
                        leftMargin = 0.0f;
                    }
                    height = (int)pf.getImageableWidth();
                    if (g != null) {
                        g2d.translate(pf.getImageableX() + (double)height, pf.getImageableY());
                    }
                    if (g != null) {
                        g2d.rotate(1.5707963267948966);
                    }
                }
                float x0 = leftMargin;
                float y = y0;
                int[] columnWidthChars = new int[colCount];
                Arrays.fill(columnWidthChars, 3);
                columnWidthChars[0] = 20;
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            String title = String.valueOf(F3KScore.this.competition.getCompetitionName()) + " - Flight Matrix";
                            g.drawString(title, (int)x0, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    float y1 = y - (float)rowHeight;
                    if (g != null) {
                        g.setFont(fontBold10pt);
                    }
                    boolean header = true;
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.groupsPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        if (pageCount == page) {
                            int colIx = 0;
                            while (colIx < colCount) {
                                String s;
                                float colWidth = charWidth * (float)columnWidthChars[colIx];
                                if (header) {
                                    s = F3KScore.this.groupsPane.getTableModel().getColumnName(colIx);
                                    if (g != null) {
                                        g.drawString(s, (int)x, (int)y);
                                    }
                                } else {
                                    s = (String)F3KScore.this.groupsPane.getTableModel().getValueAt(rowIx, colIx);
                                    if ((float)s.length() > colWidth / charWidth) {
                                        s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                    }
                                    if (g != null) {
                                        g.drawString(s, (int)x, (int)y);
                                    }
                                }
                                x += colWidth;
                                ++colIx;
                            }
                        }
                        if (header) {
                            header = false;
                            if (g != null) {
                                g.setFont(fontPlain10pt);
                            }
                            if (pageCount == page && g != null) {
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                            }
                            y += 2.0f;
                            --rowIx;
                        } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                            if (pageCount == page && g != null) {
                                g.drawLine((int)x0, (int)y + 3, (int)x, (int)y + 3);
                            }
                            y += 2.0f;
                        }
                        if (pageCount == page && g != null) {
                            x = x0 - 4.0f;
                            int[] nArray = columnWidthChars;
                            int n = columnWidthChars.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Integer colW = nArray[n2];
                                g.drawLine((int)(x += (float)((int)((float)colW.intValue() * charWidth))), (int)y1, (int)x, (int)y + 2);
                                ++n2;
                            }
                            g.setColor(Color.BLACK);
                        }
                        y1 = y;
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.groupsPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public void printTotalScores() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                int height = (int)pf.getImageableWidth();
                int width = (int)pf.getImageableHeight();
                if (g != null) {
                    g2d.translate(pf.getImageableX() + (double)height, pf.getImageableY());
                }
                if (g != null) {
                    g2d.rotate(1.5707963267948966);
                }
                float fontSize = fontPlain10pt.getSize2D();
                float charWidth = fontSize * 0.5f;
                int colCount = F3KScore.this.totalPane.getTableModel().getColumnCount() - 4;
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float leftMargin = 20.0f;
                float rightMargin = 20.0f;
                float x0 = leftMargin;
                float y = y0;
                int[] columnWidth = new int[colCount];
                Arrays.fill(columnWidth, (int)charWidth * 6);
                columnWidth[0] = (int)charWidth * 4;
                columnWidth[1] = (int)charWidth * 20;
                columnWidth[colCount - 4] = (int)charWidth * 7 + 2;
                columnWidth[colCount - 3] = (int)charWidth * 7;
                columnWidth[colCount - 2] = (int)charWidth * 7 + 2;
                columnWidth[colCount - 1] = (int)charWidth * 9;
                int pageRow = 0;
                int pageCount = 0;
                int totalTableWidth = 0;
                int i = 0;
                while (i < colCount) {
                    totalTableWidth += columnWidth[i];
                    ++i;
                }
                int pagesPerRow = (int)Math.ceil((float)totalTableWidth / ((float)width - leftMargin - rightMargin));
                if (F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                    if (page == 0 && g != null) {
                        g.setFont(fontBold10pt);
                        g.drawString(F3KScore.this.competition.getCompetitionName(), 20, (int)y);
                    }
                    y += (float)(rowHeight + 5);
                }
                float y1 = y - (float)rowHeight;
                boolean header = true;
                int rowIx = 0;
                int row0 = 0;
                while (rowIx < F3KScore.this.totalPane.getTableModel().getRowCount()) {
                    if (y >= (float)height - bottomMargin) {
                        y = y0;
                        ++pageRow;
                        header = true;
                        row0 = rowIx;
                    }
                    int pageCol = 0;
                    float x = x0;
                    int colIx = 0;
                    while (colIx < colCount) {
                        float colWidth = columnWidth[colIx];
                        if (x + colWidth > (float)width - rightMargin) {
                            x = x0;
                            ++pageCol;
                        }
                        if ((pageCount = pageRow * pagesPerRow + pageCol) == page && g != null) {
                            String s;
                            if (header) {
                                g.setFont(fontBold10pt);
                                s = F3KScore.this.totalPane.getTableModel().getColumnName(colIx);
                                g.drawString(s, (int)x, (int)y);
                                g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                            } else {
                                g.setFont(fontPlain10pt);
                                s = (String)F3KScore.this.totalPane.getTableModel().getValueAt(rowIx, colIx);
                                if ((float)s.length() > colWidth / charWidth) {
                                    s = String.valueOf(s.substring(0, (int)((double)(colWidth / charWidth) - 0.5))) + "...";
                                }
                                g.drawString(s, (int)x, (int)y);
                                if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                                    g.drawLine((int)x, (int)y + 3, (int)(x + colWidth), (int)y + 3);
                                }
                            }
                            if (x > x0) {
                                g.drawLine((int)(x - 4.0f), (int)y1, (int)(x - 4.0f), (int)y + 2);
                            }
                        }
                        x += colWidth;
                        ++colIx;
                    }
                    if (header) {
                        header = false;
                        y += 2.0f;
                        --rowIx;
                    } else if (rowIx + 1 - row0 >= 3 && (rowIx + 1 - row0) % 3 == 0) {
                        y += 2.0f;
                    }
                    y1 = y;
                    y += (float)rowHeight;
                    ++rowIx;
                }
                if (page + 1 > (pageRow + 1) * pagesPerRow) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void printScoreCards() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int roundCount = F3KScore.this.competition.getNumberOfRounds();
                int pageCount = (F3KScore.this.competition.getCompetitorCount() / 8 + 1) * roundCount;
                if (page >= pageCount) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)g;
                int width = (int)pf.getImageableWidth() + 10;
                int height = (int)pf.getImageableHeight() + 10;
                if (g != null) {
                    g2d.translate(pf.getImageableX() - 5.0, pf.getImageableY() - 5.0);
                }
                Font font = fontPlain12pt;
                int rowHeight = (int)(font.getSize2D() * 1.2f);
                int cardWidth = width / 2;
                int cardHeight = height / 4;
                int roundIx = page % roundCount;
                int card = 0;
                while (card < 8) {
                    int compIx = 8 * (page / roundCount) + card;
                    if (compIx >= F3KScore.this.competition.getCompetitorCount()) {
                        return 0;
                    }
                    int xOffset = (card & 1) * cardWidth;
                    int yOffset = (card & 7) / 2 * cardHeight;
                    if (g != null) {
                        g.drawRect(xOffset + 0, yOffset + 0, cardWidth, cardHeight);
                    }
                    xOffset += 15;
                    String name = F3KScore.this.competition.getCompetitor(compIx).getName();
                    String task = F3KScore.this.competition.getRoundTask(roundIx).getLongName();
                    int group = F3KScore.this.competition.getCompetitor(compIx).getGroup(roundIx);
                    String groupString = "" + group;
                    if (F3KScore.this.competition.useLetterGroupNames()) {
                        groupString = Competition.groupLetters.get(group - 1);
                    }
                    boolean isLadderTask = task.indexOf("Increasing times") >= 0;
                    String[] increasingTimes = new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"};
                    if (g != null) {
                        g.setFont(fontUnBold12pt);
                        g.drawString(name, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 0);
                        g.setFont(fontBold12pt);
                        g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 1);
                        g.drawString("Group:  " + groupString, xOffset + cardWidth / 2, yOffset + 25 + rowHeight * 1);
                        g.setFont(fontPlain8pt);
                        float fontSize = fontPlain8pt.getSize2D();
                        if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                            int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                            task = String.valueOf(task.substring(0, nChars)) + "...";
                        }
                        g.drawString(task, xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 2);
                    }
                    int xr = xOffset + cardWidth / 10;
                    int yr = yOffset + rowHeight * 4 - cardHeight / 6 + 3;
                    int c = 0;
                    while (c < 8) {
                        if ((c & 3) == 0) {
                            xr = xOffset + cardWidth / 10;
                            yr += cardHeight / 6 - 3;
                        }
                        if (g != null) {
                            g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                            if (isLadderTask && c < increasingTimes.length) {
                                g.setFont(fontPlain8pt);
                                g.drawString(increasingTimes[c], xr + 1, yr + 8);
                            }
                        }
                        xr += cardWidth / 5;
                        ++c;
                    }
                    if (g != null) {
                        g.setFont(fontUnBold12pt);
                        g.drawString("Penalty:              ", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 5);
                    }
                    if (g != null) {
                        g.setFont(fontBold12pt);
                        g.drawString("Sign Pilot:", xOffset + cardWidth / 10, yOffset + cardHeight - 5);
                        g.drawString("Sign Timer:", xOffset + cardWidth / 2, yOffset + cardHeight - 5);
                    }
                    ++card;
                }
                return 0;
            }
        });
    }

    public void printOfficialScoreCards() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int roundCount = F3KScore.this.competition.getNumberOfRounds();
                int pageCount = roundCount;
                if (page >= pageCount) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)g;
                int width = (int)pf.getImageableWidth() + 10;
                int height = (int)pf.getImageableHeight() + 10;
                if (g != null) {
                    g2d.translate(pf.getImageableX() - 5.0, pf.getImageableY() - 5.0);
                }
                Font font = fontPlain12pt;
                int rowHeight = (int)(font.getSize2D() * 1.2f);
                int cardWidth = width / 2;
                int cardHeight = height / 4;
                int roundIx = page;
                int card = 0;
                while (card < 8) {
                    int xOffset = (card & 1) * cardWidth;
                    int yOffset = (card & 7) / 2 * cardHeight;
                    if (g != null) {
                        g.drawRect(xOffset + 0, yOffset + 0, cardWidth, cardHeight);
                    }
                    xOffset += 15;
                    String name = "Pilot:                                              ";
                    String task = F3KScore.this.competition.getRoundTask(roundIx).getLongName();
                    if (g != null) {
                        g.setFont(fontUnBold12pt);
                        g.drawString(name, xOffset + cardWidth / 10, yOffset + 20 + rowHeight * 0);
                        g.setFont(fontBold12pt);
                        g.drawString("Round:  " + (roundIx + 1), xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 1);
                        g.setFont(fontUnBold12pt);
                        g.drawString("Group:           ", xOffset + cardWidth / 2, yOffset + 25 + rowHeight * 1);
                        g.setFont(fontPlain8pt);
                        float fontSize = fontPlain8pt.getSize2D();
                        if ((double)((float)task.length() * fontSize) > 2.0 * (double)cardWidth / 1.1) {
                            int nChars = (int)(2.0 * (double)cardWidth / 1.1 / (double)fontSize);
                            task = String.valueOf(task.substring(0, nChars)) + "...";
                        }
                        g.drawString(task, xOffset + cardWidth / 10, yOffset + 25 + rowHeight * 2);
                    }
                    int xr = xOffset + cardWidth / 10;
                    int yr = yOffset + rowHeight * 4 - cardHeight / 6 + 3;
                    int c = 0;
                    while (c < 8) {
                        if ((c & 3) == 0) {
                            xr = xOffset + cardWidth / 10;
                            yr += cardHeight / 6 - 3;
                        }
                        if (g != null) {
                            g.drawRect(xr, yr, cardWidth / 5, cardHeight / 6 - 3);
                        }
                        xr += cardWidth / 5;
                        ++c;
                    }
                    if (g != null) {
                        g.setFont(fontUnBold12pt);
                        g.drawString("Penalty:              ", xOffset + cardWidth / 10, yr + cardHeight / 6 + rowHeight + 10);
                    }
                    if (g != null) {
                        g.setFont(fontBold12pt);
                        g.drawString("Official Timer:", xOffset + cardWidth / 10, yOffset + cardHeight - 5);
                    }
                    ++card;
                }
                return 0;
            }
        });
    }

    public void printBibNumbersFullPage() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int pageCount = F3KScore.this.competition.getCompetitorCount();
                if (page >= pageCount) {
                    return 1;
                }
                if (g == null) {
                    return 0;
                }
                Graphics2D g2d = (Graphics2D)g;
                int pageHeight = (int)pf.getImageableWidth();
                int pageWidth = (int)pf.getImageableHeight();
                g2d.translate(pf.getImageableX() + (double)pageHeight, pf.getImageableY());
                g2d.rotate(1.5707963267948966);
                Font nameFont = new Font("Serif", 1, pageHeight / 8);
                FontRenderContext frc = g2d.getFontRenderContext();
                String nameString = F3KScore.this.competition.getCompetitor(page).getName();
                TextLayout layout = new TextLayout(nameString, nameFont, frc);
                int nameWidth = (int)layout.getBounds().getWidth();
                int nameHeight = (int)layout.getBounds().getHeight();
                int nameX = pageWidth / 2 - nameWidth / 2;
                int nameY = nameHeight + pageHeight / 10;
                g.setFont(nameFont);
                g.drawString(nameString, nameX, nameY);
                Font numberFont = new Font("Serif", 1, 4 * pageHeight / 5);
                String numberString = "" + (page + 1);
                layout = new TextLayout(numberString, numberFont, frc);
                int numberWidth = (int)layout.getBounds().getWidth();
                int numberHeight = (int)layout.getBounds().getHeight();
                int numberX = pageWidth / 2 - numberWidth / 2;
                int numberY = numberHeight + pageHeight / 10 + nameHeight + pageHeight / 10;
                g.setFont(numberFont);
                g.drawString(numberString, numberX, numberY);
                nameFont = new Font("Serif", 1, pageHeight / 30);
                nameString = F3KScore.this.competition.getCompetitionName();
                if (nameString != null) {
                    layout = new TextLayout(nameString, nameFont, frc);
                    nameWidth = (int)layout.getBounds().getWidth();
                    nameHeight = (int)layout.getBounds().getHeight();
                    nameX = pageWidth / 2 - nameWidth / 2;
                    nameY = numberY + nameHeight + pageHeight / 10;
                    g.setFont(nameFont);
                    g.drawString(nameString, nameX, nameY);
                }
                return 0;
            }
        });
    }

    public void printBibNumbersHalfPage() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                int pageCount = F3KScore.this.competition.getCompetitorCount();
                if (page >= pageCount) {
                    return 1;
                }
                if (g == null) {
                    return 0;
                }
                Graphics2D g2d = (Graphics2D)g;
                int pageHeight = (int)pf.getImageableHeight() / 2;
                int pageWidth = (int)pf.getImageableWidth();
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                int offsetY = -pageHeight / 20;
                int i = 0;
                while (i < 2) {
                    Font nameFont = new Font("Serif", 1, pageHeight / 8);
                    FontRenderContext frc = g2d.getFontRenderContext();
                    String nameString = F3KScore.this.competition.getCompetitor(page).getName();
                    TextLayout layout = new TextLayout(nameString, nameFont, frc);
                    int nameWidth = (int)layout.getBounds().getWidth();
                    int nameHeight = (int)layout.getBounds().getHeight();
                    int nameX = pageWidth / 2 - nameWidth / 2;
                    int nameY = offsetY + nameHeight + pageHeight / 20;
                    g.setFont(nameFont);
                    g.drawString(nameString, nameX, nameY);
                    Font numberFont = new Font("Serif", 1, 5 * pageHeight / 6);
                    String numberString = "" + (page + 1);
                    layout = new TextLayout(numberString, numberFont, frc);
                    int numberWidth = (int)layout.getBounds().getWidth();
                    int numberHeight = (int)layout.getBounds().getHeight();
                    int numberX = pageWidth / 2 - numberWidth / 2;
                    int numberY = nameY + numberHeight + pageHeight / 20;
                    g.setFont(numberFont);
                    g.drawString(numberString, numberX, numberY);
                    nameFont = new Font("Serif", 1, pageHeight / 30);
                    nameString = F3KScore.this.competition.getCompetitionName();
                    if (nameString != null) {
                        layout = new TextLayout(nameString, nameFont, frc);
                        nameWidth = (int)layout.getBounds().getWidth();
                        nameHeight = (int)layout.getBounds().getHeight();
                        nameX = pageWidth / 2 - nameWidth / 2;
                        nameY = numberY + nameHeight + pageHeight / 20;
                        g.setFont(nameFont);
                        g.drawString(nameString, nameX, nameY);
                    }
                    ++i;
                    offsetY += 12 * pageHeight / 10;
                }
                g.drawLine(0, pageHeight, pageWidth, pageHeight);
                return 0;
            }
        });
    }

    public void printStartList() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                if (g != null) {
                    g2d.translate(pf.getImageableX(), pf.getImageableY());
                }
                int width = (int)pf.getImageableWidth();
                int height = (int)pf.getImageableHeight();
                Font font = fontPlain8pt;
                float fontSize = font.getSize2D();
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float x0 = 20.0f;
                float y = y0;
                int colCount = F3KScore.this.startListPane.getTableModel().getColumnCount();
                int colWidth = (int)(((float)width - 2.0f * x0) / (float)colCount);
                int nPilotsInGroup = (int)Math.ceil((double)F3KScore.this.competition.getCompetitorCount() / (double)F3KScore.this.competition.getMaxGroupCount());
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.this.competition.getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 5);
                    }
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.startListPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            int n;
                            String s = (String)F3KScore.this.startListPane.getTableModel().getValueAt(rowIx, colIx);
                            if (s.startsWith("_____")) {
                                s = s.substring(5);
                                font = fontBold8pt;
                                if (colIx == 0) {
                                    y += 5.0f;
                                }
                                if (y + (float)((n = nPilotsInGroup + 1) * rowHeight) >= (float)height - bottomMargin) {
                                    y = height;
                                    --rowIx;
                                    break;
                                }
                            } else if (s.startsWith("Round")) {
                                font = fontBold8pt;
                                n = nPilotsInGroup + 1;
                                if ((y += 5.0f) + (float)(n * rowHeight) + 5.0f >= (float)height - bottomMargin) {
                                    y = height;
                                    --rowIx;
                                    break;
                                }
                            } else {
                                font = fontPlain8pt;
                                if ((double)s.length() > 2.0 * (double)colWidth / (double)fontSize) {
                                    s = String.valueOf(s.substring(0, (int)(2.0 * (double)colWidth / (double)fontSize - 0.5))) + "...";
                                }
                            }
                            if (pageCount == page && g != null) {
                                g.setFont(font);
                                g.drawString(s, (int)x, (int)y);
                            }
                            x += (float)colWidth;
                            ++colIx;
                        }
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.startListPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public void printSelectedRoundScores() {
        this.printData(new Printable(){

            @Override
            public synchronized int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2d = (Graphics2D)g;
                if (g != null) {
                    g2d.translate(pf.getImageableX(), pf.getImageableY());
                }
                int width = (int)pf.getImageableWidth();
                int height = (int)pf.getImageableHeight();
                Font font = fontPlain8pt;
                float fontSize = font.getSize2D();
                int rowHeight = (int)(fontSize * 1.1f);
                float topMargin = 10.0f;
                float bottomMargin = 10.0f;
                float y0 = topMargin + (float)rowHeight;
                float x0 = 20.0f;
                float y = y0;
                int colCount = F3KScore.this.timesPane.getTableModel().getColumnCount() - 1;
                int colWidth = (int)(((float)width - 2.0f * x0 - 100.0f) / (float)colCount);
                int nPilotsInGroup = (int)Math.ceil((double)F3KScore.this.competition.getCompetitorCount() / (double)F3KScore.this.competition.getMaxGroupCount());
                int rowIx = 0;
                int pageCount = 0;
                while (true) {
                    if (pageCount == 0 && F3KScore.this.competition.getCompetitionName() != null && F3KScore.this.competition.getCompetitionName().length() > 0) {
                        if (page == 0 && g != null) {
                            g.setFont(fontBold10pt);
                            g.drawString(F3KScore.this.competition.getCompetitionName(), 20, (int)y);
                        }
                        y += (float)(rowHeight + 10);
                    }
                    if (page == 0 && g != null) {
                        g.setFont(fontBold10pt);
                        g.drawString("Round " + (F3KScore.this.competition.getSelectedRoundIndex() + 1) + " - " + F3KScore.this.competition.getSelectedTask().getLongName(), 20, (int)y);
                    }
                    y += (float)(rowHeight + 10);
                    int row0 = rowIx;
                    while (rowIx < F3KScore.this.timesPane.getTableModel().getRowCount()) {
                        if (y >= (float)height - bottomMargin) {
                            y = y0;
                            break;
                        }
                        float x = x0;
                        int colIx = 0;
                        while (colIx < colCount) {
                            String s = (String)F3KScore.this.timesPane.getTableModel().getValueAt(rowIx, colIx);
                            if (s.startsWith("#####")) {
                                int n;
                                s = s.substring(3);
                                s = s.replaceAll("#", "_").replaceAll("\\s", "_");
                                font = fontBold8pt;
                                if (colIx == 0) {
                                    y += 5.0f;
                                }
                                if (y + (float)((n = nPilotsInGroup + 1) * rowHeight) >= (float)height - bottomMargin) {
                                    y = height;
                                    --rowIx;
                                    break;
                                }
                                if (colIx > 0) {
                                    s = "__" + F3KScore.this.timesPane.getTableModel().getColumnName(colIx).split("\\s+")[0] + "____";
                                    if (colIx == 1) {
                                        x -= 8.0f;
                                    }
                                }
                            } else {
                                font = fontPlain8pt;
                                if (colIx == 0) {
                                    double maxNameLength = 2.0 * (double)(colWidth + 80) / (double)fontSize;
                                    if ((double)s.length() > maxNameLength) {
                                        s = String.valueOf(s.substring(0, (int)(maxNameLength - 0.5))) + "...";
                                    }
                                }
                            }
                            if (pageCount == page && g != null) {
                                g.setFont(font);
                                g.drawString(s, (int)x, (int)y);
                            }
                            x += (float)colWidth;
                            if (colIx == 0) {
                                x += 80.0f;
                            }
                            ++colIx;
                        }
                        y += (float)rowHeight;
                        ++rowIx;
                    }
                    if (pageCount == page) {
                        return 0;
                    }
                    if (rowIx >= F3KScore.this.timesPane.getTableModel().getRowCount()) {
                        return 1;
                    }
                    ++pageCount;
                }
            }
        });
    }

    public File chooseFileExport(String dlgTitle) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(dlgTitle);
        fileChooser.addChoosableFileFilter(this.txtFilter);
        fileChooser.addChoosableFileFilter(this.csvFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Export");
        if (returnVal == 0) {
            int reply;
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            String ext = MyFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("txt")) {
                file = fileChooser.getFileFilter() == this.txtFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".txt") : (fileChooser.getFileFilter() == this.csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".csv"));
            }
            if (file.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 1)) != 0) {
                return null;
            }
            return file;
        }
        return null;
    }

    private void exportTable(TableModel tableModel, File file, int maxRows) {
        if (file == null) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            int ncol = tableModel.getColumnCount();
            int nrow = tableModel.getRowCount();
            if (maxRows > 0) {
                nrow = maxRows;
            }
            String separator = ",";
            if (MyFileFilter.getExtension(file).equals("txt")) {
                separator = "\t";
            }
            writer.write(tableModel.getColumnName(0));
            int i = 1;
            while (i < ncol) {
                writer.write(String.valueOf(separator) + tableModel.getColumnName(i));
                ++i;
            }
            writer.write("\n");
            int row = 0;
            while (row < nrow) {
                String val = tableModel.getValueAt(row, 0).toString();
                if (separator.equals(",") && (val.indexOf(44) >= 0 || val.indexOf(34) >= 0)) {
                    val = val.replace("\"", "\"\"");
                    val = "\"" + val + "\"";
                }
                writer.write(val);
                int col = 1;
                while (col < ncol) {
                    String string = val = tableModel.getValueAt(row, col) == null ? "" : tableModel.getValueAt(row, col).toString();
                    if (separator.equals(",") && (val.indexOf(44) >= 0 || val.indexOf(34) >= 0)) {
                        val = val.replace("\"", "\"\"");
                        val = "\"" + val + "\"";
                    }
                    writer.write(String.valueOf(separator) + val);
                    ++col;
                }
                writer.write("\n");
                ++row;
            }
            writer.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + file.getName() + "\":\n\n" + ex.getLocalizedMessage());
        }
    }

    private void exportPilotList() {
        File file = this.chooseFileExport("Select file name for exporting Pilot List");
        this.exportTable(this.registrationPane.getTableModel(), file, this.competition.getCompetitorCount());
    }

    private void exportTaskList() {
        File file = this.chooseFileExport("Select file name for exporting Task List");
        this.exportTable(this.tasksPane.getTableModel(), file, -1);
    }

    private void exportFlightMatrix() {
        File file = this.chooseFileExport("Select file name for exporting Flight Matrix");
        this.exportTable(this.groupsPane.getTableModel(), file, -1);
    }

    private void exportStartList() {
        File file = this.chooseFileExport("Select file name for exporting Start List");
        this.exportTable(this.startListPane.getTableModel(), file, -1);
    }

    private void exportRoundScores() {
        File file = this.chooseFileExport("Select file name for exporting Round Scores");
        this.exportTable(this.timesPane.getTableModel(), file, -1);
    }

    private void exportTotalScores() {
        File file = this.chooseFileExport("Select file name for exporting Total Scores");
        this.exportTable(this.totalPane.getTableModel(), file, -1);
    }

    public void createMenuBar() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(new JMenuItem(new AbstractAction("New"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Open"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.chooseFileOpen();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.save(F3KScore.this.file);
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.saveAs();
            }
        }));
        this.fileMenu.add(new JMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exitApplication();
            }
        }));
        this.mainMenuBar.add(this.fileMenu);
        this.printMenu = new JMenu("Print");
        this.printMenu.add(new JMenuItem(new AbstractAction("Flight Matrix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printFlightMatrix();
            }
        }));
        JMenu bibNumbersMenu = new JMenu("Pilot Bib Numbers");
        bibNumbersMenu.add(new JMenuItem(new AbstractAction("Full Page Size"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printBibNumbersFullPage();
            }
        }));
        bibNumbersMenu.add(new JMenuItem(new AbstractAction("Half Page Size"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printBibNumbersHalfPage();
            }
        }));
        this.printMenu.add(bibNumbersMenu);
        this.printMenu.add(new JMenuItem(new AbstractAction("Pilot Score Cards"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printScoreCards();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Official Timer Cards"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printOfficialScoreCards();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Start List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printStartList();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Round Scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedRoundScores();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Total Scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printTotalScores();
            }
        }));
        this.mainMenuBar.add(this.printMenu);
        this.exportMenu = new JMenu("Export");
        this.exportMenu.add(new JMenuItem(new AbstractAction("Pilot List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportPilotList();
            }
        }));
        this.exportMenu.add(new JMenuItem(new AbstractAction("Task List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTaskList();
            }
        }));
        this.exportMenu.add(new JMenuItem(new AbstractAction("Flight Matrix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportFlightMatrix();
            }
        }));
        this.exportMenu.add(new JMenuItem(new AbstractAction("Start List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportStartList();
            }
        }));
        this.exportMenu.add(new JMenuItem(new AbstractAction("Round Scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportRoundScores();
            }
        }));
        this.exportMenu.add(new JMenuItem(new AbstractAction("Total Scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTotalScores();
            }
        }));
        this.mainMenuBar.add(this.exportMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.add(new JMenuItem(new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showHelpDialog();
            }
        }));
        this.helpMenu.add(new JMenuItem(new AbstractAction("About F3KScore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showAboutDialog();
            }
        }));
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    public void createNewCompetition() {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return;
        }
        this.competition = new Competition(this);
        this.file = null;
        this.setTitle("F3KScore");
        this.fireChangeEvent();
    }

    public void chooseFileOpen() {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select F3KScore file to open");
        fileChooser.setFileFilter(this.f3kFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Open");
        if (returnVal == 0) {
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            try {
                this.loadFromFile(file);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed when trying to read file \"" + file.getName() + "\"\nError message:\n\n\"" + ex.getLocalizedMessage() + "\"", "Error reading data file", 0);
            }
        }
    }

    public void loadFromFile(File file) throws IOException {
        FileInputStream fs = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fs);
        try {
            this.competition = (Competition)ois.readObject();
            this.competition.setEditor(this);
            this.competition.setResultDirty();
            this.txtCompName.setText(this.competition.getCompetitionName());
            this.fireChangeEvent();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.file = file;
        this.setTitle("F3KScore: " + file.getName());
        this.tabbedPane.setSelectedIndex(0);
    }

    public void saveAs() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select file name for saving F3KScore data");
        fileChooser.setFileFilter(this.f3kFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Save");
        if (returnVal == 0) {
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!MyFileFilter.getExtension(file).equalsIgnoreCase("f3k")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".f3k");
            }
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 1);
                if (reply == 1) {
                    this.saveAs();
                    return;
                }
                if (reply == 2) {
                    return;
                }
            }
            this.save(file);
            this.file = file;
            this.setTitle("F3KScore: " + file.getName());
        }
    }

    public void save(File file) {
        if (file == null) {
            this.saveAs();
            return;
        }
        try {
            FileOutputStream fs = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fs);
            oos.writeObject(this.competition);
            oos.close();
            this.competition.setChangesMade(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + file.getName() + "\":\n\n" + ex.getLocalizedMessage());
        }
    }

    public void fireChangeEvent() {
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataStructureChanged(this.competition);
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
    }

    public void fireDataChangeEvent() {
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataChanged();
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
    }

    private void showAboutDialog() {
        JDialog aboutDialog = new JDialog(this){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.black);
                g.setFont(new Font("serif", 1, 32));
                int x = 30;
                int y = 60;
                g.drawImage(F3KScore.this.f3kLogo, x, y, null);
                g.drawString("F3KScore", (x += 20) + 120, (y += 0) + 10);
                g.setFont(new Font("serif", 1, 16));
                g.drawString("Version 8.2", x + 120, y + 30);
                g.drawString("FAI F3K Scoring Software", x + 120, y + 50);
                g.drawString("2007-2009,  Peter Jubel", x + 120, y + 70);
                g.drawString("2010,  Oleg Golovidov", x + 120, y + 90);
            }
        };
        aboutDialog.setTitle("About F3KScore");
        aboutDialog.setSize(380, 200);
        aboutDialog.setResizable(false);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setModal(true);
        aboutDialog.setVisible(true);
    }

    private void showHelpDialog() {
        final class HelpDialog
        extends JDialog {
            private static final String newline = "\n";

            public HelpDialog(JFrame parent) {
                super((Frame)parent, "F3KScore Help");
                this.setSize(860, 760);
                this.setLocationRelativeTo(parent);
                JTextArea textArea = new JTextArea(50, 20);
                textArea.setMargin(new Insets(10, 10, 10, 10));
                textArea.setFont(new Font("serif", 0, 14));
                textArea.setLineWrap(true);
                textArea.append("F3KScore is a program for managing F3K contests.\n");
                textArea.append("This program is distributed under the terms of the GNU General Public License.\n");
                textArea.append("See installation directory for GNU General Public License file, version 3.0.\n\n");
                textArea.append("F3KScore is implemented in Java and runs on any Java enabled system.\n");
                textArea.append("Original implementation 2007-2009 by Peter Jubel.\n");
                textArea.append("Re-written in 2010, version 8.0 by Oleg Golovidov.\n");
                textArea.append("Send comments or bug reports to \"oleg.golovidov@gmail.com\"\n");
                textArea.append(newline);
                textArea.append("Functional description:\n");
                textArea.append(" \n");
                textArea.append("Pilot List:\tAdd new competitor by entering a name in the last empty row or paste a new list of pilots copied from Excel.\n");
                textArea.append("\tTo delete a competitor, highlight one or more names, then hit DELETE button.\n");
                textArea.append("\tFirst frequency is used for generating the flight groups.\n");
                textArea.append(newline);
                textArea.append("Task List:\tEnter desired number of rounds in the text box.\n");
                textArea.append("\tClick on the task name to assign a task for each round.\n");
                textArea.append(newline);
                textArea.append("Flight Matrix:\tEnter desired number of flight groups in the text box.\n");
                textArea.append("\tClick the button to generate new random groups.\n");
                textArea.append("\tClick the checkbox to change how group names are displayed (numbers or letters A,B,C,..).\n");
                textArea.append("\tGroups can also be assigned manually by entering a group letter or number directly in the table.\n");
                textArea.append(newline);
                textArea.append("Start List:\tDisplays the names of the pilots for each round/group.\n");
                textArea.append(newline);
                textArea.append("Round Scores:\tFlight times for each round are entered on this page.\n");
                textArea.append("\tFlight time can be entered as seconds, or as minutes and seconds (formats \"1:12\" or \"1.12\" are equivalent).\n");
                textArea.append("\tAll times are automatically truncated to max time according to the definition of the task.\n");
                textArea.append("\tATTENTION: 1,2,3,4 task times must be entered in the proper order to avoid incorrect truncation.\n");
                textArea.append(newline);
                textArea.append("Total Scores:\tPilot names are displayed sorted by their total scores.\n");
                textArea.append("\tDiscarded scores are shown in parantheses.\n");
                textArea.append("\tPenalty values must be entered on this page.\n");
                textArea.append("\tUse Copy/Paste to export results to other applications.\n");
                textArea.append(newline);
                textArea.append(newline);
                textArea.append("Version History:\n");
                textArea.append(" \n");
                textArea.append("version 1:\tOriginal version.\n");
                textArea.append(newline);
                textArea.append("version 2:\tSpeedup in calculating results added more info in Register tab.\n");
                textArea.append(newline);
                textArea.append("version 3:\tMake use of discard rounds if equal score. Removed result Tab, everything is now in Total tab.\n");
                textArea.append(newline);
                textArea.append("version 4:\tAdded about and help window. Added startlist Tab. Added dialog for selecting number of groups in Make Groups command.\n");
                textArea.append(" \n");
                textArea.append("version 5:\tImproved MakeGroups algorithm. Decimal percent on total score.\n");
                textArea.append(" \n");
                textArea.append("version 6:\tAdded F3F/F3B Speed task (fastest time get 1000).\n");
                textArea.append(" \n");
                textArea.append("version 7:\tHandles frequency collisions when making flight groups.\n");
                textArea.append("\tCutting of maxtimes.\n");
                textArea.append("\tPenalty support.\n");
                textArea.append("\tPrinting support (Result, Scorecards, Startlist) .\n");
                textArea.append(" \n");
                textArea.append("version 8:\tMajor re-write of the entire program.\n");
                textArea.append("\tPasting data from Excel.\n");
                textArea.append("\tVarious improvements to the interface.\n");
                textArea.append("\tVarious improvements to the printing functions.\n");
                textArea.append(" \n");
                textArea.append("version 8.1:\tPrinting of indiviual round scores.\n");
                textArea.append("\tChanges to registration data (\"Models\", \"Team\", \"E-mail\" columns).\n");
                textArea.append("\tGroup generation algorithm improved to have more randomness in the matrix.\n");
                textArea.append("\tGroup generation process is terminated as soon as there are no improvements, takes less time.\n");
                textArea.append("\tOption to use team protection when generating groups.\n");
                textArea.append("\tTask list expanded to include all variations of F3K tasks in the rules.\n");
                textArea.append("\tSmall UI improvements to tables and scroll bars.\n");
                textArea.append(" \n");
                textArea.append("version 8.2:\tPrinting Total Scores and Flight Matrix for contests with a large number of groups (over 15) \n\tnow will be done correctly with multiple pages widthwise when needed. Prior to this change data was cut \n\toff if it did not fit on one page widthwise.\n");
                textArea.append("\tRound Scores page will now display a warning when the total score equals or exceeds the window time of the task.\n");
                textArea.append("\tPilot List (registration) page now is more user friendly for manual entry of new names.\n");
                textArea.append("\tScore cards for Task \"D\" (Increasing times) will now have pre-printed target times in each cell\n\tfor easier checking off all achieved times.\n");
                textArea.append("\tAll score cards will now have a \"Penalty\" field for entering penalty values.\n");
                textArea.append("\tTask \"F3B Speed\" is now handled properly. All previous versions did not score it correctly.\n");
                textArea.append("\tExport menu added. This menu allows one to export data from any page of the program as a tab separated\n\ttext (.txt) file or as a comma separated values (.csv) file.\n");
                JScrollPane scrollPane = new JScrollPane(textArea, 22, 30);
                textArea.setCaretPosition(0);
                textArea.setEditable(false);
                this.add(scrollPane);
                this.setVisible(true);
            }
        }
        new HelpDialog(this);
    }

    static class MyFileFilter
    extends FileFilter {
        String extension;
        String description;

        public MyFileFilter(String extension, String description) {
            this.extension = extension;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (!f.isFile()) {
                return true;
            }
            return MyFileFilter.getExtension(f).equalsIgnoreCase(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File f) {
            String ext = "";
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

