/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class GroupsPane
extends AbstractF3KScoreEditorPanel {
    private JLabel lbl;
    private JTextField txtNumGroups;
    private JCheckBox chkUseLetters;
    private JButton btnGenerateGroups;
    private JCheckBox chkUseTeamProtection = new JCheckBox("Use team protection when generating groups");

    public GroupsPane(Competition competition) {
        this.competition = competition;
        this.lbl = new JLabel("Number of flight groups:");
        this.txtNumGroups = new JTextField();
        this.txtNumGroups.setMinimumSize(new Dimension(50, 20));
        this.txtNumGroups.setPreferredSize(new Dimension(50, 20));
        this.btnGenerateGroups = new JButton("Generate new random groups");
        this.btnGenerateGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.generateNewGroups();
            }
        });
        this.txtNumGroups.setText("" + competition.getMaxGroupCount());
        this.chkUseLetters = new JCheckBox("Use letters for group names (A,B,C, ...)");
        this.chkUseLetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.useLettersForGroupNamesChanged();
            }
        });
        this.tableModel = new GroupsTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component c = super.prepareEditor(editor, row, column);
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).selectAll();
                }
                return c;
            }
        };
        this.table.setAutoResizeMode(0);
        this.configurePanel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.add(scrollPane);
        ExcelAdapter myAd = new ExcelAdapter(this.table);
        this.setLayout(new GridBagLayout());
        super.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 5), 0, 0));
        super.add((Component)this.txtNumGroups, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0));
        super.add((Component)this.btnGenerateGroups, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        super.add((Component)this.chkUseLetters, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
    }

    private void useLettersForGroupNamesChanged() {
        this.competition.setUseLetterGroupNames(this.chkUseLetters.isSelected());
        this.tableModel.fireTableDataChanged();
        this.competition.setChangesMade(true);
    }

    private void generateNewGroups() {
        int numGroups = -1;
        try {
            numGroups = Integer.parseInt(this.txtNumGroups.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numGroups < 2 || numGroups > 10) {
            JOptionPane.showMessageDialog(this, "Invalid entry for the number of groups: \"" + this.txtNumGroups.getText() + "\"\nEnter an integer in the range 2...10", "Invalid Entry", 0);
            this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
            return;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("Generating new groups will overwrite all existing group assignments. Do you want to generate new random groups?"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.chkUseTeamProtection, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        int reply = JOptionPane.showConfirmDialog(this, panel, "Generate goups?", 0);
        if (reply != 0) {
            this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                this.generateGroups(numGroups);
            }
            catch (Throwable throwable) {
                this.setCursor(Cursor.getDefaultCursor());
                this.competition.setChangesMade(true);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.competition.setChangesMade(true);
        }
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        int i = 1;
        while (i <= this.competition.getNumberOfRounds()) {
            this.table.getColumnModel().getColumn(i).setMinWidth(40);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(40);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.competition.getNumberOfRounds() + 1).setPreferredWidth(2000);
        boolean enabled = this.competition.getCompetitorCount() > 0;
        this.lbl.setEnabled(enabled);
        this.txtNumGroups.setEnabled(enabled);
        this.btnGenerateGroups.setEnabled(enabled);
        this.chkUseLetters.setEnabled(enabled);
        this.chkUseLetters.setSelected(this.competition.useLetterGroupNames());
        this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
    }

    private void mutateGroupings(int compCount, int roundCount, int[][] groups, boolean randomize) {
        double mutateAmount = Math.random() * 1.3;
        mutateAmount *= mutateAmount;
        mutateAmount *= mutateAmount;
        mutateAmount *= mutateAmount;
        int swapCount = (int)mutateAmount + 1;
        if (randomize) {
            swapCount = 1000;
        }
        int x = 0;
        while (x < swapCount) {
            int swapIndex = (int)(Math.random() * (double)compCount);
            int roundIndex = (int)(Math.random() * (double)roundCount);
            int prevGroup = groups[swapIndex][roundIndex];
            int newGroup = 1;
            int newComp = 0;
            for (int cs = 1; cs < compCount; ++cs) {
                int tComp = (swapIndex + cs) % compCount;
                int tGroup = groups[tComp][roundIndex];
                if (tGroup == prevGroup) continue;
                newGroup = tGroup;
                newComp = tComp;
                break;
            }
            groups[swapIndex][roundIndex] = newGroup;
            groups[newComp][roundIndex] = prevGroup;
            ++x;
        }
    }

    private int calcMinGroupCount() {
        int compCount = this.competition.getCompetitorCount();
        int minGroupCount = 1;
        int c = 0;
        while (c < compCount - 1) {
            String frequency = this.competition.getCompetitor(c).getProperty("Freq 1");
            String team = this.competition.getCompetitor(c).getProperty("Team");
            if (!this.chkUseTeamProtection.isSelected()) {
                team = "";
            }
            int freqCount = 1;
            int teamCount = 1;
            int c2 = c + 1;
            while (c2 < compCount) {
                if (!frequency.equals("") && !frequency.startsWith("2.4") && frequency.equals(this.competition.getCompetitor(c2).getProperty("Freq 1"))) {
                    ++freqCount;
                } else if (!team.equals("") && team.equals(this.competition.getCompetitor(c2).getProperty("Team"))) {
                    ++teamCount;
                }
                ++c2;
            }
            if (freqCount > minGroupCount) {
                minGroupCount = freqCount;
            }
            if (teamCount > minGroupCount) {
                minGroupCount = teamCount;
            }
            ++c;
        }
        return minGroupCount;
    }

    private int calcGroupingScore(int compCount, int roundCount, int[][] groups) {
        int compIx;
        int[][] conflicts = new int[compCount][compCount];
        int compIx2 = 0;
        while (compIx2 < compCount - 1) {
            int c2 = compIx2 + 1;
            while (c2 < compCount) {
                conflicts[compIx2][c2] = 0;
                ++c2;
            }
            ++compIx2;
        }
        int roundIx = 0;
        while (roundIx < roundCount) {
            compIx = 0;
            while (compIx < compCount - 1) {
                int group = groups[compIx][roundIx];
                String frequency = this.competition.getCompetitor(compIx).getProperty("Freq 1");
                String team = this.competition.getCompetitor(compIx).getProperty("Team");
                if (!this.chkUseTeamProtection.isSelected()) {
                    team = "";
                }
                int comp2Ix = compIx + 1;
                while (comp2Ix < compCount) {
                    if (groups[comp2Ix][roundIx] == group) {
                        if (!frequency.equals("") && !frequency.startsWith("2.4") && frequency.equals(this.competition.getCompetitor(comp2Ix).getProperty("Freq 1"))) {
                            int[] nArray = conflicts[compIx];
                            int n = comp2Ix;
                            nArray[n] = nArray[n] + 100;
                        }
                        if (!team.equals("") && team.equals(this.competition.getCompetitor(comp2Ix).getProperty("Team"))) {
                            int[] nArray = conflicts[compIx];
                            int n = comp2Ix;
                            nArray[n] = nArray[n] + 100;
                        }
                        int[] nArray = conflicts[compIx];
                        int n = comp2Ix;
                        nArray[n] = nArray[n] + 1;
                    }
                    ++comp2Ix;
                }
                ++compIx;
            }
            ++roundIx;
        }
        int total = 0;
        compIx = 0;
        while (compIx < compCount - 1) {
            int c2 = compIx + 1;
            while (c2 < compCount) {
                int score = conflicts[compIx][c2];
                total += score * score;
                ++c2;
            }
            ++compIx;
        }
        return total;
    }

    public void generateGroups(int groupCount) {
        int minGroupCount = this.calcMinGroupCount();
        if (groupCount < minGroupCount) {
            JOptionPane.showMessageDialog(this, "Specified number of groups is not sufficient\ndue to the frequency conflicts and/or team sizes.\nMinimum number of groups is " + minGroupCount + ".\n ", "Insufficient number of groups specified", 0);
            return;
        }
        int compCount = this.competition.getCompetitorCount();
        if (compCount < 1) {
            return;
        }
        int roundCount = this.competition.getNumberOfRounds();
        if (groupCount < minGroupCount) {
            groupCount = minGroupCount;
        }
        int[][] totalBestGroups = new int[compCount][roundCount];
        int[][] currentGroups = new int[compCount][roundCount];
        int[][] mutateGroups = new int[compCount][roundCount];
        int c = 0;
        while (c < compCount) {
            int r = 0;
            while (r < roundCount) {
                currentGroups[c][r] = (c + r) % groupCount + 1;
                ++r;
            }
            ++c;
        }
        int totalLowestScore = this.calcGroupingScore(compCount, roundCount, currentGroups);
        int convergenceCounter = 0;
        int evocount = 0;
        while (evocount < 100) {
            int r;
            int c2;
            int c3 = 0;
            while (c3 < compCount) {
                int r2 = 0;
                while (r2 < roundCount) {
                    currentGroups[c3][r2] = (c3 + r2) % groupCount + 1;
                    ++r2;
                }
                ++c3;
            }
            int i = 0;
            while (i < 10) {
                this.mutateGroupings(compCount, roundCount, mutateGroups, true);
                ++i;
            }
            int lowestScore = this.calcGroupingScore(compCount, roundCount, currentGroups);
            int mutateCountSinceImprovement = 0;
            boolean done = false;
            while (!done) {
                c2 = 0;
                while (c2 < compCount) {
                    r = 0;
                    while (r < roundCount) {
                        mutateGroups[c2][r] = currentGroups[c2][r];
                        ++r;
                    }
                    ++c2;
                }
                this.mutateGroupings(compCount, roundCount, mutateGroups, false);
                int mutateScore = this.calcGroupingScore(compCount, roundCount, mutateGroups);
                if (mutateScore < lowestScore) {
                    mutateCountSinceImprovement = 0;
                    lowestScore = mutateScore;
                    int c4 = 0;
                    while (c4 < compCount) {
                        int r3 = 0;
                        while (r3 < roundCount) {
                            currentGroups[c4][r3] = mutateGroups[c4][r3];
                            ++r3;
                        }
                        ++c4;
                    }
                    continue;
                }
                if (++mutateCountSinceImprovement <= 100) continue;
                done = true;
            }
            if (lowestScore < totalLowestScore) {
                c2 = 0;
                while (c2 < compCount) {
                    r = 0;
                    while (r < roundCount) {
                        totalBestGroups[c2][r] = currentGroups[c2][r];
                        ++r;
                    }
                    ++c2;
                }
                totalLowestScore = lowestScore;
                convergenceCounter = 0;
            } else if (++convergenceCounter > 5) break;
            ++evocount;
        }
        int c5 = 0;
        while (c5 < compCount) {
            int r = 0;
            while (r < roundCount) {
                this.competition.getCompetitor(c5).setGroup(r, totalBestGroups[c5][r]);
                ++r;
            }
            ++c5;
        }
        this.competition.fireChangeEvent();
    }

    private class GroupsTableModel
    extends AbstractTableModel {
        private GroupsTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            GroupsPane.this.configurePanel();
        }

        @Override
        public int getColumnCount() {
            return GroupsPane.this.competition.getNumberOfRounds() + 2;
        }

        @Override
        public int getRowCount() {
            return GroupsPane.this.competition.getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            if (col <= GroupsPane.this.competition.getNumberOfRounds()) {
                return "" + col;
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor comp = GroupsPane.this.competition.getCompetitor(row);
            if (col == 0) {
                return comp.getName();
            }
            if (col <= GroupsPane.this.competition.getNumberOfRounds()) {
                int groupNumber = GroupsPane.this.competition.getCompetitor(row).getGroup(col - 1);
                if (GroupsPane.this.chkUseLetters.isSelected()) {
                    if (groupNumber >= Competition.groupLetters.size()) {
                        return "";
                    }
                    return Competition.groupLetters.get(groupNumber - 1);
                }
                return "" + groupNumber;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && col <= GroupsPane.this.competition.getNumberOfRounds();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int groupNumber;
            block4: {
                groupNumber = -1;
                if (GroupsPane.this.chkUseLetters.isSelected() && (groupNumber = Competition.groupLetters.indexOf(value.toString().toUpperCase()) + 1) <= 0) {
                    JOptionPane.showMessageDialog(GroupsPane.this, "Invalid entry for group name: \"" + value + "\"\nPlease enter one of A,B,C,D,E,F,G,H,I,J", "Invalid entry", 0);
                    return;
                }
                try {
                    groupNumber = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    if (Competition.groupLetters.indexOf(value.toString().toUpperCase()) < 0) break block4;
                    GroupsPane.this.chkUseLetters.setSelected(true);
                    groupNumber = Competition.groupLetters.indexOf(value.toString().toUpperCase()) + 1;
                }
            }
            if (groupNumber < 1 || groupNumber > 10) {
                JOptionPane.showMessageDialog(GroupsPane.this, "Invalid entry for group number: \"" + value + "\"\nPlease enter one of 1,2,3,4,5,6,7,8,9,10", "Invalid entry", 0);
                return;
            }
            GroupsPane.this.competition.getCompetitor(row).setGroup(col - 1, groupNumber);
            this.fireTableDataChanged();
            GroupsPane.this.txtNumGroups.setText("" + GroupsPane.this.competition.getMaxGroupCount());
            GroupsPane.this.competition.setChangesMade(true);
        }
    }
}

