/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class StartListPane
extends AbstractF3KScoreEditorPanel {
    private static ArrayList<String> groupLetters = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J"));

    public StartListPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new StartListTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setFocusable(false);
        this.table.setCellSelectionEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setLayout(new GridBagLayout());
        super.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private class StartListTableModel
    extends AbstractTableModel {
        private static final int roundHeaderRows = 1;
        private static final int groupHeaderRows = 3;

        private StartListTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        private int getRowsPerGroup() {
            int compPerGroup = StartListPane.this.competition.getCompetitorCount() / StartListPane.this.competition.getMaxGroupCount();
            return 3 + compPerGroup;
        }

        private int getRowsPerRound() {
            int groupRows = (StartListPane.this.competition.getMaxGroupCount() - 1) / this.getColumnCount() + 1;
            int compPerGroup = StartListPane.this.competition.getCompetitorCount() / StartListPane.this.competition.getMaxGroupCount();
            return 1 + (3 + compPerGroup) * groupRows;
        }

        @Override
        public int getRowCount() {
            return StartListPane.this.competition.getNumberOfRounds() * this.getRowsPerRound();
        }

        @Override
        public String getColumnName(int col) {
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            CompetitorGroup compGroup;
            Competitor comp;
            int rowPerRound = this.getRowsPerRound();
            int round = row / rowPerRound;
            if (round >= StartListPane.this.competition.getNumberOfRounds()) {
                return "";
            }
            int rowInRound = row - round * rowPerRound;
            if (rowInRound < 0) {
                return "";
            }
            if (rowInRound == 0) {
                if (col == 0) {
                    return "Round " + (round + 1) + " - " + StartListPane.this.competition.getRoundTask(round).getLongName();
                }
                return "";
            }
            int groupRow = --rowInRound / this.getRowsPerGroup();
            int group = groupRow * this.getColumnCount() + col + 1;
            int compInGroup = rowInRound - groupRow * this.getRowsPerGroup() - 1;
            if (compInGroup == -1 && group <= StartListPane.this.competition.getGroupCount(round)) {
                if (StartListPane.this.competition.useLetterGroupNames()) {
                    String letter = (String)groupLetters.get(group - 1);
                    return "_______ Group \"" + letter + "\" _______";
                }
                return "______ Group " + group + " ______";
            }
            if (compInGroup >= 0 && group <= StartListPane.this.competition.getGroupCount(round) && (comp = (compGroup = new CompetitorGroup(StartListPane.this.competition, group, round)).GetCompetitor(compInGroup)) != null) {
                return comp.getName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object obj, int i, int j) {
        }
    }
}

