/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Task;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class TasksPane
extends AbstractF3KScoreEditorPanel {
    private JTextField txtNumRounds;

    public TasksPane(Competition competition) {
        this.competition = competition;
        this.tableModel = new TasksTableModel();
        this.setLayout(new GridBagLayout());
        this.table = new JTable(this.tableModel);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(3);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        JLabel lbl = new JLabel("Number of contest rounds:");
        this.txtNumRounds = new JTextField();
        this.txtNumRounds.setMinimumSize(new Dimension(50, 20));
        this.txtNumRounds.setPreferredSize(new Dimension(50, 20));
        this.txtNumRounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.numberOfRoundsChanged();
            }
        });
        this.txtNumRounds.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TasksPane.this.numberOfRoundsChanged();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.configurePanel();
        super.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 5), 0, 0));
        super.add((Component)this.txtNumRounds, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public void configurePanel() {
        this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
        int numTasks = this.competition.getTaskPoolSize();
        JComboBox<Task> comboBox = new JComboBox<Task>();
        int i = 0;
        while (i < numTasks) {
            comboBox.addItem(this.competition.getPoolTask(i));
            ++i;
        }
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setMinWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(2000);
    }

    private void numberOfRoundsChanged() {
        int val = -1;
        try {
            val = Integer.parseInt(this.txtNumRounds.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (val < 1 || val > 50) {
            JOptionPane.showMessageDialog(this, "Invalid value entered for number of rounds: \"" + this.txtNumRounds.getText() + "\"", "Invalid entry", 0);
            this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
            return;
        }
        this.competition.setNumberOfRounds(val);
        this.competition.setChangesMade(true);
    }

    private class TasksTableModel
    extends AbstractTableModel {
        private TasksTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            TasksPane.this.configurePanel();
        }

        @Override
        public int getRowCount() {
            return TasksPane.this.competition.getNumberOfRounds();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Round";
            }
            if (col == 1) {
                return "Task";
            }
            return "Description";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return TasksPane.this.competition.getRoundTask(row).getName();
            }
            return TasksPane.this.competition.getRoundTask(row).getLongName();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            TasksPane.this.competition.setRoundTask(row, (Task)value);
            TasksPane.this.competition.setResultDirty();
            TasksPane.this.competition.setChangesMade(true);
        }
    }
}

