/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public abstract class AbstractF3KScoreEditorPanel
extends JPanel {
    protected AbstractTableModel tableModel;
    protected Competition competition;
    protected JTable table;
    protected ExcelAdapter excelAdapter;

    protected void setMultilineTableHeaders() {
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> myEnum = this.table.getColumnModel().getColumns();
        while (myEnum.hasMoreElements()) {
            myEnum.nextElement().setHeaderRenderer(renderer);
        }
    }

    protected JTable createTable(AbstractTableModel tableModel) {
        this.tableModel = tableModel;
        this.table = new F3KScoreTable(tableModel);
        this.table.addMouseListener(new PopupListener());
        this.excelAdapter = new ExcelAdapter(this.table);
        return this.table;
    }

    protected JPopupMenu getPopupMenu(MouseEvent e) {
        return null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public void dataStructureChanged(Competition competition) {
        this.competition = competition;
        this.tableModel.fireTableStructureChanged();
    }

    public void dataChanged() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
            this.table.removeEditor();
        }
        this.tableModel.fireTableDataChanged();
    }

    public boolean stopEditing() {
        if (this.table.isEditing()) {
            return this.table.getCellEditor().stopCellEditing();
        }
        return true;
    }

    public void updatePanel() {
        this.dataStructureChanged(this.competition);
    }

    public class F3KScoreTable
    extends JTable {
        public F3KScoreTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).selectAll();
                c.setBackground(F3KScore.veryLightBlue);
            }
            return c;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (super.isRowSelected(rowIndex)) {
                if (!super.isColumnSelected(vColIndex)) {
                    c.setBackground(F3KScore.veryLightGrey);
                } else {
                    c.setBackground(this.getSelectionBackground());
                    c.setBackground(F3KScore.veryLightBlue);
                }
            } else {
                c.setBackground(this.getBackground());
            }
            return c;
        }
    }

    public class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        public MultiLineHeaderRenderer() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ListCellRenderer renderer = this.getCellRenderer();
            ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
            this.setCellRenderer(renderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setListData(v);
            return this;
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup;
                Point p = e.getPoint();
                int rowNumber = AbstractF3KScoreEditorPanel.this.table.rowAtPoint(p);
                int[] selRows = AbstractF3KScoreEditorPanel.this.table.getSelectedRows();
                boolean clickedInSelection = false;
                int i = 0;
                while (i < selRows.length) {
                    if (rowNumber == selRows[i]) {
                        clickedInSelection = true;
                        break;
                    }
                    ++i;
                }
                if (!clickedInSelection) {
                    AbstractF3KScoreEditorPanel.this.table.clearSelection();
                    AbstractF3KScoreEditorPanel.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                    int colNumber = AbstractF3KScoreEditorPanel.this.table.columnAtPoint(p);
                    AbstractF3KScoreEditorPanel.this.table.changeSelection(rowNumber, colNumber, false, false);
                }
                if ((popup = AbstractF3KScoreEditorPanel.this.getPopupMenu(e)) == null) {
                    return;
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
                F3KScore.editor().addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent arg0) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent arg0) {
                        popup.setVisible(false);
                        F3KScore.editor().removeWindowFocusListener(this);
                    }
                });
            }
        }
    }
}

