/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.F3KScore;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ExcelAdapter
implements ActionListener {
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable jTable1;
    private boolean pasteEnabled = true;

    public ExcelAdapter(JTable myJTable) {
        this.jTable1 = myJTable;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
        this.jTable1.registerKeyboardAction(this, "Paste", paste, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable1) {
        this.jTable1 = jTable1;
    }

    public void setPasteEnabled(boolean pasteEnabled) {
        this.pasteEnabled = pasteEnabled;
    }

    public void copyAction() {
        StringBuffer sbf = new StringBuffer();
        int numcols = this.jTable1.getSelectedColumnCount();
        int numrows = this.jTable1.getSelectedRowCount();
        int[] rowsselected = this.jTable1.getSelectedRows();
        int[] colsselected = this.jTable1.getSelectedColumns();
        if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "Invalid Copy Selection", "Invalid Copy Selection", 0);
            return;
        }
        int i = 0;
        while (i < numrows) {
            int j = 0;
            while (j < numcols) {
                sbf.append(this.jTable1.getValueAt(rowsselected[i], colsselected[j]));
                if (j < numcols - 1) {
                    sbf.append("\t");
                }
                ++j;
            }
            sbf.append("\n");
            ++i;
        }
        this.stsel = new StringSelection(sbf.toString());
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.system.setContents(this.stsel, this.stsel);
    }

    public void pasteAction() {
        if (!this.pasteEnabled) {
            return;
        }
        if (this.jTable1.getSelectedRows().length == 0) {
            return;
        }
        int startRow = this.jTable1.getSelectedRows()[0];
        int startCol = this.jTable1.getSelectedColumns()[0];
        try {
            try {
                this.jTable1.setCursor(Cursor.getPredefinedCursor(3));
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                String[] rows = trstring.split("\r\n|\r|\n");
                int i = 0;
                while (i < rows.length) {
                    this.rowstring = rows[i];
                    String[] cells = this.rowstring.split("\t");
                    int j = 0;
                    while (j < cells.length) {
                        this.value = cells[j];
                        if (startRow + i < this.jTable1.getRowCount() && startCol + j < this.jTable1.getColumnCount()) {
                            this.jTable1.setValueAt(this.value, startRow + i, startCol + j);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(F3KScore.editor(), "Error when copying/pasting data into table:\n\"" + ex.getLocalizedMessage() + "\"", "Error pasting data", 0);
                ex.printStackTrace();
                this.jTable1.setCursor(Cursor.getDefaultCursor());
            }
        }
        finally {
            this.jTable1.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copyAction();
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            this.pasteAction();
        }
    }
}

