/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.ExcelSpreadsheetReader;
import f3kscore.F3KScore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSpreadsheetWriter {
    private Workbook wb = new XSSFWorkbook();
    private int nextCol = 0;
    private int nextRow = 0;
    private Sheet currentSheet;
    private Row currentRow;
    private Font boldFont;

    public static boolean excelLibsAvailable() {
        try {
            Class.forName("org.apache.poi.xssf.usermodel.XSSFWorkbook");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public void addSheet(String sheetName) {
        this.currentSheet = this.wb.createSheet(sheetName);
        this.nextRow = 0;
        this.nextCol = 0;
    }

    public void addRow() {
        this.currentRow = this.currentSheet.createRow(this.nextRow++);
        this.nextCol = 0;
    }

    public Cell setNextCell(String cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue(cellValue);
        return c;
    }

    public Cell setNextCell(Integer cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue((double)cellValue.intValue());
        return c;
    }

    public Cell setNextCell(Double cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue(cellValue.doubleValue());
        return c;
    }

    public CellStyle configureCellStyle(Cell c, short alignment, short borderStyle, boolean useBoldFont) {
        CellStyle style = this.wb.createCellStyle();
        if (alignment >= 0) {
            style.setAlignment(alignment);
        }
        if (borderStyle >= 0) {
            style.setBorderBottom(borderStyle);
            style.setBorderLeft(borderStyle);
            style.setBorderRight(borderStyle);
            style.setBorderTop(borderStyle);
        }
        if (useBoldFont) {
            if (this.boldFont == null) {
                this.boldFont = this.wb.createFont();
                this.boldFont.setBoldweight((short)700);
            }
            style.setFont(this.boldFont);
        }
        c.setCellStyle(style);
        return style;
    }

    public void autoSizeColumns() {
        int i = 0;
        while (i < this.nextCol) {
            this.currentSheet.autoSizeColumn(i);
            ++i;
        }
    }

    public void saveAs(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        this.wb.write((OutputStream)out);
        out.close();
    }

    public void saveAs(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.wb.write((OutputStream)out);
        out.close();
    }

    public void writeAll(String sheetName, List<String[]> data) {
        this.addSheet(sheetName);
        ArrayList<String[]> lines = new ArrayList<String[]>(data);
        String[] header = (String[])lines.remove(0);
        this.addRow();
        int col = 0;
        while (col < header.length) {
            String val = header[col] == null ? "" : header[col];
            Cell c = null;
            Double dblVal = null;
            try {
                dblVal = Double.parseDouble(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = dblVal != null ? this.setNextCell(dblVal) : this.setNextCell(val);
            CellStyle style = this.configureCellStyle(c, (short)2, (short)2, true);
            if (val.contains("\n")) {
                style.setWrapText(true);
                this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
                c.setCellStyle(style);
            }
            ++col;
        }
        for (String[] line : lines) {
            this.addRow();
            int col2 = 0;
            while (col2 < line.length) {
                block13: {
                    Cell c;
                    String val;
                    String string = val = line[col2] == null ? "" : line[col2];
                    if (val.startsWith("(") && val.endsWith(")")) {
                        try {
                            Cell c2 = this.setNextCell(-1.0 * Double.parseDouble(val.substring(1, val.length() - 1)));
                            this.configureCellStyle(c2, (short)2, (short)1, false);
                            break block13;
                        }
                        catch (NumberFormatException c2) {
                            // empty catch block
                        }
                    }
                    Double dblVal = null;
                    try {
                        dblVal = Double.parseDouble(val);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dblVal != null) {
                        c = this.setNextCell(dblVal);
                        this.configureCellStyle(c, (short)2, (short)1, false);
                    } else {
                        c = this.setNextCell(line[col2]);
                        this.configureCellStyle(c, (short)1, (short)1, false);
                    }
                }
                ++col2;
            }
        }
        this.autoSizeColumns();
    }

    static void writeAll(File file, String sheetName, List<String[]> lines, boolean launchExcel) throws IOException {
        if (!ExcelSpreadsheetReader.excelLibsAvailable()) {
            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Excel utilities are not available. Verify your install or F3KScore version.", new Object[0]), "Excel file write error", 0);
            return;
        }
        ExcelSpreadsheetWriter xlWriter = new ExcelSpreadsheetWriter();
        xlWriter.writeAll(sheetName, lines);
        xlWriter.saveAs(file);
        if (launchExcel) {
            try {
                String[] commands = new String[]{"cmd", "/c", "start", "\"\"", file.getCanonicalPath()};
                Runtime.getRuntime().exec(commands);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

