/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CSVReader;
import f3kscore.CSVWriter;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelSpreadsheetReader;
import f3kscore.ExcelSpreadsheetWriter;
import f3kscore.F3KScore;
import f3kscore.F3kFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class MergeResultsUtils {
    private static F3KScore editor;
    private static F3kFileFilter csvFilter;
    private static F3kFileFilter xlsxFilter;
    private static MyTableModel tableModel;
    private static JTable table;
    private static int RANK;
    private static int PILOT_NAME;
    private static int STATE;
    private static int CLASS;
    private static int BEST_FOUR;
    private static int FIRST_CONTEST;
    private static int LAST_NAME;
    private static JDialog mergeDlg;
    private static String[] header;
    private static String[] contestDates;
    private static LinkedHashMap<String, List<String[]>> previousContestData;
    private static int GRACE_PERIOD_DAYS;

    static {
        csvFilter = new F3kFileFilter("csv", "Comma separated value files (.csv)");
        xlsxFilter = new F3kFileFilter("xlsx", "Excel files (.xlsx)");
        RANK = 0;
        PILOT_NAME = 1;
        STATE = 2;
        CLASS = 3;
        BEST_FOUR = 4;
        FIRST_CONTEST = 5;
        LAST_NAME = -1;
        GRACE_PERIOD_DAYS = -1;
    }

    public static void mergeResults(F3KScore editor, boolean openExisting) {
        MergeResultsUtils.mergeResults(editor, openExisting, false);
    }

    public static void mergeResults(F3KScore editor, boolean openExisting, boolean qualificationPoints) {
        List<String[]> fileData;
        File resultsFile;
        MergeResultsUtils.editor = editor;
        if (openExisting) {
            resultsFile = MergeResultsUtils.chooseTourResultsFile(qualificationPoints);
            if (resultsFile == null) {
                return;
            }
        } else {
            resultsFile = qualificationPoints ? new File(editor.getCurrentDir(), "Team_Qualification_Points") : new File(editor.getCurrentDir(), "F3K_Tour_Results");
        }
        int numBest = 4;
        int numPercent = 30;
        double numPoints = 1.0;
        if (!qualificationPoints) {
            JTextField txtNumBest = new JTextField("4");
            txtNumBest.setColumns(4);
            JLabel lblNumBest = new JLabel("Number of best scores to use for pilot rankings: ");
            JPanel pnl = new JPanel();
            pnl.add(lblNumBest);
            pnl.add(txtNumBest);
            int reply = JOptionPane.showConfirmDialog(editor, pnl, "Enter number of best scores to use for pilot rankings", 2);
            if (reply != 0) {
                return;
            }
            String val = txtNumBest.getText().trim();
            try {
                numBest = Integer.parseInt(val);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer number", val), "Invalid entry", 0);
                return;
            }
            if (numBest < 1) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer number", val), "Invalid entry", 0);
                return;
            }
        } else {
            JPanel pnl = new JPanel(new GridBagLayout());
            JLabel lblPercent = new JLabel("Percentage of top placing pilots to award qualification points (%): ");
            JTextField txtPercent = new JTextField("30");
            txtPercent.setColumns(4);
            pnl.add((Component)lblPercent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            pnl.add((Component)txtPercent, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            JLabel lblNumPoints = new JLabel("Points awarded for this event (1 point - 2 day event, 0.5 points - 1 day event): ");
            JTextField txtNumPoints = new JTextField("1");
            txtNumPoints.setColumns(4);
            pnl.add((Component)lblNumPoints, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            pnl.add((Component)txtNumPoints, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            int reply = JOptionPane.showConfirmDialog(editor, pnl, "Enter percentage of top placing pilots and qualification points awarded", 2);
            if (reply != 0) {
                return;
            }
            String val = txtPercent.getText().trim();
            try {
                numPercent = Integer.parseInt(val);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer between 1...100", val), "Invalid entry", 0);
                return;
            }
            if (numPercent < 1 || numPercent > 100) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer between 1...100", val), "Invalid entry", 0);
                return;
            }
            val = txtNumPoints.getText().trim();
            try {
                numPoints = Double.parseDouble(val);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive number", val), "Invalid entry", 0);
                return;
            }
            if (numPoints < 0.0 || numPoints > 10.0) {
                JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive number between 0...10", val), "Invalid entry", 0);
                return;
            }
        }
        if ((fileData = MergeResultsUtils.readTourResultsFile(resultsFile, qualificationPoints)) == null) {
            return;
        }
        final List<String[]> mergedData = MergeResultsUtils.mergeNewDataIntoTourResults(fileData, editor.getCompetition(), numBest, numPercent, numPoints, qualificationPoints);
        if (mergedData == null) {
            return;
        }
        mergeDlg = new JDialog((Frame)editor, String.format("F3KScore: Merged tour/series results \"%s\"", resultsFile.getName()));
        mergeDlg.setSize(800, 650);
        mergeDlg.setLocationRelativeTo(editor);
        mergeDlg.setModal(true);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.add(new JMenuItem(new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.saveMergedResults(resultsFile, mergedData);
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                mergeDlg.setVisible(false);
            }
        }));
        JMenu sortMenu = new JMenu("Sort");
        menuBar.add(sortMenu);
        sortMenu.add(new JMenuItem(new AbstractAction("By Rank"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(BEST_FOUR, true, true);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By Name"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(PILOT_NAME, false, false);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By Last Name"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(LAST_NAME, false, false);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By State"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(STATE, false, false);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By Class"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(CLASS, false, false);
            }
        }));
        tableModel = new MyTableModel(mergedData);
        table = new JTable(tableModel);
        JScrollPane pane = new JScrollPane(table);
        table.setAutoResizeMode(0);
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(60);
        table.getColumnModel().getColumn(3).setPreferredWidth(60);
        table.getColumnModel().getColumn(4).setPreferredWidth(90);
        Dimension dim = new Dimension(90, 25);
        JButton btnSave = new JButton("Save...");
        btnSave.setMargin(new Insets(0, 0, 0, 0));
        btnSave.setPreferredSize(dim);
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MergeResultsUtils.saveMergedResults(resultsFile, mergedData);
            }
        });
        JButton btnClose = new JButton("Close");
        btnClose.setMargin(new Insets(0, 0, 0, 0));
        btnClose.setPreferredSize(dim);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mergeDlg.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)menuBar, "North");
        panel.add((Component)pane, "Center");
        JPanel pnlBtns = new JPanel();
        pnlBtns.add(btnSave);
        pnlBtns.add(btnClose);
        panel.add((Component)pnlBtns, "South");
        mergeDlg.add(panel);
        mergeDlg.setVisible(true);
    }

    private static void saveMergedResults(File resultsFile, List<String[]> mergedDataOrig) {
        block24: {
            if ((resultsFile = MergeResultsUtils.chooseFileExport(resultsFile)) == null) {
                return;
            }
            ArrayList<String[]> mergedData = new ArrayList<String[]>(mergedDataOrig);
            if (contestDates.length > 0) {
                mergedData.add(0, contestDates);
            }
            mergedData.add(0, header);
            String ext = F3kFileFilter.getExtension(resultsFile);
            CSVWriter writer = null;
            try {
                mergeDlg.setCursor(Cursor.getPredefinedCursor(3));
                if (ext.equalsIgnoreCase("csv")) {
                    writer = new CSVWriter(new FileWriter(resultsFile));
                    writer.writeAll(mergedData);
                    break block24;
                }
                if (!ExcelSpreadsheetReader.excelLibsAvailable()) {
                    JOptionPane.showMessageDialog(editor, String.format("Excel utilities are not available. Verify your install or F3KScore version.", new Object[0]), "Excel file write error", 0);
                    return;
                }
                try {
                    String sheetName2;
                    ExcelSpreadsheetWriter xlWriter = new ExcelSpreadsheetWriter();
                    xlWriter.writeAll("Results", mergedData);
                    if (previousContestData != null && previousContestData.size() > 0) {
                        for (String sheetName2 : previousContestData.keySet()) {
                            xlWriter.writeAll(sheetName2, previousContestData.get(sheetName2));
                        }
                    }
                    sheetName2 = header[header.length - 1];
                    if (contestDates.length > 0) {
                        sheetName2 = String.valueOf(sheetName2) + " " + contestDates[contestDates.length - 1];
                    }
                    editor.exportTableToExcelFile(editor.getTotalPane().getTableModel(), resultsFile, sheetName2, -1, editor.getTotalPane().getTableModel().getColumnCount() - 1, xlWriter);
                    xlWriter.saveAs(resultsFile);
                    try {
                        String[] commands = new String[]{"cmd", "/c", "start", "\"\"", resultsFile.getCanonicalPath()};
                        Runtime.getRuntime().exec(commands);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(editor, "Failed to launch Excel!", "File write error", 0);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(editor, "ERROR!", "File write error", 0);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(editor, String.format("Failed when writing tour/series results to file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File write error", 0);
                }
            }
            finally {
                mergeDlg.setCursor(Cursor.getDefaultCursor());
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File chooseTourResultsFile(boolean qualificationPoints) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        if (!qualificationPoints) {
            fileChooser.setDialogTitle("Select tour/series results file or enter a new name");
        } else {
            fileChooser.setDialogTitle("Select team qualifications file or enter a new name");
        }
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.addChoosableFileFilter(xlsxFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(xlsxFilter);
        fileChooser.setCurrentDirectory(editor.getCurrentDir());
        int returnVal = fileChooser.showDialog(editor, "Open");
        if (returnVal == 0) {
            editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("xlsx")) {
                file = fileChooser.getFileFilter() == xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : (fileChooser.getFileFilter() == csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx"));
            }
            if (!file.exists()) {
                int reply = JOptionPane.showConfirmDialog(editor, String.format("File \"%s\" does not exist. A new file will be created when you save the data.", file.getAbsolutePath()), "File not found", 2, 3);
                if (reply == 0) {
                    return file;
                }
                return null;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(editor, String.format("File \"%s\" could not be opened for reading", file.getAbsolutePath()), "File not readable", 0);
                return null;
            }
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String[]> readTourResultsFile(File resultsFile, boolean qualificationPoints) {
        if (!resultsFile.exists()) {
            header = new String[]{"Rank", "Name", "State", "Class", "Best 4 scores"};
            if (qualificationPoints) {
                header = new String[]{"Rank", "Name", "Joined F3K Program", "Qualified", "Qualification Points"};
            }
            ArrayList<String[]> newResults = new ArrayList<String[]>();
            newResults.add(header);
            if (!qualificationPoints) return newResults;
            newResults.add(new String[0]);
            return newResults;
        }
        InputStreamReader fr = null;
        try {
            String ext = F3kFileFilter.getExtension(resultsFile);
            if (ext.equalsIgnoreCase("csv")) {
                fr = new FileReader(resultsFile);
                CSVReader reader = new CSVReader(fr);
                List<String[]> list = reader.readAll();
                return list;
            }
            if (!ExcelSpreadsheetReader.excelLibsAvailable()) {
                JOptionPane.showMessageDialog(editor, String.format("Excel utilities are not available. Verify your install or F3KScore version.", new Object[0]), "Excel file read error", 0);
                return null;
            }
            previousContestData = ExcelSpreadsheetReader.readAll(resultsFile);
            String firstSheetName = previousContestData.keySet().iterator().next();
            List list = (List)previousContestData.remove(firstSheetName);
            return list;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(editor, String.format("Failed when reading file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File read error", 0);
            return null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(editor, String.format("Failed when reading file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File read error", 0);
            return null;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static List<String[]> mergeNewDataIntoTourResults(List<String[]> tourResults, Competition competition, int numBest, int numPercent, double numPoints, boolean qualificationPoints) {
        String pilotName;
        ArrayList<String[]> newResults = new ArrayList<String[]>();
        header = tourResults.remove(0);
        if (header.length < 5) {
            JOptionPane.showMessageDialog(editor, "Invalid data format. Must have at least 5 columns.", "Invalid data format", 0);
            return null;
        }
        contestDates = new String[0];
        if (!qualificationPoints) {
            MergeResultsUtils.header[4] = String.format("%d best scores", numBest);
        } else {
            contestDates = tourResults.remove(0);
            contestDates = Arrays.copyOf(contestDates, contestDates.length + 1);
            Date date = MergeResultsUtils.parseDate(competition.getDate());
            MergeResultsUtils.contestDates[MergeResultsUtils.contestDates.length - 1] = date == null ? "" : new SimpleDateFormat("MM.dd.yyyy").format(date);
        }
        header = Arrays.copyOf(header, header.length + 1);
        String name = competition.getCompetitionName();
        MergeResultsUtils.header[MergeResultsUtils.header.length - 1] = name == null ? "" : name;
        int nContests = header.length - 5;
        int nPilots = 0;
        for (Competitor pilot : competition.getCompetitorList()) {
            if (!(pilot.getPercent() > 0.0)) continue;
            ++nPilots;
        }
        int lastQualifiedPosition = (int)((double)(nPilots * numPercent) / 100.0 + 0.5);
        HashMap<String, String[]> pilotDataByName = new HashMap<String, String[]>();
        for (String[] line : tourResults) {
            pilotName = line[1];
            String[] newDataLine = Arrays.copyOf(line, line.length + 1);
            newDataLine[line.length] = "";
            pilotDataByName.put(pilotName, newDataLine);
        }
        for (Competitor pilot : competition.getCompetitorList()) {
            if (!(pilot.getPercent() > 0.0)) continue;
            pilotName = pilot.getFullName();
            String[] line = (String[])pilotDataByName.get(pilotName);
            if (line == null) {
                line = new String[5 + nContests];
                line[MergeResultsUtils.PILOT_NAME] = pilotName;
                pilotDataByName.put(pilotName, line);
                line[MergeResultsUtils.STATE] = "";
                line[MergeResultsUtils.CLASS] = "";
            }
            if (!qualificationPoints) {
                if (line[STATE].equals("") && !pilot.getCountry().equals("")) {
                    line[MergeResultsUtils.STATE] = pilot.getCountry();
                }
                if (line[CLASS].equals("") && !pilot.getCompetitorClass().equals("")) {
                    line[MergeResultsUtils.CLASS] = pilot.getCompetitorClass();
                }
                line[line.length - 1] = String.format("%.2f", pilot.getPercent());
                continue;
            }
            if (pilot.getPosition() >= lastQualifiedPosition) continue;
            line[line.length - 1] = numPoints % 1.0 == 0.0 ? String.format("%d", (int)numPoints) : String.format("%.1f", numPoints);
        }
        for (String pilotName2 : pilotDataByName.keySet()) {
            int index;
            String[] line = (String[])pilotDataByName.get(pilotName2);
            double[] scores = new double[nContests];
            int i = 0;
            while (i < nContests) {
                String val;
                if (line.length < i + FIRST_CONTEST + 1) {
                    System.out.println("HELP!!!");
                }
                if ((val = line[i + FIRST_CONTEST]) != null && !val.equals("")) {
                    try {
                        scores[i] = Double.parseDouble(val);
                    }
                    catch (NumberFormatException e) {
                        int reply = JOptionPane.showConfirmDialog(editor, String.format("Failed when reading scores for pilot \"%s\": \"%s\" value will be replaced with 0.0\nDo you want to continue loading the file?", pilotName2, val), "Invalid data format", 2);
                        if (reply != 0) {
                            return null;
                        }
                        scores[i] = 0.0;
                    }
                }
                ++i;
            }
            double totalScore = 0.0;
            if (!qualificationPoints) {
                Arrays.sort(scores);
                int count = 0;
                index = scores.length - 1;
                while (count < numBest && index >= 0) {
                    totalScore += scores[index];
                    ++count;
                    --index;
                }
                line[MergeResultsUtils.BEST_FOUR] = String.format("%.2f", totalScore);
                continue;
            }
            Date date = MergeResultsUtils.parseDate(line[STATE]);
            if (date != null) {
                line[MergeResultsUtils.STATE] = new SimpleDateFormat("MM.dd.yyyy").format(date);
            }
            numBest = scores.length;
            index = 0;
            while (index < scores.length) {
                if (scores[index] != 0.0) {
                    boolean addThisContestPoint = true;
                    Date contestDate = MergeResultsUtils.parseDate(contestDates[FIRST_CONTEST + index]);
                    if (GRACE_PERIOD_DAYS > 0) {
                        addThisContestPoint = false;
                        if (!line[STATE].equals("") && contestDates[FIRST_CONTEST + index] != null) {
                            Date joined = MergeResultsUtils.parseDate(line[STATE]);
                            if (contestDate != null) {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(contestDate);
                                cal.add(5, GRACE_PERIOD_DAYS + 1);
                                if (cal.getTime().after(joined)) {
                                    addThisContestPoint = true;
                                }
                            } else {
                                System.out.println("Contest date empty!");
                            }
                        }
                    }
                    if (addThisContestPoint && (totalScore += scores[index]) >= 1.0 && line[CLASS].equals("") && contestDate != null) {
                        line[MergeResultsUtils.CLASS] = String.valueOf(new SimpleDateFormat("MM.dd.yyyy").format(contestDate)) + " (" + header[FIRST_CONTEST + index] + ")";
                    }
                }
                ++index;
            }
            if (totalScore > 0.0) {
                if (totalScore % 1.0 == 0.0) {
                    line[MergeResultsUtils.BEST_FOUR] = String.format("%d", (int)totalScore);
                    continue;
                }
                line[MergeResultsUtils.BEST_FOUR] = String.format("%.1f", totalScore);
                continue;
            }
            line[MergeResultsUtils.BEST_FOUR] = "";
        }
        TreeSet<String[]> sortedData = new TreeSet<String[]>(new DataComparator(BEST_FOUR, true, true));
        sortedData.addAll(pilotDataByName.values());
        int rank = 1;
        for (String[] line : sortedData) {
            line[0] = String.valueOf(rank++);
            newResults.add(line);
        }
        return newResults;
    }

    private static File chooseFileExport(File resultsFile) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select file for exporting merged tour/series results");
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.addChoosableFileFilter(xlsxFilter);
        fileChooser.setFileFilter(xlsxFilter);
        fileChooser.setCurrentDirectory(editor.getCurrentDir());
        fileChooser.setSelectedFile(resultsFile);
        int returnVal = fileChooser.showDialog(editor, "Save");
        if (returnVal == 0) {
            editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("xlsx")) {
                file = fileChooser.getFileFilter() == xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : (fileChooser.getFileFilter() == csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx"));
            }
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(editor, String.format("File \"%s\" exists.\nDo you want to overwrite it?", file.getName()), "File exists", 1);
                if (reply == 2) {
                    return null;
                }
                if (reply == 1) {
                    return MergeResultsUtils.chooseFileExport(resultsFile);
                }
            }
            return file;
        }
        return null;
    }

    public static Date parseDate(String dateStr) {
        if (dateStr == null || dateStr.trim().length() == 0) {
            return null;
        }
        List<String> formats = Arrays.asList("MM-dd-yy", "MM-dd-yyyy", "M-d-yy", "MM.dd.yy", "MM.dd.yyyy", "M.d.yy", "MM/dd/yy", "MM/dd/yyyy", "M/d/yy", "yy-MM-dd", "yyyy-MM-dd", "yy-M-d", "yy.MM.dd", "yyyy.MM.dd", "yy.M.d", "yy/MM/dd", "yyyy/MM/dd", "yy/M/d");
        for (String format : formats) {
            try {
                Date date = new SimpleDateFormat(format).parse(dateStr);
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class DataComparator
    implements Comparator<String[]> {
        private int compareByIndex;
        private boolean useNumericalComparison;
        private boolean descending;
        private boolean useLastName;

        public DataComparator(int compareByIndex, boolean useNumericalComparison, boolean descending) {
            this.compareByIndex = compareByIndex;
            this.useNumericalComparison = useNumericalComparison;
            this.descending = descending;
            if (compareByIndex == LAST_NAME) {
                this.compareByIndex = PILOT_NAME;
                this.useLastName = true;
            }
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (this.useNumericalComparison) {
                double total1 = 0.0;
                if (!o1[this.compareByIndex].equals("")) {
                    total1 = Double.parseDouble(o1[this.compareByIndex]);
                }
                double total2 = 0.0;
                if (!o2[this.compareByIndex].equals("")) {
                    total2 = Double.parseDouble(o2[this.compareByIndex]);
                }
                if (total1 < total2) {
                    if (this.descending) {
                        return 1;
                    }
                    return -1;
                }
                if (total1 > total2) {
                    if (this.descending) {
                        return -1;
                    }
                    return 1;
                }
                return o1[PILOT_NAME].compareTo(o2[PILOT_NAME]);
            }
            if (o1[this.compareByIndex].length() == 0 && o2[this.compareByIndex].length() > 0) {
                return 1;
            }
            if (o1[this.compareByIndex].length() > 0 && o2[this.compareByIndex].length() == 0) {
                return -1;
            }
            if (this.useLastName) {
                String name2;
                String name1 = o1[PILOT_NAME];
                if (name1.contains(" ")) {
                    name1 = name1.substring(name1.indexOf(" ") + 1);
                }
                if ((name2 = o2[PILOT_NAME]).contains(" ")) {
                    name2 = name2.substring(name2.indexOf(" ") + 1);
                }
                return name1.compareTo(name2);
            }
            return o1[this.compareByIndex].compareTo(o2[this.compareByIndex]);
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private List<String[]> tableData;
        private int MIN_ROWS = 50;
        private int MIN_COLS = 30;

        public MyTableModel(List<String[]> tableData) {
            this.tableData = tableData;
        }

        public void sortTableData(int sortByIndex, boolean useNumericalComparison, boolean descending) {
            Collections.sort(this.tableData, new DataComparator(sortByIndex, useNumericalComparison, descending));
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return Math.max(this.MIN_COLS, this.tableData.get(0).length);
        }

        @Override
        public String getColumnName(int col) {
            if (col < header.length) {
                return header[col];
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return Math.max(this.MIN_ROWS, this.tableData.size() - 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.tableData.size()) {
                return null;
            }
            String[] line = this.tableData.get(rowIndex);
            return line.length > columnIndex ? line[columnIndex] : null;
        }
    }
}

