/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CSVReader;
import f3kscore.CSVWriter;
import f3kscore.Competition;
import f3kscore.ExcelSpreadsheetReader;
import f3kscore.ExcelSpreadsheetWriter;
import f3kscore.F3KScore;
import f3kscore.F3KScoreConstants;
import f3kscore.F3kFileFilter;
import f3kscore.MergeResultsUtils;
import f3kscore.StdTask;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class PilotsDatabaseUtils
implements F3KScoreConstants {
    private static F3kFileFilter csvFilter = new F3kFileFilter("csv", "Comma separated value files (.csv)");
    private static F3kFileFilter xlsxFilter = new F3kFileFilter("xlsx", "Excel files (.xlsx)");
    private static int COUNTER = 0;
    private static int FIRST_NAME = 1;
    private static int LAST_NAME = 2;
    private static int CLASS = 3;
    private static int FREQ1 = 4;
    private static int FREQ2 = 5;
    private static int TEAM = 6;
    private static int FAI_AMA_NUM = 7;
    private static int COUNTRY = 8;
    private static int CLUB = 9;
    private static int EMAIL = 10;
    private static int MODELS = 11;
    private static int INFO = 12;
    private static JList leftList;
    private static ArrayList<String> leftData;
    private static JList rightList;
    private static ArrayList<String> rightData;

    public static void importPilotList() {
        int reply;
        Competition competition = F3KScore.editor().getCompetition();
        if (competition.getCompetitorCount() > 0 && (reply = JOptionPane.showConfirmDialog(F3KScore.editor(), "All existing pilot data will be deleted and new pilot list imported.\nDo you want to continue?", "Import new pilot list", 2, 2)) != 0) {
            return;
        }
        File dataFile = PilotsDatabaseUtils.choosePilotsDatabaseFile("Select pilot list file for importing", true, null);
        if (dataFile == null) {
            return;
        }
        F3KScore.editor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            List<String[]> data = PilotsDatabaseUtils.readPilotsDatabaseFile(dataFile);
            if (data == null) {
                return;
            }
            int reply2 = -1;
            ArrayList<String[]> cleanedUpData = new ArrayList<String[]>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (String[] line : data) {
                String name;
                if (line.length < 3 && reply2 < 0 && (reply2 = JOptionPane.showConfirmDialog(F3KScore.editor(), String.format("Non-standard data format detected in the file: \"%s\"\n\nExpected data format must match the Pilot List table or have a minimum \nof 3 values in each row: 1 - number, 2 - first name, 3 - last name. The first \nrow of the file is a header row and is not used.\n\nDo you want to continue importing the data anyway?\n\n", dataFile.getAbsolutePath()), "Import new pilot list", 0, 3)) != 0) {
                    return;
                }
                if (line.length == 0) continue;
                if (line.length == 1) {
                    line = new String[]{"", line[0], ""};
                }
                if (line.length == 2) {
                    line = new String[]{"", line[0], line[1]};
                }
                if (nameList.contains(name = String.valueOf(line[LAST_NAME]) + "," + line[FIRST_NAME])) continue;
                nameList.add(name);
                cleanedUpData.add(line);
            }
            data = cleanedUpData;
            data.remove(0);
            reply2 = JOptionPane.showOptionDialog(F3KScore.editor(), String.format("Number of pilot entries found in the file: %d\n\nDo you want to import all pilot entries, \nor select a subset of all pilot entries?\n\n", data.size()), "Import new pilot list", 1, 3, null, new String[]{"Import all pilots", "Select a subset", "Cancel"}, null);
            if (reply2 != 0 && reply2 != 1) {
                return;
            }
            if (reply2 == 1 && (data = PilotsDatabaseUtils.showSubsetSelectionDlg(data, dataFile)) == null) {
                return;
            }
            try {
                competition.removeAllCompetitors();
                TableModel registrations = F3KScore.editor().getRegistrationPane().getTableModel();
                int row = 0;
                while (row < data.size()) {
                    String[] line = data.get(row);
                    int col = 0;
                    while (col < line.length) {
                        registrations.setValueAt(line[col], row, col);
                        ++col;
                    }
                    ++row;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed when importing pilot data from file \"%s\": %n%n%s", dataFile.getName(), e.getLocalizedMessage()), "File read error", 0);
                e.printStackTrace();
            }
        }
        finally {
            F3KScore.editor().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static List<String[]> showSubsetSelectionDlg(List<String[]> data, File dataFile) {
        PilotsDatabaseUtils.leftData = new ArrayList<E>();
        pilotData = new HashMap<String, String[]>();
        for (String[] line : data) {
            firstName = line[PilotsDatabaseUtils.FIRST_NAME];
            lastName = line[PilotsDatabaseUtils.LAST_NAME];
            fullName = firstName.length() > 0 && lastName.length() > 0 ? String.valueOf(lastName) + ", " + firstName : (firstName.length() > 0 ? firstName : lastName);
            pilotData.put(fullName, line);
            PilotsDatabaseUtils.leftData.add(fullName);
        }
        PilotsDatabaseUtils.leftList = new JList<E>();
        PilotsDatabaseUtils.leftList.setFont(PilotsDatabaseUtils.leftList.getFont().deriveFont(0));
        Collections.sort(PilotsDatabaseUtils.leftData);
        PilotsDatabaseUtils.leftList.setListData(PilotsDatabaseUtils.leftData.toArray());
        leftPane = new JScrollPane(PilotsDatabaseUtils.leftList, 22, 30);
        leftPane.setPreferredSize(new Dimension(200, 500));
        PilotsDatabaseUtils.rightData = new ArrayList<E>();
        PilotsDatabaseUtils.rightList = new JList<E>();
        PilotsDatabaseUtils.rightList.setFont(PilotsDatabaseUtils.rightList.getFont().deriveFont(0));
        rightPane = new JScrollPane(PilotsDatabaseUtils.rightList, 22, 30);
        rightPane.setPreferredSize(new Dimension(200, 500));
        leftLabel = new JLabel("All pilots in data file");
        rightLabel = new JLabel("Import these pilots");
        btnLeft = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_left.png")));
        btnRight = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_right.png")));
        btnLeft.setMargin(new Insets(2, 2, 2, 2));
        btnRight.setMargin(new Insets(2, 2, 2, 2));
        btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.moveLeft();
            }
        });
        btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.moveRight();
            }
        });
        panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(600, 400));
        panel.add((Component)leftLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)rightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)leftPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)rightPane, new GridBagConstraints(2, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)btnRight, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)btnLeft, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        reply = JOptionPane.showOptionDialog(F3KScore.editor(), panel, String.format("F3KScore: import pilot entries from \"%s\"", new Object[]{dataFile.getAbsoluteFile()}), 2, -1, null, new String[]{"Import", "Cancel"}, null);
        if (reply == 0) ** GOTO lbl46
        return null;
lbl-1000:
        // 1 sources

        {
            JOptionPane.showMessageDialog(F3KScore.editor(), "You have not selected any pilots for importing", "No pilots selected", 0);
            reply = JOptionPane.showOptionDialog(F3KScore.editor(), panel, String.format("F3KScore: import pilot entries from \"%s\"", new Object[]{dataFile.getAbsoluteFile()}), 2, -1, null, new String[]{"Import", "Cancel"}, null);
            if (reply == 0) continue;
            return null;
lbl46:
            // 2 sources

            ** while (PilotsDatabaseUtils.rightData.size() == 0)
        }
lbl47:
        // 1 sources

        data.clear();
        for (String name : PilotsDatabaseUtils.rightData) {
            data.add((String[])pilotData.get(name));
        }
        return data;
    }

    protected static void moveRight() {
        int[] indices = leftList.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        int i = indices.length - 1;
        while (i >= 0) {
            rightData.add(leftData.remove(indices[i]));
            --i;
        }
        Collections.sort(rightData);
        rightList.setListData(rightData.toArray());
        leftList.setListData(leftData.toArray());
    }

    protected static void moveLeft() {
        int[] indices = rightList.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        int i = indices.length - 1;
        while (i >= 0) {
            leftData.add(rightData.remove(indices[i]));
            --i;
        }
        Collections.sort(leftData);
        rightList.setListData(rightData.toArray());
        leftList.setListData(leftData.toArray());
    }

    private static File choosePilotsDatabaseFile(String title, boolean forReading, File defaultFile) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle(title);
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.addChoosableFileFilter(xlsxFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(xlsxFilter);
        fileChooser.setCurrentDirectory(F3KScore.editor().getCurrentDir());
        fileChooser.setSelectedFile(defaultFile);
        int returnVal = forReading ? fileChooser.showDialog(F3KScore.editor(), "Open") : fileChooser.showDialog(F3KScore.editor(), "Save updated database");
        if (returnVal == 0) {
            F3KScore.editor().setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("xlsx")) {
                file = fileChooser.getFileFilter() == xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : (fileChooser.getFileFilter() == csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx"));
            }
            if (forReading && !file.canRead()) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("File \"%s\" could not be opened for reading", file.getAbsolutePath()), "File not readable", 0);
                return null;
            }
            return file;
        }
        return null;
    }

    private static List<String[]> readPilotsDatabaseFile(File dataFile) {
        List<String[]> list;
        InputStreamReader fr = null;
        try {
            String ext = F3kFileFilter.getExtension(dataFile);
            if (ext.equalsIgnoreCase("csv")) {
                fr = new FileReader(dataFile);
                CSVReader reader = new CSVReader(fr);
                List<String[]> list2 = reader.readAll();
                return list2;
            }
            list = ExcelSpreadsheetReader.readAll(dataFile, 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed when reading pilot list file \"%s\": \n\n%s", dataFile.getName(), e.getLocalizedMessage()), "File read error", 0);
            return null;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static void mergePilotListToDatabaseFile() {
        block36: {
            File dataFile = PilotsDatabaseUtils.choosePilotsDatabaseFile("Select existing pilot database file", true, null);
            if (dataFile == null) {
                return;
            }
            F3KScore.editor().setCursor(Cursor.getPredefinedCursor(3));
            try {
                List<String[]> data = PilotsDatabaseUtils.readPilotsDatabaseFile(dataFile);
                if (data == null) {
                    return;
                }
                data.remove(0);
                TableModel tableModel = F3KScore.editor().getRegistrationPane().getTableModel();
                int nCols = tableModel.getColumnCount() - 1;
                String[] header = new String[nCols];
                int col = 0;
                while (col < nCols) {
                    header[col] = tableModel.getColumnName(col);
                    ++col;
                }
                HashMap<Object, Object> pilotData = new HashMap<Object, Object>();
                int reply = -1;
                for (String[] stringArray : data) {
                    void var7_12;
                    void var7_17;
                    void var7_15;
                    if (stringArray.length < 3 && reply < 0 && (reply = JOptionPane.showConfirmDialog(F3KScore.editor(), String.format("Non-standard data format detected in the file: \"%s\"\n\nExpected data format must match the Pilot List table or have a minimum \nof 3 values in each row: 1 - number, 2 - first name, 3 - last name.\nThe first row of the file is a header row and is not used.\n\nDo you want to continue exporting and merging the data anyway?\n\n", dataFile.getAbsolutePath()), "Export pilot data", 0, 3)) != 0) {
                        return;
                    }
                    if (stringArray.length == 0) continue;
                    if (stringArray.length == 1) {
                        String[] stringArray2 = new String[]{"", stringArray[0], ""};
                    }
                    if (((void)var7_15).length == 2) {
                        String[] stringArray3 = new String[]{"", var7_15[0], var7_15[1]};
                    }
                    String key = var7_17[FIRST_NAME];
                    if (((void)var7_17).length > 2) {
                        key = String.valueOf(var7_17[LAST_NAME]) + (String)var7_17[FIRST_NAME];
                    }
                    if (((void)var7_17).length < nCols) {
                        Object[] newLine = new String[nCols];
                        Arrays.fill(newLine, "");
                        int i = 0;
                        while (i < ((void)var7_17).length) {
                            newLine[i] = var7_17[i];
                            ++i;
                        }
                        Object[] objectArray = newLine;
                    }
                    pilotData.put(key, var7_12);
                }
                int n = F3KScore.editor().getCompetition().getCompetitorCount();
                int row = 0;
                while (row < n) {
                    String[] newLine = new String[nCols];
                    int col2 = 0;
                    while (col2 < nCols) {
                        newLine[col2] = tableModel.getValueAt(row, col2) == null ? "" : tableModel.getValueAt(row, col2).toString();
                        ++col2;
                    }
                    String key = String.valueOf(newLine[LAST_NAME]) + newLine[FIRST_NAME];
                    if (pilotData.containsKey(key)) {
                        String[] oldLine = (String[])pilotData.get(key);
                        int i = 3;
                        while (i < nCols) {
                            if (newLine[i].length() == 0 && i < oldLine.length && oldLine[i].length() > 0) {
                                newLine[i] = oldLine[i];
                            }
                            ++i;
                        }
                    }
                    pilotData.put(key, newLine);
                    ++row;
                }
                data.clear();
                data.add(header);
                ArrayList keys = new ArrayList(pilotData.keySet());
                Collections.sort(keys);
                int counter = 0;
                for (String key : keys) {
                    String[] line = (String[])pilotData.get(key);
                    line[0] = String.valueOf(++counter);
                    data.add(line);
                }
                Object[] options = new String[]{"Overwrite", "Create new file", "Cancel"};
                reply = JOptionPane.showOptionDialog(F3KScore.editor(), String.format("Do you want to overwrite file \"%s\"\nor create a new file for the updated pilot database?", dataFile.getAbsoluteFile()), "Save updated pilot database", 1, 3, null, options, options[1]);
                if (reply != 0 && reply != 1) {
                    return;
                }
                if (reply == 1 && (dataFile = PilotsDatabaseUtils.choosePilotsDatabaseFile("Select file for saving updated pilot database", false, dataFile)) == null) {
                    return;
                }
                try {
                    String ext = F3kFileFilter.getExtension(dataFile);
                    if (ext.equalsIgnoreCase("csv")) {
                        CSVWriter writer = null;
                        try {
                            writer = new CSVWriter(new FileWriter(dataFile));
                            writer.writeAll(data);
                            break block36;
                        }
                        finally {
                            try {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    ExcelSpreadsheetWriter.writeAll(dataFile, "Pilot List", data, true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed when writing pilot data to file \"%s\": %n%n%s", dataFile.getName(), e.getLocalizedMessage()), "File write error", 0);
                    e.printStackTrace();
                }
            }
            finally {
                F3KScore.editor().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static void importF3XVaultFile() {
        int reply;
        Competition competition = F3KScore.editor().getCompetition();
        if (competition.getCompetitorCount() > 0 && (reply = JOptionPane.showConfirmDialog(F3KScore.editor(), "All existing contest data will be deleted and a new contest created.\nDo you want to continue?", "Import F3XVault data file", 2, 2)) != 0) {
            return;
        }
        File dataFile = PilotsDatabaseUtils.chooseF3XVaultFile("Select F3XVault data file for importing", null);
        if (dataFile == null) {
            return;
        }
        F3KScore.editor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            int nRounds;
            Date endDate;
            List<String[]> data = PilotsDatabaseUtils.readPilotsDatabaseFile(dataFile);
            if (data == null) {
                return;
            }
            String[] line1 = data.get(0);
            String[] line2 = data.get(1);
            String[] line3 = data.get(2);
            String[] line4 = data.get(3);
            if (!(line1[0].equals("Event_ID") && line2[0].equals("Event_Name") && line3[0].equals("Event_Location") && line4[0].equals("Start_Date"))) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("\nFile \"%s\" is not a F3XVault data file", dataFile.getAbsolutePath()), "Invalid file format", 0);
                return;
            }
            competition = F3KScore.editor().createNewCompetition(1);
            competition.setF3xvaultID(Integer.parseInt(line1[1]));
            competition.setCompetitionName(line2[1]);
            Date startDate = MergeResultsUtils.parseDate(line4[1]);
            if (startDate != null) {
                String date = new SimpleDateFormat("MM-dd-yyyy").format(startDate);
                competition.setDate(date);
            }
            if ((endDate = MergeResultsUtils.parseDate(data.get(4)[1])) != null) {
                String date = new SimpleDateFormat("MM-dd-yyyy").format(endDate);
                competition.setEndDate(date);
            }
            if ((nRounds = Integer.parseInt(data.get(7)[1])) <= 0) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("\nNumber of rounds = 0 in file \"%s\" \nF3XVault file has no valid contest data.", dataFile.getAbsolutePath()), "Invalid file format", 0);
                return;
            }
            try {
                competition.setNumberOfRounds(nRounds);
                int round = 0;
                while (round < nRounds) {
                    String taskCode;
                    switch (taskCode = data.get(8)[round + 1]) {
                        case "f3k_a": {
                            competition.setRoundTask(round, StdTask.F3K_A);
                            break;
                        }
                        case "f3k_a2": {
                            competition.setRoundTask(round, StdTask.F3K_A2);
                            break;
                        }
                        case "f3k_b": {
                            competition.setRoundTask(round, StdTask.F3K_B);
                            break;
                        }
                        case "f3k_b2": {
                            competition.setRoundTask(round, StdTask.F3K_B2);
                            break;
                        }
                        case "f3k_c": {
                            competition.setRoundTask(round, StdTask.F3K_C);
                            break;
                        }
                        case "f3k_c2": {
                            competition.setRoundTask(round, StdTask.F3K_C2);
                            break;
                        }
                        case "f3k_c3": {
                            competition.setRoundTask(round, StdTask.F3K_C3);
                            break;
                        }
                        case "f3k_d": {
                            competition.setRoundTask(round, StdTask.F3K_D);
                            break;
                        }
                        case "f3k_e": {
                            competition.setRoundTask(round, StdTask.F3K_E);
                            break;
                        }
                        case "f3k_f": {
                            competition.setRoundTask(round, StdTask.F3K_F);
                            break;
                        }
                        case "f3k_g": {
                            competition.setRoundTask(round, StdTask.F3K_G);
                            break;
                        }
                        case "f3k_h": {
                            competition.setRoundTask(round, StdTask.F3K_H);
                            break;
                        }
                        case "f3k_i": {
                            competition.setRoundTask(round, StdTask.F3K_I);
                            break;
                        }
                        case "f3k_j": {
                            competition.setRoundTask(round, StdTask.F3K_J);
                            break;
                        }
                        case "f3k_k": {
                            competition.setRoundTask(round, StdTask.F3K_K);
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("\nUnknown task code \"%s\" for round %d.", taskCode, round + 1), "Unknown task code", 2);
                        }
                    }
                    ++round;
                }
                TableModel registrations = F3KScore.editor().getRegistrationPane().getTableModel();
                TableModel matrix = F3KScore.editor().getGroupsPane().getTableModel();
                int row = 0;
                while (row < data.size() - 10) {
                    String[] line = data.get(row + 10);
                    int f3xVaultID = Integer.parseInt(line[0]);
                    String firstName = line[2];
                    String lastName = line[3];
                    String pilotClass = line[4];
                    String amaNum = line[5];
                    String faiNum = line[6];
                    String teamName = line[7];
                    registrations.setValueAt(firstName, row, 1);
                    registrations.setValueAt(lastName, row, 2);
                    registrations.setValueAt(pilotClass, row, 3);
                    if (amaNum != null && amaNum.length() != 0) {
                        registrations.setValueAt(amaNum, row, 7);
                    } else {
                        registrations.setValueAt(faiNum, row, 7);
                    }
                    registrations.setValueAt(teamName, row, 6);
                    int round2 = 0;
                    while (round2 < nRounds && line[8 + round2].trim().length() > 0) {
                        if (competition.useLetterGroupNames()) {
                            matrix.setValueAt(line[8 + round2], row, 2 + round2);
                        } else {
                            int groupNum = Competition.groupLetters.indexOf(line[8 + round2].toUpperCase()) + 1;
                            matrix.setValueAt(groupNum, row, 2 + round2);
                        }
                        ++round2;
                    }
                    competition.getCompetitor(row).setF3xvaultID(f3xVaultID);
                    ++row;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed when importing pilot data from file \"%s\": %n%n%s", dataFile.getName(), e.getLocalizedMessage()), "File read error", 0);
                e.printStackTrace();
            }
        }
        finally {
            F3KScore.editor().setCursor(Cursor.getDefaultCursor());
        }
    }

    private static File chooseF3XVaultFile(String title, File defaultFile) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle(title);
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(F3KScore.editor().getCurrentDir());
        fileChooser.setSelectedFile(defaultFile);
        int returnVal = fileChooser.showDialog(F3KScore.editor(), "Open");
        if (returnVal == 0) {
            F3KScore.editor().setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".csv");
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("File \"%s\" could not be opened for reading", file.getAbsolutePath()), "File not readable", 0);
                return null;
            }
            return file;
        }
        return null;
    }
}

