/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CompetitionTask;
import f3kscore.F3KScore;
import f3kscore.F3KScoreConstants;
import java.io.Serializable;

public final class StdTask
extends Enum<StdTask>
implements Serializable,
F3KScoreConstants,
CompetitionTask {
    public static final /* enum */ StdTask F3K_A = new StdTask(0, "f3k_a", "\"A\" - Last 5:00 in 7:00", "L1x5", "Last flight, 5:00 max, 7:00 window", new int[]{300}, null, 420, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_7min_window.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_A2 = new StdTask(0, "f3k_a2", "\"A\" - Last 5:00 in 10:00", "L1x5", "Last flight, 5:00 max, 10:00 window", new int[]{300}, null, 600, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_B = new StdTask(0, "f3k_b", "\"B\" - Last 2 x 4:00", "L2x4", "Last 2 flights, 4:00 max, 10:00 window", new int[]{240, 240}, null, 600, false, new String[]{"Max=4:00", "Max=4:00"}, new String[]{"Max=240s", "Max=240s"}, new String[]{"description_task_B_last_two_4min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_B2 = new StdTask(0, "f3k_b2", "\"B\" - Last 2 x 3:00", "L2x3", "Last 2 flights, 3:00 max, 7:00 window", new int[]{180, 180}, null, 420, false, new String[]{"Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s"}, new String[]{"description_task_B_last_two_3min.mp3", "window_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C = new StdTask(0, "f3k_c", "\"C\" - All up 3 x 3:00", "AUp", "All up, 3 flights, 3:00 max", new int[]{180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C2 = new StdTask(0, "f3k_c2", "\"C\" - All up 4 x 3:00", "AUp4", "All up, 4 flights, 3:00 max", new int[]{180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C3 = new StdTask(0, "f3k_c3", "\"C\" - All up 5 x 3:00", "AUp5", "All up, 5 flights, 3:00 max", new int[]{180, 180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_D = new StdTask(0, "f3k_d", "\"D\" - Ladder +15 sec", "Laddr", "Increasing times - 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00, in 10:00 window", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}, 600, true, new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"}, new String[]{"30s", "45s", "60s", "75s", "90s", "105s", "120s"}, new String[]{"description_task_D_ladder.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_E = new StdTask(0, "f3k_e", "\"E\" - Poker", "Poker", "Poker, 5 self nominated targets, 10:00 window", new int[5], null, 600, false, new String[]{"Target #1", "Target #2", "Target #3", "Target #4", "Target #5"}, null, new String[]{"description_task_E_poker.mp3", "window_3_min_prep_10_min_poker_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_F = new StdTask(0, "f3k_f", "\"F\" - Best 3 of 6", "3of6", "Best 3 flights, 3:00 max, 6 launches only, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_F_3_of_6.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_G = new StdTask(0, "f3k_g", "\"G\" - Best 5 x 2:00", "5x2.0", "Best 5 flights, 2:00 max, 10:00 window", new int[]{120, 120, 120, 120, 120}, null, 600, false, new String[]{"Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00"}, new String[]{"Max=120s", "Max=120s", "Max=120s", "Max=120s", "Max=120s"}, new String[]{"description_task_G_5x2.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_H = new StdTask(0, "f3k_h", "\"H\" - 1:00, 2:00, 3:00, 4:00", "1234", "Best 4 flights, 1:00, 2:00, 3:00, 4:00 max in any order, 10:00 window", new int[]{60, 120, 180, 240}, null, 600, false, new String[]{"Max=1:00", "Max=2:00", "Max=3:00", "Max=4:00"}, new String[]{"Max=60s", "Max=120s", "Max=180s", "Max=240s"}, new String[]{"description_task_H_1_2_3_4.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_I = new StdTask(0, "f3k_i", "\"I\" - Best 3 x 200s", "3200", "Best 3 flights, 200s (3:20) max, 10:00 window", new int[]{200, 200, 200}, null, 600, false, new String[]{"Max=3:20", "Max=3:20", "Max=3:20"}, new String[]{"Max=200s", "Max=200s", "Max=200s"}, new String[]{"description_task_I_3x200s.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_J = new StdTask(0, "f3k_j", "\"J\" - Last 3 x 3:00", "L3x3", "Last 3 flights, 3:00 max, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_J_last_three_3min.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_K = new StdTask(0, "f3k_k", "\"K\" - Big Ladder", "BLddr", "Big Ladder - 5 flights only, 1:00, 1:30, 2:00, 2:30, 3:00 targets, 10:00 window", new int[]{60, 90, 120, 150, 180}, null, 600, false, new String[]{"Max=1:00", "Max=1:30", "Max=2:00", "Max=2:30", "Max=3:00"}, new String[]{"Max=60s", "Max=90s", "Max=120s", "Max=150s", "Max=180s"}, new String[]{"description_task_K_big_ladder.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_L = new StdTask(0, "f3k_l", "\"L\" - Deuce in 7:00", "Deuce", "Deuce - Lowest flight of 2 flights, 7:00 window (non-F3K)", new int[2], null, 420, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_L_deuce_7min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true);
    public static final /* enum */ StdTask F3K_L2 = new StdTask(0, "f3k_l2", "\"L\" - Deuce in 10:00", "Deuce", "Deuce - Lowest flight of 2 flights, 10:00 window (non-F3K)", new int[2], null, 600, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_L_deuce_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true);
    public static final /* enum */ StdTask F3K_M = new StdTask(0, "f3k_m", "\"M\" - Two flights only, 2 x 3:30", "2x3.5", "Two flights only, 3:30 max, 7:00 window (non-F3K)", new int[]{210, 210}, null, 420, false, new String[]{"Max=3:30", "Max=3:30"}, new String[]{"Max=210s", "Max=210s"}, new String[]{"description_task_M_two_flights_only_7min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_M2 = new StdTask(0, "f3k_m2", "\"M\" - Two flights only, 2 x 5:00", "2x5.0", "Two flights only, 5:00 max, 10:00 window (non-F3K)", new int[]{300, 300}, null, 600, false, new String[]{"Max=5:00", "Max=5:00"}, new String[]{"Max=300s", "Max=300s"}, new String[]{"description_task_M_two_flights_only_10min_window.mp3", "window_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask ALES_TD_6;
    public static final /* enum */ StdTask ALES_TD_8;
    public static final /* enum */ StdTask ALES_TD_10;
    public static final /* enum */ StdTask ALES_TD_15;
    public static final /* enum */ StdTask F5J_10;
    public static final /* enum */ StdTask F5J_15;
    public static final /* enum */ StdTask F3B_SPEED;
    public static final /* enum */ StdTask F3K_1x10;
    public static final /* enum */ StdTask F3J_10;
    public static final /* enum */ StdTask F3J_15;
    private static final long serialVersionUID = 1L;
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private String codedName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private String[] scoreCardTextTips;
    private String[] scoreCardTextTipsSecondsOnly;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean isShortestFlightTask;
    private int taskType = 0;
    private static final /* synthetic */ StdTask[] ENUM$VALUES;

    static {
        int[] nArray = new int[2];
        nArray[0] = 360;
        ALES_TD_6 = new StdTask(2, "ales_6", "ALES/TD - 6:00 max", "6:00", "Normalized duration, landing scored separately, 6:00 maximum", nArray, null, 360, false, new String[]{"Max=6:00", "Landing"}, new String[]{"Max=360s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing"}, false);
        int[] nArray2 = new int[2];
        nArray2[0] = 480;
        ALES_TD_8 = new StdTask(2, "ales_8", "ALES/TD - 8:00 max", "8:00", "Normalized duration, landing scored separately, 8:00 maximum", nArray2, null, 480, false, new String[]{"Max=8:00", "Landing"}, new String[]{"Max=480s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing"}, false);
        int[] nArray3 = new int[2];
        nArray3[0] = 600;
        ALES_TD_10 = new StdTask(2, "ales_10", "ALES/TD - 10:00 max", "10:00", "Normalized duration, landing scored separately, 10:00 maximum", nArray3, null, 600, false, new String[]{"Max=10:00", "Landing"}, new String[]{"Max=600s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing"}, false);
        int[] nArray4 = new int[2];
        nArray4[0] = 900;
        ALES_TD_15 = new StdTask(2, "ales_15", "ALES/TD - 15:00 max", "15:00", "Normalized duration, landing scored separately, 15:00 maximum", nArray4, null, 900, false, new String[]{"Max=15:00", "Landing"}, new String[]{"Max=900s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing"}, false);
        int[] nArray5 = new int[3];
        nArray5[0] = 599;
        F5J_10 = new StdTask(1, "f5j_10", "F5J - 10:00", "10:00", "F5J duration, 10:00 window", nArray5, null, 600, false, new String[]{"Time", "Landing", "Altitude", "Lndg Late?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_10_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing", "Altitude"}, false);
        int[] nArray6 = new int[3];
        nArray6[0] = 899;
        F5J_15 = new StdTask(1, "f5j_15", "F5J - 15:00", "15:00", "F5J duration, 15:00 window", nArray6, null, 900, false, new String[]{"Time", "Landing", "Altitude", "Lndg Late?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_15_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing", "Altitude"}, false);
        F3B_SPEED = new StdTask(4, "f3b_speed", "F3B speed", "F3B", "F3F/F3B type speed task", new int[1], null, 0, false, null, null, null, null, false);
        F3K_1x10 = new StdTask(0, "f3k_1x10", "Best 10 x 1:00", "10x1", "Best 10 flights, 1:00 max, 10:00 window", new int[]{60, 60, 60, 60, 60, 60, 60, 60, 60, 60}, null, 600, false, new String[]{"Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00"}, new String[]{"Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s"}, null, null, false);
        int[] nArray7 = new int[2];
        nArray7[0] = 600;
        F3J_10 = new StdTask(3, "f3j_10", "F3J - 10:00", "10:00", "F3J duration, 10:00 window", nArray7, null, 600, false, new String[]{"Time (1:23.4)", "Landing", "Lndg Late?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_10_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing"}, false);
        int[] nArray8 = new int[2];
        nArray8[0] = 900;
        F3J_15 = new StdTask(3, "f3j_15", "F3J - 15:00", "15:00", "F3J duration, 15:00 window", nArray8, null, 900, false, new String[]{"Time (1:23.4)", "Landing", "Lndg Late?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_15_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing"}, false);
        ENUM$VALUES = new StdTask[]{F3K_A, F3K_A2, F3K_B, F3K_B2, F3K_C, F3K_C2, F3K_C3, F3K_D, F3K_E, F3K_F, F3K_G, F3K_H, F3K_I, F3K_J, F3K_K, F3K_L, F3K_L2, F3K_M, F3K_M2, ALES_TD_6, ALES_TD_8, ALES_TD_10, ALES_TD_15, F5J_10, F5J_15, F3B_SPEED, F3K_1x10, F3J_10, F3J_15};
    }

    private StdTask(int taskType, String codedName, String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isLadderTask, String[] scoreCardTextTips, String[] scoreCardTextTipsSecondsOnly, String[] playList, String[] columnTitles, boolean isShortestFlightTask) {
        this.taskType = taskType;
        this.codedName = codedName;
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        this.scoreCardTextTips = scoreCardTextTips;
        this.scoreCardTextTipsSecondsOnly = scoreCardTextTipsSecondsOnly;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.isShortestFlightTask = isShortestFlightTask;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
    }

    @Override
    public boolean isSpeedTask() {
        return this.taskType == 4;
    }

    @Override
    public boolean isLadderTask() {
        return this.isLadderTask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getDescription() {
        return this.longName;
    }

    @Override
    public int getNumFlights() {
        return this.numFlights;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    @Override
    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }

    @Override
    public int getWindowTime() {
        return this.windowTime;
    }

    @Override
    public String[] getScoreCardTextTips() {
        if (F3KScore.editor().getCompetition().isUseSecondsForFlightTimes() && this.scoreCardTextTipsSecondsOnly != null) {
            return this.scoreCardTextTipsSecondsOnly;
        }
        return this.scoreCardTextTips;
    }

    @Override
    public String[] getPlaylist() {
        return this.playList;
    }

    @Override
    public String[] getFlightTimesColumnTitles() {
        return this.flightTimesColumnTitles;
    }

    @Override
    public boolean hasLandingScore() {
        return this.taskType == 2 || this.taskType == 1 || this.taskType == 3;
    }

    @Override
    public boolean isLandingScoredSeparately() {
        return this.taskType == 2;
    }

    @Override
    public boolean isShortestFlightTask() {
        return this.isShortestFlightTask;
    }

    @Override
    public boolean isF5Jtask() {
        return this.taskType == 1;
    }

    @Override
    public boolean isF3Jtask() {
        return this.taskType == 3;
    }

    @Override
    public boolean isF3Ktask() {
        return this.taskType == 0;
    }

    @Override
    public boolean isAlesTdTask() {
        return this.taskType == 2;
    }

    @Override
    public String getCodedName() {
        if (this.codedName == null) {
            StdTask[] stdTaskArray = StdTask.values();
            int n = stdTaskArray.length;
            int n2 = 0;
            while (n2 < n) {
                StdTask task = stdTaskArray[n2];
                if (this.shortName != null ? task.getShortName().equals(this.shortName) : task.getName().equals(this.name)) {
                    return task.getCodedName();
                }
                ++n2;
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 420) {
                return F3K_A.getCodedName();
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 600) {
                return F3K_A2.getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 600) {
                return F3K_B.getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 420) {
                return F3K_B2.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 3) {
                return F3K_C.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 4) {
                return F3K_C2.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 5) {
                return F3K_C3.getCodedName();
            }
            if (this.name.startsWith("\"D\"")) {
                return F3K_D.getCodedName();
            }
            if (this.name.startsWith("\"E\"")) {
                return F3K_E.getCodedName();
            }
            if (this.name.startsWith("\"F\"")) {
                return F3K_F.getCodedName();
            }
            if (this.name.startsWith("\"G\"")) {
                return F3K_G.getCodedName();
            }
            if (this.name.startsWith("\"H\"")) {
                return F3K_H.getCodedName();
            }
            if (this.name.startsWith("\"I\"")) {
                return F3K_I.getCodedName();
            }
            if (this.name.startsWith("\"J\"")) {
                return F3K_J.getCodedName();
            }
        }
        return this.codedName;
    }

    @Override
    public void setCodedName(String codedName) {
        this.codedName = codedName;
    }

    public static StdTask[] values() {
        StdTask[] stdTaskArray = ENUM$VALUES;
        int n = stdTaskArray.length;
        StdTask[] stdTaskArray2 = new StdTask[n];
        System.arraycopy(ENUM$VALUES, 0, stdTaskArray2, 0, n);
        return stdTaskArray2;
    }

    public static StdTask valueOf(String string) {
        return Enum.valueOf(StdTask.class, string);
    }
}

