/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.F3KScoreConstants;
import f3kscore.StdTask;
import java.io.Serializable;
import java.util.ArrayList;

public class Task
implements Serializable,
F3KScoreConstants {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FLIGHT_TIMES = 20;
    public static ArrayList<Task> taskPool = new ArrayList();
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private String codedName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private String[] scoreCardTextTips;
    private String[] scoreCardTextTipsSecondsOnly;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean isShortestFlightTask;
    private int taskType = 0;

    public Task(int taskType, String codedName, String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isLadderTask, String[] scoreCardTextTips, String[] scoreCardTextTipsSecondsOnly, String[] playList, String[] columnTitles, boolean isShortestFlightTask) {
        this.taskType = taskType;
        this.codedName = codedName;
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        this.scoreCardTextTips = scoreCardTextTips;
        this.scoreCardTextTipsSecondsOnly = scoreCardTextTipsSecondsOnly;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.isShortestFlightTask = isShortestFlightTask;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public StdTask toEventTask() {
        block104: {
            block102: {
                if (this.shortName == null) break block102;
                switch (this.shortName) {
                    case "L1x5": {
                        if (this.windowTime == 420) {
                            return StdTask.F3K_A;
                        }
                        return StdTask.F3K_A2;
                    }
                    case "L2x4": {
                        return StdTask.F3K_B;
                    }
                    case "L2x3": {
                        return StdTask.F3K_B2;
                    }
                    case "AUp": {
                        return StdTask.F3K_C;
                    }
                    case "AUp4": {
                        return StdTask.F3K_C2;
                    }
                    case "AUp5": {
                        return StdTask.F3K_C3;
                    }
                    case "Laddr": {
                        return StdTask.F3K_D;
                    }
                    case "Poker": {
                        return StdTask.F3K_E;
                    }
                    case "3of6": {
                        return StdTask.F3K_F;
                    }
                    case "5x2": 
                    case "5x2.0": {
                        return StdTask.F3K_G;
                    }
                    case "1234": {
                        return StdTask.F3K_H;
                    }
                    case "3200": {
                        return StdTask.F3K_I;
                    }
                    case "L3x3": {
                        return StdTask.F3K_J;
                    }
                    case "BLddr": {
                        return StdTask.F3K_K;
                    }
                    case "Deuce": {
                        if (this.windowTime == 420) {
                            return StdTask.F3K_L;
                        }
                        return StdTask.F3K_L2;
                    }
                    case "2x3.5": {
                        return StdTask.F3K_M;
                    }
                    case "2x5.0": {
                        return StdTask.F3K_M2;
                    }
                    case "F3B": {
                        return StdTask.F3B_SPEED;
                    }
                    case "10x1": {
                        return StdTask.F3K_1x10;
                    }
                }
            }
            if (this.codedName == null) break block104;
            switch (this.codedName) {
                case "ales_6": {
                    return StdTask.ALES_TD_6;
                }
                case "ales_8": {
                    return StdTask.ALES_TD_8;
                }
                case "ales_10": {
                    return StdTask.ALES_TD_10;
                }
                case "ales_15": {
                    return StdTask.ALES_TD_15;
                }
                case "f5j_10": {
                    return StdTask.F5J_10;
                }
                case "f5j_15": {
                    return StdTask.F5J_15;
                }
            }
        }
        if (this.name.toLowerCase().contains("last 5:00 in 7:00") || this.name.toLowerCase().contains("last flight")) {
            return StdTask.F3K_A;
        }
        if (this.name.toLowerCase().contains("last 5:00 in 10:00")) {
            return StdTask.F3K_A2;
        }
        if (this.name.toLowerCase().contains("2 x 4") || this.name.toLowerCase().contains("last two flights") || this.name.toLowerCase().contains("last two, 4")) {
            return StdTask.F3K_B;
        }
        if (this.name.toLowerCase().contains("2 x 3") || this.name.toLowerCase().contains("last two, 3")) {
            return StdTask.F3K_B2;
        }
        if (this.name.toLowerCase().contains("all up 4")) {
            return StdTask.F3K_C2;
        }
        if (this.name.toLowerCase().contains("all up 5")) {
            return StdTask.F3K_C3;
        }
        if (this.name.toLowerCase().contains("all up")) {
            return StdTask.F3K_C;
        }
        if (this.name.toLowerCase().contains("ladder")) {
            return StdTask.F3K_D;
        }
        if (this.name.toLowerCase().contains("poker")) {
            return StdTask.F3K_E;
        }
        if (this.name.toLowerCase().contains("3 of 6")) {
            return StdTask.F3K_F;
        }
        if (this.name.contains("5 x 2") || this.name.contains("5x2")) {
            return StdTask.F3K_G;
        }
        if (this.name.toLowerCase().contains("1:00, 2:00, 3:00, 4:00") || this.name.contains("1,2,3,4")) {
            return StdTask.F3K_H;
        }
        if (this.name.toLowerCase().contains("best 3 x 200")) {
            return StdTask.F3K_I;
        }
        if (this.name.toLowerCase().contains("last 3 x 3")) {
            return StdTask.F3K_J;
        }
        if (this.name.toLowerCase().contains("speed")) {
            return StdTask.F3B_SPEED;
        }
        return StdTask.F3B_SPEED;
    }
}

