/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class TotalScoresPane
extends AbstractF3KScoreEditorPanel {
    private String[] colNames = new String[20];
    private int[] colWidths = new int[20];
    private boolean useSecondNameColumn;
    private int lastRoundCol;
    private int secondNameCol = -1;
    private int penaltyCol;
    private int scoreCol;
    private int percentCol;
    private int classCol;
    private int faiAmaCol;
    private int clubCol;
    private int stateCol;
    private NumberFormat scoreFormatter = NumberFormat.getNumberInstance();
    private NumberFormat scoreFormatter1000 = NumberFormat.getNumberInstance();
    private NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private NumberFormat percentFormatter100 = NumberFormat.getPercentInstance();
    private JPopupMenu popupMenu;
    private HashMap<Integer, Integer> rowToPositionMap = null;
    private HashMap<Integer, Competitor> rowToPilotMap = null;

    public TotalScoresPane(Competition competition) {
        this.competition = competition;
        this.configurePanel();
        this.createTable(new TotalScoresTableModel());
        this.table.setAutoResizeMode(0);
        this.setMultilineTableHeaders();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter.setPasteEnabled(false);
        if (competition.getEventType() == 1) {
            this.scoreFormatter.setMinimumFractionDigits(0);
        } else {
            this.scoreFormatter.setMinimumFractionDigits(1);
        }
        this.scoreFormatter.setMaximumFractionDigits(1);
        this.scoreFormatter1000.setMinimumFractionDigits(0);
        this.scoreFormatter1000.setMaximumFractionDigits(0);
        this.percentFormatter.setMaximumFractionDigits(2);
        this.percentFormatter.setMinimumFractionDigits(2);
        this.percentFormatter100.setMaximumFractionDigits(1);
        this.percentFormatter100.setMinimumFractionDigits(1);
    }

    private void configurePanel() {
        int nRounds = this.competition.getNumberOfRounds();
        int nCol = nRounds + 10;
        this.useSecondNameColumn = false;
        if (nRounds > 20) {
            nCol += 2;
            this.useSecondNameColumn = true;
        }
        this.colNames = new String[nCol];
        this.colWidths = new int[nCol];
        this.colNames[0] = "";
        this.colWidths[0] = 25;
        this.colNames[1] = "Name";
        this.colWidths[1] = 140;
        int col = 2;
        while (col < this.competition.getNumberOfRounds() + 2) {
            int roundIndex = col - 2;
            String shortTaskName = this.competition.getRoundTask(roundIndex).getShortName();
            if (shortTaskName == null || shortTaskName.length() == 0) {
                this.colNames[col] = "" + (col - 1);
                this.colWidths[col] = 40;
            } else {
                this.colNames[col] = String.format("%d\n%s", col - 1, shortTaskName);
                this.colWidths[col] = 50;
            }
            ++col;
        }
        this.lastRoundCol = col - 1;
        this.secondNameCol = -1;
        if (this.useSecondNameColumn) {
            this.colNames[col] = "";
            this.colWidths[col] = 25;
            this.secondNameCol = ++col;
            this.colNames[col] = "Name";
            this.colWidths[col] = 150;
            ++col;
        }
        this.penaltyCol = col;
        this.colNames[col] = "Penalty\n& Rnd";
        this.colWidths[col] = 65;
        int i = 0;
        while (i < this.competition.getCompetitorCount()) {
            Competitor comp = this.competition.getCompetitorAtPosition(i);
            if (comp.getPenalty() > 100) {
                this.colWidths[col] = 75;
            }
            if (comp.getPenalty() > 200) {
                this.colWidths[col] = 80;
            }
            ++i;
        }
        this.scoreCol = ++col;
        this.colNames[col] = "Score";
        this.colWidths[col] = 60;
        this.percentCol = ++col;
        this.colNames[col] = "%";
        this.colWidths[col] = 55;
        this.classCol = ++col;
        this.colNames[col] = "Class";
        this.colWidths[col] = 70;
        this.faiAmaCol = ++col;
        this.colNames[col] = "FAI/AMA\nnumber";
        this.colWidths[col] = 85;
        this.clubCol = ++col;
        this.colNames[col] = "Club";
        this.colWidths[col] = 65;
        this.stateCol = ++col;
        this.colNames[col] = "State";
        this.colWidths[col] = 65;
        this.colNames[++col] = "";
        this.colWidths[col] = 2000;
        if (this.competition.getTaskList().get(0).isF3Ktask()) {
            this.scoreFormatter.setMinimumFractionDigits(0);
        } else {
            this.scoreFormatter.setMinimumFractionDigits(1);
        }
    }

    private void loadPilotData() {
        this.rowToPilotMap = new HashMap();
        this.rowToPositionMap = new HashMap();
        int position = 1;
        int row = 0;
        Competitor prevPilot = null;
        int i = 0;
        while (i < this.competition.getCompetitorCount()) {
            Competitor pilot = this.competition.getCompetitorAtPosition(i);
            if (prevPilot != null && prevPilot.getDivision() < pilot.getDivision()) {
                this.rowToPositionMap.put(row, 0);
                this.rowToPilotMap.put(row, null);
                position = 1;
                ++row;
            }
            this.rowToPositionMap.put(row, position);
            this.rowToPilotMap.put(row, pilot);
            prevPilot = pilot;
            ++i;
            ++position;
            ++row;
        }
    }

    private HashMap<Integer, Integer> rowToPositionMap() {
        if (this.rowToPositionMap == null) {
            this.loadPilotData();
        }
        return this.rowToPositionMap;
    }

    private HashMap<Integer, Competitor> rowToPilotMap() {
        if (this.rowToPilotMap == null) {
            this.loadPilotData();
        }
        return this.rowToPilotMap;
    }

    private void configureColumnWidths() {
        int i = 0;
        while (i < this.colWidths.length) {
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidths[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            ++i;
        }
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TotalScoresPane.this.excelAdapter.copyAction();
                }
            });
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(copyMenuItem);
        }
        return this.popupMenu;
    }

    private class TotalScoresTableModel
    extends AbstractTableModel {
        private TotalScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            TotalScoresPane.this.rowToPilotMap = null;
            TotalScoresPane.this.rowToPositionMap = null;
            TotalScoresPane.this.configurePanel();
            super.fireTableStructureChanged();
            TotalScoresPane.this.configureColumnWidths();
            TotalScoresPane.this.setMultilineTableHeaders();
        }

        @Override
        public int getColumnCount() {
            return TotalScoresPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return TotalScoresPane.this.rowToPositionMap().size();
        }

        @Override
        public String getColumnName(int col) {
            return TotalScoresPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor pilot = (Competitor)TotalScoresPane.this.rowToPilotMap().get(row);
            if (pilot == null) {
                return "";
            }
            if (col >= TotalScoresPane.this.colNames.length - 1) {
                return "";
            }
            if (col == 0 || col == TotalScoresPane.this.secondNameCol - 1) {
                return "" + TotalScoresPane.this.rowToPositionMap().get(row);
            }
            if (col == 1 || col == TotalScoresPane.this.secondNameCol) {
                return pilot.getFullName();
            }
            if (col <= TotalScoresPane.this.lastRoundCol) {
                int round = col - 2;
                double roundScore = pilot.getRoundScore(round);
                String displayValue = roundScore == 1000.0 ? TotalScoresPane.this.scoreFormatter1000.format(roundScore) : (roundScore <= 0.0 ? "0" : TotalScoresPane.this.scoreFormatter.format(roundScore));
                if (pilot.isDiscardRound(round) && pilot.calculateTotalScore() >= 0.0) {
                    return "(" + displayValue + ")";
                }
                if (roundScore <= 0.0) {
                    return "";
                }
                return displayValue;
            }
            if (col == TotalScoresPane.this.penaltyCol) {
                int penalty = pilot.getPenalty();
                if (penalty == 0) {
                    return "";
                }
                StringBuffer res = new StringBuffer();
                res.append(pilot.getPenalty());
                if (pilot.getPenaltyRounds().length() > 0) {
                    res.append("/").append(pilot.getPenaltyRounds());
                }
                return res.toString();
            }
            if (col == TotalScoresPane.this.scoreCol) {
                double score = pilot.calculateTotalScore();
                if (score != 0.0) {
                    if (score == 1000.0) {
                        return TotalScoresPane.this.scoreFormatter1000.format(score);
                    }
                    return TotalScoresPane.this.scoreFormatter.format(score);
                }
                return "";
            }
            if (col == TotalScoresPane.this.percentCol) {
                double val = pilot.getPercent();
                if (val == 100.0) {
                    return TotalScoresPane.this.percentFormatter100.format(1.0);
                }
                if (val != 0.0) {
                    return TotalScoresPane.this.percentFormatter.format(pilot.getPercent() / 100.0);
                }
                return "";
            }
            if (col == TotalScoresPane.this.classCol) {
                String val = pilot.getProperty("Class");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.faiAmaCol) {
                String val = pilot.getProperty("FAI/AMA Num");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.clubCol) {
                String val = pilot.getProperty("Club");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.stateCol) {
                String val = pilot.getProperty("State");
                return val == null ? "" : val;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

