/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.ExcelSpreadsheetReader;
import f3kscore.F3KScore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSpreadsheetWriter {
    private Workbook wb = new XSSFWorkbook();
    private int nextCol = 0;
    private int nextRow = 0;
    private Sheet currentSheet;
    private Row currentRow;
    private Font boldFont;
    private Font strikeoutFont;
    private DataFormat dataFormat = this.wb.createDataFormat();
    private String roundScoreFormat;
    private String totalScoreFormat;

    public static boolean excelLibsAvailable() {
        try {
            Class.forName("org.apache.poi.xssf.usermodel.XSSFWorkbook");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public ExcelSpreadsheetWriter() {
        if (F3KScore.editor().getCompetition().getEventType() == 1) {
            this.roundScoreFormat = "##0";
            this.totalScoreFormat = "#,###";
        } else {
            this.roundScoreFormat = "##0.0";
            this.totalScoreFormat = "#,##0.0";
        }
    }

    public void addSheet(String sheetName) {
        this.currentSheet = this.wb.createSheet(sheetName);
        this.nextRow = 0;
        this.nextCol = 0;
    }

    public void addRow() {
        this.currentRow = this.currentSheet.createRow(this.nextRow++);
        this.nextCol = 0;
    }

    public Cell setNextCell(String cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue(cellValue);
        return c;
    }

    public Cell setNextCell(Integer cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue((double)cellValue.intValue());
        return c;
    }

    public Cell setNextCell(Double cellValue) {
        Cell c = this.currentRow.createCell(this.nextCol++);
        c.setCellValue(cellValue.doubleValue());
        return c;
    }

    public CellStyle configureCellStyle(Cell c, short alignment, short borderStyle, boolean useBoldFont, boolean useStrikeoutFont) {
        CellStyle style = this.wb.createCellStyle();
        if (alignment >= 0) {
            style.setAlignment(alignment);
        }
        if (borderStyle >= 0) {
            style.setBorderBottom(borderStyle);
            style.setBorderLeft(borderStyle);
            style.setBorderRight(borderStyle);
            style.setBorderTop(borderStyle);
        }
        if (useBoldFont) {
            if (this.boldFont == null) {
                this.boldFont = this.wb.createFont();
                this.boldFont.setBoldweight((short)700);
            }
            style.setFont(this.boldFont);
        } else if (useStrikeoutFont) {
            if (this.strikeoutFont == null) {
                this.strikeoutFont = this.wb.createFont();
                this.strikeoutFont.setStrikeout(true);
            }
            style.setFont(this.strikeoutFont);
        }
        c.setCellStyle(style);
        return style;
    }

    public CellStyle configureCellStyle(Cell c, short alignment, boolean useBoldFont, boolean useStrikeoutFont, boolean leftBorder, boolean rightBorder, boolean topBorder, boolean bottomBorder) {
        CellStyle style = this.wb.createCellStyle();
        if (alignment >= 0) {
            style.setAlignment(alignment);
        }
        if (leftBorder) {
            style.setBorderLeft((short)1);
        }
        if (rightBorder) {
            style.setBorderRight((short)1);
        }
        if (bottomBorder) {
            style.setBorderBottom((short)1);
        }
        if (topBorder) {
            style.setBorderTop((short)1);
        }
        if (useBoldFont) {
            if (this.boldFont == null) {
                this.boldFont = this.wb.createFont();
                this.boldFont.setBoldweight((short)700);
            }
            style.setFont(this.boldFont);
        } else if (useStrikeoutFont) {
            if (this.strikeoutFont == null) {
                this.strikeoutFont = this.wb.createFont();
                this.strikeoutFont.setStrikeout(true);
            }
            style.setFont(this.strikeoutFont);
        }
        c.setCellStyle(style);
        return style;
    }

    public void autoSizeColumns() {
        int i = 0;
        while (i < this.nextCol) {
            this.currentSheet.autoSizeColumn(i);
            ++i;
        }
    }

    public void saveAs(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        this.wb.write((OutputStream)out);
        out.close();
    }

    public void saveAs(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.wb.write((OutputStream)out);
        out.close();
    }

    public void writeAll(String sheetName, List<String[]> data) {
        this.addSheet(sheetName);
        ArrayList<String[]> lines = new ArrayList<String[]>(data);
        String[] header = (String[])lines.remove(0);
        this.addRow();
        int col = 0;
        while (col < header.length) {
            String val = header[col] == null ? "" : header[col];
            Cell c = null;
            Double dblVal = null;
            try {
                dblVal = Double.parseDouble(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = dblVal != null ? this.setNextCell(dblVal) : this.setNextCell(val);
            CellStyle style = this.configureCellStyle(c, (short)2, (short)1, true, false);
            if (val.contains("\n")) {
                style.setWrapText(true);
                this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
                c.setCellStyle(style);
            }
            ++col;
        }
        for (String[] line : lines) {
            this.addRow();
            int col2 = 0;
            while (col2 < line.length) {
                block22: {
                    Cell c;
                    short stringCellAlignment = 1;
                    String val = line[col2] == null ? "" : line[col2];
                    Double dblVal = null;
                    if (val.equalsIgnoreCase("false")) {
                        val = "";
                    } else if (val.equalsIgnoreCase("true")) {
                        val = "yes";
                        stringCellAlignment = 2;
                    } else if (val.contains(":") && val.length() <= 7) {
                        stringCellAlignment = 2;
                    } else if (val.endsWith("%")) {
                        stringCellAlignment = 2;
                    } else {
                        if (val.startsWith("(") && val.endsWith(")")) {
                            try {
                                c = this.setNextCell(val.substring(1, val.length() - 1));
                                this.configureCellStyle(c, (short)2, (short)1, false, true);
                                break block22;
                            }
                            catch (NumberFormatException c2) {
                                // empty catch block
                            }
                        }
                        try {
                            if (ExcelSpreadsheetWriter.isNumeric(val)) {
                                dblVal = NumberFormat.getNumberInstance().parse(val).doubleValue();
                            }
                        }
                        catch (Exception c2) {
                            // empty catch block
                        }
                    }
                    if (dblVal != null) {
                        c = this.setNextCell(dblVal);
                        this.configureCellStyle(c, (short)2, (short)1, false, false);
                    } else {
                        c = this.setNextCell(val);
                        this.configureCellStyle(c, stringCellAlignment, (short)1, false, false);
                    }
                }
                ++col2;
            }
        }
        this.autoSizeColumns();
    }

    public void writeTotalScores(String sheetName, List<String[]> data) {
        this.addSheet(sheetName);
        ArrayList<String[]> lines = new ArrayList<String[]>(data);
        String[] header = (String[])lines.remove(0);
        this.addRow();
        int col = 0;
        while (col < header.length) {
            boolean leftBorder = true;
            boolean rightBorder = true;
            boolean topBorder = true;
            boolean bottomBorder = true;
            String val = header[col] == null ? "" : header[col];
            Cell c = null;
            Double dblVal = null;
            try {
                dblVal = Double.parseDouble(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = dblVal != null ? this.setNextCell(dblVal) : this.setNextCell(val);
            CellStyle style = this.configureCellStyle(c, (short)2, true, false, leftBorder, rightBorder, topBorder, bottomBorder);
            if (val.contains("\n")) {
                style.setWrapText(true);
                this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
                c.setCellStyle(style);
            }
            ++col;
        }
        int row = 0;
        while (row < lines.size()) {
            String[] line = (String[])lines.get(row);
            this.addRow();
            int col2 = 0;
            while (col2 < line.length) {
                int cellAlignment = 1;
                boolean strikeThrough = false;
                boolean leftBorder = true;
                boolean rightBorder = true;
                boolean topBorder = false;
                boolean bottomBorder = false;
                Cell c = null;
                if (row % 3 == 0) {
                    topBorder = true;
                } else if (row % 3 == 2) {
                    bottomBorder = true;
                }
                if (row == lines.size() - 1) {
                    bottomBorder = true;
                }
                String val = line[col2] == null ? "" : line[col2];
                Double dblVal = null;
                if (val.equalsIgnoreCase("false")) {
                    val = "";
                } else if (val.equalsIgnoreCase("true")) {
                    val = "yes";
                    cellAlignment = 2;
                } else if (val.contains(":")) {
                    cellAlignment = 2;
                } else if (val.endsWith("%")) {
                    try {
                        dblVal = NumberFormat.getNumberInstance().parse(val).doubleValue();
                        dblVal = dblVal / 100.0;
                        cellAlignment = 2;
                    }
                    catch (Exception exception) {}
                } else {
                    if (val.startsWith("(") && val.endsWith(")")) {
                        val = val.substring(1, val.length() - 1);
                        cellAlignment = 2;
                        strikeThrough = true;
                    }
                    try {
                        if (ExcelSpreadsheetWriter.isNumeric(val)) {
                            dblVal = NumberFormat.getNumberInstance().parse(val).doubleValue();
                            cellAlignment = 2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c = dblVal != null ? this.setNextCell(dblVal) : this.setNextCell(val);
                CellStyle style = this.configureCellStyle(c, (short)cellAlignment, false, strikeThrough, leftBorder, rightBorder, topBorder, bottomBorder);
                if (header[col2].contains("Total")) {
                    style.setDataFormat(this.dataFormat.getFormat(this.totalScoreFormat));
                    c.setCellStyle(style);
                } else if (header[col2].contains("%")) {
                    if (dblVal != null) {
                        if (dblVal == 1.0) {
                            style.setDataFormat(this.dataFormat.getFormat("###.0%"));
                        } else {
                            style.setDataFormat(this.dataFormat.getFormat("###.00%"));
                        }
                    }
                    c.setCellStyle(style);
                }
                ++col2;
            }
            ++row;
        }
        this.autoSizeColumns();
    }

    static void writeAll(File file, String sheetName, List<String[]> lines, boolean launchExcel, boolean totalScoresTable) throws IOException {
        if (!ExcelSpreadsheetReader.excelLibsAvailable()) {
            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Excel utilities are not available. Verify your install or F3KScore version.", new Object[0]), "Excel file write error", 0);
            return;
        }
        ExcelSpreadsheetWriter xlWriter = new ExcelSpreadsheetWriter();
        if (totalScoresTable) {
            xlWriter.writeTotalScores(sheetName, lines);
        } else {
            xlWriter.writeAll(sheetName, lines);
        }
        xlWriter.saveAs(file);
        if (launchExcel) {
            try {
                String[] commands = new String[]{"cmd", "/c", "start", "\"\"", file.getCanonicalPath()};
                Runtime.getRuntime().exec(commands);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }
}

