/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.RoundScoresPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class FlyoffRoundScoresPane
extends RoundScoresPane {
    private JButton btnConfigurePilots = new JButton("Select Fly-off Pilots");

    public FlyoffRoundScoresPane(Competition competition) {
        super(competition.getFlyoffCompetition());
        this.taskSelectLabel.setText("Fly-off Round:");
        this.topPanel.add((Component)this.btnConfigurePilots, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.btnConfigurePilots.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlyoffRoundScoresPane.this.configureFlyoffPilots();
            }
        });
    }

    private void configureFlyoffPilots() {
        JPanel dlgPanel = new JPanel(new GridBagLayout());
        JLabel lblTitle = new JLabel("Select fly-off pilots from the list:");
        Object[] selections = new Boolean[this.competition.getMainCompetition().getCompetitorCount()];
        Arrays.fill(selections, (Object)false);
        int i = 0;
        while (i < selections.length) {
            Competitor pilot = this.competition.getMainCompetition().getCompetitorAtPosition(i);
            if (this.competition.getCompetitorList().contains(pilot)) {
                selections[i] = true;
            }
            ++i;
        }
        JTable theTable = new JTable();
        theTable.setModel(new AbstractTableModel((Boolean[])selections){
            private final /* synthetic */ Boolean[] val$selections;
            {
                this.val$selections = booleanArray;
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getRowCount() {
                return this.val$selections.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                Competitor pilot = FlyoffRoundScoresPane.this.competition.getMainCompetition().getCompetitorAtPosition(row);
                switch (col) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        return this.val$selections[row];
                    }
                    case 2: {
                        return pilot.getFullName();
                    }
                    case 3: {
                        return pilot.getCompetitorClass();
                    }
                    case 4: {
                        double score = pilot.calculateTotalScore();
                        int nDigits = FlyoffRoundScoresPane.this.competition.scoreRoundOffNumDigits();
                        FlyoffRoundScoresPane.this.scoreFormatter.setMinimumFractionDigits(nDigits);
                        FlyoffRoundScoresPane.this.scoreFormatter.setMaximumFractionDigits(nDigits);
                        return FlyoffRoundScoresPane.this.scoreFormatter.format(score);
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return Integer.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: 
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "Name";
                    }
                    case 3: {
                        return "Class";
                    }
                    case 4: {
                        return "Prelim\nScore";
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }

            @Override
            public void setValueAt(Object val, int row, int col) {
                if (col != 1) {
                    return;
                }
                this.val$selections[row] = (Boolean)val;
            }
        });
        AbstractF3KScoreEditorPanel.MultiLineHeaderRenderer renderer = new AbstractF3KScoreEditorPanel.MultiLineHeaderRenderer(this);
        theTable.getColumnModel().getColumn(0).setMinWidth(8);
        theTable.getColumnModel().getColumn(0).setPreferredWidth(8);
        theTable.getColumnModel().getColumn(0).setHeaderRenderer(renderer);
        theTable.getColumnModel().getColumn(1).setMinWidth(15);
        theTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        theTable.getColumnModel().getColumn(1).setHeaderRenderer(renderer);
        theTable.getColumnModel().getColumn(2).setMinWidth(200);
        theTable.getColumnModel().getColumn(2).setPreferredWidth(250);
        theTable.getColumnModel().getColumn(2).setHeaderRenderer(renderer);
        theTable.getColumnModel().getColumn(3).setMinWidth(70);
        theTable.getColumnModel().getColumn(3).setPreferredWidth(70);
        theTable.getColumnModel().getColumn(3).setHeaderRenderer(renderer);
        theTable.getColumnModel().getColumn(4).setMinWidth(60);
        theTable.getColumnModel().getColumn(4).setPreferredWidth(60);
        theTable.getColumnModel().getColumn(4).setHeaderRenderer(renderer);
        theTable.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(theTable);
        scrollPane.setPreferredSize(new Dimension(450, 420));
        dlgPanel.add((Component)lblTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        dlgPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        int reply = JOptionPane.showConfirmDialog(this, dlgPanel, "Fly-off Pilots", 2, -1);
        if (reply != 0) {
            return;
        }
        String[] attrNames = new String[]{"Tag", "Class", "Team", "FAI/AMA Num", "State", "Club"};
        int i2 = 0;
        while (i2 < selections.length) {
            Competitor pilot = this.competition.getMainCompetition().getCompetitorAtPosition(i2);
            if (((Boolean)selections[i2]).booleanValue()) {
                Competitor aPilot = new Competitor(this.competition, pilot.getProperty("First Name"), pilot.getProperty("Last Name"));
                String[] stringArray = attrNames;
                int n = attrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    aPilot.setProperty(attr, pilot.getProperty(attr));
                    ++n2;
                }
                this.competition.addCompetitor(aPilot);
            } else {
                this.competition.removeCompetitor(pilot);
            }
            ++i2;
        }
    }

    @Override
    public void updatePanel() {
        this.dataStructureChanged(null);
    }

    @Override
    public void dataStructureChanged(Competition competition) {
        if (competition != null) {
            super.dataStructureChanged(competition.getFlyoffCompetition());
        } else {
            super.dataStructureChanged(this.competition);
        }
    }
}

