/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.CompetitionTask;
import f3kscore.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class RoundScore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int groupNumber;
    private Competition competition;
    private CompetitionTask lastCalculatedEventTask;
    private Task lastCalculatedTask;
    private int roundNumber;
    private double[] flightTimeVals;
    private int[] flightTimes;
    private int totalTime;
    private double totalTaskTime;
    private int penalty;
    private int landingScore;
    private double launchPenalty;
    private transient Random randGen = new Random();

    public RoundScore(Competition competition, int roundIndex) {
        this.competition = competition;
        this.roundNumber = roundIndex;
        this.groupNumber = 1;
        this.flightTimeVals = new double[20];
        Arrays.fill(this.flightTimeVals, -1.0);
    }

    private void calcTotalTime() {
        CompetitionTask task = this.competition.getRoundTask(this.roundNumber);
        task.calculateTaskResults(this);
        this.lastCalculatedEventTask = task;
    }

    public double getTotalTime() {
        if (this.competition.getRoundTask(this.roundNumber) != this.lastCalculatedEventTask) {
            this.calcTotalTime();
        }
        return this.totalTaskTime;
    }

    public void setTotalTaskTime(double totalTaskTime) {
        this.totalTaskTime = totalTaskTime;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public int getGroupNum() {
        return this.groupNumber;
    }

    public void setGroupNum(int groupNum) {
        if (groupNum < 1 || groupNum > 20) {
            throw new IllegalArgumentException("Group assignment is " + groupNum + ", must be between 1 and " + 20);
        }
        this.groupNumber = groupNum;
        this.competition.setResultsDirty();
    }

    public double getTime(int timeIndex) {
        return this.flightTimeVals[timeIndex];
    }

    public void setTime(int timeIndex, double time) {
        CompetitionTask task = this.competition.getRoundTask(this.roundNumber);
        boolean isAlesTdTask = task.isAlesTdTask();
        int maxTimeCut = task.getMaxTimeCut(timeIndex);
        int minTimeCut = task.getMinTimeCut(timeIndex);
        if (maxTimeCut > 0 && time > (double)maxTimeCut && !isAlesTdTask) {
            time = maxTimeCut;
        }
        if (time < (double)minTimeCut && time > 0.0) {
            time = minTimeCut;
        }
        this.flightTimeVals[timeIndex] = time;
        if (task.isLadderTask()) {
            int i = 0;
            while (i < timeIndex && time > 0.0) {
                this.flightTimeVals[i] = task.getMinTimeCut(i);
                ++i;
            }
            i = timeIndex;
            while (i < this.flightTimeVals.length && time <= 0.0) {
                this.flightTimeVals[i] = -1.0;
                ++i;
            }
        }
        this.calcTotalTime();
        this.competition.setResultsDirty();
    }

    public void clearAllFlightTimes() {
        this.flightTimeVals = new double[20];
        Arrays.fill(this.flightTimeVals, -1.0);
        this.totalTaskTime = -1.0;
        this.launchPenalty = -1.0;
    }

    /*
     * Unable to fully structure code
     */
    public void generateRandomFlightTimes() {
        if (this.randGen == null) {
            this.randGen = new Random();
        }
        this.flightTimeVals = new double[20];
        Arrays.fill(this.flightTimeVals, -1.0);
        task = this.competition.getRoundTask(this.roundNumber);
        timeIndex = 0;
        while (timeIndex < task.getNumFlights()) {
            block12: {
                dblVal = this.randGen.nextDouble();
                maxTimeCut = task.getMaxTimeCut(timeIndex);
                minTimeCut = task.getMinTimeCut(timeIndex);
                if (maxTimeCut <= 0) {
                    maxTimeCut = task.getWindowTime();
                }
                if (minTimeCut < 0) {
                    minTimeCut = 0;
                }
                if (this.competition.getEventType() == 2 && timeIndex == 1) {
                    maxTimeCut = 50;
                }
                if (this.competition.getEventType() == 3 && timeIndex == 1) {
                    maxTimeCut = 100;
                }
                if (this.competition.getEventType() != 4) ** GOTO lbl-1000
                if (timeIndex != 2) break block12;
                maxTimeCut = 250;
                ** GOTO lbl-1000
            }
            if (timeIndex == 3 || timeIndex == 4) {
                if (dblVal > 0.95) {
                    this.flightTimeVals[timeIndex] = minTimeCut;
                }
            } else if (this.competition.getEventType() == 5 && (timeIndex == 2 || timeIndex == 3)) {
                if (dblVal > 0.95) {
                    this.flightTimeVals[timeIndex] = minTimeCut;
                }
            } else {
                this.flightTimeVals[timeIndex] = time = (double)minTimeCut + dblVal * (double)(maxTimeCut - minTimeCut);
                if (task.isLadderTask() && dblVal > 0.8) break;
            }
            ++timeIndex;
        }
        this.totalTaskTime = -1.0;
        this.launchPenalty = -1.0;
        this.calcTotalTime();
        this.competition.setResultsDirty();
    }

    public int getLandingScore() {
        return this.landingScore;
    }

    public void setLandingScore(int landingScore) {
        this.landingScore = landingScore;
    }

    public double getAllFlightsTotalTime() {
        CompetitionTask task = this.competition.getRoundTask(this.roundNumber);
        if (!task.isShortestFlightTask()) {
            return this.getTotalTime();
        }
        int sum = 0;
        int nTimes = task.getNumFlights();
        int i = 0;
        while (i < nTimes) {
            sum = (int)((double)sum + this.flightTimeVals[i]);
            ++i;
        }
        return sum;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.totalTime != 0 && this.totalTaskTime == 0.0) {
            this.totalTaskTime = this.totalTime;
        }
        if (this.flightTimeVals == null && this.flightTimes != null) {
            this.flightTimeVals = new double[this.flightTimes.length];
            int i = 0;
            while (i < this.flightTimes.length) {
                this.flightTimeVals[i] = this.flightTimes[i];
                ++i;
            }
        }
    }

    public double getLaunchPenalty() {
        return this.launchPenalty;
    }

    public void setLaunchPenalty(double launchPenalty) {
        this.launchPenalty = launchPenalty;
    }

    public double[] getFlightTimeVals() {
        return this.flightTimeVals;
    }
}

