/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CompetitionTask;
import f3kscore.F3KScore;
import f3kscore.F3KScoreConstants;
import f3kscore.RoundScore;
import java.io.Serializable;

public final class StdTask
extends Enum<StdTask>
implements Serializable,
F3KScoreConstants,
CompetitionTask {
    public static final /* enum */ StdTask F3K_A = new StdTask(0, "f3k_a", "\"A\" - Last 5:00 in 7:00", "L1x5", "Last flight, 5:00 max, 7:00 window", new int[]{300}, null, 420, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_7min_window.mp3", "window_F3K_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_A2 = new StdTask(0, "f3k_a2", "\"A\" - Last 5:00 in 10:00", "L1x5", "Last flight, 5:00 max, 10:00 window", new int[]{300}, null, 600, false, new String[]{"Max=5:00"}, new String[]{"Max=300s"}, new String[]{"description_task_A_last_flight_10min_window.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_B = new StdTask(0, "f3k_b", "\"B\" - Last 2 x 4:00", "L2x4", "Last 2 flights, 4:00 max, 10:00 window", new int[]{240, 240}, null, 600, false, new String[]{"Max=4:00", "Max=4:00"}, new String[]{"Max=240s", "Max=240s"}, new String[]{"description_task_B_last_two_4min.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_B2 = new StdTask(0, "f3k_b2", "\"B\" - Last 2 x 3:00", "L2x3", "Last 2 flights, 3:00 max, 7:00 window", new int[]{180, 180}, null, 420, false, new String[]{"Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s"}, new String[]{"description_task_B_last_two_3min.mp3", "window_F3K_3_min_prep_7_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C = new StdTask(0, "f3k_c", "\"C\" - All up 3 x 3:00", "AUp", "All up, 3 flights, 3:00 max", new int[]{180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_F3K_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C2 = new StdTask(0, "f3k_c2", "\"C\" - All up 4 x 3:00", "AUp4", "All up, 4 flights, 3:00 max", new int[]{180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_F3K_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_C3 = new StdTask(0, "f3k_c3", "\"C\" - All up 5 x 3:00", "AUp5", "All up, 5 flights, 3:00 max", new int[]{180, 180, 180, 180, 180}, null, 0, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_C_all_up_3_flights.mp3", "window_F3K_3_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3", "window_F3K_1_min_prep_3_min_all_up_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_D = new StdTask(0, "f3k_d", "\"D\" - Two flights only", "2x5.0", "Two flights only, 5:00 max, 10:00 window", new int[]{300, 300}, null, 600, false, new String[]{"Max=5:00", "Max=5:00"}, new String[]{"Max=300s", "Max=300s"}, new String[]{"description_task_D_two_flights_only.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_E = new StdTask(0, "f3k_e2", "\"E\" - Poker in 10:00", "Poker", "Poker, 3 self nominated targets, 10:00 window", new int[3], null, 600, false, new String[]{"Target #1", "Target #2", "Target #3"}, null, new String[]{"description_task_E_poker.mp3", "window_F3K_3_min_prep_10_min_poker_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_E2 = new StdTask(0, "f3k_e3", "\"E\" - Poker in 15:00", "Poker", "Poker, 3 self nominated targets, 15:00 window", new int[3], null, 900, false, new String[]{"Target #1", "Target #2", "Target #3"}, null, new String[]{"description_task_E_poker.mp3", "window_F3K_3_min_prep_15_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_F = new StdTask(0, "f3k_f", "\"F\" - Best 3 of 6", "3of6", "Best 3 flights, 3:00 max, 6 launches only, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_F_3_of_6.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_G = new StdTask(0, "f3k_g", "\"G\" - Best 5 x 2:00", "5x2.0", "Best 5 flights, 2:00 max, 10:00 window", new int[]{120, 120, 120, 120, 120}, null, 600, false, new String[]{"Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00"}, new String[]{"Max=120s", "Max=120s", "Max=120s", "Max=120s", "Max=120s"}, new String[]{"description_task_G_5x2.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_H = new StdTask(0, "f3k_h", "\"H\" - 1:00, 2:00, 3:00, 4:00", "1234", "Best 4 flights, 1:00, 2:00, 3:00, 4:00 max in any order, 10:00 window", new int[]{60, 120, 180, 240}, null, 600, false, new String[]{"Max=1:00", "Max=2:00", "Max=3:00", "Max=4:00"}, new String[]{"Max=60s", "Max=120s", "Max=180s", "Max=240s"}, new String[]{"description_task_H_1_2_3_4.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_I = new StdTask(0, "f3k_i", "\"I\" - Best 3 x 200s", "3200", "Best 3 flights, 200s (3:20) max, 10:00 window", new int[]{200, 200, 200}, null, 600, false, new String[]{"Max=3:20", "Max=3:20", "Max=3:20"}, new String[]{"Max=200s", "Max=200s", "Max=200s"}, new String[]{"description_task_I_3x200s.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_J = new StdTask(0, "f3k_j", "\"J\" - Last 3 x 3:00", "L3x3", "Last 3 flights, 3:00 max, 10:00 window", new int[]{180, 180, 180}, null, 600, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"Max=180s", "Max=180s", "Max=180s"}, new String[]{"description_task_J_last_3x180.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_K = new StdTask(0, "f3k_k", "\"K\" - Big ladder", "BLddr", "Big ladder - 5 flights only, 1:00, 1:30, 2:00, 2:30, 3:00 targets, 10:00 window", new int[]{60, 90, 120, 150, 180}, null, 600, false, new String[]{"Max=1:00", "Max=1:30", "Max=2:00", "Max=2:30", "Max=3:00"}, new String[]{"Max=60s", "Max=90s", "Max=120s", "Max=150s", "Max=180s"}, new String[]{"description_task_K_big_ladder.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_L = new StdTask(0, "f3k_l", "\"L\" - One flight", "1 flght", "One flight only, 10:00 window", new int[1], null, 600, false, new String[]{"Max=10:00"}, new String[]{"Max=600s"}, new String[]{"description_task_L_one_flight_only.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true);
    public static final /* enum */ StdTask F3K_M = new StdTask(0, "f3k_m", "\"M\" - Huge ladder", "HLddr", "Huge ladder - 3 flights only, 3:00, 5:00, 7:00 targets, 15:00 window", new int[]{180, 300, 420}, null, 900, false, new String[]{"Max=3:00", "Max=5:00", "Max=7:00"}, new String[]{"Max=180s", "Max=300s", "Max=420s"}, new String[]{"description_task_M_huge_ladder.mp3", "window_F3K_3_min_prep_15_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_N = new StdTask(0, "f3k_n", "\"N\" - Best Flight", "Best1", "Best flight, unlimited launches, 9:59 max, 10:00 window", new int[]{599}, null, 600, false, new String[]{"Max=9:59"}, new String[]{"Max=599s"}, new String[]{"description_task_N_best_flight.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask F3K_DEUCE_1 = new StdTask(0, "f3k_l", "Deuce in 7:00", "Deuce", "Deuce - Lowest flight of 2 flights, 7:00 window", new int[2], null, 420, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_deuce.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true);
    public static final /* enum */ StdTask F3K_DEUCE_2 = new StdTask(0, "f3k_l2", "Deuce in 10:00", "Deuce", "Deuce - Lowest flight of 2 flights, 10:00 window", new int[2], null, 600, false, new String[]{"Flight #1", "Flight #2"}, null, new String[]{"description_task_deuce.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, true);
    public static final /* enum */ StdTask F3K_TWO_FLIGHTS = new StdTask(0, "f3k_d", "Two flights only, 2 x 3:30", "2x3.5", "Two flights only, 3:30 max, 7:00 window", new int[]{210, 210}, null, 420, false, new String[]{"Max=3:30", "Max=3:30"}, new String[]{"Max=210s", "Max=210s"}, new String[]{"description_task_two_flights_only_7min_window.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
    public static final /* enum */ StdTask ALES_TD_6 = new StdTask(2, "ales_6", "ALES/TD - 6:00 max", "6:00", "Normalized duration, landing scored separately, 6:00 maximum", new int[]{360, 100}, null, 360, false, new String[]{"Max=6:00", "Landing"}, new String[]{"Max=360s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing\nPoints"}, false);
    public static final /* enum */ StdTask ALES_TD_8 = new StdTask(2, "ales_8", "ALES/TD - 8:00 max", "8:00", "Normalized duration, landing scored separately, 8:00 maximum", new int[]{480, 100}, null, 480, false, new String[]{"Max=8:00", "Landing"}, new String[]{"Max=480s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing\nPoints"}, false);
    public static final /* enum */ StdTask ALES_TD_10 = new StdTask(2, "ales_10", "ALES/TD - 10:00 max", "10:00", "Normalized duration, landing scored separately, 10:00 maximum", new int[]{600, 100}, null, 600, false, new String[]{"Max=10:00", "Landing"}, new String[]{"Max=600s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing\nPoints"}, false);
    public static final /* enum */ StdTask ALES_TD_15 = new StdTask(2, "ales_15", "ALES/TD - 15:00 max", "15:00", "Normalized duration, landing scored separately, 15:00 maximum", new int[]{900, 100}, null, 900, false, new String[]{"Max=15:00", "Landing"}, new String[]{"Max=900s", "Landing"}, new String[]{"window_ALES_3_min_prep_and_10_sec_launch.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3", "silence_1_minute.mp3"}, new String[]{"Time", "Landing\nPoints"}, false);
    public static final /* enum */ StdTask F5J_10;
    public static final /* enum */ StdTask F5J_15;
    public static final /* enum */ StdTask F3B_SPEED;
    public static final /* enum */ StdTask F3K_1x10;
    public static final /* enum */ StdTask F3J_10;
    public static final /* enum */ StdTask F3J_15;
    public static final /* enum */ StdTask F3K_LADDER;
    private static final long serialVersionUID = 1L;
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private String codedName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private String[] scoreCardTextTips;
    private String[] scoreCardTextTipsSecondsOnly;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean isShortestFlightTask;
    private int taskType = 0;
    private static final /* synthetic */ StdTask[] ENUM$VALUES;

    static {
        int[] nArray = new int[5];
        nArray[0] = 599;
        nArray[1] = 50;
        nArray[3] = 1;
        nArray[4] = 1;
        int[] nArray2 = new int[5];
        nArray2[1] = 5;
        nArray2[3] = 1;
        nArray2[4] = 1;
        F5J_10 = new StdTask(1, "f5j_10", "F5J - 10:00", "10:00", "F5J duration, 10:00 window", nArray, nArray2, 600, false, new String[]{"Time", "Landing", "Launch Altitude", "Late Landing?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_10_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing\nPoints", "Launch\nAltitude", "Late\nLndg?", ">75m?"}, false);
        int[] nArray3 = new int[5];
        nArray3[0] = 899;
        nArray3[1] = 50;
        nArray3[3] = 1;
        nArray3[4] = 1;
        int[] nArray4 = new int[5];
        nArray4[1] = 5;
        nArray4[3] = 1;
        nArray4[4] = 1;
        F5J_15 = new StdTask(1, "f5j_15", "F5J - 15:00", "15:00", "F5J duration, 15:00 window", nArray3, nArray4, 900, false, new String[]{"Time", "Landing", "Launch Altitude", "Late Landing?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_15_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing\nPoints", "Launch\nAltitude", "Late\nLndg?", ">75m?"}, false);
        F3B_SPEED = new StdTask(4, "f3b_speed", "F3B speed", "F3B", "F3F/F3B type speed task", new int[1], null, 0, false, null, null, null, null, false);
        F3K_1x10 = new StdTask(0, "f3k_1x10", "Best 10 x 1:00", "10x1", "Best 10 flights, 1:00 max, 10:00 window", new int[]{60, 60, 60, 60, 60, 60, 60, 60, 60, 60}, null, 600, false, new String[]{"Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00", "Max=1:00"}, new String[]{"Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s", "Max=60s"}, new String[]{"description_task_10x1min.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
        int[] nArray5 = new int[4];
        nArray5[1] = 30;
        nArray5[2] = 1;
        nArray5[3] = 1;
        F3J_10 = new StdTask(3, "f3j_10", "F3J - 10:00", "10:00", "F3J duration, 10:00 window", new int[]{599, 100, 1, 1}, nArray5, 600, false, new String[]{"Time (1:23.4)", "Landing Points", "Late Lndg?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_10_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing\nPoints", "Late\nLndg?", ">75m?"}, false);
        int[] nArray6 = new int[4];
        nArray6[1] = 30;
        nArray6[2] = 1;
        nArray6[3] = 1;
        F3J_15 = new StdTask(3, "f3j_15", "F3J - 15:00", "15:00", "F3J duration, 15:00 window", new int[]{899, 100, 1, 1}, nArray6, 900, false, new String[]{"Time (1:23.4)", "Landing Points", "Late Lndg?", " >75m?"}, null, new String[]{"window_F5J_3_min_prep_15_min_working_1_min_landing.mp3"}, new String[]{"Time", "Landing\nPoints", "Late\nLndg?", ">75m?"}, false);
        F3K_LADDER = new StdTask(0, "f3k_d", "Ladder +15 sec", "Laddr", "Increasing times - 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00, in 10:00 window", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}, 600, true, new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"}, new String[]{"30s", "45s", "60s", "75s", "90s", "105s", "120s"}, new String[]{"description_task_ladder.mp3", "window_F3K_3_min_prep_10_min_working_30_sec_landing.mp3"}, null, false);
        ENUM$VALUES = new StdTask[]{F3K_A, F3K_A2, F3K_B, F3K_B2, F3K_C, F3K_C2, F3K_C3, F3K_D, F3K_E, F3K_E2, F3K_F, F3K_G, F3K_H, F3K_I, F3K_J, F3K_K, F3K_L, F3K_M, F3K_N, F3K_DEUCE_1, F3K_DEUCE_2, F3K_TWO_FLIGHTS, ALES_TD_6, ALES_TD_8, ALES_TD_10, ALES_TD_15, F5J_10, F5J_15, F3B_SPEED, F3K_1x10, F3J_10, F3J_15, F3K_LADDER};
    }

    private StdTask(int taskType, String codedName, String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isLadderTask, String[] scoreCardTextTips, String[] scoreCardTextTipsSecondsOnly, String[] playList, String[] columnTitles, boolean isShortestFlightTask) {
        this.taskType = taskType;
        this.codedName = codedName;
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        this.scoreCardTextTips = scoreCardTextTips;
        this.scoreCardTextTipsSecondsOnly = scoreCardTextTipsSecondsOnly;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.isShortestFlightTask = isShortestFlightTask;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
    }

    @Override
    public boolean isSpeedTask() {
        return this.taskType == 4;
    }

    @Override
    public boolean isLadderTask() {
        return this.isLadderTask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getDescription() {
        return this.longName;
    }

    @Override
    public int getNumFlights() {
        return this.numFlights;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    @Override
    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }

    @Override
    public int getWindowTime() {
        return this.windowTime;
    }

    @Override
    public String[] getScoreCardTextTips() {
        if (F3KScore.editor().getCompetition().isUseSecondsForFlightTimes() && this.scoreCardTextTipsSecondsOnly != null) {
            return this.scoreCardTextTipsSecondsOnly;
        }
        return this.scoreCardTextTips;
    }

    @Override
    public String[] getPlaylist() {
        return this.playList;
    }

    @Override
    public String[] getFlightTimesColumnTitles() {
        return this.flightTimesColumnTitles;
    }

    @Override
    public boolean hasLandingScore() {
        return this.taskType == 2 || this.taskType == 1 || this.taskType == 3;
    }

    @Override
    public boolean isLandingScoredSeparately() {
        return this.taskType == 2;
    }

    @Override
    public boolean isShortestFlightTask() {
        return this.isShortestFlightTask;
    }

    @Override
    public boolean isF5Jtask() {
        return this.taskType == 1;
    }

    @Override
    public boolean isF3Jtask() {
        return this.taskType == 3;
    }

    @Override
    public boolean isF3Ktask() {
        return this.taskType == 0;
    }

    @Override
    public boolean isAlesTdTask() {
        return this.taskType == 2;
    }

    @Override
    public String getCodedName() {
        if (this.codedName == null) {
            StdTask[] stdTaskArray = StdTask.values();
            int n = stdTaskArray.length;
            int n2 = 0;
            while (n2 < n) {
                StdTask task = stdTaskArray[n2];
                if (this.shortName != null ? task.getShortName().equals(this.shortName) : task.getName().equals(this.name)) {
                    return task.getCodedName();
                }
                ++n2;
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 420) {
                return F3K_A.getCodedName();
            }
            if (this.name.startsWith("\"A\"") && this.windowTime == 600) {
                return F3K_A2.getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 600) {
                return F3K_B.getCodedName();
            }
            if (this.name.startsWith("\"B\"") && this.windowTime == 420) {
                return F3K_B2.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 3) {
                return F3K_C.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 4) {
                return F3K_C2.getCodedName();
            }
            if (this.name.startsWith("\"C\"") && this.numFlights == 5) {
                return F3K_C3.getCodedName();
            }
            if (this.name.startsWith("\"D\"")) {
                return F3K_D.getCodedName();
            }
            if (this.name.startsWith("\"E\"")) {
                return F3K_E.getCodedName();
            }
            if (this.name.startsWith("\"F\"")) {
                return F3K_F.getCodedName();
            }
            if (this.name.startsWith("\"G\"")) {
                return F3K_G.getCodedName();
            }
            if (this.name.startsWith("\"H\"")) {
                return F3K_H.getCodedName();
            }
            if (this.name.startsWith("\"I\"")) {
                return F3K_I.getCodedName();
            }
            if (this.name.startsWith("\"J\"")) {
                return F3K_J.getCodedName();
            }
        }
        return this.codedName;
    }

    @Override
    public void setCodedName(String codedName) {
        this.codedName = codedName;
    }

    @Override
    public void calculateTaskResults(RoundScore roundScore) {
        double maxAllowedTime;
        double[] flightTimeVals = roundScore.getFlightTimeVals();
        if (flightTimeVals == null || flightTimeVals.length == 0) {
            return;
        }
        if (this.isF5Jtask()) {
            this.calculateTaskResultsF5J(roundScore);
            return;
        }
        if (this.isF3Jtask()) {
            this.calculateTaskResultsF3J(roundScore);
            return;
        }
        double totalTaskTime = -1.0;
        boolean isShortestFlightTask = this.isShortestFlightTask();
        boolean isAlesTdTask = this.isAlesTdTask();
        boolean isF3Ktask = this.isF3Ktask();
        int nonZeroTimeCount = 0;
        int nTimes = this.getNumFlights();
        int landingScore = 0;
        double launchPenalty = -1.0;
        if (isAlesTdTask) {
            nTimes = 1;
            landingScore = (int)flightTimeVals[1];
            if (landingScore < 0) {
                landingScore = 0;
            } else {
                int remainder = landingScore % 5;
                flightTimeVals[1] = landingScore -= remainder;
            }
        }
        double shortestFlight = 10000.0;
        int i = 0;
        while (i < nTimes) {
            double time = flightTimeVals[i];
            if (time >= 0.0) {
                if (isAlesTdTask && time > (double)this.getMaxTimeCut(i)) {
                    time = (double)(2 * this.getMaxTimeCut(i)) - time;
                }
                totalTaskTime += time;
                ++nonZeroTimeCount;
            }
            if (time < shortestFlight) {
                shortestFlight = time;
            }
            ++i;
        }
        if (nonZeroTimeCount > 0) {
            totalTaskTime += 1.0;
            if (isShortestFlightTask && (totalTaskTime = shortestFlight) < 0.0) {
                totalTaskTime = 0.0;
            }
        }
        if (isF3Ktask && this.getWindowTime() > 0 && totalTaskTime > (maxAllowedTime = (double)(this.getWindowTime() - nonZeroTimeCount))) {
            totalTaskTime = maxAllowedTime;
        }
        roundScore.setTotalTaskTime(totalTaskTime);
        roundScore.setLandingScore(landingScore);
        roundScore.setLaunchPenalty(launchPenalty);
    }

    public void calculateTaskResultsF5J(RoundScore roundScore) {
        double totalTaskTime = -1.0;
        boolean nonZeroTime = true;
        double[] flightTimeVals = roundScore.getFlightTimeVals();
        double time = flightTimeVals[0];
        int landingScore = (int)flightTimeVals[1];
        if (landingScore > 0) {
            int remainder = landingScore % 5;
            flightTimeVals[1] = landingScore -= remainder;
        }
        double launchAlt = flightTimeVals[2];
        boolean lateLndg = flightTimeVals[3] > 0.0;
        boolean land75m = flightTimeVals[4] > 0.0;
        double launchPenalty = -1.0;
        if (time <= 0.0 || launchAlt <= 0.0 || land75m) {
            totalTaskTime = -1.0;
            nonZeroTime = false;
        } else if (lateLndg) {
            landingScore = 0;
        }
        if (nonZeroTime) {
            int altitude = (int)launchAlt;
            launchPenalty = altitude <= 200 ? (double)altitude / 2.0 : 100.0 + (double)(altitude - 200) * 3.0;
            totalTaskTime = time + (double)landingScore - launchPenalty;
        }
        roundScore.setTotalTaskTime(totalTaskTime);
        roundScore.setLandingScore(0);
        roundScore.setLaunchPenalty(launchPenalty);
    }

    public void calculateTaskResultsF3J(RoundScore roundScore) {
        boolean land75m;
        double totalTaskTime = -1.0;
        boolean nonZeroTime = true;
        double[] flightTimeVals = roundScore.getFlightTimeVals();
        double time = flightTimeVals[0];
        int landingScore = (int)flightTimeVals[1];
        if (landingScore > 0 && landingScore < 90) {
            int remainder = landingScore % 5;
            flightTimeVals[1] = landingScore -= remainder;
        }
        boolean lateLndg = flightTimeVals[2] > 0.0;
        boolean bl = land75m = flightTimeVals[3] > 0.0;
        if (time <= 0.0 || land75m) {
            totalTaskTime = -1.0;
            nonZeroTime = false;
        } else if (lateLndg) {
            landingScore = 0;
            time -= 30.0;
        }
        if (nonZeroTime) {
            totalTaskTime = time + (double)landingScore;
        }
        roundScore.setTotalTaskTime(totalTaskTime);
        roundScore.setLandingScore(0);
        roundScore.setLaunchPenalty(0.0);
    }

    public static StdTask[] values() {
        StdTask[] stdTaskArray = ENUM$VALUES;
        int n = stdTaskArray.length;
        StdTask[] stdTaskArray2 = new StdTask[n];
        System.arraycopy(ENUM$VALUES, 0, stdTaskArray2, 0, n);
        return stdTaskArray2;
    }

    public static StdTask valueOf(String string) {
        return Enum.valueOf(StdTask.class, string);
    }
}

