/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.Team;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class TeamScoresPane
extends AbstractF3KScoreEditorPanel {
    private static final int MIN_ROWS = 0;
    private static final int RANK_COL = 0;
    private static final int TEAM_NAME_COL = 1;
    private static final int PILOTNAME_COL = 2;
    private static final int PILOTSCORE_COL = 3;
    private static final int TEAMSCORE_COL = 4;
    private String[] colNames = new String[]{"", "Team name", "Pilot name", "Pilot score", "Team score", ""};
    private int[] colWidths = new int[]{35, 250, 150, 100, 100, 100};
    private NumberFormat defaultFormatter = NumberFormat.getNumberInstance();
    private NumberFormat score1000formatter = NumberFormat.getNumberInstance();
    private JPopupMenu popupMenu;
    private JMenuItem copyMenuItem;

    public TeamScoresPane(Competition competition) {
        this.competition = competition;
        this.createTable(new TeamScoresTableModel());
        this.configureColumnWidths();
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter.setPasteEnabled(false);
        this.defaultFormatter.setMinimumFractionDigits(1);
        this.defaultFormatter.setMaximumFractionDigits(1);
        this.score1000formatter.setMinimumFractionDigits(0);
        this.score1000formatter.setMaximumFractionDigits(0);
        this.addLastColumnAutoResizer();
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configureColumnWidths() {
        int i = 0;
        while (i < this.colWidths.length) {
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidths[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            ++i;
        }
        this.resizeLastColumnWidth();
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TeamScoresPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
        }
        return this.popupMenu;
    }

    private class TeamScoresTableModel
    extends AbstractTableModel {
        private TeamScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            TeamScoresPane.this.configureColumnWidths();
        }

        @Override
        public int getColumnCount() {
            return TeamScoresPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            int rowCount = 0;
            if (TeamScoresPane.this.competition == null || TeamScoresPane.this.competition.getTeams() == null) {
                return 0;
            }
            for (Team team : TeamScoresPane.this.competition.getTeams()) {
                if (team.getPilotList() == null || team.getPilotList().size() == 0) continue;
                if (rowCount > 0) {
                    ++rowCount;
                }
                rowCount += team.getPilotList().size();
            }
            if (rowCount < 0) {
                rowCount = 0;
            }
            return rowCount;
        }

        @Override
        public String getColumnName(int col) {
            return TeamScoresPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            int index = 0;
            int rank = 0;
            for (Team team : TeamScoresPane.this.competition.getTeams()) {
                ++rank;
                if (index == row) {
                    if (col == 0) {
                        return rank;
                    }
                    if (col == 1) {
                        return team.getName();
                    }
                    if (col == 4) {
                        double score = team.getTeamScore();
                        if (score == 0.0) {
                            return null;
                        }
                        if (score == 1000.0) {
                            return TeamScoresPane.this.score1000formatter.format(score);
                        }
                        return TeamScoresPane.this.defaultFormatter.format(score);
                    }
                }
                for (Competitor pilot : team.getPilotList()) {
                    if (index == row) {
                        if (col == 2) {
                            return pilot.getFullName();
                        }
                        if (col == 3) {
                            double score = pilot.calculateTotalScore();
                            if (score == 0.0) {
                                return null;
                            }
                            if (score == 1000.0) {
                                return TeamScoresPane.this.score1000formatter.format(score);
                            }
                            return TeamScoresPane.this.defaultFormatter.format(score);
                        }
                    }
                    ++index;
                }
                if (index == row) {
                    return null;
                }
                ++index;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

