/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.ExcelSpreadsheetWriter;
import f3kscore.F3KScore;
import f3kscore.F3kFileFilter;
import f3kscore.RoundScoresPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class UploadClient
implements ActionListener {
    private JTextField txtFileName;
    private JButton btnBrowse;
    private JTextField txtURL;
    private JTextField txtPwd;
    private boolean overwrite;
    private File file;
    private JPanel panelContents;
    public static UploadClient uploadClient;
    private File f3kFile;

    public static boolean uploadExcelFile(File filename, String url, String pwd) {
        boolean retval = false;
        DefaultHttpClient F3kScoreClient = new DefaultHttpClient();
        HttpPost F3kStatsPost = new HttpPost(url);
        FileBody excelFile = new FileBody(filename);
        try {
            StringBody password = new StringBody(pwd);
            StringBody command = new StringBody("UploadF3KScoreExcelFile");
            StringBody upload = new StringBody("Upload");
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("File", (ContentBody)excelFile);
            reqEntity.addPart("Command", (ContentBody)command);
            reqEntity.addPart("Upload", (ContentBody)upload);
            reqEntity.addPart("Password", (ContentBody)password);
            F3kStatsPost.setEntity((HttpEntity)reqEntity);
            HttpResponse response = F3kScoreClient.execute((HttpUriRequest)F3kStatsPost);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode == 200) {
                retval = true;
            } else {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed upload status returned by the F3K web-server\n\nServer reponse:\n\"%s\"", status.getReasonPhrase()), "Upload failed", 0);
                retval = false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(F3KScore.editor(), String.valueOf(e.getMessage()) + "\n\n" + F3KScore.stackTraceToString(e), "Upload error", 0);
            retval = true;
        }
        return retval;
    }

    public static void uploadResults() {
        Competition competition = F3KScore.editor().getCompetition();
        if (competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "You have no competition data loaded.", "No competition data", 0);
            return;
        }
        if (uploadClient == null) {
            uploadClient = new UploadClient();
        }
        uploadClient.upload();
    }

    private void upload() {
        String pwd;
        int reply;
        Competition competition = F3KScore.editor().getCompetition();
        if (this.panelContents == null) {
            JLabel lblFileName = new JLabel(String.format("<html>To upload the results, a new Excel workbook file with all contest data will be created.<br><br>To control how the F3K server displays your contest, change the Excel file name!<br><br>Name of Excel file that will be created and uploaded:", new Object[0]));
            this.txtFileName = new JTextField();
            this.btnBrowse = this.createButton("Browse...", "BROWSE", new Dimension(70, 22));
            JPanel panelExcelFile = new JPanel(new GridBagLayout());
            panelExcelFile.add((Component)this.txtFileName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panelExcelFile.add((Component)this.btnBrowse, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            JLabel lblURL = new JLabel("URL of F3K web-server:");
            this.txtURL = new JTextField();
            this.txtURL.setText("https://www.hemidata.com/F3k/");
            JLabel lblPwd = new JLabel("Password:");
            this.txtPwd = new JTextField();
            this.panelContents = new JPanel(new GridBagLayout());
            this.panelContents.setPreferredSize(new Dimension(500, 180));
            this.panelContents.add((Component)lblFileName, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)panelExcelFile, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)lblURL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)this.txtURL, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)lblPwd, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)this.txtPwd, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.add((Component)new JLabel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.panelContents.setPreferredSize(new Dimension(650, 180));
        }
        if (this.f3kFile != F3KScore.editor().getLoadedFile()) {
            this.f3kFile = F3KScore.editor().getLoadedFile();
            String name = this.f3kFile.getAbsolutePath();
            name = String.valueOf(name.substring(0, name.lastIndexOf(46))) + ".xlsx";
            this.txtFileName.setText(name);
        }
        if ((reply = JOptionPane.showOptionDialog(F3KScore.editor(), this.panelContents, String.format("F3KScore: upload results to F3K web-server", new Object[0]), 2, -1, null, new String[]{"Upload", "Cancel"}, null)) != 0) {
            return;
        }
        if (this.txtFileName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "No file name entered for uploading to the F3K web-server", "No file name entered", 0);
            return;
        }
        this.file = new File(this.txtFileName.getText());
        String url = this.txtURL.getText().trim();
        if (url.length() == 0) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "No URL entered for the F3K web-server", "No URL entered", 0);
            return;
        }
        if (!url.endsWith("/service")) {
            url = url.endsWith("/") ? String.valueOf(url) + "service" : String.valueOf(url) + "/service";
        }
        if ((pwd = this.txtPwd.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "No password entered for the F3K web-server", "No password entered", 0);
            return;
        }
        this.overwrite = true;
        if (this.overwrite) {
            try {
                ExcelSpreadsheetWriter xlWriter = new ExcelSpreadsheetWriter();
                F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getRegistrationPane(), "Pilot List", competition.getCompetitorCount(), F3KScore.editor().getRegistrationPane().getTableModel().getColumnCount() - 1, xlWriter);
                F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getTasksPane(), "Task List", -1, F3KScore.editor().getTasksPane().getTableModel().getColumnCount(), xlWriter);
                F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getGroupsPane(), "Flight Matrix", -1, F3KScore.editor().getGroupsPane().getTableModel().getColumnCount() - 1, xlWriter);
                int roundIndex = 0;
                while (roundIndex < competition.getNumberOfRounds()) {
                    ((RoundScoresPane)F3KScore.editor().getRoundScoresPane()).selectRound(roundIndex);
                    String sheetName = String.format("Round-%d", roundIndex + 1);
                    F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getRoundScoresPane(), sheetName, -1, F3KScore.editor().getRoundScoresPane().getTableModel().getColumnCount() - 1, xlWriter);
                    ++roundIndex;
                }
                F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getTotalScoresPane(), "Total Scores", -1, F3KScore.editor().getTotalScoresPane().getTableModel().getColumnCount() - 1, xlWriter);
                F3KScore.editor().exportTableToExcelFile(F3KScore.editor().getTeamsPane(), "Team Scores", -1, F3KScore.editor().getTeamsPane().getTableModel().getColumnCount() - 1, xlWriter);
                xlWriter.saveAs(this.file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Failed when writing results to file \"%s\":\n\n%s", this.file.getName(), ex.getLocalizedMessage()));
                return;
            }
        }
        F3KScore.editor().setCursor(Cursor.getPredefinedCursor(3));
        boolean res = UploadClient.uploadExcelFile(this.file, url, pwd);
        F3KScore.editor().setCursor(Cursor.getDefaultCursor());
        if (res) {
            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Upload to the F3K server finished successfully", new Object[0]), "Upload finished", 1);
        }
    }

    private JButton createButton(String text, String command, Dimension dim) {
        JButton btn = new JButton(text);
        btn.addActionListener(this);
        btn.setActionCommand(command);
        btn.setMargin(new Insets(0, 5, 0, 5));
        if (dim != null) {
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setPreferredSize(dim);
            btn.setMinimumSize(dim);
        }
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("BROWSE")) {
            this.browseExcelFile();
        }
    }

    private void browseExcelFile() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select file name for uploading to the F3K web-server");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new F3kFileFilter("xlsx", "Excel files (.xlsx)"));
        fileChooser.setCurrentDirectory(F3KScore.editor().getCurrentDir());
        String name = F3KScore.editor().getCompetition().getCompetitionName();
        fileChooser.setSelectedFile(new File(name == null ? "Contest-data" : name));
        int returnVal = fileChooser.showDialog(F3KScore.editor(), "Select");
        File file = null;
        if (returnVal == 0) {
            F3KScore.editor().setCurrentDir(fileChooser.getCurrentDirectory());
            file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("xlsx")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".xlsx");
            }
            this.overwrite = true;
            this.txtFileName.setText(file.getAbsolutePath());
            return;
        }
    }
}

