/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.CSVReader;
import f3kscore.CSVWriter;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelSpreadsheetReader;
import f3kscore.ExcelSpreadsheetWriter;
import f3kscore.F3KScore;
import f3kscore.F3kFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class MergeResultsUtils {
    private static F3KScore editor;
    private static F3kFileFilter csvFilter;
    private static F3kFileFilter xlsxFilter;
    private static MyTableModel tableModel;
    private static JTable table;
    private static int RANK;
    private static int PILOT_NAME;
    private static int STATE;
    private static int CLASS;
    private static int BEST_FOUR;
    private static int FIRST_CONTEST;

    static {
        csvFilter = new F3kFileFilter("csv", "Comma separated value files (.csv)");
        xlsxFilter = new F3kFileFilter("xlsx", "Excel files (.xlsx)");
        RANK = 0;
        PILOT_NAME = 1;
        STATE = 2;
        CLASS = 3;
        BEST_FOUR = 4;
        FIRST_CONTEST = 5;
    }

    public static void mergeResults(F3KScore editor, boolean openExisting) {
        File resultsFile;
        MergeResultsUtils.editor = editor;
        if (openExisting) {
            resultsFile = MergeResultsUtils.chooseTourResultsFile();
            if (resultsFile == null) {
                return;
            }
        } else {
            resultsFile = new File(editor.getCurrentDir(), "F3K Tour Results");
        }
        JTextField txtNumBest = new JTextField("4");
        txtNumBest.setColumns(4);
        JLabel lblNumBest = new JLabel("Number of best scores to use for pilot rankings: ");
        JPanel pnl = new JPanel();
        pnl.add(lblNumBest);
        pnl.add(txtNumBest);
        int reply = JOptionPane.showConfirmDialog(editor, pnl, "Enter number of best scores to use for pilot rankings", 2);
        if (reply != 0) {
            return;
        }
        String val = txtNumBest.getText().trim();
        int numBest = 4;
        try {
            numBest = Integer.parseInt(val);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer number", val), "Invalid entry", 0);
            return;
        }
        if (numBest < 1) {
            JOptionPane.showMessageDialog(editor, String.format("Invalid value \"%s\", must be a positive integer number", val), "Invalid entry", 0);
            return;
        }
        List<String[]> fileData = MergeResultsUtils.readTourResultsFile(resultsFile);
        if (fileData == null) {
            return;
        }
        final List<String[]> mergedData = MergeResultsUtils.mergeNewDataIntoTourResults(fileData, editor.getCompetition(), numBest);
        if (mergedData == null) {
            return;
        }
        final JDialog mergeDlg = new JDialog((Frame)editor, String.format("F3KScore: Merged tour/series results \"%s\"", resultsFile.getName()));
        mergeDlg.setSize(800, 650);
        mergeDlg.setLocationRelativeTo(editor);
        mergeDlg.setModal(true);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.add(new JMenuItem(new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.saveMergedResults(resultsFile, mergedData);
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                mergeDlg.setVisible(false);
            }
        }));
        JMenu sortMenu = new JMenu("Sort");
        menuBar.add(sortMenu);
        sortMenu.add(new JMenuItem(new AbstractAction("By Rank"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(BEST_FOUR, true, true);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By Name"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(PILOT_NAME, false, false);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By State"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(STATE, false, false);
            }
        }));
        sortMenu.add(new JMenuItem(new AbstractAction("By Class"){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.sortTableData(CLASS, false, false);
            }
        }));
        tableModel = new MyTableModel(mergedData);
        table = new JTable(tableModel);
        JScrollPane pane = new JScrollPane(table);
        table.setAutoResizeMode(0);
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(60);
        table.getColumnModel().getColumn(3).setPreferredWidth(60);
        table.getColumnModel().getColumn(4).setPreferredWidth(90);
        Dimension dim = new Dimension(90, 25);
        JButton btnSave = new JButton("Save...");
        btnSave.setMargin(new Insets(0, 0, 0, 0));
        btnSave.setPreferredSize(dim);
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MergeResultsUtils.saveMergedResults(resultsFile, mergedData);
            }
        });
        JButton btnClose = new JButton("Close");
        btnClose.setMargin(new Insets(0, 0, 0, 0));
        btnClose.setPreferredSize(dim);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mergeDlg.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)menuBar, "North");
        panel.add((Component)pane, "Center");
        JPanel pnlBtns = new JPanel();
        pnlBtns.add(btnSave);
        pnlBtns.add(btnClose);
        panel.add((Component)pnlBtns, "South");
        mergeDlg.add(panel);
        mergeDlg.setVisible(true);
    }

    private static void saveMergedResults(File resultsFile, List<String[]> mergedData) {
        block15: {
            if ((resultsFile = MergeResultsUtils.chooseFileExport(resultsFile)) == null) {
                return;
            }
            String ext = F3kFileFilter.getExtension(resultsFile);
            CSVWriter writer = null;
            try {
                try {
                    if (ext.equalsIgnoreCase("csv")) {
                        writer = new CSVWriter(new FileWriter(resultsFile));
                        writer.writeAll(mergedData);
                        break block15;
                    }
                    ExcelSpreadsheetWriter.writeAll(resultsFile, "F3K Results", mergedData, true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(editor, String.format("Failed when writing tour/series results to file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File write error", 0);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File chooseTourResultsFile() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select tour/series results file or enter a new name");
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.addChoosableFileFilter(xlsxFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(editor.getCurrentDir());
        int returnVal = fileChooser.showDialog(editor, "Open");
        if (returnVal == 0) {
            editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("xlsx")) {
                file = fileChooser.getFileFilter() == xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : (fileChooser.getFileFilter() == csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx"));
            }
            if (!file.exists()) {
                int reply = JOptionPane.showConfirmDialog(editor, String.format("File \"%s\" does not exist. A new file will be created when you save the data.", file.getAbsolutePath()), "File not found", 2, 3);
                if (reply == 0) {
                    return file;
                }
                return null;
            }
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(editor, String.format("File \"%s\" could not be opened for reading", file.getAbsolutePath()), "File not readable", 0);
                return null;
            }
            return file;
        }
        return null;
    }

    private static List<String[]> readTourResultsFile(File resultsFile) {
        List<String[]> list;
        if (!resultsFile.exists()) {
            String[] header = new String[]{"Rank", "Name", "State", "Class", "Best 4 scores"};
            ArrayList<String[]> newResults = new ArrayList<String[]>();
            newResults.add(header);
            return newResults;
        }
        InputStreamReader fr = null;
        try {
            String ext = F3kFileFilter.getExtension(resultsFile);
            if (ext.equalsIgnoreCase("csv")) {
                fr = new FileReader(resultsFile);
                CSVReader reader = new CSVReader(fr);
                List<String[]> list2 = reader.readAll();
                return list2;
            }
            list = ExcelSpreadsheetReader.readAll(resultsFile, 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(editor, String.format("Failed when reading tour/series results file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File read error", 0);
            return null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(editor, String.format("Failed when reading tour/series results file \"%s\": %n%n%s", resultsFile.getName(), e.getLocalizedMessage()), "File read error", 0);
            return null;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    static List<String[]> mergeNewDataIntoTourResults(List<String[]> tourResults, Competition competition, int numBest) {
        String[] newDataLine;
        String numBestString;
        ArrayList<String[]> newResults = new ArrayList<String[]>();
        String[] header = tourResults.remove(0);
        if (header.length < 5) {
            JOptionPane.showMessageDialog(editor, "Invalid data format. Must have at least 5 columns.", "Invalid data format", 0);
            return null;
        }
        header[4] = numBestString = String.format("%d best scores", numBest);
        header = Arrays.copyOf(header, header.length + 1);
        String name = competition.getCompetitionName();
        header[header.length - 1] = name == null ? "" : name;
        int nContests = header.length - 5;
        HashMap<String, Competitor> newContestPilots = new HashMap<String, Competitor>();
        int i = 0;
        while (i < competition.getCompetitorCount()) {
            Competitor pilot = competition.getCompetitor(i);
            newContestPilots.put(pilot.getFullName(), pilot);
            ++i;
        }
        HashMap<Object, String[]> pilotDataByName = new HashMap<Object, String[]>();
        for (String[] line : tourResults) {
            String pilotName = line[1];
            newDataLine = Arrays.copyOf(line, line.length + 1);
            double[] scores = new double[nContests];
            int i2 = 0;
            while (i2 < nContests - 1) {
                String val = line[i2 + FIRST_CONTEST];
                if (!val.equals("")) {
                    try {
                        scores[i2] = Double.parseDouble(val);
                    }
                    catch (NumberFormatException e) {
                        int reply = JOptionPane.showConfirmDialog(editor, String.format("Failed when reading scores for pilot \"%s\": \"%s\" value will be replaced with 0.0\nDo you want to continue loading the file?", pilotName, val), "Invalid data format", 2);
                        if (reply != 0) {
                            return null;
                        }
                        scores[i2] = 0.0;
                    }
                }
                ++i2;
            }
            if (newContestPilots.get(pilotName) != null) {
                Competitor pilot = (Competitor)newContestPilots.remove(pilotName);
                if ((double)pilot.getPercent() == 0.0) continue;
                scores[nContests - 1] = pilot.getPercent();
                newDataLine[line.length] = String.format("%.2f", Float.valueOf(pilot.getPercent()));
                if (newDataLine[STATE].equals("") && !pilot.getCountry().equals("")) {
                    newDataLine[MergeResultsUtils.STATE] = pilot.getCountry();
                }
                if (newDataLine[CLASS].equals("") && !pilot.getCompetitorClass().equals("")) {
                    newDataLine[MergeResultsUtils.CLASS] = pilot.getCompetitorClass();
                }
            }
            Arrays.sort(scores);
            double bestFour = 0.0;
            int count = 0;
            int index = scores.length - 1;
            while (count < numBest && index >= 0) {
                bestFour += scores[index];
                ++count;
                --index;
            }
            newDataLine[MergeResultsUtils.BEST_FOUR] = String.format("%.2f", bestFour);
            pilotDataByName.put(pilotName, newDataLine);
        }
        int count = pilotDataByName.size();
        for (Competitor pilot : newContestPilots.values()) {
            if ((double)pilot.getPercent() == 0.0) continue;
            newDataLine = new String[nContests + 5];
            newDataLine[MergeResultsUtils.RANK] = String.valueOf(count++);
            newDataLine[MergeResultsUtils.PILOT_NAME] = pilot.getFullName();
            newDataLine[MergeResultsUtils.STATE] = pilot.getCountry();
            newDataLine[MergeResultsUtils.CLASS] = pilot.getCompetitorClass();
            newDataLine[MergeResultsUtils.BEST_FOUR] = String.format("%.2f", Float.valueOf(pilot.getPercent()));
            newDataLine[MergeResultsUtils.BEST_FOUR + nContests] = newDataLine[BEST_FOUR];
            pilotDataByName.put(pilot.getFullName(), newDataLine);
        }
        TreeSet<String[]> sortedData = new TreeSet<String[]>(new DataComparator(BEST_FOUR, true, true));
        sortedData.addAll(pilotDataByName.values());
        newResults.add(0, header);
        int rank = 1;
        for (String[] line : sortedData) {
            line[0] = String.valueOf(rank++);
            newResults.add(line);
        }
        return newResults;
    }

    private static File chooseFileExport(File resultsFile) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select file for exporting merged tour/series results");
        fileChooser.addChoosableFileFilter(csvFilter);
        fileChooser.addChoosableFileFilter(xlsxFilter);
        fileChooser.setCurrentDirectory(editor.getCurrentDir());
        fileChooser.setSelectedFile(resultsFile);
        int returnVal = fileChooser.showDialog(editor, "Save");
        if (returnVal == 0) {
            editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv") && !ext.equalsIgnoreCase("xlsx")) {
                file = fileChooser.getFileFilter() == xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : (fileChooser.getFileFilter() == csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx"));
            }
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(editor, String.format("File \"%s\" exists.\nDo you want to overwrite it?", file.getName()), "File exists", 1);
                if (reply == 2) {
                    return null;
                }
                if (reply == 1) {
                    return MergeResultsUtils.chooseFileExport(resultsFile);
                }
            }
            return file;
        }
        return null;
    }

    private static class DataComparator
    implements Comparator<String[]> {
        private int compareByIndex;
        private boolean useNumericalComparison;
        private boolean descending;

        public DataComparator(int compareByIndex, boolean useNumericalComparison, boolean descending) {
            this.compareByIndex = compareByIndex;
            this.useNumericalComparison = useNumericalComparison;
            this.descending = descending;
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (this.useNumericalComparison) {
                double total2;
                double total1 = Double.parseDouble(o1[this.compareByIndex]);
                if (total1 < (total2 = Double.parseDouble(o2[this.compareByIndex]))) {
                    if (this.descending) {
                        return 1;
                    }
                    return -1;
                }
                if (total1 > total2) {
                    if (this.descending) {
                        return -1;
                    }
                    return 1;
                }
                return o1[PILOT_NAME].compareTo(o2[PILOT_NAME]);
            }
            if (o1[this.compareByIndex].length() == 0 && o2[this.compareByIndex].length() > 0) {
                return 1;
            }
            if (o1[this.compareByIndex].length() > 0 && o2[this.compareByIndex].length() == 0) {
                return -1;
            }
            return o1[this.compareByIndex].compareTo(o2[this.compareByIndex]);
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private List<String[]> tableData;
        private int MIN_ROWS = 50;
        private int MIN_COLS = 30;

        public MyTableModel(List<String[]> tableData) {
            this.tableData = tableData;
        }

        public void sortTableData(int sortByIndex, boolean useNumericalComparison, boolean descending) {
            String[] header = this.tableData.remove(0);
            Collections.sort(this.tableData, new DataComparator(sortByIndex, useNumericalComparison, descending));
            this.tableData.add(0, header);
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return Math.max(this.MIN_COLS, this.tableData.get(0).length);
        }

        @Override
        public String getColumnName(int col) {
            if (col < this.tableData.get(0).length) {
                return this.tableData.get(0)[col];
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return Math.max(this.MIN_ROWS, this.tableData.size() - 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.tableData.size() - 1) {
                return null;
            }
            String[] line = this.tableData.get(rowIndex + 1);
            return line.length > columnIndex ? line[columnIndex] : null;
        }
    }
}

