/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AudioConstants;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.F3KScore;
import f3kscore.F3kFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PlaylistDialog
extends JDialog
implements ActionListener,
AudioConstants {
    private JTextArea playlistText;
    private JTextField txtSoundFilesDir;
    private JButton btnBrowseSoundFilesDir;
    private JButton btnRegeneratePlaylist;
    private JButton btnSavePlaylist;
    private JCheckBox chkAddSilence;
    private JComboBox cmboAddSilence;
    private JCheckBox chkAddPilotNames;
    private JTextField txtPilotNameFilesDir;
    private JButton btnBrowsePilotNameFilesDir;
    private JTextField txtPilotNamePattern;
    private int silenceMinutes;
    private String soundFilesDirName;
    private String pilotFilesDirName;
    private String pilotNamePattern;
    private HashMap<String, String> soundFilesMap;
    private JLabel lblPilotNamePattern;
    private F3kFileFilter m3uFilter;
    private File playListFile;
    private F3KScore editor;

    public PlaylistDialog(F3KScore editor) {
        super((Frame)editor, "F3KScore: Audio Playlist Generator");
        this.editor = editor;
        super.setLayout(new GridBagLayout());
        super.setSize(650, 650);
        super.setLocationRelativeTo(editor);
        JLabel lblSoundFilesDir = new JLabel("Directory with sound files (absolute or relative path):");
        this.txtSoundFilesDir = new JTextField();
        this.txtSoundFilesDir.addActionListener(this);
        this.txtSoundFilesDir.setActionCommand("REGENERATE");
        this.btnBrowseSoundFilesDir = this.createButton("Browse...", "BROWSE_DIR", new Dimension(70, 22));
        JPanel frmSoundFilesDir = new JPanel(new GridBagLayout());
        frmSoundFilesDir.add((Component)this.txtSoundFilesDir, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
        frmSoundFilesDir.add((Component)this.btnBrowseSoundFilesDir, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.playlistText = new JTextArea(30, 20);
        this.playlistText.setMargin(new Insets(10, 10, 10, 10));
        this.playlistText.setFont(new Font(null, 0, 12));
        this.playlistText.setLineWrap(false);
        JScrollPane scrollPane = new JScrollPane(this.playlistText, 22, 30);
        this.playlistText.setEditable(false);
        Dimension dim = new Dimension(90, 25);
        this.btnRegeneratePlaylist = this.createButton("Regenerate", "REGENERATE", dim);
        this.btnSavePlaylist = this.createButton("Save As...", "SAVE_AS", dim);
        JPanel frmButtons = new JPanel();
        frmButtons.add(this.btnRegeneratePlaylist);
        frmButtons.add(this.btnSavePlaylist);
        this.chkAddSilence = new JCheckBox("Add breaks between groups:", false);
        this.chkAddSilence.setMargin(new Insets(0, 0, 0, 0));
        this.chkAddSilence.addActionListener(this);
        this.chkAddSilence.setActionCommand("ADD_SILENCE");
        this.cmboAddSilence = new JComboBox<String>(new String[]{"1 minute", "2 minutes", "3 minutes", "4 minutes", "5 minutes"});
        this.cmboAddSilence.setPreferredSize(new Dimension(90, 22));
        this.cmboAddSilence.addActionListener(this);
        this.cmboAddSilence.setActionCommand("ADD_SILENCE");
        this.cmboAddSilence.setEnabled(false);
        JPanel frmAddSilence = new JPanel(new GridBagLayout());
        frmAddSilence.add((Component)this.chkAddSilence, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        frmAddSilence.add((Component)this.cmboAddSilence, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        frmAddSilence.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.chkAddPilotNames = new JCheckBox("Include pilot name sound files from this directory (absolute or relative path):", false);
        this.chkAddPilotNames.setMargin(new Insets(0, 0, 0, 0));
        this.chkAddPilotNames.addActionListener(this);
        this.chkAddPilotNames.setActionCommand("ADD_PILOTS");
        this.txtPilotNameFilesDir = new JTextField();
        this.txtPilotNameFilesDir.addActionListener(this);
        this.txtPilotNameFilesDir.setActionCommand("REGENERATE");
        this.txtPilotNameFilesDir.setEnabled(false);
        this.btnBrowsePilotNameFilesDir = this.createButton("Browse...", "BROWSE_PILOTS", new Dimension(70, 22));
        this.btnBrowsePilotNameFilesDir.setEnabled(false);
        JPanel frmPilotNames = new JPanel(new GridBagLayout());
        frmPilotNames.add((Component)this.txtPilotNameFilesDir, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        frmPilotNames.add((Component)this.btnBrowsePilotNameFilesDir, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        String helpMsg = String.format("Replacement patterns: STARTNUMBER, LASTNAME, FIRSTNAME, INFO, EMAIL, FAI_AMA", new Object[0]);
        this.lblPilotNamePattern = new JLabel("Pattern for pilot name sound files:");
        this.lblPilotNamePattern.setEnabled(false);
        this.lblPilotNamePattern.setToolTipText(helpMsg);
        this.txtPilotNamePattern = new JTextField("STARTNUMBER-FIRSTNAME-LASTNAME.wav");
        this.txtPilotNamePattern.addActionListener(this);
        this.txtPilotNamePattern.setActionCommand("REGENERATE");
        this.txtPilotNamePattern.setEnabled(false);
        this.txtPilotNamePattern.setToolTipText(helpMsg);
        JPanel frmPilotNamePattern = new JPanel(new GridBagLayout());
        frmPilotNamePattern.add((Component)this.lblPilotNamePattern, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        frmPilotNamePattern.add((Component)this.txtPilotNamePattern, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        int row = 0;
        super.add((Component)lblSoundFilesDir, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        super.add((Component)frmSoundFilesDir, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        super.add((Component)frmAddSilence, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(7, 10, 0, 10), 0, 0));
        super.add((Component)this.chkAddPilotNames, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 0, 10), 0, 0));
        super.add((Component)frmPilotNames, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        super.add((Component)frmPilotNamePattern, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 10, 0, 10), 0, 0));
        super.add((Component)frmButtons, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 0, 0, 0), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m3uFilter = new F3kFileFilter("m3u", "m3u playlist files (.m3u)");
        this.initializeSoundFilesMap();
        this.generatePlaylist();
        this.setVisible(true);
    }

    private JButton createButton(String text, String command, Dimension dim) {
        JButton btn = new JButton(text);
        btn.addActionListener(this);
        btn.setActionCommand(command);
        btn.setMargin(new Insets(0, 5, 0, 5));
        if (dim != null) {
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setPreferredSize(dim);
        }
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("REGENERATE")) {
            this.generatePlaylist();
        } else if (action.getActionCommand().equals("SAVE_AS")) {
            this.browseSavePlaylist();
        } else if (action.getActionCommand().equals("CLOSE")) {
            super.setVisible(false);
        } else if (action.getActionCommand().equals("BROWSE_DIR")) {
            this.browseSoundFilesDir();
        } else if (action.getActionCommand().equals("BROWSE_PILOTS")) {
            this.browsePilotNameFilesDir();
        } else if (action.getActionCommand().equals("ADD_PILOTS")) {
            boolean enabled = this.chkAddPilotNames.isSelected();
            this.txtPilotNameFilesDir.setEnabled(enabled);
            this.txtPilotNamePattern.setEnabled(enabled);
            this.lblPilotNamePattern.setEnabled(enabled);
            this.btnBrowsePilotNameFilesDir.setEnabled(enabled);
            this.generatePlaylist();
        } else if (action.getActionCommand().equals("ADD_SILENCE")) {
            boolean enabled = this.chkAddSilence.isSelected();
            this.cmboAddSilence.setEnabled(enabled);
            this.silenceMinutes = enabled ? this.cmboAddSilence.getSelectedIndex() + 1 : 0;
            this.generatePlaylist();
        }
    }

    private void initializeSoundFilesMap() {
        this.soundFilesMap = new HashMap();
        this.soundFilesMap.put("SILENCE_1_MINUTE", "silence_1_minute.mp3");
        this.soundFilesMap.put("ROUND_1", "round_1.mp3");
        this.soundFilesMap.put("ROUND_2", "round_2.mp3");
        this.soundFilesMap.put("ROUND_3", "round_3.mp3");
        this.soundFilesMap.put("ROUND_4", "round_4.mp3");
        this.soundFilesMap.put("ROUND_5", "round_5.mp3");
        this.soundFilesMap.put("ROUND_6", "round_6.mp3");
        this.soundFilesMap.put("ROUND_7", "round_7.mp3");
        this.soundFilesMap.put("ROUND_8", "round_8.mp3");
        this.soundFilesMap.put("ROUND_9", "round_9.mp3");
        this.soundFilesMap.put("ROUND_10", "round_10.mp3");
        this.soundFilesMap.put("ROUND_11", "round_11.mp3");
        this.soundFilesMap.put("ROUND_12", "round_12.mp3");
        this.soundFilesMap.put("ROUND_13", "round_13.mp3");
        this.soundFilesMap.put("ROUND_14", "round_14.mp3");
        this.soundFilesMap.put("ROUND_15", "round_15.mp3");
        this.soundFilesMap.put("ROUND_16", "round_16.mp3");
        this.soundFilesMap.put("ROUND_17", "round_17.mp3");
        this.soundFilesMap.put("ROUND_18", "round_18.mp3");
        this.soundFilesMap.put("ROUND_19", "round_19.mp3");
        this.soundFilesMap.put("ROUND_20", "round_20.mp3");
        this.soundFilesMap.put("ROUND_21", "round_21.mp3");
        this.soundFilesMap.put("ROUND_22", "round_22.mp3");
        this.soundFilesMap.put("ROUND_23", "round_23.mp3");
        this.soundFilesMap.put("ROUND_24", "round_24.mp3");
        this.soundFilesMap.put("ROUND_25", "round_25.mp3");
        this.soundFilesMap.put("ROUND_26", "round_26.mp3");
        this.soundFilesMap.put("ROUND_27", "round_27.mp3");
        this.soundFilesMap.put("ROUND_28", "round_28.mp3");
        this.soundFilesMap.put("ROUND_29", "round_29.mp3");
        this.soundFilesMap.put("ROUND_30", "round_30.mp3");
        this.soundFilesMap.put("TASK", "task.mp3");
        this.soundFilesMap.put("HEAT", "heat.mp3");
        this.soundFilesMap.put("SEVEN_MINUTE_WINDOW", "7_minute_window.mp3");
        this.soundFilesMap.put("TEN_MINUTE_WINDOW", "10_minute_window.mp3");
        this.soundFilesMap.put("COUNTDOWN_3_MIN_PREP_7_MIN_WORKING_TIME", "countdown_3_min_prep_7_min_working_time.mp3");
        this.soundFilesMap.put("COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "countdown_3_min_prep_10_min_working_time.mp3");
        this.soundFilesMap.put("COUNTDOWN_3_MIN_PREP_10_MIN_POKER", "countdown_3_min_prep_10_min_poker.mp3");
        this.soundFilesMap.put("COUNTDOWN_3_MIN_PREP_3_MIN_ALL_UP", "countdown_3_min_prep_3_min_all_up.mp3");
        this.soundFilesMap.put("COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "countdown_1_min_prep_3_min_all_up.mp3");
        this.soundFilesMap.put("COUNTDOWN_30_SEC_LANDING", "30_sec_landing.mp3");
        this.soundFilesMap.put("A", "A.mp3");
        this.soundFilesMap.put("B", "B.mp3");
        this.soundFilesMap.put("C", "C.mp3");
        this.soundFilesMap.put("D", "D.mp3");
        this.soundFilesMap.put("E", "E.mp3");
        this.soundFilesMap.put("F", "F.mp3");
        this.soundFilesMap.put("G", "G.mp3");
        this.soundFilesMap.put("H", "H.mp3");
        this.soundFilesMap.put("I", "I.mp3");
        this.soundFilesMap.put("J", "J.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_A_LAST_FLIGHT", "description_task_A_last_flight.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_B_LAST_TWO_4_MIN", "description_task_B_last_two_4min.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_B_LAST_TWO_3_MIN", "description_task_B_last_two_3min.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_C_ALL_UP_3_FLIGHTS", "description_task_C_all_up_3_flights.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_C_ALL_UP_4_FLIGHTS", "description_task_C_all_up_4_flights.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_C_ALL_UP_5_FLIGHTS", "description_task_C_all_up_5_flights.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_D_LADDER", "description_task_D_ladder.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_E_POKER", "description_task_E_poker.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_F_3_OF_6", "description_task_F_3_of_6.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_G_5X2", "description_task_G_5x2.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_H_1_2_3_4", "description_task_H_1_2_3_4.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_I_3X200", "description_task_I_3x200s.mp3");
        this.soundFilesMap.put("DESCRIPTION_TASK_J_LAST_THREE_3_MIN", "description_task_J_last_three_3min.mp3");
    }

    public void generatePlaylist() {
        ArrayList<String> playList = new ArrayList<String>();
        this.soundFilesDirName = this.txtSoundFilesDir.getText().trim();
        this.pilotFilesDirName = this.txtPilotNameFilesDir.getText().trim();
        this.pilotNamePattern = this.txtPilotNamePattern.getText().trim();
        if (this.editor.getCompetition().getCompetitionName() != null) {
            playList.add("# " + this.editor.getCompetition().getCompetitionName());
        }
        playList.add("# Playlist generated " + new Date(System.currentTimeMillis()));
        int nRounds = this.editor.getCompetition().getNumberOfRounds();
        int roundIndex = 0;
        while (roundIndex < nRounds) {
            String[] taskPlayList = this.editor.getCompetition().getRoundTask(roundIndex).getPlaylist();
            if (roundIndex > 0) {
                int i = 0;
                while (i < this.silenceMinutes) {
                    playList.add(this.getPlaylistFileEntry("SILENCE_1_MINUTE"));
                    ++i;
                }
            }
            int nGroups = this.editor.getCompetition().getGroupCount(roundIndex);
            int group = 1;
            while (group <= nGroups) {
                if (group > 1) {
                    int i = 0;
                    while (i < this.silenceMinutes) {
                        playList.add(this.getPlaylistFileEntry("SILENCE_1_MINUTE"));
                        ++i;
                    }
                }
                playList.add("#");
                playList.add("# ROUND " + (roundIndex + 1) + ", GROUP " + group);
                playList.add("# " + this.editor.getCompetition().getRoundTask(roundIndex).getDescription());
                playList.add("#");
                playList.add(this.getPlaylistFileEntry(ROUND[roundIndex]));
                playList.add(this.getPlaylistFileEntry("HEAT"));
                playList.add(this.getPlaylistFileEntry(Competition.groupLetters.get(group - 1)));
                if (this.chkAddPilotNames.isSelected()) {
                    CompetitorGroup compGroup = new CompetitorGroup(this.editor.getCompetition(), group, roundIndex, false);
                    int nPilots = compGroup.getCompetitorCount();
                    int i = 0;
                    while (i < nPilots) {
                        Competitor comp = compGroup.getCompetitor(i);
                        if (comp != null) {
                            String pilotNameFileName = this.getPilotNameFileName(comp);
                            if (this.pilotFilesDirName != null && this.pilotFilesDirName.length() > 0) {
                                pilotNameFileName = String.valueOf(this.pilotFilesDirName) + File.separator + pilotNameFileName;
                            }
                            playList.add(pilotNameFileName);
                        }
                        ++i;
                    }
                }
                if (taskPlayList == null || taskPlayList.length == 0) {
                    playList.add("#############################################################################");
                    playList.add("# WARNING: playlist cannot be correctly generated for old F3KScore data files!");
                    playList.add("# Task specific sound files are not included here.");
                    playList.add("#############################################################################");
                } else {
                    int i = 0;
                    while (i < taskPlayList.length) {
                        playList.add(this.getPlaylistFileEntry(taskPlayList[i]));
                        ++i;
                    }
                }
                ++group;
            }
            ++roundIndex;
        }
        this.playlistText.setText(null);
        for (String line : playList) {
            this.playlistText.append(line);
            this.playlistText.append("\n");
        }
        this.playlistText.setCaretPosition(0);
    }

    private String getPilotNameFileName(Competitor comp) {
        String startNumber = "" + comp.getStartNumber();
        String firstName = comp.getProperty("First Name");
        String lastName = comp.getProperty("Last Name");
        String email = comp.getProperty("E-mail");
        String faiAmaNum = comp.getProperty("FAI/AMA Num");
        String info = comp.getProperty("Info");
        String pilotName = this.pilotNamePattern.replaceAll("STARTNUMBER", startNumber);
        pilotName = pilotName.replaceAll("FIRSTNAME", firstName);
        pilotName = pilotName.replaceAll("LASTNAME", lastName);
        pilotName = pilotName.replaceAll("INFO", info);
        pilotName = pilotName.replaceAll("EMAIL", email);
        pilotName = pilotName.replaceAll("FAI_AMA", faiAmaNum);
        return pilotName;
    }

    private String getPlaylistFileEntry(String key) {
        String txt = this.soundFilesMap.get(key);
        if (txt == null) {
            txt = "# KEY not found: " + key;
        }
        if (this.soundFilesDirName != null && this.soundFilesDirName.trim().length() > 0) {
            txt = String.valueOf(this.soundFilesDirName) + File.separator + txt;
        }
        return txt;
    }

    public void browseSoundFilesDir() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select directory with audio files");
        fileChooser.setCurrentDirectory(new File("."));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = fileChooser.showDialog(this, "Select directory with audio files");
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.txtSoundFilesDir.setText(file.getAbsolutePath());
            this.generatePlaylist();
        }
    }

    public void browsePilotNameFilesDir() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select directory with pilot name audio files");
        fileChooser.setCurrentDirectory(this.editor.getCurrentDir());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = fileChooser.showDialog(this, "Select directory with pilot name audio files");
        if (returnVal == 0) {
            this.editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            this.txtPilotNameFilesDir.setText(file.getAbsolutePath());
            this.generatePlaylist();
        }
    }

    private void browseSavePlaylist() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select file name for saving the playlist");
        fileChooser.setFileFilter(this.m3uFilter);
        fileChooser.setCurrentDirectory(this.editor.getCurrentDir());
        if (this.playListFile == null && this.editor.getLoadedFile() != null) {
            this.playListFile = new File(this.editor.getLoadedFile().getName().replace(".f3k", ".m3u"));
        }
        fileChooser.setSelectedFile(this.playListFile);
        int returnVal = fileChooser.showDialog(this, "Save playlist");
        if (returnVal == 0) {
            int reply;
            this.editor.setCurrentDir(fileChooser.getCurrentDirectory());
            this.playListFile = fileChooser.getSelectedFile();
            if (this.playListFile == null) {
                return;
            }
            if (!F3kFileFilter.getExtension(this.playListFile).equalsIgnoreCase("m3u")) {
                this.playListFile = new File(String.valueOf(this.playListFile.getAbsolutePath()) + ".m3u");
            }
            if (this.playListFile.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + this.playListFile.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 0)) != 0) {
                return;
            }
            try {
                FileOutputStream fs = new FileOutputStream(this.playListFile);
                fs.write(this.playlistText.getText().getBytes());
                fs.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + this.playListFile.getName() + "\":\n\n" + ex.getLocalizedMessage() + "\n\n" + ex.getStackTrace());
            }
        }
    }
}

