/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AudioConstants;
import java.io.Serializable;
import java.util.ArrayList;

public class Task
implements Serializable,
AudioConstants {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FLIGHT_TIMES = 20;
    public static ArrayList<Task> taskPool = new ArrayList();
    private int fIndex;
    private int numFlights;
    private String name;
    private String longName;
    private String shortName;
    private int[] maxTimes;
    private int[] minTimes;
    private int windowTime = 600;
    private boolean isSpeedTask;
    private String[] scoreCardTextTips;
    private String[] playList;
    private boolean isLadderTask;
    private String[] flightTimesColumnTitles;
    private boolean hasLandingScore;

    static {
        taskPool.add(new Task("\"A\" - Last 5:00 in 7:00", "L1x5", "Last flight, 5:00 max, 7:00 window", new int[]{300}, null, 420, false, false, new String[]{"Max=5:00"}, new String[]{"TASK", "A", "SEVEN_MINUTE_WINDOW", "DESCRIPTION_TASK_A_LAST_FLIGHT", "COUNTDOWN_3_MIN_PREP_7_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"A\" - Last 5:00 in 10:00", "L1x5", "Last flight, 5:00 max, 10:00 window", new int[]{300}, null, 600, false, false, new String[]{"Max=5:00"}, new String[]{"TASK", "A", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_A_LAST_FLIGHT", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"B\" - Last 2 x 4:00", "L2x4", "Last 2 flights, 4:00 max, 10:00 window", new int[]{240, 240}, null, 600, false, false, new String[]{"Max=4:00", "Max=4:00"}, new String[]{"TASK", "B", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_B_LAST_TWO_4_MIN", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"B\" - Last 2 x 3:00", "L2x3", "Last 2 flights, 3:00 max, 7:00 window", new int[]{180, 180}, null, 420, false, false, new String[]{"Max=3:00", "Max=3:00"}, new String[]{"TASK", "B", "SEVEN_MINUTE_WINDOW", "DESCRIPTION_TASK_B_LAST_TWO_3_MIN", "COUNTDOWN_3_MIN_PREP_7_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"C\" - All up 3 x 3:00", "AUp", "All up, 3 flights, 3:00 max", new int[]{180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"TASK", "C", "DESCRIPTION_TASK_C_ALL_UP_3_FLIGHTS", "COUNTDOWN_3_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"C\" - All up 4 x 3:00", "AUp4", "All up, 4 flights, 3:00 max", new int[]{180, 180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"TASK", "C", "DESCRIPTION_TASK_C_ALL_UP_4_FLIGHTS", "COUNTDOWN_3_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"C\" - All up 5 x 3:00", "AUp5", "All up, 5 flights, 3:00 max", new int[]{180, 180, 180, 180, 180}, null, 0, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"TASK", "C", "DESCRIPTION_TASK_C_ALL_UP_5_FLIGHTS", "COUNTDOWN_3_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING", "COUNTDOWN_1_MIN_PREP_3_MIN_ALL_UP", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"D\" - Ladder +15 sec", "Lddr", "Increasing times - 0:30, 0:45, 1:00, 1:15, 1:30, 1:45, 2:00, 10:00 window", new int[]{30, 45, 60, 75, 90, 105, 120}, new int[]{30, 45, 60, 75, 90, 105, 120}, 600, false, true, new String[]{"0:30", "0:45", "1:00", "1:15", "1:30", "1:45", "2:00"}, new String[]{"TASK", "D", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_D_LADDER", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"E\" - Poker", "Pkr", "Poker, 5 self nominated targets, 10:00 window", new int[5], null, 600, false, false, new String[]{"Target #1", "Target #2", "Target #3", "Target #4", "Target #5"}, new String[]{"TASK", "E", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_E_POKER", "COUNTDOWN_3_MIN_PREP_10_MIN_POKER", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"F\" - Best 3 of 6", "3of6", "Best 3 flights, 3:00 max, 6 launches only, 10:00 window", new int[]{180, 180, 180}, null, 600, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"TASK", "F", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_F_3_OF_6", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"G\" - Best 5 x 2:00", "5x2", "Best 5 flights, 2:00 max, 10:00 window", new int[]{120, 120, 120, 120, 120}, null, 600, false, false, new String[]{"Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00", "Max=2:00"}, new String[]{"TASK", "G", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_G_5X2", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"H\" - 1:00, 2:00, 3:00, 4:00", "1234", "Best 4 flights, 1:00, 2:00, 3:00, 4:00 max in any order, 10:00 window", new int[]{60, 120, 180, 240}, null, 600, false, false, new String[]{"Max=1:00", "Max=2:00", "Max=3:00", "Max=4:00"}, new String[]{"TASK", "H", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_H_1_2_3_4", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"I\" - Best 3 x 200s", "3200", "Best 3 flights, 200s (3:20) max, 10:00 window", new int[]{200, 200, 200}, null, 600, false, false, new String[]{"Max=3:20", "Max=3:20", "Max=3:20"}, new String[]{"TASK", "I", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_I_3X200", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        taskPool.add(new Task("\"J\" - Last 3 x 3:00", "L3x3", "Last 3 flights, 3:00 max, 10:00 window", new int[]{180, 180, 180}, null, 600, false, false, new String[]{"Max=3:00", "Max=3:00", "Max=3:00"}, new String[]{"TASK", "J", "TEN_MINUTE_WINDOW", "DESCRIPTION_TASK_J_LAST_THREE_3_MIN", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, null, false));
        int[] nArray = new int[2];
        nArray[0] = 600;
        taskPool.add(new Task("TD-F3J-ALES 10:00 max", "10:00", "Normalized duration with a precision landing, 10:00 maximum", nArray, null, 0, false, false, new String[]{"Max=10:00", "Landing"}, new String[]{"TEN_MINUTE_WINDOW", "COUNTDOWN_3_MIN_PREP_10_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, new String[]{"10:00", "Landing"}, true));
        int[] nArray2 = new int[2];
        nArray2[0] = 420;
        taskPool.add(new Task("TD-F3J-ALES 7:00 max", "7:00", "Normalized duration with a precision landing, 7:00 maximum", nArray2, null, 0, false, false, new String[]{"Max=7:00", "Landing"}, new String[]{"SEVEN_MINUTE_WINDOW", "COUNTDOWN_3_MIN_PREP_7_MIN_WORKING_TIME", "COUNTDOWN_30_SEC_LANDING"}, new String[]{"7:00", "Landing"}, true));
        taskPool.add(new Task("F3B speed", "F3B", "F3F/F3B type speed task", new int[1], null, 0, true, false, null, null, null, false));
    }

    public Task(String name, String shortName, String description, int[] maxTimes, int[] minTimes, int windowTime, boolean isSpeedTask, boolean isLadderTask, String[] scoreCardTextTips, String[] playList, String[] columnTitles, boolean hasLandingScore) {
        this.name = name;
        this.shortName = shortName;
        this.longName = description;
        this.maxTimes = maxTimes;
        this.minTimes = minTimes;
        this.windowTime = windowTime;
        this.isSpeedTask = isSpeedTask;
        this.isLadderTask = isLadderTask;
        this.numFlights = maxTimes.length;
        if (this.numFlights > 20) {
            throw new IllegalArgumentException("Too many flight times " + this.numFlights + ". Max # flight times = " + 20);
        }
        this.scoreCardTextTips = scoreCardTextTips;
        this.playList = playList;
        this.flightTimesColumnTitles = columnTitles;
        this.hasLandingScore = hasLandingScore;
    }

    public boolean isSpeedTask() {
        return this.isSpeedTask;
    }

    public boolean isLadderTask() {
        return this.isLadderTask;
    }

    public int getPoolIndex() {
        return this.fIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.longName;
    }

    public int getNumFlights() {
        return this.numFlights;
    }

    public String toString() {
        return this.name;
    }

    public int getMaxTimeCut(int flightIndex) {
        if (this.maxTimes == null) {
            return 0;
        }
        if (this.maxTimes.length <= flightIndex) {
            return 0;
        }
        return this.maxTimes[flightIndex];
    }

    public int getMinTimeCut(int flightIndex) {
        if (this.minTimes == null) {
            return 0;
        }
        if (this.minTimes.length <= flightIndex) {
            return 0;
        }
        return this.minTimes[flightIndex];
    }

    public int getWindowTime() {
        return this.windowTime;
    }

    public String[] getScoreCardTextTips() {
        return this.scoreCardTextTips;
    }

    public String[] getPlaylist() {
        return this.playList;
    }

    public String[] getFlightTimesColumnTitles() {
        return this.flightTimesColumnTitles;
    }

    public boolean hasLandingScore() {
        return this.hasLandingScore;
    }
}

