/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.CompetitorGroup;
import f3kscore.RoundScore;
import f3kscore.Team;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class Competitor
implements Serializable,
Comparable<Competitor> {
    private static final long serialVersionUID = 1L;
    public static final String FIRST_NAME = "First Name";
    public static final String LAST_NAME = "Last Name";
    public static final String FULL_NAME = "Name";
    public static final String CLASS = "Class";
    public static final String COUNTRY = "State";
    public static final String CLUB = "Club";
    public static final String INFO = "Info";
    public static final String PENALTY = "Penalty";
    public static final String FREQ1 = "Freq 1";
    public static final String FREQ2 = "Freq 2";
    public static final String FREQ3 = "Freq 3";
    public static final String MODELS = "Glider Models";
    public static final String EMAIL = "E-mail";
    public static final String TEAM = "Team";
    public static final String FAI_AMA_NUM = "FAI/AMA Num";
    private Competition competition;
    private String firstName;
    private String lastName;
    private String name;
    private String competitorClass;
    private String country;
    private String club;
    private String info;
    private int penalty;
    private String freq1;
    private String freq2;
    private String freq3;
    private String models;
    private String email;
    private String team;
    private String faiAmaNum;
    private ArrayList<RoundScore> scores;
    private HashMap<Integer, RoundScore> reflightScoresMap;
    private transient int totalScore = -1;
    private transient ArrayList<Integer> droppedRoundIndices;
    private transient int[] roundTaskScores;
    private transient int[] roundReflightScores;
    private transient int[] roundFinalScores;
    private transient ArrayList<Integer> droppedRoundScores;
    private Team theTeam;

    public Competitor(Competition competition, String firstName, String lastName) {
        this.firstName = firstName.trim();
        this.lastName = lastName.trim();
        this.competition = competition;
        this.competitorClass = "";
        this.country = "";
        this.club = "";
        this.info = "";
        this.freq1 = "";
        this.freq2 = "";
        this.freq3 = "";
        this.models = "";
        this.email = "";
        this.team = "";
        this.faiAmaNum = "";
        this.scores = new ArrayList();
        int numRounds = competition.getNumberOfRounds();
        this.setNumberOfRounds(numRounds);
    }

    public Competition getCompetition() {
        return this.competition;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Competitor) {
            Competitor other = (Competitor)obj;
            return other.getFullName().equals(this.getFullName());
        }
        return false;
    }

    public void setNumberOfRounds(int numRounds) {
        while (this.scores.size() > numRounds) {
            this.scores.remove(numRounds);
        }
        int i = this.scores.size();
        while (i < numRounds) {
            this.scores.add(new RoundScore(this.competition, i));
            ++i;
        }
    }

    public String getProperty(String propName) {
        if (propName.equals(FIRST_NAME)) {
            return this.firstName != null ? this.firstName : "";
        }
        if (propName.equals(LAST_NAME)) {
            return this.lastName != null ? this.lastName : (this.name != null ? this.name : "");
        }
        if (propName.equals(FULL_NAME)) {
            return this.getFullName();
        }
        if (propName.equals(CLASS)) {
            return this.competitorClass;
        }
        if (propName.equals(COUNTRY)) {
            return this.country;
        }
        if (propName.equals(CLUB)) {
            return this.club;
        }
        if (propName.equals(INFO)) {
            return this.info;
        }
        if (propName.equals(PENALTY)) {
            return "" + this.penalty;
        }
        if (propName.equals(FREQ1)) {
            return this.freq1;
        }
        if (propName.equals(FREQ2)) {
            return this.freq2;
        }
        if (propName.equals(FREQ3)) {
            return this.freq3;
        }
        if (propName.equals(MODELS)) {
            return this.models;
        }
        if (propName.equals(EMAIL)) {
            return this.email;
        }
        if (propName.equals(TEAM)) {
            return this.getTeamName();
        }
        if (propName.equals(FAI_AMA_NUM)) {
            return this.faiAmaNum;
        }
        return "";
    }

    public void setProperty(String propName, String propVal) {
        if (propVal == null) {
            propVal = "";
        }
        propVal = propVal.trim();
        if (propName.equals(LAST_NAME)) {
            this.lastName = propVal;
            this.competition.setResultsDirty();
        }
        if (propName.equals(FIRST_NAME)) {
            this.firstName = propVal;
            this.competition.setResultsDirty();
        }
        if (propName.equals(CLASS)) {
            this.competitorClass = propVal;
        }
        if (propName.equals(COUNTRY)) {
            this.country = propVal;
        }
        if (propName.equals(CLUB)) {
            this.club = propVal;
        }
        if (propName.equals(INFO)) {
            this.info = propVal;
        }
        if (propName.equals(PENALTY)) {
            this.penalty = Integer.parseInt(propVal);
        }
        if (propName.equals(FREQ1)) {
            this.freq1 = propVal;
        }
        if (propName.equals(FREQ2)) {
            this.freq2 = propVal;
        }
        if (propName.equals(FREQ3)) {
            this.freq3 = propVal;
        }
        if (propName.equals(MODELS)) {
            this.models = propVal;
        }
        if (propName.equals(EMAIL)) {
            this.email = propVal;
        }
        if (propName.equals(TEAM)) {
            this.setTeamName(propVal);
        }
        if (propName.equals(FAI_AMA_NUM)) {
            this.faiAmaNum = propVal;
        }
    }

    public String getFullName() {
        if (this.firstName != null && this.firstName.length() > 0 && this.lastName != null && this.lastName.length() > 0) {
            if (this.competition.isUseLastCommaFirstNameFormat()) {
                return String.valueOf(this.lastName) + ", " + this.firstName;
            }
            return String.valueOf(this.firstName) + " " + this.lastName;
        }
        if (this.firstName != null && this.firstName.length() > 0) {
            return this.firstName;
        }
        if (this.lastName != null && this.lastName.length() > 0) {
            return this.lastName;
        }
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public String getFrequency() {
        return this.freq1;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCompetitorClass() {
        return this.competitorClass;
    }

    public String getClub() {
        return this.club;
    }

    public String getInfo() {
        return this.info;
    }

    public String getFaiAmaNumber() {
        if (this.faiAmaNum == null) {
            return "";
        }
        return this.faiAmaNum;
    }

    public int getPenalty() {
        if (this.penalty != 0) {
            return this.penalty;
        }
        int total = 0;
        for (RoundScore score : this.scores) {
            total += score.getPenalty();
        }
        for (RoundScore score : this.reflightScoresMap().values()) {
            total += score.getPenalty();
        }
        return total;
    }

    public String getPenaltyRounds() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.scores.size()) {
            if (this.scores.get(i).getPenalty() > 0 || this.reflightScoresMap().containsKey(i) && this.reflightScoresMap().get(i).getPenalty() > 0) {
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(i + 1);
            }
            ++i;
        }
        return result.toString();
    }

    public int getPenalty(int roundIndex) {
        return this.scores.get(roundIndex).getPenalty();
    }

    public int getReflightPenalty(int roundIndex) {
        if (this.reflightScoresMap().containsKey(roundIndex)) {
            return this.reflightScoresMap().get(roundIndex).getPenalty();
        }
        return 0;
    }

    public void setPenalty(int roundIndex, int penalty) {
        this.scores.get(roundIndex).setPenalty(penalty);
        this.competition.setResultsDirty();
    }

    public void setReflightPenalty(int roundIndex, int penalty) {
        if (!this.reflightScoresMap().containsKey(roundIndex)) {
            this.reflightScoresMap().put(roundIndex, new RoundScore(this.competition, roundIndex));
        }
        this.reflightScoresMap().get(roundIndex).setPenalty(penalty);
        this.competition.setResultsDirty();
    }

    public void setGroupNum(int roundIndex, int groupNum) {
        this.scores.get(roundIndex).setGroupNum(groupNum);
        this.competition.setResultsDirty();
    }

    public int getGroupNum(int roundIndex) {
        return this.scores.get(roundIndex).getGroupNum();
    }

    public void setTaskTime(int roundIndex, int flightIndex, int newTime) {
        this.scores.get(roundIndex).setTime(flightIndex, newTime);
        this.competition.setChangesMade(true);
        this.competition.setResultsDirty();
    }

    public void setReflightTime(int roundIndex, int flightIndex, int newTime) {
        if (!this.reflightScoresMap().containsKey(roundIndex)) {
            this.reflightScoresMap().put(roundIndex, new RoundScore(this.competition, roundIndex));
        }
        this.reflightScoresMap().get(roundIndex).setTime(flightIndex, newTime);
        this.competition.setResultsDirty();
    }

    public int getTaskTime(int roundIndex, int flightIndex) {
        return this.scores.get(roundIndex).getTime(flightIndex);
    }

    public int getReflightTime(int roundIndex, int flightIndex) {
        if (this.reflightScoresMap().containsKey(roundIndex)) {
            return this.reflightScoresMap().get(roundIndex).getTime(flightIndex);
        }
        return 0;
    }

    public int getTaskTotalTime(int roundIndex) {
        return this.scores.get(roundIndex).getTotalTime();
    }

    public int getReflightTotalTime(int roundIndex) {
        if (this.reflightScoresMap().containsKey(roundIndex)) {
            return this.reflightScoresMap().get(roundIndex).getTotalTime();
        }
        return 0;
    }

    public int getStartNumber() {
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            if (this.competition.getCompetitor(c) == this) {
                return c + 1;
            }
            ++c;
        }
        return -1;
    }

    public int getPosition() {
        int myScore = this.calculateTotalScore();
        int pos = 0;
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            Competitor comp = this.competition.getCompetitor(c);
            if (comp != this) {
                int score = comp.calculateTotalScore();
                if (score > myScore) {
                    ++pos;
                } else if (score == myScore) {
                    int discardCount = this.competition.getDiscardCount();
                    int discardIndex = 0;
                    while (discardIndex < discardCount && comp.getDiscardScore(discardIndex) == this.getDiscardScore(discardIndex)) {
                        ++discardIndex;
                    }
                    if (discardIndex < discardCount) {
                        if (comp.getDiscardScore(discardIndex) > this.getDiscardScore(discardIndex)) {
                            ++pos;
                        }
                    } else if (this.getStartNumber() > comp.getStartNumber()) {
                        ++pos;
                    }
                }
            }
            ++c;
        }
        return pos;
    }

    public float getPercent() {
        int myTotal;
        int maxTotal = myTotal = this.calculateTotalScore();
        int c = 0;
        while (c < this.competition.getCompetitorCount()) {
            int tot;
            Competitor comp = this.competition.getCompetitor(c);
            if (comp != this && (tot = comp.calculateTotalScore()) > maxTotal) {
                maxTotal = tot;
            }
            ++c;
        }
        if (maxTotal > 0) {
            return (float)myTotal * 100.0f / (float)maxTotal;
        }
        return 0.0f;
    }

    public int getDiscardScore(int discardIndex) {
        this.calculateTotalScore();
        int nDropped = this.droppedRoundScores.size();
        if (nDropped <= discardIndex) {
            this.totalScore = -1;
            this.calculateTotalScore();
            nDropped = this.droppedRoundScores.size();
        }
        return nDropped == 0 || nDropped <= discardIndex ? 0 : this.droppedRoundScores.get(nDropped - 1 - discardIndex);
    }

    public boolean isDiscardRound(int roundIndex) {
        this.calculateTotalScore();
        return this.droppedRoundIndices.contains(roundIndex);
    }

    public int calculateTaskScore(int round, int group, int totalTime) {
        CompetitorGroup compGroup = new CompetitorGroup(this.competition, group, round, false);
        boolean isSpeedTask = this.competition.getRoundTask(round).isSpeedTask();
        int LARGE_INT = 99999;
        if (isSpeedTask) {
            totalTime = totalTime > 0 ? LARGE_INT / totalTime : 0;
        }
        int maxTime = 0;
        int c = 0;
        while (c < compGroup.getCompetitorCount()) {
            int time = 0;
            time = group < 0 ? compGroup.getCompetitor(c).getReflightTotalTime(round) : compGroup.getCompetitor(c).getTaskTotalTime(round);
            if (isSpeedTask) {
                time = time > 0 ? LARGE_INT / time : 0;
            }
            if (time > maxTime) {
                maxTime = time;
            }
            ++c;
        }
        if (maxTime > 0) {
            return totalTime * 1000 / maxTime;
        }
        return 0;
    }

    public int calculateTotalScore() {
        if (this.totalScore != -1) {
            return this.totalScore;
        }
        int nRoundsFlown = this.competition.getDoneRoundCount();
        int[] flownRoundIndex = new int[nRoundsFlown];
        int[] flownScores = new int[nRoundsFlown];
        int nRounds = this.competition.getNumberOfRounds();
        this.roundTaskScores = new int[nRounds];
        this.roundReflightScores = new int[nRounds];
        this.roundFinalScores = new int[nRounds];
        int round = 0;
        int count = 0;
        while (round < this.competition.getNumberOfRounds()) {
            if (this.competition.isRoundFlown(round)) {
                int bestScore;
                this.roundTaskScores[round] = this.calculateTaskScore(round, this.getGroupNum(round), this.getTaskTotalTime(round));
                if (this.reflightScoresMap().containsKey(round)) {
                    this.roundReflightScores[round] = this.calculateTaskScore(round, -1, this.getReflightTotalTime(round));
                }
                this.roundFinalScores[round] = bestScore = Math.max(this.roundTaskScores[round], this.roundReflightScores[round]);
                flownRoundIndex[count] = round;
                flownScores[count] = bestScore;
                ++count;
            }
            ++round;
        }
        int discardCount = this.competition.getDiscardCount();
        int[] droppedRndIndArray = new int[discardCount];
        this.droppedRoundScores = new ArrayList();
        int d = 0;
        while (d < discardCount) {
            int lowest = 1001;
            int lowIx = 0;
            int b = 0;
            while (b < nRoundsFlown) {
                if (flownScores[b] >= 0 && flownScores[b] < lowest) {
                    lowest = flownScores[b];
                    lowIx = b;
                    droppedRndIndArray[d] = flownRoundIndex[b];
                    this.droppedRoundScores.add(lowest);
                }
                ++b;
            }
            flownScores[lowIx] = -lowest - 1;
            ++d;
        }
        this.droppedRoundIndices = new ArrayList();
        int i = 0;
        while (i < discardCount) {
            this.droppedRoundIndices.add(droppedRndIndArray[i]);
            ++i;
        }
        int total = 0;
        int c = 0;
        while (c < nRoundsFlown) {
            if (flownScores[c] > 0) {
                total += flownScores[c];
            }
            ++c;
        }
        this.totalScore = total - this.getPenalty();
        return this.totalScore;
    }

    public int getRoundScore(int roundIndex) {
        if (this.totalScore <= 0) {
            this.calculateTotalScore();
        }
        if (this.roundFinalScores.length <= roundIndex) {
            return 0;
        }
        return this.roundFinalScores[roundIndex];
    }

    public int getReflightScore(int roundIndex) {
        if (this.totalScore <= 0) {
            this.calculateTotalScore();
        }
        if (this.roundReflightScores.length <= roundIndex) {
            return 0;
        }
        return this.roundReflightScores[roundIndex];
    }

    public int getScore(int roundIndex) {
        if (this.totalScore <= 0) {
            this.calculateTotalScore();
        }
        if (this.roundTaskScores.length <= roundIndex) {
            return 0;
        }
        return this.roundTaskScores[roundIndex];
    }

    public void setResultsDirty() {
        this.droppedRoundIndices = null;
        this.droppedRoundScores = null;
        this.totalScore = -1;
    }

    public void clearAllFlightTimes() {
        for (RoundScore score : this.scores) {
            score.clearAllFlightTimes();
        }
        this.reflightScoresMap().clear();
        this.setResultsDirty();
    }

    public String getTeamName() {
        if (this.team != null && !this.team.equals("") && this.theTeam == null) {
            this.setTeamName(this.team);
            this.team = "";
        }
        return this.theTeam != null ? this.theTeam.getName() : "";
    }

    public void setTeamName(String teamName) {
        if (this.theTeam != null) {
            this.theTeam.removePilot(this);
        }
        if (!teamName.equals("")) {
            this.theTeam = this.competition.getTeam(teamName);
            if (this.theTeam == null) {
                this.theTeam = this.competition.addNewTeam(teamName);
            }
            this.theTeam.addPilot(this);
        } else {
            this.theTeam = null;
        }
        this.competition.setResultsDirty();
    }

    @Override
    public int compareTo(Competitor other) {
        return this.getFullName().compareTo(other.getFullName());
    }

    public void includeInReflightGroup(int roundIndex, boolean include) {
        if (include) {
            this.reflightScoresMap().put(roundIndex, new RoundScore(this.competition, roundIndex));
        } else {
            this.reflightScoresMap().remove(roundIndex);
        }
        this.competition.setResultsDirty();
    }

    public boolean isIncludedInReflightGroup(int roundIndex) {
        return this.reflightScoresMap().containsKey(roundIndex);
    }

    private HashMap<Integer, RoundScore> reflightScoresMap() {
        if (this.reflightScoresMap == null) {
            this.reflightScoresMap = new HashMap();
        }
        return this.reflightScoresMap;
    }
}

