/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Competitor;
import java.util.ArrayList;

public class CompetitorGroup {
    private ArrayList<Competitor> groupList;
    private int competitorCount;
    private final int groupNumber;
    private final Competition competition;

    public String getGroupName() {
        return this.competition.formatGroupNumberAsString(this.groupNumber);
    }

    public Competitor getCompetitor(int index) {
        if (index >= this.groupList.size()) {
            return null;
        }
        return this.groupList.get(index);
    }

    public int getCompetitorCount() {
        return this.competitorCount;
    }

    public CompetitorGroup(Competition comp, int groupNumber, int roundIndex, boolean shuffle) {
        this.groupNumber = groupNumber;
        this.competition = comp;
        this.groupList = new ArrayList();
        int c = 0;
        while (c < comp.getCompetitorCount()) {
            if (groupNumber >= 0 && comp.getCompetitor(c).getGroupNum(roundIndex) == groupNumber) {
                this.groupList.add(comp.getCompetitor(c));
            } else if (groupNumber < 0 && comp.getCompetitor(c).isIncludedInReflightGroup(roundIndex)) {
                this.groupList.add(comp.getCompetitor(c));
            }
            ++c;
        }
        this.competitorCount = this.groupList.size();
        if (!shuffle) {
            return;
        }
        ArrayList<Competitor> groupList2 = this.groupList;
        this.groupList = new ArrayList();
        int shift = (groupNumber + 17) * roundIndex;
        int c2 = 0;
        while (c2 < this.competitorCount) {
            this.groupList.add(groupList2.get((c2 + shift) % this.competitorCount));
            ++c2;
        }
    }
}

