/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSpreadsheetReader {
    public static List<String[]> readAll(File file, int sheetIndex) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        XSSFWorkbook wb = new XSSFWorkbook((InputStream)inStream);
        XSSFFormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        XSSFSheet sheet1 = wb.getSheetAt(sheetIndex);
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Row row : sheet1) {
            ArrayList<String> line = new ArrayList<String>();
            for (Cell cell : row) {
                switch (evaluator.evaluateInCell(cell).getCellType()) {
                    case 1: {
                        line.add(cell.getRichStringCellValue().getString());
                        break;
                    }
                    case 0: {
                        double val = cell.getNumericCellValue();
                        int intVal = (int)val;
                        if ((double)intVal == val) {
                            line.add(String.valueOf(intVal));
                            break;
                        }
                        line.add(String.valueOf(val));
                        break;
                    }
                    default: {
                        line.add("");
                    }
                }
            }
            String[] lineArray = new String[line.size()];
            line.toArray(lineArray);
            data.add(lineArray);
        }
        ((InputStream)inStream).close();
        return data;
    }
}

