/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class GroupsPane
extends AbstractF3KScoreEditorPanel {
    private JLabel lbl;
    private JTextField txtNumGroups;
    private JCheckBox chkUseLetters;
    private JButton btnGenerateGroups;
    private JButton btnShowPilotMeets;
    private JCheckBox chkUseTeamProtection = new JCheckBox("Enforce team protection when generating groups");
    private Random randomGenerator = new Random();
    private HashMap<String, Integer> pilotMeets;
    private JDialog reportDlg;
    private JTextArea textArea;
    private JCheckBox chkOptimizeMatrix = new JCheckBox("Optimize flight matrix relative to the number of pilot-pilot interactions", true);
    private JCheckBox chkStartFromCurrent = new JCheckBox("Start optimization from the current flight matrix", true);
    private JTextField txtNumOptLoops = new JTextField();
    private JLabel lblMaxOptLoops = new JLabel("Number of optimization trials: ");
    private ExcelAdapter excelAdapter;
    private JPopupMenu popupMenu;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;

    public GroupsPane(Competition competition) {
        this.competition = competition;
        this.lbl = new JLabel("Num. groups:");
        this.txtNumGroups = new JTextField();
        this.txtNumGroups.setMinimumSize(new Dimension(30, 20));
        this.txtNumGroups.setPreferredSize(new Dimension(30, 20));
        this.txtNumGroups.setText("" + competition.getMaxGroupCount());
        this.txtNumGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.generateNewGroups();
            }
        });
        this.btnGenerateGroups = new JButton("Generate");
        this.btnGenerateGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.generateNewGroups();
            }
        });
        this.btnShowPilotMeets = new JButton("Show report");
        this.btnShowPilotMeets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.showPilotMeetings();
            }
        });
        this.chkUseLetters = new JCheckBox("Use letters for group names (A,B,C,...)");
        this.chkUseLetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.useLettersForGroupNamesChanged();
            }
        });
        this.tableModel = new GroupsTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component c = super.prepareEditor(editor, row, column);
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).selectAll();
                    c.setBackground(super.getSelectionBackground());
                }
                return c;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (super.isRowSelected(rowIndex)) {
                    if (!super.isColumnSelected(vColIndex)) {
                        c.setBackground(F3KScore.veryLightGrey);
                    } else {
                        c.setBackground(this.getSelectionBackground());
                    }
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        };
        this.table.setAutoResizeMode(0);
        this.configurePanel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.add(scrollPane);
        this.excelAdapter = new ExcelAdapter(this.table);
        this.setLayout(new GridBagLayout());
        super.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        super.add((Component)this.txtNumGroups, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0));
        super.add((Component)this.btnGenerateGroups, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        super.add((Component)this.btnShowPilotMeets, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        super.add((Component)this.chkUseTeamProtection, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        super.add((Component)this.chkUseLetters, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        this.txtNumOptLoops.setMinimumSize(new Dimension(40, 20));
        this.txtNumOptLoops.setMaximumSize(new Dimension(40, 20));
        this.txtNumOptLoops.setPreferredSize(new Dimension(40, 20));
        this.txtNumOptLoops.setText("10");
        this.lblMaxOptLoops.setEnabled(false);
        this.txtNumOptLoops.setEnabled(false);
        this.chkStartFromCurrent.setEnabled(false);
        this.chkOptimizeMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = GroupsPane.this.chkOptimizeMatrix.isSelected();
                GroupsPane.this.lblMaxOptLoops.setEnabled(enabled);
                GroupsPane.this.txtNumOptLoops.setEnabled(enabled);
                GroupsPane.this.chkStartFromCurrent.setEnabled(enabled);
            }
        });
        this.chkUseTeamProtection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsPane.this.competition.setUseTeamProtection(GroupsPane.this.chkUseTeamProtection.isSelected());
                GroupsPane.this.competition.setChangesMade(true);
                GroupsPane.this.generateNewGroups();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = GroupsPane.this.table.rowAtPoint(p);
                    int[] selRows = GroupsPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        GroupsPane.this.table.clearSelection();
                        GroupsPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = GroupsPane.this.table.columnAtPoint(p);
                        GroupsPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    GroupsPane.this.showPopupMenu(e);
                }
            }
        });
    }

    private void useLettersForGroupNamesChanged() {
        this.competition.setUseLetterGroupNames(this.chkUseLetters.isSelected());
        this.tableModel.fireTableDataChanged();
        this.competition.setChangesMade(true);
    }

    private void generateNewGroups() {
        int numGroups = -1;
        try {
            numGroups = Integer.parseInt(this.txtNumGroups.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numGroups < 1 || numGroups > 20) {
            JOptionPane.showMessageDialog(this, String.format("Invalid entry for the number of groups: \"%s\"\nEnter an integer in the range 1...%d", this.txtNumGroups.getText(), 20), "Invalid Entry", 0);
            this.txtNumGroups.setText(String.valueOf(this.competition.getMaxGroupCount()));
            return;
        }
        if (numGroups > this.competition.getCompetitorCount()) {
            JOptionPane.showMessageDialog(this, String.format("Number of groups cannot be above the number of pilots! (%s > %d)", this.txtNumGroups.getText(), this.competition.getCompetitorCount()), "Invalid Entry", 0);
            this.txtNumGroups.setText(String.valueOf(this.competition.getMaxGroupCount()));
            return;
        }
        int reply = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        if (numGroups == 1) {
            reply = JOptionPane.showConfirmDialog(this, "Entering \"1\" for number of groups resets all group assignments.\nDo you want to clear all groups?", "Clear all goup assignments?", 0);
        } else {
            int minGroupCount = this.calcMinGroupCount();
            if (numGroups < minGroupCount) {
                JOptionPane.showMessageDialog(this, String.format("Specified number of groups is not sufficient\ndue to the frequency conflicts and/or team sizes.\nMinimum number of groups is %d\n", minGroupCount), "Insufficient number of groups specified", 0);
                this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
                return;
            }
            boolean enabled = this.chkOptimizeMatrix.isSelected();
            this.lblMaxOptLoops.setEnabled(enabled);
            this.txtNumOptLoops.setEnabled(enabled);
            this.chkStartFromCurrent.setEnabled(enabled);
            panel.add((Component)new JLabel("<html>Generating a new matrix will overwrite all existing group assignments.<br>Do you want to generate a new flight matrix?"), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.chkOptimizeMatrix, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
            panel.add((Component)this.lblMaxOptLoops, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 23, 0, 0), 0, 0));
            panel.add((Component)this.txtNumOptLoops, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            if (this.competition.getMaxGroupCount() > 1 && numGroups == this.competition.getMaxGroupCount()) {
                this.chkStartFromCurrent.setSelected(true);
                panel.add((Component)this.chkStartFromCurrent, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 10, 0), 0, 0));
            } else {
                this.chkStartFromCurrent.setSelected(false);
                panel.add((Component)new JLabel("  "), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            reply = JOptionPane.showConfirmDialog(this, panel, "Generate new flight matrix?", 2);
        }
        if (reply != 0) {
            this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
            return;
        }
        F3KScore.editor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            final int nGroups = numGroups;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            if (GroupsPane.this.reportDlg != null && GroupsPane.this.reportDlg.isVisible()) {
                                GroupsPane.this.reportDlg.setVisible(false);
                            }
                            boolean startFromCurrent = false;
                            boolean optimize = GroupsPane.this.chkOptimizeMatrix.isSelected();
                            int numOptLoops = 0;
                            if (optimize) {
                                numOptLoops = Integer.parseInt(GroupsPane.this.txtNumOptLoops.getText().trim());
                                startFromCurrent = GroupsPane.this.chkStartFromCurrent.isSelected();
                            }
                            GroupsPane.this.generateGroups(nGroups, optimize, numOptLoops, startFromCurrent);
                            if (GroupsPane.this.competition.getMaxGroupCount() > 1) {
                                GroupsPane.this.showPilotMeetings();
                            }
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(F3KScore.editor(), "Invalid value entered for number of optimization trials", "Invalid Value", 0);
                            F3KScore.editor().setCursor(Cursor.getDefaultCursor());
                            GroupsPane.this.competition.setChangesMade(true);
                        }
                        catch (Throwable t) {
                            JOptionPane.showMessageDialog(F3KScore.editor(), String.format("Internal error when generating flight matrix: \n\n%s", t.getLocalizedMessage()), "Internal Error", 0);
                            t.printStackTrace();
                            F3KScore.editor().setCursor(Cursor.getDefaultCursor());
                            GroupsPane.this.competition.setChangesMade(true);
                        }
                    }
                    finally {
                        F3KScore.editor().setCursor(Cursor.getDefaultCursor());
                        GroupsPane.this.competition.setChangesMade(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.table.getColumnModel().getColumn(0).setMinWidth(25);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(1).setMinWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        int colWidth = 40;
        String shortTaskName = this.competition.getRoundTask(0).getShortName();
        if (shortTaskName != null && shortTaskName.length() != 0) {
            colWidth = 50;
        }
        int i = 2;
        while (i <= this.competition.getNumberOfRounds() + 2) {
            this.table.getColumnModel().getColumn(i).setMinWidth(colWidth);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(colWidth);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.competition.getNumberOfRounds() + 2).setPreferredWidth(2000);
        boolean enabled = this.competition.getCompetitorCount() > 0;
        this.lbl.setEnabled(enabled);
        this.txtNumGroups.setEnabled(enabled);
        this.btnGenerateGroups.setEnabled(enabled);
        this.chkUseLetters.setEnabled(enabled);
        this.btnShowPilotMeets.setEnabled(enabled);
        this.chkUseLetters.setSelected(this.competition.useLetterGroupNames());
        this.txtNumGroups.setText("" + this.competition.getMaxGroupCount());
        this.chkUseTeamProtection.setEnabled(this.competition.haveTeams() && enabled);
        if (!this.competition.haveTeams()) {
            this.chkUseTeamProtection.setSelected(false);
        } else {
            this.chkUseTeamProtection.setSelected(this.competition.isUseTeamProtection());
        }
        this.setMultilineTableHeaders();
    }

    @Override
    public void dataChanged() {
        super.dataChanged();
        this.configurePanel();
    }

    private void mutateGroupings(int compCount, int roundCount, int[][] groups, boolean randomize) {
        this.randomGenerator.setSeed(System.currentTimeMillis());
        double mutateAmount = this.randomGenerator.nextDouble() * 1.3;
        mutateAmount *= mutateAmount;
        mutateAmount *= mutateAmount;
        mutateAmount *= mutateAmount;
        int swapCount = (int)mutateAmount + 1;
        if (randomize) {
            swapCount = 1000;
        }
        int x = 0;
        while (x < swapCount) {
            int swapIndex = (int)(this.randomGenerator.nextDouble() * (double)compCount);
            int roundIndex = (int)(this.randomGenerator.nextDouble() * (double)roundCount);
            int prevGroup = groups[swapIndex][roundIndex];
            int newGroup = 1;
            int newComp = 0;
            for (int cs = 1; cs < compCount; ++cs) {
                int tComp = (swapIndex + cs) % compCount;
                int tGroup = groups[tComp][roundIndex];
                if (tGroup == prevGroup) continue;
                newGroup = tGroup;
                newComp = tComp;
                break;
            }
            groups[swapIndex][roundIndex] = newGroup;
            groups[newComp][roundIndex] = prevGroup;
            ++x;
        }
    }

    private int calcMinGroupCount() {
        int compCount = this.competition.getCompetitorCount();
        int minGroupCount = 1;
        int c = 0;
        while (c < compCount - 1) {
            String frequency = this.competition.getCompetitor(c).getProperty("Freq 1");
            String team = this.competition.getCompetitor(c).getTeamName();
            if (!this.chkUseTeamProtection.isSelected()) {
                team = "";
            }
            int freqCount = 1;
            int teamCount = 1;
            int c2 = c + 1;
            while (c2 < compCount) {
                if (!frequency.equals("") && !frequency.startsWith("2.4") && !frequency.startsWith("2,4") && frequency.equals(this.competition.getCompetitor(c2).getProperty("Freq 1"))) {
                    ++freqCount;
                } else if (!team.equals("") && team.equals(this.competition.getCompetitor(c2).getTeamName())) {
                    ++teamCount;
                }
                ++c2;
            }
            if (freqCount > minGroupCount) {
                minGroupCount = freqCount;
            }
            if (teamCount > minGroupCount) {
                minGroupCount = teamCount;
            }
            ++c;
        }
        return minGroupCount;
    }

    private int calcGroupingScore(int compCount, int roundCount, int[][] groups) {
        String key;
        int[][] conflicts = new int[compCount][compCount];
        int compIx = 0;
        while (compIx < compCount - 1) {
            int c2 = compIx + 1;
            while (c2 < compCount) {
                conflicts[compIx][c2] = 0;
                ++c2;
            }
            ++compIx;
        }
        HashMap<String, Integer> duels = new HashMap<String, Integer>();
        int roundIx = 0;
        while (roundIx < roundCount) {
            int compIx2 = 0;
            while (compIx2 < compCount - 1) {
                int group = groups[compIx2][roundIx];
                String frequency = this.competition.getCompetitor(compIx2).getProperty("Freq 1");
                String team = this.competition.getCompetitor(compIx2).getTeamName();
                if (!this.chkUseTeamProtection.isSelected()) {
                    team = "";
                }
                int comp2Ix = compIx2 + 1;
                while (comp2Ix < compCount) {
                    String frequency2 = this.competition.getCompetitor(comp2Ix).getProperty("Freq 1");
                    String team2 = this.competition.getCompetitor(comp2Ix).getTeamName();
                    key = String.format("%d,%d", compIx2, comp2Ix);
                    if (duels.get(key) == null && (team.equals("") || !team.equals(team2))) {
                        duels.put(key, 0);
                    }
                    if (groups[comp2Ix][roundIx] == group) {
                        if (!frequency.equals("") && !frequency.startsWith("2.4") && !frequency.startsWith("2,4") && frequency.equals(frequency2)) {
                            int[] nArray = conflicts[compIx2];
                            int n = comp2Ix;
                            nArray[n] = nArray[n] + 100000;
                        }
                        if (!team.equals("") && team.equals(team2)) {
                            int[] nArray = conflicts[compIx2];
                            int n = comp2Ix;
                            nArray[n] = nArray[n] + 100000;
                        }
                        if (duels.containsKey(key)) {
                            int counter = (Integer)duels.get(key);
                            duels.put(key, ++counter);
                        }
                    }
                    ++comp2Ix;
                }
                ++compIx2;
            }
            ++roundIx;
        }
        ArrayList duelsList = new ArrayList(duels.values());
        int maxDuels = (Integer)Collections.max(duelsList);
        int minDuels = (Integer)Collections.min(duelsList);
        double total = 0.0;
        int compIx3 = 0;
        while (compIx3 < compCount - 1) {
            int c2 = compIx3 + 1;
            while (c2 < compCount) {
                int score = conflicts[compIx3][c2];
                total += (double)score;
                key = String.format("%d,%d", compIx3, c2);
                if (duels.containsKey(key)) {
                    int duelsNum = (Integer)duels.get(key);
                    total += Math.pow(0.5 * (double)(maxDuels + minDuels) - (double)duelsNum, 6.0);
                    if (duelsNum == 0) {
                        total += 1000.0;
                    }
                }
                ++c2;
            }
            ++compIx3;
        }
        return (int)total;
    }

    public void generateGroupsOLD(int groupCount, int timeLimit, boolean startFromCurrent) {
        int roundCount = this.competition.getNumberOfRounds();
        int compCount = this.competition.getCompetitorCount();
        double scoreTolerance = 0.05;
        double initScoreTolerance = 5.0;
        if (compCount < 1) {
            return;
        }
        if (groupCount == 1) {
            int c = 0;
            while (c < compCount) {
                int r = 0;
                while (r < roundCount) {
                    this.competition.getCompetitor(c).setGroupNum(r, 1);
                    ++r;
                }
                ++c;
            }
            this.competition.fireChangeEvent();
            return;
        }
        int minGroupCount = this.calcMinGroupCount();
        if (groupCount < minGroupCount) {
            groupCount = minGroupCount;
        }
        int[][] totalBestGroups = new int[compCount][roundCount];
        int[][] currentGroups = new int[compCount][roundCount];
        int[][] mutateGroups = new int[compCount][roundCount];
        int c = 0;
        while (c < compCount) {
            int r = 0;
            while (r < roundCount) {
                if (!startFromCurrent) {
                    currentGroups[compCount - c - 1][r] = (c + r) % groupCount + 1;
                } else {
                    currentGroups[c][r] = this.competition.getCompetitor(c).getGroupNum(r);
                }
                ++r;
            }
            ++c;
        }
        long startTime = System.currentTimeMillis();
        if (!startFromCurrent) {
            int i = 0;
            while (i < 10) {
                this.mutateGroupings(compCount, roundCount, currentGroups, true);
                ++i;
            }
        }
        int c2 = 0;
        while (c2 < compCount) {
            int r = 0;
            while (r < roundCount) {
                totalBestGroups[c2][r] = currentGroups[c2][r];
                ++r;
            }
            ++c2;
        }
        int totalLowestScore = this.calcGroupingScore(compCount, roundCount, currentGroups);
        int convergenceCounter = 0;
        int evocount = 0;
        while (evocount < 100) {
            int r;
            int c3;
            int lowestScore = this.calcGroupingScore(compCount, roundCount, currentGroups);
            int mutateCountSinceImprovement = 0;
            boolean done = false;
            double timeElapsed = 0.0;
            double currentScoreTolerance = initScoreTolerance;
            while (!done) {
                c3 = 0;
                while (c3 < compCount) {
                    r = 0;
                    while (r < roundCount) {
                        mutateGroups[c3][r] = currentGroups[c3][r];
                        ++r;
                    }
                    ++c3;
                }
                this.mutateGroupings(compCount, roundCount, mutateGroups, false);
                int mutateScore = this.calcGroupingScore(compCount, roundCount, mutateGroups);
                currentScoreTolerance *= 0.9;
                if ((double)mutateScore <= (1.0 + currentScoreTolerance) * (double)lowestScore) {
                    int c4 = 0;
                    while (c4 < compCount) {
                        int r2 = 0;
                        while (r2 < roundCount) {
                            currentGroups[c4][r2] = mutateGroups[c4][r2];
                            lowestScore = mutateScore;
                            ++r2;
                        }
                        ++c4;
                    }
                }
                if (mutateScore < lowestScore) {
                    mutateCountSinceImprovement = 0;
                } else if (++mutateCountSinceImprovement > 10) {
                    done = true;
                }
                if ((timeElapsed = (double)((System.currentTimeMillis() - startTime) / 1000L)) < (double)timeLimit && currentScoreTolerance > scoreTolerance) continue;
            }
            if (lowestScore <= totalLowestScore) {
                c3 = 0;
                while (c3 < compCount) {
                    r = 0;
                    while (r < roundCount) {
                        totalBestGroups[c3][r] = currentGroups[c3][r];
                        ++r;
                    }
                    ++c3;
                }
            } else {
                c3 = 0;
                while (c3 < compCount) {
                    r = 0;
                    while (r < roundCount) {
                        currentGroups[c3][r] = totalBestGroups[c3][r];
                        ++r;
                    }
                    ++c3;
                }
            }
            if (lowestScore < totalLowestScore) {
                totalLowestScore = lowestScore;
                convergenceCounter = 0;
            } else {
                ++convergenceCounter;
            }
            timeElapsed = (System.currentTimeMillis() - startTime) / 1000L;
            if (timeElapsed > (double)timeLimit) break;
            ++evocount;
        }
        int c5 = 0;
        while (c5 < compCount) {
            int r = 0;
            while (r < roundCount) {
                this.competition.getCompetitor(c5).setGroupNum(r, totalBestGroups[c5][r]);
                ++r;
            }
            ++c5;
        }
        this.competition.fireChangeEvent();
    }

    private void showPilotMeetings() {
        if (this.reportDlg == null) {
            this.reportDlg = new JDialog((Frame)((JFrame)this.getTopLevelAncestor()), "F3KScore: Pilot-pilot interactions report");
            this.reportDlg.setSize(600, 600);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (screen.height < 650) {
                this.reportDlg.setSize(600, screen.height * 9 / 10);
            }
            this.reportDlg.setLocationRelativeTo(this);
            this.textArea = new JTextArea(30, 20);
            this.textArea.setMargin(new Insets(10, 10, 10, 10));
            this.textArea.setFont(new Font("Monospaced", 0, 13));
            this.textArea.setLineWrap(false);
            JScrollPane scrollPane = new JScrollPane(this.textArea, 22, 30);
            this.textArea.setEditable(false);
            JMenuBar menuBar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            menuBar.add(fileMenu);
            fileMenu.add(new JMenuItem(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupsPane.this.reportDlg.setVisible(false);
                }
            }));
            JMenu sortMenu = new JMenu("Sort");
            menuBar.add(sortMenu);
            sortMenu.add(new JMenuItem(new AbstractAction("Sort by pilot name"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupsPane.this.textArea.setText(GroupsPane.this.getPilotMeetingsAsText(true));
                    GroupsPane.this.textArea.setCaretPosition(0);
                }
            }));
            sortMenu.add(new JMenuItem(new AbstractAction("Sort by number of interactions"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupsPane.this.textArea.setText(GroupsPane.this.getPilotMeetingsAsText(false));
                    GroupsPane.this.textArea.setCaretPosition(0);
                }
            }));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)menuBar, "North");
            panel.add((Component)scrollPane, "Center");
            this.reportDlg.add(panel);
        }
        this.textArea.setText(this.getPilotMeetingsAsText(false));
        this.textArea.setCaretPosition(0);
        this.reportDlg.setVisible(true);
    }

    private String getPilotMeetingsAsText(boolean sortedByName) {
        this.pilotMeets = new HashMap();
        int nRounds = this.competition.getNumberOfRounds();
        int nPilots = this.competition.getCompetitorCount();
        int maxKeyLength = 0;
        StringBuilder conflictsMsg = new StringBuilder();
        int nConflicts = 0;
        int roundIndex = 0;
        while (roundIndex < nRounds) {
            int index1 = 0;
            while (index1 < nPilots - 1) {
                Competitor comp1 = this.competition.getCompetitor(index1);
                int group1 = comp1.getGroupNum(roundIndex);
                int index2 = index1 + 1;
                while (index2 < nPilots) {
                    Competitor comp2 = this.competition.getCompetitor(index2);
                    int group2 = comp2.getGroupNum(roundIndex);
                    String key1 = String.valueOf(comp1.getFullName()) + " - " + comp2.getFullName();
                    String key2 = String.valueOf(comp2.getFullName()) + " - " + comp1.getFullName();
                    if (this.pilotMeets.get(key1) == null) {
                        this.pilotMeets.put(key1, 0);
                        if (sortedByName) {
                            this.pilotMeets.put(key2, 0);
                        }
                    }
                    if (key1.length() > maxKeyLength) {
                        maxKeyLength = key1.length();
                    }
                    if (group1 == group2) {
                        String msg;
                        int counter = this.pilotMeets.get(key1);
                        this.pilotMeets.put(key1, ++counter);
                        if (sortedByName) {
                            this.pilotMeets.put(key2, counter);
                        }
                        String freq1 = comp1.getFrequency();
                        String freq2 = comp2.getFrequency();
                        String team1 = comp1.getTeamName();
                        String team2 = comp2.getTeamName();
                        if (freq1 != null && !freq1.equals("") && !freq1.startsWith("2.4") && !freq1.startsWith("2,4") && freq1.equals(freq2) && ++nConflicts <= 10) {
                            msg = String.format("Frequency conflict in round %d, group %d, pilots \"%s\" and \"%s\", frequency %s.\n", roundIndex + 1, group1, comp1.getFullName(), comp2.getFullName(), freq1);
                            conflictsMsg.append(msg);
                        }
                        if (this.chkUseTeamProtection.isSelected() && team1 != null && !team1.equals("") && team1.equals(team2) && ++nConflicts <= 10) {
                            msg = String.format("Team conflict in round %d, group %d, pilots \"%s\" and \"%s\", team \"%s\".\n", roundIndex + 1, group1, comp1.getFullName(), comp2.getFullName(), team1);
                            conflictsMsg.append(msg);
                        }
                    }
                    ++index2;
                }
                ++index1;
            }
            ++roundIndex;
        }
        if (nConflicts > 0) {
            if (nConflicts > 10) {
                conflictsMsg.append(String.format("...%d total conflicts\n", nConflicts));
            }
            JOptionPane.showMessageDialog(this, conflictsMsg.toString(), "WARNING: team/channel conflicts detected", 0);
        }
        ArrayList<String> meetNames = new ArrayList<String>(this.pilotMeets.keySet());
        if (sortedByName) {
            Collections.sort(meetNames);
        } else {
            Collections.sort(meetNames, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int n2;
                    int n1 = (Integer)GroupsPane.this.pilotMeets.get(o1);
                    if (n1 == (n2 = ((Integer)GroupsPane.this.pilotMeets.get(o2)).intValue())) {
                        return o1.compareTo(o2);
                    }
                    if (n1 < n2) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        Collection<Integer> vals = this.pilotMeets.values();
        int[] stats = new int[Collections.max(vals) + 1];
        for (Integer val : vals) {
            int n = val;
            stats[n] = stats[n] + 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Statistics\n");
        int i = 0;
        while (i < maxKeyLength + 20) {
            sb.append("-");
            ++i;
        }
        sb.append("\n");
        String formatStr = "%2d %-" + maxKeyLength + "s %-3d %s\n";
        int divider = sortedByName ? 2 : 1;
        int i2 = stats.length - 1;
        while (i2 >= 0) {
            sb.append(String.format(formatStr, i2, "pilot-pilot interactions", stats[i2] / divider, "cases"));
            --i2;
        }
        sb.append("\n\n");
        sb.append(String.format("%-" + (maxKeyLength + 3) + "s %s\n", "Pilot names", "# interactions"));
        i2 = 0;
        while (i2 < maxKeyLength + 20) {
            sb.append("-");
            ++i2;
        }
        sb.append("\n");
        formatStr = " %-" + (maxKeyLength + 2) + "s %d\n";
        for (String meetName : meetNames) {
            sb.append(String.format(formatStr, meetName, this.pilotMeets.get(meetName)));
        }
        return sb.toString();
    }

    private void generateGroups(int groupCount, boolean optimize, int numOptLoops, boolean startFromCurrent) {
        int roundCount = this.competition.getNumberOfRounds();
        int compCount = this.competition.getCompetitorCount();
        if (groupCount == 1) {
            int c = 0;
            while (c < compCount) {
                int r = 0;
                while (r < roundCount) {
                    this.competition.getCompetitor(c).setGroupNum(r, 1);
                    ++r;
                }
                ++c;
            }
            this.competition.fireChangeEvent();
            return;
        }
        int minGroupCount = this.calcMinGroupCount();
        if (groupCount < minGroupCount) {
            groupCount = minGroupCount;
        }
        DrawMatrix drawMatrix = new DrawMatrix(this.competition, roundCount, groupCount);
        drawMatrix.generateMatrix(optimize, numOptLoops, startFromCurrent);
        this.competition.fireChangeEvent();
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GroupsPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GroupsPane.this.excelAdapter.pasteAction();
                }
            });
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.popupMenu.add(this.pasteMenuItem);
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class DrawGroup {
        private List<Pilot> pilotList = new ArrayList<Pilot>();

        private DrawGroup() {
        }

        private boolean canAddPilot(Pilot candidate) {
            return this.canAddPilot(candidate, null);
        }

        private boolean canAddPilot(Pilot candidate, Pilot doNotCheckPilot) {
            String freq = candidate.getFrequency();
            String team = candidate.getTeam();
            for (Pilot pilot : this.pilotList) {
                if (pilot == doNotCheckPilot) continue;
                if (freq != null && !freq.equals("") && !freq.startsWith("2.4") && !freq.startsWith("2,4") && freq.equals(pilot.getFrequency())) {
                    return false;
                }
                if (team == null || team.equals("") || !team.equals(pilot.getTeam())) continue;
                return false;
            }
            return true;
        }

        private boolean addPilot(Pilot candidate) {
            if (!this.canAddPilot(candidate)) {
                return false;
            }
            candidate.addedToGroup(this);
            this.pilotList.add(candidate);
            return true;
        }

        private void removeFromMatrix() {
            ArrayList<Pilot> listCopy = new ArrayList<Pilot>(this.pilotList);
            Iterator<Pilot> it = this.pilotList.iterator();
            while (it.hasNext()) {
                it.next().removedFromGroup(this);
                it.remove();
            }
            this.pilotList = listCopy;
        }
    }

    private class DrawMatrix {
        private List<Pilot> allPilots = new ArrayList<Pilot>();
        private List<DrawRound> rounds = new ArrayList<DrawRound>();
        private int nRounds;
        private int nGroups;

        private DrawMatrix(Competition competition, int nRounds, int nGroups) {
            for (Competitor competitor : competition.getCompetitorList()) {
                this.allPilots.add(new Pilot(competitor));
            }
            this.nRounds = nRounds;
            this.nGroups = nGroups;
            for (Pilot pilot : this.allPilots) {
                pilot.initializeDuels(this.allPilots);
            }
        }

        private double calculateTotalScore() {
            int min = 100000;
            int max = 0;
            for (Pilot pilot : this.allPilots) {
                int min1 = pilot.getMinDuelsValue();
                int max1 = pilot.getMaxDuelsValue();
                if (min1 < min) {
                    min = min1;
                }
                if (max1 <= max) continue;
                max = max1;
            }
            double median = 0.5 * (double)(max + min);
            double totalScore = 0.0;
            for (Pilot pilot : this.allPilots) {
                for (Integer numDuels : pilot.duels.values()) {
                    double score = Math.pow((double)numDuels.intValue() - median, 4.0);
                    totalScore += score;
                    if (numDuels != 0) continue;
                    totalScore += 1000.0;
                }
            }
            int roundIndex = 0;
            for (DrawRound round : this.rounds) {
                int groupIndex = 0;
                for (DrawGroup group : round.groups) {
                    for (Pilot pilot1 : group.pilotList) {
                        int group1 = pilot1.competitor.getGroupNum(roundIndex);
                        for (Pilot pilot2 : group.pilotList) {
                            int group2;
                            if (pilot2 == pilot1 || group1 != (group2 = pilot2.competitor.getGroupNum(roundIndex))) continue;
                            String freq1 = pilot1.getFrequency();
                            String freq2 = pilot2.getFrequency();
                            String team1 = pilot1.getTeam();
                            String team2 = pilot2.getTeam();
                            if (freq1 != null && !freq1.equals("") && !freq1.startsWith("2.4") && !freq1.startsWith("2,4") && freq1.equals(freq2)) {
                                totalScore += 1000000.0;
                            }
                            if (team1 == null || team1.equals("") || !team1.equals(team2)) continue;
                            totalScore += 1000000.0;
                        }
                    }
                    ++groupIndex;
                }
                ++roundIndex;
            }
            return totalScore;
        }

        private DrawRound generateRound(List<Integer> groupSize) {
            DrawRound round = new DrawRound();
            ArrayList<Pilot> pilots = new ArrayList<Pilot>(this.allPilots);
            round.generateGroups(groupSize, pilots);
            Collections.shuffle(round.groups);
            return round;
        }

        private void addRound(DrawRound aRound) {
            aRound.addToMatrix();
            this.rounds.add(aRound);
        }

        private void removeRound(DrawRound aRound) {
            aRound.removeFromMatrix();
            this.rounds.remove(aRound);
        }

        private void generateMatrix(boolean optimize, int numOptLoops, boolean startFromCurrent) {
            int roundIndex;
            int MAX_TRIALS = 5;
            int CONVERGENCE_TRIALS = 1000 * this.nRounds;
            int MAX_OPTIMIZATION_LOOPS = numOptLoops * this.nRounds;
            if (CONVERGENCE_TRIALS < MAX_OPTIMIZATION_LOOPS / 2) {
                CONVERGENCE_TRIALS = MAX_OPTIMIZATION_LOOPS / 2;
            }
            ArrayList<Integer> groupSize = new ArrayList<Integer>(this.nGroups);
            int nPilots = this.allPilots.size();
            int i = this.nGroups;
            while (i > 0) {
                int size = Math.round(nPilots / i);
                groupSize.add(size);
                nPilots -= size;
                --i;
            }
            if (!optimize || !startFromCurrent) {
                roundIndex = 0;
                while (roundIndex < this.nRounds) {
                    HashMap<Double, DrawRound> trialRounds = new HashMap<Double, DrawRound>();
                    int trial = 1;
                    while (trial <= MAX_TRIALS) {
                        DrawRound aRound = this.generateRound(groupSize);
                        double score = this.calculateTotalScore();
                        trialRounds.put(score, aRound);
                        this.removeRound(aRound);
                        ++trial;
                    }
                    Double minScore = (Double)Collections.min(trialRounds.keySet());
                    DrawRound bestRound = (DrawRound)trialRounds.get(minScore);
                    this.addRound(bestRound);
                    ++roundIndex;
                }
            } else {
                roundIndex = 0;
                while (roundIndex < this.nRounds) {
                    DrawRound aRound = new DrawRound();
                    int groupNum = 1;
                    while (groupNum <= this.nGroups) {
                        DrawGroup group = new DrawGroup();
                        for (Pilot pilot : this.allPilots) {
                            if (pilot.competitor.getGroupNum(roundIndex) != groupNum) continue;
                            group.pilotList.add(pilot);
                        }
                        aRound.groups.add(group);
                        ++groupNum;
                    }
                    this.addRound(aRound);
                    ++roundIndex;
                }
            }
            double initScore = this.calculateTotalScore();
            if (optimize) {
                int counter = 0;
                boolean terminated = false;
                int iter = 0;
                while (iter < MAX_OPTIMIZATION_LOOPS) {
                    HashMap<Double, DrawRound> trialRounds = new HashMap<Double, DrawRound>();
                    DrawRound aRound = this.rounds.get(0);
                    initScore = this.calculateTotalScore();
                    trialRounds.put(initScore, aRound);
                    this.removeRound(aRound);
                    int trial = 1;
                    while (trial <= MAX_TRIALS) {
                        aRound = this.generateRound(groupSize);
                        double score = this.calculateTotalScore();
                        trialRounds.put(score, aRound);
                        this.removeRound(aRound);
                        ++trial;
                    }
                    Double minScore = (Double)Collections.min(trialRounds.keySet());
                    DrawRound bestRound = (DrawRound)trialRounds.get(minScore);
                    this.addRound(bestRound);
                    if (minScore < initScore) {
                        counter = 0;
                    } else if (++counter > CONVERGENCE_TRIALS) {
                        JOptionPane.showMessageDialog(GroupsPane.this, String.format("No matrix score improvement in the last %d trials. Optimization terminated.\nRe-start optimization from a random matrix if desired.", CONVERGENCE_TRIALS / this.nRounds), "Optimization terminated", 1);
                        terminated = true;
                        break;
                    }
                    ++iter;
                }
            }
            int roundIndex2 = 0;
            for (DrawRound round : this.rounds) {
                int groupNum = 1;
                for (DrawGroup group : round.groups) {
                    for (Pilot pilot : group.pilotList) {
                        pilot.competitor.setGroupNum(roundIndex2, groupNum);
                    }
                    ++groupNum;
                }
                ++roundIndex2;
            }
        }
    }

    private class DrawRound {
        private List<DrawGroup> groups = new ArrayList<DrawGroup>();

        private DrawRound() {
        }

        private void generateGroups(List<Integer> groupSize, List<Pilot> pilotCandidates) {
            ArrayList<Integer> groupSizeCopy = new ArrayList<Integer>(groupSize);
            Integer lastGroupSize = groupSizeCopy.remove(groupSize.size() - 1);
            for (Integer size : groupSizeCopy) {
                this.groups.add(this.generateGroup(pilotCandidates, size));
            }
            DrawGroup lastGroup = new DrawGroup();
            lastGroup.addPilot(pilotCandidates.remove(0));
            for (Pilot pilot : pilotCandidates) {
                if (lastGroup.addPilot(pilot)) continue;
                DrawGroup altGroup = null;
                Pilot altPilot = null;
                block2: for (DrawGroup group : this.groups) {
                    for (Pilot swapPilot : group.pilotList) {
                        if (!group.canAddPilot(pilot, swapPilot) || !lastGroup.canAddPilot(swapPilot)) continue;
                        altGroup = group;
                        altPilot = swapPilot;
                        continue block2;
                    }
                }
                if (altGroup == null || altPilot == null) {
                    JOptionPane.showMessageDialog(GroupsPane.this, String.format("Failed to resolve team/frequency conflict for pilot \"%s\". \nRemove team or frequency conflicts, or increase number of groups.", pilot.competitor.getFullName()), "Team/frequency conflicts cannot be resolved", 0);
                    break;
                }
                altGroup.pilotList.remove(altPilot);
                altPilot.removedFromGroup(altGroup);
                lastGroup.addPilot(altPilot);
                altGroup.addPilot(pilot);
            }
            this.groups.add(lastGroup);
        }

        private DrawGroup generateGroup(List<Pilot> candidates, int groupSize) {
            final DrawGroup group = new DrawGroup();
            Comparator<Pilot> comparator = new Comparator<Pilot>(){

                @Override
                public int compare(Pilot pilot1, Pilot pilot2) {
                    int count2;
                    int count1 = pilot1.getMinDuelCountWithSelectedPilots(group.pilotList);
                    if (count1 < (count2 = pilot2.getMinDuelCountWithSelectedPilots(group.pilotList))) {
                        return -1;
                    }
                    if (count1 > count2) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.shuffle(candidates);
            Collections.sort(candidates);
            group.pilotList.add(candidates.remove(0));
            int count = 1;
            while (count < groupSize) {
                Collections.shuffle(candidates);
                Collections.sort(candidates, comparator);
                Pilot addedPilot = null;
                for (Pilot pilot : candidates) {
                    if (!group.addPilot(pilot)) continue;
                    addedPilot = pilot;
                    break;
                }
                candidates.remove(addedPilot);
                ++count;
            }
            return group;
        }

        private void removeFromMatrix() {
            for (DrawGroup group : this.groups) {
                group.removeFromMatrix();
            }
        }

        private void addToMatrix() {
            for (DrawGroup group : this.groups) {
                List pilots = group.pilotList;
                group.pilotList = new ArrayList();
                for (Pilot pilot : pilots) {
                    pilot.addedToGroup(group);
                    group.pilotList.add(pilot);
                }
            }
        }
    }

    private class GroupsTableModel
    extends AbstractTableModel {
        private GroupsTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            GroupsPane.this.configurePanel();
        }

        @Override
        public int getColumnCount() {
            return GroupsPane.this.competition.getNumberOfRounds() + 3;
        }

        @Override
        public int getRowCount() {
            return GroupsPane.this.competition.getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            if (col == 1) {
                return "Name";
            }
            if (col <= GroupsPane.this.competition.getNumberOfRounds() + 1) {
                int roundIndex = col - 2;
                String shortTaskName = GroupsPane.this.competition.getRoundTask(roundIndex).getShortName();
                if (shortTaskName == null || shortTaskName.length() == 0) {
                    return String.format("%d", col - 1);
                }
                return String.format("%d\n%s", col - 1, shortTaskName);
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor comp = GroupsPane.this.competition.getCompetitor(row);
            if (col == 0) {
                return String.format("%d", row + 1);
            }
            if (col == 1) {
                return comp.getFullName();
            }
            if (col <= GroupsPane.this.competition.getNumberOfRounds() + 1) {
                int groupNumber = GroupsPane.this.competition.getCompetitor(row).getGroupNum(col - 2);
                return GroupsPane.this.competition.formatGroupNumberAsString(groupNumber);
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 1 && col <= GroupsPane.this.competition.getNumberOfRounds() + 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int groupNumber = -1;
            if (GroupsPane.this.chkUseLetters.isSelected()) {
                groupNumber = Competition.groupLetterToNumber(value.toString().toUpperCase());
                if (groupNumber <= 0) {
                    JOptionPane.showMessageDialog(GroupsPane.this, String.format("Invalid entry for group name: \"%s\"\nGroup name must be a letter in the range \"A\"...\"%s\"", value.toString(), Competition.groupLetters.get(19)), "Invalid entry", 0);
                    return;
                }
            } else {
                try {
                    groupNumber = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (groupNumber < 1 || groupNumber > 20) {
                    JOptionPane.showMessageDialog(GroupsPane.this, String.format("Invalid entry for group number: \"%s\"\nGroup number must be an integer in the range 1...%d", value, 20), "Invalid entry", 0);
                    return;
                }
            }
            GroupsPane.this.competition.getCompetitor(row).setGroupNum(col - 2, groupNumber);
            this.fireTableDataChanged();
            GroupsPane.this.txtNumGroups.setText("" + GroupsPane.this.competition.getMaxGroupCount());
            GroupsPane.this.competition.setChangesMade(true);
        }
    }

    private class Pilot
    implements Comparable<Pilot> {
        private HashMap<Pilot, Integer> duels = new HashMap();
        private Competitor competitor;
        private String frequency;
        private String team;

        private Pilot(Competitor competitor) {
            this.competitor = competitor;
            this.frequency = competitor.getFrequency();
            if (this.frequency != null && (this.frequency.equals("") || this.frequency.startsWith("2.4") || this.frequency.startsWith("2,4"))) {
                this.frequency = null;
            }
            if (GroupsPane.this.chkUseTeamProtection.isSelected()) {
                this.team = competitor.getTeamName();
            }
        }

        private void initializeDuels(List<Pilot> allPilots) {
            for (Pilot pilot : allPilots) {
                if (pilot == this) continue;
                this.duels.put(pilot, 0);
            }
        }

        public String toString() {
            return this.competitor.getFullName();
        }

        private String getFrequency() {
            return this.frequency;
        }

        private String getTeam() {
            return this.team;
        }

        private int getDuelCount(Pilot aPilot) {
            if (this.duels.containsKey(aPilot)) {
                return this.duels.get(aPilot);
            }
            return 0;
        }

        private int getMinDuelsValue() {
            if (this.duels.size() == 0) {
                return 0;
            }
            return Collections.min(this.duels.values());
        }

        private int getMaxDuelsValue() {
            if (this.duels.size() == 0) {
                return 0;
            }
            return Collections.max(this.duels.values());
        }

        private int getCountForDuelsValue(int numDuels) {
            int counter = 0;
            for (Integer val : this.duels.values()) {
                if (val != numDuels) continue;
                ++counter;
            }
            return counter;
        }

        private int getMinDuelCountWithSelectedPilots(List<Pilot> group) {
            if (group == null || group.size() == 0) {
                return 0;
            }
            int minDuelsCount = 100000;
            for (Pilot pilot : group) {
                if (this.frequency != null && this.frequency.equals(pilot.getFrequency())) {
                    return 1000;
                }
                if (this.team != null && this.team.equals(pilot.getTeam())) {
                    return 1000;
                }
                int val = this.getDuelCount(pilot);
                if (val >= minDuelsCount) continue;
                minDuelsCount = val;
            }
            return minDuelsCount;
        }

        @Override
        public int compareTo(Pilot aPilot) {
            int minCount2;
            int minDuels2;
            int minDuels1 = this.getMinDuelsValue();
            if (minDuels1 < (minDuels2 = aPilot.getMinDuelsValue())) {
                return -1;
            }
            if (minDuels1 > minDuels2) {
                return 1;
            }
            int minCount1 = this.getCountForDuelsValue(minDuels1);
            if (minCount1 < (minCount2 = aPilot.getCountForDuelsValue(minDuels1))) {
                return 1;
            }
            if (minCount1 > minCount2) {
                return -1;
            }
            return 0;
        }

        private void addedToGroup(DrawGroup group) {
            for (Pilot pilot : group.pilotList) {
                int num;
                if (pilot == this) continue;
                if (!this.duels.containsKey(pilot)) {
                    this.duels.put(pilot, 1);
                } else {
                    num = this.duels.get(pilot) + 1;
                    this.duels.put(pilot, num);
                }
                if (!pilot.duels.containsKey(this)) {
                    pilot.duels.put(this, 1);
                    continue;
                }
                num = pilot.duels.get(this) + 1;
                pilot.duels.put(this, num);
            }
        }

        private void removedFromGroup(DrawGroup group) {
            for (Pilot pilot : group.pilotList) {
                if (pilot == this) continue;
                int num = this.duels.get(pilot) - 1;
                if (num < 0) {
                    throw new IllegalStateException("Number of duels < 0 for pilot " + this);
                }
                this.duels.put(pilot, num);
                num = pilot.duels.get(this) - 1;
                if (num < 0) {
                    throw new IllegalStateException("Number of duels < 0 for pilot " + this);
                }
                pilot.duels.put(this, num);
            }
        }
    }
}

