/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AudioConstants;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.F3KScore;
import f3kscore.F3kFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PlaylistDialog
extends JDialog
implements ActionListener,
AudioConstants {
    private JTextArea playlistText;
    private JTextField txtSoundFilesDir;
    private JButton btnBrowseSoundFilesDir;
    private JButton btnRegeneratePlaylist;
    private JButton btnSavePlaylist;
    private JCheckBox chkAddSilence;
    private JComboBox cmboAddSilence;
    private JCheckBox chkAddPilotNames;
    private JTextField txtPilotNameFilesDir;
    private JButton btnBrowsePilotNameFilesDir;
    private JTextField txtPilotNamePattern;
    private int silenceMinutes;
    private String soundFilesDirName;
    private String pilotFilesDirName;
    private String pilotNamePattern;
    private F3kFileFilter m3uFilter;
    private F3kFileFilter xmlFilter;
    private File playListFile;
    private F3KScore editor;
    private HtmlLabel lblPilotNamePattern;

    public PlaylistDialog(F3KScore editor) {
        super((Frame)editor, "F3KScore: Audio Playlist Generator");
        this.editor = editor;
        super.setLayout(new GridBagLayout());
        super.setSize(650, 650);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (screen.height < 750) {
            super.setSize(650, screen.height * 9 / 10);
        }
        super.setLocationRelativeTo(editor);
        JLabel lblSoundFilesDir = new JLabel("Directory with sound files (absolute or relative path):");
        this.txtSoundFilesDir = new JTextField();
        this.txtSoundFilesDir.addActionListener(this);
        this.txtSoundFilesDir.setActionCommand("REGENERATE");
        this.btnBrowseSoundFilesDir = this.createButton("Browse...", "BROWSE_DIR", new Dimension(70, 22));
        JPanel frmSoundFilesDir = new JPanel(new GridBagLayout());
        frmSoundFilesDir.add((Component)this.txtSoundFilesDir, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
        frmSoundFilesDir.add((Component)this.btnBrowseSoundFilesDir, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.playlistText = new JTextArea(30, 20);
        this.playlistText.setMargin(new Insets(10, 10, 10, 10));
        this.playlistText.setFont(new Font(null, 0, 12));
        this.playlistText.setLineWrap(false);
        JScrollPane scrollPane = new JScrollPane(this.playlistText, 22, 30);
        this.playlistText.setEditable(false);
        Dimension dim = new Dimension(90, 25);
        this.btnRegeneratePlaylist = this.createButton("Regenerate", "REGENERATE", dim);
        this.btnSavePlaylist = this.createButton("Save As...", "SAVE_AS", dim);
        JPanel frmButtons = new JPanel();
        frmButtons.add(this.btnRegeneratePlaylist);
        frmButtons.add(this.btnSavePlaylist);
        JButton btnClose = this.createButton("Close", "CLOSE", dim);
        this.chkAddSilence = new JCheckBox("Add a pause between groups:", false);
        this.chkAddSilence.setMargin(new Insets(0, 0, 0, 0));
        this.chkAddSilence.addActionListener(this);
        this.chkAddSilence.setActionCommand("ADD_SILENCE");
        this.cmboAddSilence = new JComboBox<String>(new String[]{"1 minute", "2 minutes", "3 minutes", "4 minutes", "5 minutes"});
        this.cmboAddSilence.setPreferredSize(new Dimension(90, 22));
        this.cmboAddSilence.addActionListener(this);
        this.cmboAddSilence.setActionCommand("ADD_SILENCE");
        this.cmboAddSilence.setEnabled(false);
        JPanel frmAddSilence = new JPanel(new GridBagLayout());
        frmAddSilence.add((Component)this.chkAddSilence, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        frmAddSilence.add((Component)this.cmboAddSilence, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        frmAddSilence.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.chkAddPilotNames = new JCheckBox("Include pilot name sound files from this directory (absolute or relative path):", false);
        this.chkAddPilotNames.setMargin(new Insets(0, 0, 0, 0));
        this.chkAddPilotNames.addActionListener(this);
        this.chkAddPilotNames.setActionCommand("ADD_PILOTS");
        this.txtPilotNameFilesDir = new JTextField();
        this.txtPilotNameFilesDir.addActionListener(this);
        this.txtPilotNameFilesDir.setActionCommand("REGENERATE");
        this.txtPilotNameFilesDir.setEnabled(false);
        this.btnBrowsePilotNameFilesDir = this.createButton("Browse...", "BROWSE_PILOTS", new Dimension(70, 22));
        this.btnBrowsePilotNameFilesDir.setEnabled(false);
        JPanel frmPilotNames = new JPanel(new GridBagLayout());
        frmPilotNames.add((Component)this.txtPilotNameFilesDir, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        frmPilotNames.add((Component)this.btnBrowsePilotNameFilesDir, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.lblPilotNamePattern = new HtmlLabel();
        this.lblPilotNamePattern.setText("<html>Use these substitution keywords - <i>STARTNUMBER, LASTNAME, FIRSTNAME, INFO, EMAIL, FAI_AMA</i> - to construct the pattern for your pilot name files. <br><br>Pattern for pilot name sound files:");
        this.lblPilotNamePattern.setEnabled(false);
        this.txtPilotNamePattern = new JTextField("FIRSTNAME-LASTNAME.mp3");
        this.txtPilotNamePattern.addActionListener(this);
        this.txtPilotNamePattern.setActionCommand("REGENERATE");
        this.txtPilotNamePattern.setEnabled(false);
        JPanel frmPilotNamePattern = new JPanel(new GridBagLayout());
        frmPilotNamePattern.add((Component)this.lblPilotNamePattern, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        frmPilotNamePattern.add((Component)this.txtPilotNamePattern, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        int row = 0;
        super.add((Component)lblSoundFilesDir, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        super.add((Component)frmSoundFilesDir, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        super.add((Component)frmAddSilence, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        super.add((Component)this.chkAddPilotNames, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(13, 10, 0, 10), 0, 0));
        super.add((Component)frmPilotNames, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        super.add((Component)frmPilotNamePattern, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        super.add((Component)frmButtons, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 0, 0, 0), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        super.add((Component)btnClose, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m3uFilter = new F3kFileFilter("m3u", "m3u playlist files (.m3u)");
        this.xmlFilter = new F3kFileFilter("xml", "iTunes playlist files (.xml)");
        this.generatePlaylist();
        this.setVisible(true);
    }

    private JButton createButton(String text, String command, Dimension dim) {
        JButton btn = new JButton(text);
        btn.addActionListener(this);
        btn.setActionCommand(command);
        btn.setMargin(new Insets(0, 5, 0, 5));
        if (dim != null) {
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setPreferredSize(dim);
            btn.setMinimumSize(dim);
        }
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("REGENERATE")) {
            this.generatePlaylist();
        } else if (action.getActionCommand().equals("SAVE_AS")) {
            this.browseSavePlaylist();
        } else if (action.getActionCommand().equals("CLOSE")) {
            super.setVisible(false);
        } else if (action.getActionCommand().equals("BROWSE_DIR")) {
            this.browseSoundFilesDir();
        } else if (action.getActionCommand().equals("BROWSE_PILOTS")) {
            this.browsePilotNameFilesDir();
        } else if (action.getActionCommand().equals("ADD_PILOTS")) {
            boolean enabled = this.chkAddPilotNames.isSelected();
            this.txtPilotNameFilesDir.setEnabled(enabled);
            this.txtPilotNamePattern.setEnabled(enabled);
            this.lblPilotNamePattern.setEnabled(enabled);
            this.btnBrowsePilotNameFilesDir.setEnabled(enabled);
            this.generatePlaylist();
        } else if (action.getActionCommand().equals("ADD_SILENCE")) {
            boolean enabled = this.chkAddSilence.isSelected();
            this.cmboAddSilence.setEnabled(enabled);
            this.silenceMinutes = enabled ? this.cmboAddSilence.getSelectedIndex() + 1 : 0;
            this.generatePlaylist();
        }
    }

    public void generatePlaylist() {
        ArrayList<String> playList = new ArrayList<String>();
        this.soundFilesDirName = this.txtSoundFilesDir.getText().trim();
        this.pilotFilesDirName = this.txtPilotNameFilesDir.getText().trim();
        this.pilotNamePattern = this.txtPilotNamePattern.getText().trim();
        if (this.editor.getCompetition().getCompetitionName() != null) {
            playList.add("# " + this.editor.getCompetition().getCompetitionName());
        }
        playList.add("# Playlist generated " + new Date(System.currentTimeMillis()));
        int nRounds = this.editor.getCompetition().getNumberOfRounds();
        int roundIndex = 0;
        while (roundIndex < nRounds) {
            String[] taskPlayList = this.editor.getCompetition().getRoundTask(roundIndex).getPlaylist();
            if (roundIndex > 0) {
                int i = 0;
                while (i < this.silenceMinutes) {
                    playList.add(this.getPlaylistFileEntry("silence_1_minute.mp3"));
                    ++i;
                }
            }
            int nGroups = this.editor.getCompetition().getGroupCount(roundIndex);
            int group = 1;
            while (group <= nGroups) {
                if (group > 1) {
                    int i = 0;
                    while (i < this.silenceMinutes) {
                        playList.add(this.getPlaylistFileEntry("silence_1_minute.mp3"));
                        ++i;
                    }
                }
                playList.add("#");
                playList.add("# ROUND " + (roundIndex + 1) + ", GROUP " + group);
                playList.add("# " + this.editor.getCompetition().getRoundTask(roundIndex).getDescription());
                playList.add("#");
                playList.add(this.getPlaylistFileEntry(ROUND_LIST[roundIndex]));
                if (this.editor.getCompetition().useLetterGroupNames()) {
                    playList.add(this.getPlaylistFileEntry(HEAT_LETTER_LIST[group - 1]));
                } else {
                    playList.add(this.getPlaylistFileEntry(HEAT_NUMBER_LIST[group - 1]));
                }
                if (this.chkAddPilotNames.isSelected()) {
                    CompetitorGroup compGroup = new CompetitorGroup(this.editor.getCompetition(), group, roundIndex, false);
                    int nPilots = compGroup.getCompetitorCount();
                    int i = 0;
                    while (i < nPilots) {
                        Competitor comp = compGroup.getCompetitor(i);
                        if (comp != null) {
                            String pilotNameFileName = this.getPilotNameFileName(comp);
                            if (this.pilotFilesDirName != null && this.pilotFilesDirName.length() > 0) {
                                pilotNameFileName = String.valueOf(this.pilotFilesDirName) + File.separator + pilotNameFileName;
                            }
                            playList.add(pilotNameFileName);
                        }
                        ++i;
                    }
                }
                if (taskPlayList == null || taskPlayList.length == 0) {
                    playList.add("#############################################################################");
                    playList.add("# WARNING: playlist cannot be correctly generated for old F3KScore data files!");
                    playList.add("# Task specific sound files are not included here.");
                    playList.add("#############################################################################");
                } else {
                    int i = 0;
                    while (i < taskPlayList.length) {
                        playList.add(this.getPlaylistFileEntry(taskPlayList[i]));
                        ++i;
                    }
                }
                ++group;
            }
            ++roundIndex;
        }
        this.playlistText.setText(null);
        for (String line : playList) {
            this.playlistText.append(line);
            this.playlistText.append("\n");
        }
        this.playlistText.setCaretPosition(0);
    }

    private String getPilotNameFileName(Competitor comp) {
        String startNumber = "" + comp.getStartNumber();
        String firstName = comp.getProperty("First Name").trim();
        String lastName = comp.getProperty("Last Name").trim();
        String email = comp.getProperty("E-mail").trim();
        String faiAmaNum = comp.getProperty("FAI/AMA Num").trim();
        String info = comp.getProperty("Info").trim();
        String pilotName = this.pilotNamePattern.replaceAll("STARTNUMBER", startNumber);
        pilotName = pilotName.replaceAll("FIRSTNAME", firstName);
        pilotName = pilotName.replaceAll("LASTNAME", lastName);
        pilotName = pilotName.replaceAll("INFO", info);
        pilotName = pilotName.replaceAll("EMAIL", email);
        pilotName = pilotName.replaceAll("FAI_AMA", faiAmaNum);
        return pilotName;
    }

    private String getPlaylistFileEntry(String key) {
        if (this.soundFilesDirName != null && this.soundFilesDirName.trim().length() > 0) {
            return String.valueOf(this.soundFilesDirName) + File.separator + key;
        }
        return key;
    }

    public void browseSoundFilesDir() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select directory with audio files");
        fileChooser.setCurrentDirectory(new File("."));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = fileChooser.showDialog(this, "Select directory");
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.txtSoundFilesDir.setText(file.getAbsolutePath());
            this.generatePlaylist();
        }
    }

    public void browsePilotNameFilesDir() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select directory with pilot name audio files");
        fileChooser.setCurrentDirectory(this.editor.getCurrentDir());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = fileChooser.showDialog(this, "Select directory");
        if (returnVal == 0) {
            this.editor.setCurrentDir(fileChooser.getCurrentDirectory());
            File file = fileChooser.getSelectedFile();
            this.txtPilotNameFilesDir.setText(file.getAbsolutePath());
            this.generatePlaylist();
        }
    }

    private void browseSavePlaylist() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select file name for saving the playlist");
        fileChooser.setFileFilter(this.m3uFilter);
        fileChooser.setFileFilter(this.xmlFilter);
        fileChooser.setCurrentDirectory(this.editor.getCurrentDir());
        if (this.playListFile == null && this.editor.getLoadedFile() != null) {
            this.playListFile = new File(this.editor.getLoadedFile().getName().replace(".f3k", ""));
        }
        fileChooser.setSelectedFile(this.playListFile);
        int returnVal = fileChooser.showDialog(this, "Save playlist");
        if (returnVal == 0) {
            int reply;
            this.editor.setCurrentDir(fileChooser.getCurrentDirectory());
            this.playListFile = fileChooser.getSelectedFile();
            if (this.playListFile == null) {
                return;
            }
            if (!F3kFileFilter.getExtension(this.playListFile).equalsIgnoreCase("m3u") && !F3kFileFilter.getExtension(this.playListFile).equalsIgnoreCase("xml")) {
                this.playListFile = fileChooser.getFileFilter() == this.m3uFilter ? new File(String.valueOf(this.playListFile.getAbsolutePath()) + ".m3u") : new File(String.valueOf(this.playListFile.getAbsolutePath()) + ".xml");
            }
            if (this.playListFile.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + this.playListFile.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 0)) != 0) {
                return;
            }
            try {
                if (F3kFileFilter.getExtension(this.playListFile).equalsIgnoreCase("m3u")) {
                    FileOutputStream fs = new FileOutputStream(this.playListFile);
                    fs.write(this.playlistText.getText().getBytes());
                    fs.close();
                } else {
                    this.exportPlaylistAsXML(this.playListFile);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + this.playListFile.getName() + "\":\n\n" + ex.getLocalizedMessage() + "\n\n" + ex.getStackTrace());
            }
        }
    }

    private void exportPlaylistAsXML(File playListFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        sb.append("<plist version=\"1.0\">\n");
        sb.append("<dict>\n<key>Tracks</key>\n<dict>\n");
        String playlistName = playListFile.getName();
        playlistName = playlistName.substring(0, playlistName.lastIndexOf(46)).replaceAll("_", " ");
        Random randomGen = new Random();
        int trackID = (int)(randomGen.nextDouble() * 1000000.0);
        HashMap<String, Integer> includedTracks = new HashMap<String, Integer>();
        ArrayList<Integer> playlistTracks = new ArrayList<Integer>();
        boolean warningDisplayed = false;
        String[] lines = this.playlistText.getText().split("\\n");
        int i = 0;
        while (i < lines.length) {
            String aLine = lines[i];
            if (!aLine.startsWith("#")) {
                String trackName;
                File aFile = new File(aLine);
                if (!(aFile.isAbsolute() && aFile.exists() || warningDisplayed)) {
                    int reply = JOptionPane.showConfirmDialog(this, String.format("Playlist entry \"%s\" does not point to an actual file. \nBe sure to select correct directories for all audio files. \niTunes will not import a playlist entry which does not point to an existing file (a full file path). \nDo you want to ignore all invalid file warnings and continue?", aLine), "Invalid playlist entry", 2, 0);
                    if (reply != 0) {
                        return;
                    }
                    warningDisplayed = true;
                }
                if (includedTracks.containsKey(trackName = aFile.getName())) {
                    playlistTracks.add((Integer)includedTracks.get(trackName));
                } else {
                    sb.append("<key>").append(trackID).append("</key>\n<dict>\n");
                    sb.append("<key>Track ID</key><integer>").append(trackID).append("</integer>\n");
                    sb.append("<key>Album</key><string>").append("F3KScore").append("</string>\n");
                    sb.append("<key>Artist</key><string>").append("F3KScore").append("</string>\n");
                    sb.append("<key>Track Type</key><string>").append("File").append("</string>\n");
                    sb.append("<key>Location</key><string>").append("file://localhost").append(aFile.toURI().getPath()).append("</string>\n");
                    sb.append("<key>File Folder Count</key><integer>-1</integer>\n");
                    sb.append("<key>Library Folder Count</key><integer>-1</integer>\n");
                    sb.append("</dict>\n");
                    playlistTracks.add(trackID);
                    includedTracks.put(trackName, trackID);
                    ++trackID;
                }
            }
            ++i;
        }
        sb.append("</dict>\n");
        sb.append("<key>Playlists</key>\n<array>\n<dict>\n");
        sb.append("<key>Name</key><string>").append(playlistName).append("</string>\n");
        sb.append("<key>All Items</key><true/>\n");
        sb.append("<key>Playlist Items</key>\n<array>\n");
        for (Integer track : playlistTracks) {
            sb.append("<dict>\n  <key>Track ID</key><integer>").append(track).append("</integer>\n</dict>\n");
        }
        sb.append("</array>\n</dict>\n</array>\n</dict>\n</plist>\n");
        FileOutputStream fs = new FileOutputStream(playListFile);
        fs.write(sb.toString().getBytes());
        fs.close();
    }

    public class HtmlLabel
    extends JLabel {
        @Override
        public void setEnabled(boolean enabled) {
            if (this.getClientProperty("html") != null) {
                Color foreground = enabled ? SystemColor.textText : Color.LIGHT_GRAY;
                this.setForeground(foreground);
            }
            super.setEnabled(enabled);
        }
    }
}

