/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Task;
import java.io.Serializable;
import java.util.Arrays;

public class RoundScore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int groupNumber;
    private Competition competition;
    private Task lastCalculatedTask;
    private int roundNumber;
    private int[] flightTimes;
    private int totalTime;
    private int penalty;

    public RoundScore(Competition competition, int roundIndex) {
        this.competition = competition;
        this.roundNumber = roundIndex;
        this.groupNumber = 1;
        this.flightTimes = new int[20];
        Arrays.fill(this.flightTimes, -1);
    }

    private void calcTotalTime() {
        this.totalTime = 0;
        Task task = this.competition.getRoundTask(this.roundNumber);
        int i = 0;
        while (i < task.getNumFlights()) {
            int time = this.flightTimes[i];
            if (time > 0) {
                this.totalTime += time;
            }
            ++i;
        }
        this.lastCalculatedTask = task;
    }

    public int getTotalTime() {
        if (this.competition.getRoundTask(this.roundNumber) != this.lastCalculatedTask) {
            this.calcTotalTime();
        }
        return this.totalTime;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public int getGroupNum() {
        return this.groupNumber;
    }

    public void setGroupNum(int groupNum) {
        if (groupNum < 1 || groupNum > 20) {
            throw new IllegalArgumentException("Group assignment is " + groupNum + ", must be between 1 and " + 20);
        }
        this.groupNumber = groupNum;
        this.competition.setResultsDirty();
    }

    public int getTime(int timeIndex) {
        return this.flightTimes[timeIndex];
    }

    public void setTime(int timeIndex, int time) {
        Task task = this.competition.getRoundTask(this.roundNumber);
        int maxTimeCut = task.getMaxTimeCut(timeIndex);
        int minTimeCut = task.getMinTimeCut(timeIndex);
        if (maxTimeCut > 0 && time > maxTimeCut) {
            time = maxTimeCut;
        }
        if (time < minTimeCut && time > 0) {
            time = minTimeCut;
        }
        this.flightTimes[timeIndex] = time;
        if (task.isLadderTask()) {
            int i = 0;
            while (i < timeIndex && time > 0) {
                this.flightTimes[i] = task.getMinTimeCut(i);
                ++i;
            }
            i = timeIndex;
            while (i < this.flightTimes.length && time <= 0) {
                this.flightTimes[i] = -1;
                ++i;
            }
        }
        this.calcTotalTime();
        this.competition.setResultsDirty();
    }

    public void clearAllFlightTimes() {
        this.flightTimes = new int[20];
        this.totalTime = 0;
    }
}

