/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import f3kscore.PrintUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class RoundScoresPane
extends AbstractF3KScoreEditorPanel {
    private JSpinner taskSelectSpinner;
    private JLabel taskDescription;
    JScrollPane scrollPane;
    protected int clickedCol;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemMovePilotsToGroup;
    private JMenuItem menuItemAddPilotsToReflight;
    private JMenuItem menuItemRemovePilotsFromReflight;
    private JMenu menuPrintCards;
    private ExcelAdapter excelAdapter;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;

    public RoundScoresPane(Competition competition) {
        this.competition = competition;
        Font font = new Font("serif", 1, 18);
        this.taskSelectSpinner = new JSpinner();
        this.taskSelectSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RoundScoresPane.this.roundChanged();
            }
        });
        JLabel taskSelectLabel = new JLabel("Round:");
        taskSelectLabel.setFont(font);
        this.taskDescription = new JLabel();
        this.taskDescription.setFont(font);
        this.tableModel = new RoundScoresTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component c = super.prepareEditor(editor, row, column);
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).selectAll();
                    c.setBackground(super.getSelectionBackground());
                }
                return c;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (super.isRowSelected(rowIndex)) {
                    if (!super.isColumnSelected(vColIndex)) {
                        c.setBackground(F3KScore.veryLightGrey);
                    } else {
                        c.setBackground(this.getSelectionBackground());
                    }
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        };
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.configurePanel();
        this.excelAdapter = new ExcelAdapter(this.table);
        this.table.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "DELETE_SCORES");
        this.table.getActionMap().put("DELETE_SCORES", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoundScoresPane.this.deleteSelectedScores();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)taskSelectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 0), 0, 0));
        this.add((Component)this.taskSelectSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.add((Component)this.taskDescription, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "ENTER_PRESSED");
        this.table.getActionMap().put("ENTER_PRESSED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RoundScoresPane.this.clickedCol > 0) {
                    int selRow = RoundScoresPane.this.table.getSelectedRow();
                    int selCol = RoundScoresPane.this.table.getSelectedColumn();
                    if (selRow < 0 || selCol < 0) {
                        return;
                    }
                    if (RoundScoresPane.this.clickedCol != -1 && selCol < RoundScoresPane.this.clickedCol) {
                        RoundScoresPane.this.clickedCol = selCol;
                    }
                    if (RoundScoresPane.this.table.isEditing()) {
                        RoundScoresPane.this.table.getCellEditor().stopCellEditing();
                        RoundScoresPane.this.table.removeEditor();
                    }
                    if (++selRow < RoundScoresPane.this.table.getRowCount()) {
                        RoundScoresPane.this.table.setRowSelectionInterval(selRow, selRow);
                        RoundScoresPane.this.table.setColumnSelectionInterval(RoundScoresPane.this.clickedCol, RoundScoresPane.this.clickedCol);
                        RoundScoresPane.this.table.editCellAt(selRow, RoundScoresPane.this.clickedCol);
                    } else {
                        RoundScoresPane.this.clickedCol = -1;
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    RoundScoresPane.this.clickedCol = RoundScoresPane.this.table.columnAtPoint(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = RoundScoresPane.this.table.rowAtPoint(p);
                    int[] selRows = RoundScoresPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        RoundScoresPane.this.table.clearSelection();
                        RoundScoresPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = RoundScoresPane.this.table.columnAtPoint(p);
                        RoundScoresPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    RoundScoresPane.this.showPopupMenu(e, rowNumber);
                }
            }
        });
    }

    protected void deleteSelectedScores() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int[] cols = this.table.getSelectedColumns();
        int i = 0;
        while (i < rows.length) {
            int j = 0;
            while (j < cols.length) {
                int row = rows[i];
                int col = cols[j];
                if (this.tableModel.isCellEditable(row, col)) {
                    this.tableModel.setValueAt("", row, col);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void showPopupMenu(MouseEvent e, int clickedRowIndex) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu = new JPopupMenu();
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.excelAdapter.pasteAction();
                }
            });
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.popupMenu.add(this.pasteMenuItem);
            this.menuItemMovePilotsToGroup = new JMenuItem(new AbstractAction("Move selected pilots to another group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.showMovePilotsToAnotherGroupDlg();
                }
            });
            this.popupMenu.add(this.menuItemMovePilotsToGroup);
            this.menuItemAddPilotsToReflight = new JMenuItem(new AbstractAction("Add selected pilots to the re-flight group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.includeSelectedPilotsToReflightGroup(true);
                }
            });
            this.popupMenu.add(this.menuItemAddPilotsToReflight);
            this.menuItemRemovePilotsFromReflight = new JMenuItem(new AbstractAction("Remove selected pilots from the re-flight group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.includeSelectedPilotsToReflightGroup(false);
                }
            });
            this.popupMenu.add(this.menuItemRemovePilotsFromReflight);
            this.menuPrintCards = new JMenu("Print score cards for the selected pilot(s)");
            this.popupMenu.add(this.menuPrintCards);
            JMenu printAllRoundCardsMenu = new JMenu("All rounds");
            this.menuPrintCards.add(printAllRoundCardsMenu);
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(8);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(6);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(4);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(2);
                }
            }));
            JMenu printSelectedGroupCardsMenu = new JMenu("Selected round/group only");
            this.menuPrintCards.add(printSelectedGroupCardsMenu);
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(8);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(6);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(4);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(2);
                }
            }));
        }
        boolean pilotsSelected = this.getSelectedPilotList().size() > 0;
        boolean clickedInReflightGroup = ((RoundScoresTableModel)this.tableModel).groupNumberForRow(clickedRowIndex) < 0;
        this.menuItemMovePilotsToGroup.setEnabled(pilotsSelected && !clickedInReflightGroup);
        this.menuItemAddPilotsToReflight.setEnabled(pilotsSelected && !clickedInReflightGroup);
        this.menuItemRemovePilotsFromReflight.setEnabled(pilotsSelected && clickedInReflightGroup);
        this.menuPrintCards.setEnabled(pilotsSelected);
        this.pasteMenuItem.setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) != null);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void includeSelectedPilotsToReflightGroup(boolean include) {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        int roundIndex = this.competition.getSelectedRoundIndex();
        for (Competitor pilot : selPilots) {
            pilot.includeInReflightGroup(roundIndex, include);
        }
        this.tableModel.fireTableStructureChanged();
    }

    private ArrayList<Competitor> getSelectedPilotList() {
        ArrayList<Competitor> pilots = new ArrayList<Competitor>();
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0) {
            return pilots;
        }
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            Competitor pilot = ((RoundScoresTableModel)this.tableModel).rowToPilotMap().get(row);
            if (pilot != null) {
                pilots.add(pilot);
            }
            ++i;
        }
        return pilots;
    }

    private void showMovePilotsToAnotherGroupDlg() {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        JPanel panel = new JPanel();
        String msg = "Enter new group (A,B,C,...):  ";
        if (!this.competition.useLetterGroupNames()) {
            msg = "Enter new group (1,2,3,...):  ";
        }
        JLabel lbl = new JLabel(msg);
        JTextField txtField = new JTextField();
        txtField.setColumns(4);
        panel.add(lbl);
        panel.add(txtField);
        int reply = JOptionPane.showConfirmDialog(this, panel, "Move selected pilot(s) to a new group", 2, -1);
        if (reply != 0) {
            return;
        }
        String txt = txtField.getText().trim();
        if (txt.length() == 0) {
            return;
        }
        int groupNumber = -1;
        if (this.competition.useLetterGroupNames() && (groupNumber = Competition.groupLetterToNumber(txt)) <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid entry for group name.\nPlease enter one of A,B,C,D,E,F,G,H,I,J", "Invalid entry", 0);
            return;
        }
        try {
            groupNumber = Integer.parseInt(txt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (groupNumber < 1 || groupNumber > 10) {
            JOptionPane.showMessageDialog(this, "Invalid entry for group number.\nPlease enter one of 1,2,3,4,5,6,7,8,9,10", "Invalid entry", 0);
            return;
        }
        int roundIndex = this.competition.getSelectedRoundIndex();
        for (Competitor pilot : selPilots) {
            pilot.setGroupNum(roundIndex, groupNumber);
        }
        this.competition.setChangesMade(true);
        this.competition.fireChangeEvent();
    }

    private void printSelectedPilotsAllScoreCards(int nCardsPerPage) {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        PrintUtils.printScoreCardsSelectedPilot(selPilots, nCardsPerPage);
    }

    private void printSelectedPilotsScoreCards(int nCardsPerPage) {
        ArrayList<Competitor> pilots = new ArrayList<Competitor>();
        ArrayList<Integer> groupList = new ArrayList<Integer>();
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0) {
            return;
        }
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            Competitor pilot = ((RoundScoresTableModel)this.tableModel).rowToPilotMap().get(row);
            if (pilot != null) {
                pilots.add(pilot);
                groupList.add(((RoundScoresTableModel)this.tableModel).groupNumberForRow(row));
            }
            ++i;
        }
        PrintUtils.printScoreCardsSelectedPilotTaskGroup(pilots, this.competition.getSelectedRoundIndex(), groupList, nCardsPerPage);
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.taskSelectSpinner.setModel(new SpinnerNumberModel(this.competition.getSelectedRoundIndex() + 1, 1, this.competition.getNumberOfRounds(), 1));
        this.taskDescription.setText(this.competition.getSelectedTask().getDescription());
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        int i = 1;
        while (i <= this.tableModel.getColumnCount() - 2) {
            this.table.getColumnModel().getColumn(i).setMinWidth(65);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(65);
            ++i;
        }
        this.table.getColumnModel().getColumn(this.tableModel.getColumnCount() - 1).setPreferredWidth(2000);
        this.setMultilineTableHeaders();
    }

    public void roundChanged() {
        this.stopEditing();
        String params = this.taskSelectSpinner.getValue().toString();
        int tcount = Integer.parseInt(params);
        this.competition.setSelectedRoundIndex(tcount - 1);
        this.tableModel.fireTableStructureChanged();
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    public void selectRound(int roundIndex) {
        this.taskSelectSpinner.getModel().setValue(new Integer(roundIndex + 1));
        this.roundChanged();
    }

    private String convertSecondsToMinSec(double seconds) {
        double secs = seconds % 60.0;
        DecimalFormat formatter = new DecimalFormat("00");
        int mins = (int)(seconds - secs) / 60;
        return String.valueOf(mins) + ":" + formatter.format(secs);
    }

    private int convertScoreToSeconds(String valString) {
        int time = -1;
        int dotPos = valString.indexOf(46);
        if (dotPos == -1) {
            dotPos = valString.indexOf(58);
        }
        if (dotPos == -1) {
            time = Integer.parseInt(valString);
        } else {
            String secString = valString.substring(dotPos + 1);
            String minString = valString.substring(0, dotPos);
            int seconds = Integer.parseInt(secString);
            if (seconds >= 60) {
                JOptionPane.showMessageDialog(this, "Invalid value: number of seconds must not exceed 59.", "Invalid Entry", 0);
                return -1;
            }
            time = Integer.parseInt(minString) * 60 + Integer.parseInt(secString);
        }
        return time;
    }

    private class RoundScoresTableModel
    extends AbstractTableModel {
        private HashMap<Integer, Competitor> rowToPilotMap;
        private ArrayList<Integer> groupNumberList;

        private RoundScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            this.rowToPilotMap = null;
            this.groupNumberList = null;
            super.fireTableStructureChanged();
            RoundScoresPane.this.configurePanel();
        }

        public HashMap<Integer, Competitor> rowToPilotMap() {
            if (this.rowToPilotMap == null) {
                this.loadTableData();
            }
            return this.rowToPilotMap;
        }

        public int groupNumberForRow(int rowIndex) {
            if (this.groupNumberList == null) {
                this.loadTableData();
            }
            if (rowIndex >= this.groupNumberList.size()) {
                return 0;
            }
            return this.groupNumberList.get(rowIndex);
        }

        private void loadTableData() {
            this.rowToPilotMap = new HashMap();
            this.groupNumberList = new ArrayList();
            int nRows = this.getRowCount();
            int group = 1;
            int rowIndex = 0;
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            int nGroups = RoundScoresPane.this.competition.getGroupCount(roundIndex, true);
            boolean hasReflight = new CompetitorGroup(RoundScoresPane.this.competition, -1, roundIndex, false).getCompetitorCount() > 0;
            while (rowIndex < nRows) {
                CompetitorGroup compGroup = new CompetitorGroup(RoundScoresPane.this.competition, group, roundIndex, false);
                this.groupNumberList.add(group);
                ++rowIndex;
                int groupSize = compGroup.getCompetitorCount();
                int i = 0;
                while (i < groupSize) {
                    this.rowToPilotMap.put(rowIndex, compGroup.getCompetitor(i));
                    this.groupNumberList.add(group);
                    ++rowIndex;
                    ++i;
                }
                if (!hasReflight || ++group < nGroups) continue;
                group = -1;
            }
        }

        private String formatGroupName(int groupNumber) {
            if (groupNumber > 0) {
                return String.format("#########   Group %s  #########", RoundScoresPane.this.competition.formatGroupNumberAsString(groupNumber));
            }
            return String.format("########  Re-flight group  ######", RoundScoresPane.this.competition.formatGroupNumberAsString(groupNumber));
        }

        @Override
        public int getColumnCount() {
            return RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 5;
        }

        @Override
        public int getRowCount() {
            if (RoundScoresPane.this.competition.getCompetitorCount() == 0) {
                return 0;
            }
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            return RoundScoresPane.this.competition.getCompetitorCount() + RoundScoresPane.this.competition.getGroupCount(roundIndex, true) + new CompetitorGroup(RoundScoresPane.this.competition, -1, roundIndex, false).getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            int nFlights = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            if (col > nFlights + 3) {
                return "";
            }
            if (col == nFlights + 1) {
                return "Sum";
            }
            if (col == nFlights + 2) {
                return "Score";
            }
            if (col == nFlights + 3) {
                return "Penalty";
            }
            int timeCut = RoundScoresPane.this.competition.getSelectedTask().getMaxTimeCut(col - 1);
            String[] flightTimesColumnTitles = RoundScoresPane.this.competition.getSelectedTask().getFlightTimesColumnTitles();
            if (flightTimesColumnTitles != null) {
                return flightTimesColumnTitles[col - 1];
            }
            if (timeCut <= 0) {
                return String.format("T-%d", col);
            }
            return String.format("T-%d\nMax %s", col, RoundScoresPane.this.convertSecondsToMinSec(timeCut));
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col > RoundScoresPane.this.competition.getSelectedTask().getNumFlights() + 3) {
                return "";
            }
            int nFlights = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor pilot = this.rowToPilotMap().get(row);
            boolean isReflightRow = this.groupNumberForRow(row) < 0;
            boolean isSpeedTask = RoundScoresPane.this.competition.getSelectedTask().isSpeedTask();
            double multiplier = 1.0;
            DecimalFormat formatter = new DecimalFormat("#");
            if (isSpeedTask) {
                multiplier = 0.01;
                formatter = new DecimalFormat("##.00");
            }
            if (pilot != null) {
                if (col == 0) {
                    return pilot.getFullName();
                }
                if (col < nFlights + 1) {
                    int time = pilot.getTaskTime(roundIndex, col - 1);
                    if (isReflightRow) {
                        time = pilot.getReflightTime(roundIndex, col - 1);
                    }
                    if (time > 0) {
                        if (!RoundScoresPane.this.competition.isUseSecondsForFlightTimes()) {
                            if (RoundScoresPane.this.competition.getSelectedTask().hasLandingScore() && col == nFlights) {
                                return formatter.format((double)time * multiplier);
                            }
                            return RoundScoresPane.this.convertSecondsToMinSec((double)time * multiplier);
                        }
                        return formatter.format((double)time * multiplier);
                    }
                    return "";
                }
                if (col == nFlights + 1) {
                    int time = pilot.getTaskTotalTime(roundIndex);
                    if (isReflightRow) {
                        time = pilot.getReflightTotalTime(roundIndex);
                    }
                    if (time > 0) {
                        if (!RoundScoresPane.this.competition.isUseSecondsForFlightTimes()) {
                            if (RoundScoresPane.this.competition.getSelectedTask().hasLandingScore()) {
                                return formatter.format((double)time * multiplier);
                            }
                            return RoundScoresPane.this.convertSecondsToMinSec((double)time * multiplier);
                        }
                        return formatter.format((double)time * multiplier);
                    }
                    return "";
                }
                if (col == nFlights + 2) {
                    int score = pilot.getScore(roundIndex);
                    if (isReflightRow) {
                        score = pilot.getReflightScore(roundIndex);
                    }
                    if (score > 0) {
                        return String.valueOf(score);
                    }
                    return "";
                }
                if (col == nFlights + 3) {
                    int penalty = pilot.getPenalty(roundIndex);
                    if (isReflightRow) {
                        penalty = pilot.getReflightPenalty(roundIndex);
                    }
                    if (penalty > 0) {
                        return String.valueOf(penalty);
                    }
                    return "";
                }
                return "";
            }
            if (col == 0) {
                return this.formatGroupName(this.groupNumberForRow(row));
            }
            return "########";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Competitor comp = this.rowToPilotMap().get(row);
            int nFlights = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            return comp != null && col > 0 && (col < nFlights + 1 || col == nFlights + 3);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (RoundScoresPane.this.clickedCol != -1 && col < RoundScoresPane.this.clickedCol) {
                RoundScoresPane.this.clickedCol = col;
            }
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor pilot = this.rowToPilotMap().get(row);
            if (pilot == null) {
                return;
            }
            boolean isReflight = this.groupNumberForRow(row) < 0;
            int timeIndex = col - 1;
            int maxTimesCount = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            if (timeIndex == maxTimesCount + 2) {
                int val = -1;
                if (value.equals("")) {
                    val = 0;
                } else {
                    try {
                        val = Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (val % 100 != 0) {
                        JOptionPane.showMessageDialog(RoundScoresPane.this, "Invalid value: penalty must be a multiple of 100.", "Invalid Entry", 0);
                        return;
                    }
                }
                if (!isReflight) {
                    pilot.setPenalty(roundIndex, val);
                } else {
                    pilot.setReflightPenalty(roundIndex, val);
                }
                this.fireTableDataChanged();
                RoundScoresPane.this.competition.setResultsDirty();
                RoundScoresPane.this.competition.setChangesMade(true);
                RoundScoresPane.this.competition.fireChangeEvent();
                if (pilot.getPenalty() > 300) {
                    JOptionPane.showMessageDialog(RoundScoresPane.this, "Warning! Total penalty for this pilot exceeds the F3K maximum \nof 300 points. The pilot must be disqualified from the contest.", "Penalty Above Maximum", 2);
                }
                return;
            }
            if (timeIndex < 0 || timeIndex >= maxTimesCount) {
                return;
            }
            boolean isSpeedTask = RoundScoresPane.this.competition.getSelectedTask().isSpeedTask();
            String valString = value.toString().trim();
            int time = 0;
            if (valString.length() > 0) {
                try {
                    if (isSpeedTask) {
                        time = (int)(Double.parseDouble(valString) * 100.0);
                    }
                    time = RoundScoresPane.this.convertScoreToSeconds(valString);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(RoundScoresPane.this, "Invalid entry: \"" + value + "\"", "Invalid Entry", 0);
                    return;
                }
            } else {
                time = -1;
            }
            int totalTime = 0;
            if (!isReflight) {
                pilot.setTaskTime(roundIndex, timeIndex, time);
                totalTime = pilot.getTaskTotalTime(roundIndex);
            } else {
                pilot.setReflightTime(roundIndex, timeIndex, time);
                totalTime = pilot.getReflightTotalTime(roundIndex);
            }
            int windowTime = RoundScoresPane.this.competition.getSelectedTask().getWindowTime();
            if (windowTime > 0 && totalTime >= windowTime) {
                JOptionPane.showMessageDialog(RoundScoresPane.this, "WARNING! Total time for \"" + pilot.getFullName() + "\" equals or exceeds the window time of " + windowTime + " seconds!", "Invalid Score Card", 0);
            }
            this.fireTableDataChanged();
        }
    }
}

