/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelAdapter;
import f3kscore.F3KScore;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class TotalScoresPane
extends AbstractF3KScoreEditorPanel {
    private String[] colNames = new String[20];
    private int[] colWidths = new int[20];
    private boolean useSecondNameColumn;
    private int lastRoundCol;
    private int secondNameCol = -1;
    private int penaltyCol;
    private int scoreCol;
    private int percentCol;
    private int classCol;
    private int faiAmaCol;
    private int clubCol;
    private int stateCol;
    private NumberFormat formatter = new DecimalFormat("##.00");
    private NumberFormat defaultFormatter = NumberFormat.getIntegerInstance();
    private ExcelAdapter excelAdapter;
    private JPopupMenu popupMenu;

    public TotalScoresPane(Competition competition) {
        this.competition = competition;
        this.configurePanel();
        this.tableModel = new TotalScoresTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (super.isRowSelected(rowIndex)) {
                    if (!super.isColumnSelected(vColIndex)) {
                        c.setBackground(F3KScore.veryLightGrey);
                    } else {
                        c.setBackground(this.getSelectionBackground());
                    }
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        };
        this.table.setAutoResizeMode(0);
        this.setMultilineTableHeaders();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter = new ExcelAdapter(this.table){

            @Override
            public void pasteAction() {
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = e.getPoint();
                    int rowNumber = TotalScoresPane.this.table.rowAtPoint(p);
                    int[] selRows = TotalScoresPane.this.table.getSelectedRows();
                    boolean clickedInSelection = false;
                    int i = 0;
                    while (i < selRows.length) {
                        if (rowNumber == selRows[i]) {
                            clickedInSelection = true;
                            break;
                        }
                        ++i;
                    }
                    if (!clickedInSelection) {
                        TotalScoresPane.this.table.clearSelection();
                        TotalScoresPane.this.table.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
                        int colNumber = TotalScoresPane.this.table.columnAtPoint(p);
                        TotalScoresPane.this.table.changeSelection(rowNumber, colNumber, false, false);
                    }
                    TotalScoresPane.this.showPopupMenu(e);
                }
            }
        });
    }

    private void configurePanel() {
        int nRounds = this.competition.getNumberOfRounds();
        int nCol = nRounds + 10;
        this.useSecondNameColumn = false;
        if (nRounds > 20) {
            nCol += 2;
            this.useSecondNameColumn = true;
        }
        this.colNames = new String[nCol];
        this.colWidths = new int[nCol];
        this.colNames[0] = "";
        this.colWidths[0] = 25;
        this.colNames[1] = "Name";
        this.colWidths[1] = 140;
        int col = 2;
        while (col < this.competition.getNumberOfRounds() + 2) {
            int roundIndex = col - 2;
            String shortTaskName = this.competition.getRoundTask(roundIndex).getShortName();
            if (shortTaskName == null || shortTaskName.length() == 0) {
                this.colNames[col] = "" + (col - 1);
                this.colWidths[col] = 40;
            } else {
                this.colNames[col] = String.format("%d\n%s", col - 1, shortTaskName);
                this.colWidths[col] = 50;
            }
            ++col;
        }
        this.lastRoundCol = col - 1;
        this.secondNameCol = -1;
        if (this.useSecondNameColumn) {
            this.colNames[col] = "";
            this.colWidths[col] = 25;
            this.secondNameCol = ++col;
            this.colNames[col] = "Name";
            this.colWidths[col] = 150;
            ++col;
        }
        this.penaltyCol = col;
        this.colNames[col] = "Penalty\n& Rnd";
        this.colWidths[col] = 65;
        int i = 0;
        while (i < this.competition.getCompetitorCount()) {
            Competitor comp = this.competition.getCompetitorAtPosition(i);
            if (comp.getPenalty() > 100) {
                this.colWidths[col] = 75;
            }
            if (comp.getPenalty() > 200) {
                this.colWidths[col] = 80;
            }
            ++i;
        }
        this.scoreCol = ++col;
        this.colNames[col] = "Score";
        this.colWidths[col] = 50;
        this.percentCol = ++col;
        this.colNames[col] = "%";
        this.colWidths[col] = 55;
        this.classCol = ++col;
        this.colNames[col] = "Class";
        this.colWidths[col] = 70;
        this.faiAmaCol = ++col;
        this.colNames[col] = "FAI/AMA\nnumber";
        this.colWidths[col] = 75;
        this.clubCol = ++col;
        this.colNames[col] = "Club";
        this.colWidths[col] = 65;
        this.stateCol = ++col;
        this.colNames[col] = "State";
        this.colWidths[col] = 65;
        this.colNames[++col] = "";
        this.colWidths[col] = 2000;
    }

    private void configureColumnWidths() {
        int i = 0;
        while (i < this.colWidths.length) {
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidths[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            ++i;
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TotalScoresPane.this.excelAdapter.copyAction();
                }
            });
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(copyMenuItem);
        }
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class TotalScoresTableModel
    extends AbstractTableModel {
        private TotalScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            TotalScoresPane.this.configurePanel();
            super.fireTableStructureChanged();
            TotalScoresPane.this.configureColumnWidths();
            TotalScoresPane.this.setMultilineTableHeaders();
        }

        @Override
        public int getColumnCount() {
            return TotalScoresPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return TotalScoresPane.this.competition.getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            return TotalScoresPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Competitor comp = TotalScoresPane.this.competition.getCompetitorAtPosition(row);
            if (comp == null) {
                return "";
            }
            if (col >= TotalScoresPane.this.colNames.length - 1) {
                return "";
            }
            if (col == 0 || col == TotalScoresPane.this.secondNameCol - 1) {
                return "" + (row + 1);
            }
            if (col == 1 || col == TotalScoresPane.this.secondNameCol) {
                return comp.getFullName();
            }
            if (col <= TotalScoresPane.this.lastRoundCol) {
                int round = col - 2;
                int roundScore = comp.getRoundScore(round);
                if (comp.isDiscardRound(round) && comp.calculateTotalScore() > 0) {
                    return "(" + roundScore + ")";
                }
                if (roundScore == 0) {
                    return "";
                }
                return "" + roundScore;
            }
            if (col == TotalScoresPane.this.penaltyCol) {
                int penalty = comp.getPenalty();
                if (penalty == 0) {
                    return "";
                }
                StringBuffer res = new StringBuffer();
                res.append(comp.getPenalty());
                if (comp.getPenaltyRounds().length() > 0) {
                    res.append("/").append(comp.getPenaltyRounds());
                }
                return res.toString();
            }
            if (col == TotalScoresPane.this.scoreCol) {
                int score = comp.calculateTotalScore();
                if (score != 0) {
                    return TotalScoresPane.this.defaultFormatter.format(comp.calculateTotalScore());
                }
                return "";
            }
            if (col == TotalScoresPane.this.percentCol) {
                float val = comp.getPercent();
                if ((double)val == 100.0) {
                    return "100.0%";
                }
                if (val != 0.0f) {
                    String perc = TotalScoresPane.this.formatter.format(comp.getPercent());
                    return String.valueOf(perc) + "%";
                }
                return "";
            }
            if (col == TotalScoresPane.this.classCol) {
                String val = comp.getProperty("Class");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.faiAmaCol) {
                String val = comp.getProperty("FAI/AMA Num");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.clubCol) {
                String val = comp.getProperty("Club");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.stateCol) {
                String val = comp.getProperty("State");
                return val == null ? "" : val;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

